/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.digests.GeneralDigest;
import org.bouncycastle.util.Memoable;
import org.bouncycastle.util.Pack;

public final class SHA1Digest
extends GeneralDigest {
    private int H1;
    private int H2;
    private int H3;
    private int H4;
    private int H5;
    private int[] X = new int[80];
    private int xOff;

    public SHA1Digest() {
        ((GeneralDigest)this).reset();
    }

    private SHA1Digest(SHA1Digest sHA1Digest) {
        super(sHA1Digest);
        this.copyIn(sHA1Digest);
    }

    private void copyIn(SHA1Digest sHA1Digest) {
        this.H1 = sHA1Digest.H1;
        this.H2 = sHA1Digest.H2;
        this.H3 = sHA1Digest.H3;
        this.H4 = sHA1Digest.H4;
        this.H5 = sHA1Digest.H5;
        System.arraycopy(sHA1Digest.X, 0, this.X, 0, sHA1Digest.X.length);
        this.xOff = sHA1Digest.xOff;
    }

    public final String getAlgorithmName() {
        return "SHA-1";
    }

    public final int getDigestSize() {
        return 20;
    }

    protected final void processWord(byte[] byArray, int n) {
        int n2 = byArray[n] << 24;
        n2 |= (byArray[++n] & 0xFF) << 16;
        n2 |= (byArray[++n] & 0xFF) << 8;
        this.X[this.xOff] = n2 |= byArray[++n] & 0xFF;
        if (++this.xOff == 16) {
            this.processBlock();
        }
    }

    protected final void processLength(long l) {
        if (this.xOff > 14) {
            this.processBlock();
        }
        this.X[14] = (int)(l >>> 32);
        this.X[15] = (int)l;
    }

    public final int doFinal(byte[] byArray, int n) {
        this.finish();
        Pack.intToBigEndian(this.H1, byArray, n);
        Pack.intToBigEndian(this.H2, byArray, n + 4);
        Pack.intToBigEndian(this.H3, byArray, n + 8);
        Pack.intToBigEndian(this.H4, byArray, n + 12);
        Pack.intToBigEndian(this.H5, byArray, n + 16);
        ((GeneralDigest)this).reset();
        return 20;
    }

    public final void reset() {
        super.reset();
        this.H1 = 1732584193;
        this.H2 = -271733879;
        this.H3 = -1732584194;
        this.H4 = 271733878;
        this.H5 = -1009589776;
        this.xOff = 0;
        for (int i = 0; i != this.X.length; ++i) {
            this.X[i] = 0;
        }
    }

    private static int f(int n, int n2, int n3) {
        return n & n2 | ~n & n3;
    }

    private static int g(int n, int n2, int n3) {
        return n & n2 | n & n3 | n2 & n3;
    }

    protected final void processBlock() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        for (n6 = 16; n6 < 80; ++n6) {
            n5 = this.X[n6 - 3] ^ this.X[n6 - 8] ^ this.X[n6 - 14] ^ this.X[n6 - 16];
            this.X[n6] = n5 << 1 | n5 >>> 31;
        }
        n6 = this.H1;
        n5 = this.H2;
        int n7 = this.H3;
        int n8 = this.H4;
        int n9 = this.H5;
        int n10 = 0;
        for (n4 = 0; n4 < 4; ++n4) {
            n9 += (n6 << 5 | n6 >>> 27) + SHA1Digest.f(n5, n7, n8) + this.X[n10++] + 1518500249;
            n5 = n5 << 30 | n5 >>> 2;
            n8 += (n9 << 5 | n9 >>> 27) + SHA1Digest.f(n6, n5, n7) + this.X[n10++] + 1518500249;
            n6 = n6 << 30 | n6 >>> 2;
            n7 += (n8 << 5 | n8 >>> 27) + SHA1Digest.f(n9, n6, n5) + this.X[n10++] + 1518500249;
            n9 = n9 << 30 | n9 >>> 2;
            n5 += (n7 << 5 | n7 >>> 27) + SHA1Digest.f(n8, n9, n6) + this.X[n10++] + 1518500249;
            n8 = n8 << 30 | n8 >>> 2;
            n6 += (n5 << 5 | n5 >>> 27) + SHA1Digest.f(n7, n8, n9) + this.X[n10++] + 1518500249;
            n7 = n7 << 30 | n7 >>> 2;
        }
        for (n4 = 0; n4 < 4; ++n4) {
            n3 = n8;
            n2 = n7;
            n = n5;
            n9 += (n6 << 5 | n6 >>> 27) + (n ^ n2 ^ n3) + this.X[n10++] + 1859775393;
            n5 = n5 << 30 | n5 >>> 2;
            n3 = n7;
            n2 = n5;
            n = n6;
            n8 += (n9 << 5 | n9 >>> 27) + (n ^ n2 ^ n3) + this.X[n10++] + 1859775393;
            n6 = n6 << 30 | n6 >>> 2;
            n3 = n5;
            n2 = n6;
            n = n9;
            n7 += (n8 << 5 | n8 >>> 27) + (n ^ n2 ^ n3) + this.X[n10++] + 1859775393;
            n9 = n9 << 30 | n9 >>> 2;
            n3 = n6;
            n2 = n9;
            n = n8;
            n5 += (n7 << 5 | n7 >>> 27) + (n ^ n2 ^ n3) + this.X[n10++] + 1859775393;
            n8 = n8 << 30 | n8 >>> 2;
            n3 = n9;
            n2 = n8;
            n = n7;
            n6 += (n5 << 5 | n5 >>> 27) + (n ^ n2 ^ n3) + this.X[n10++] + 1859775393;
            n7 = n7 << 30 | n7 >>> 2;
        }
        for (n4 = 0; n4 < 4; ++n4) {
            n9 += (n6 << 5 | n6 >>> 27) + SHA1Digest.g(n5, n7, n8) + this.X[n10++] + -1894007588;
            n5 = n5 << 30 | n5 >>> 2;
            n8 += (n9 << 5 | n9 >>> 27) + SHA1Digest.g(n6, n5, n7) + this.X[n10++] + -1894007588;
            n6 = n6 << 30 | n6 >>> 2;
            n7 += (n8 << 5 | n8 >>> 27) + SHA1Digest.g(n9, n6, n5) + this.X[n10++] + -1894007588;
            n9 = n9 << 30 | n9 >>> 2;
            n5 += (n7 << 5 | n7 >>> 27) + SHA1Digest.g(n8, n9, n6) + this.X[n10++] + -1894007588;
            n8 = n8 << 30 | n8 >>> 2;
            n6 += (n5 << 5 | n5 >>> 27) + SHA1Digest.g(n7, n8, n9) + this.X[n10++] + -1894007588;
            n7 = n7 << 30 | n7 >>> 2;
        }
        for (n4 = 0; n4 <= 3; ++n4) {
            n3 = n8;
            n2 = n7;
            n = n5;
            n9 += (n6 << 5 | n6 >>> 27) + (n ^ n2 ^ n3) + this.X[n10++] + -899497514;
            n5 = n5 << 30 | n5 >>> 2;
            n3 = n7;
            n2 = n5;
            n = n6;
            n8 += (n9 << 5 | n9 >>> 27) + (n ^ n2 ^ n3) + this.X[n10++] + -899497514;
            n6 = n6 << 30 | n6 >>> 2;
            n3 = n5;
            n2 = n6;
            n = n9;
            n7 += (n8 << 5 | n8 >>> 27) + (n ^ n2 ^ n3) + this.X[n10++] + -899497514;
            n9 = n9 << 30 | n9 >>> 2;
            n3 = n6;
            n2 = n9;
            n = n8;
            n5 += (n7 << 5 | n7 >>> 27) + (n ^ n2 ^ n3) + this.X[n10++] + -899497514;
            n8 = n8 << 30 | n8 >>> 2;
            n3 = n9;
            n2 = n8;
            n = n7;
            n6 += (n5 << 5 | n5 >>> 27) + (n ^ n2 ^ n3) + this.X[n10++] + -899497514;
            n7 = n7 << 30 | n7 >>> 2;
        }
        this.H1 += n6;
        this.H2 += n5;
        this.H3 += n7;
        this.H4 += n8;
        this.H5 += n9;
        this.xOff = 0;
        for (n4 = 0; n4 < 16; ++n4) {
            this.X[n4] = 0;
        }
    }

    public final Memoable copy() {
        return new SHA1Digest(this);
    }

    public final void reset(Memoable memoable) {
        memoable = (SHA1Digest)memoable;
        super.copyIn((GeneralDigest)memoable);
        this.copyIn((SHA1Digest)memoable);
    }
}

