/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.macs;

import java.util.Hashtable;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.Memoable;

public final class HMac
implements Mac {
    private Digest digest;
    private int digestSize;
    private int blockLength;
    private Memoable ipadState;
    private Memoable opadState;
    private byte[] inputPad;
    private byte[] outputBuf;
    private static Hashtable blockLengths = new Hashtable<String, Integer>();

    public HMac(Digest digest) {
        int n;
        if (digest instanceof ExtendedDigest) {
            n = ((ExtendedDigest)digest).getByteLength();
        } else {
            Integer n2 = (Integer)blockLengths.get(digest.getAlgorithmName());
            if (n2 == null) {
                throw new IllegalArgumentException("unknown digest passed: " + digest.getAlgorithmName());
            }
            n = n2;
        }
        this(digest, n);
    }

    private HMac(Digest digest, int n) {
        this.digest = digest;
        this.digestSize = digest.getDigestSize();
        this.blockLength = n;
        this.inputPad = new byte[this.blockLength];
        this.outputBuf = new byte[this.blockLength + this.digestSize];
    }

    public final String getAlgorithmName() {
        return this.digest.getAlgorithmName() + "/HMAC";
    }

    public final void init(CipherParameters object) {
        this.digest.reset();
        byte[] byArray = ((KeyParameter)object).getKey();
        object = byArray;
        int n = byArray.length;
        if (n > this.blockLength) {
            this.digest.update((byte[])object, 0, n);
            this.digest.doFinal(this.inputPad, 0);
            n = this.digestSize;
        } else {
            System.arraycopy(object, 0, this.inputPad, 0, n);
        }
        for (int i = n; i < this.inputPad.length; ++i) {
            this.inputPad[i] = 0;
        }
        System.arraycopy(this.inputPad, 0, this.outputBuf, 0, this.blockLength);
        HMac.xorPad(this.inputPad, this.blockLength, (byte)54);
        HMac.xorPad(this.outputBuf, this.blockLength, (byte)92);
        if (this.digest instanceof Memoable) {
            this.opadState = ((Memoable)((Object)this.digest)).copy();
            ((Digest)((Object)this.opadState)).update(this.outputBuf, 0, this.blockLength);
        }
        this.digest.update(this.inputPad, 0, this.inputPad.length);
        if (this.digest instanceof Memoable) {
            this.ipadState = ((Memoable)((Object)this.digest)).copy();
        }
    }

    public final int getMacSize() {
        return this.digestSize;
    }

    public final void update(byte by) {
        this.digest.update(by);
    }

    public final void update(byte[] byArray, int n, int n2) {
        this.digest.update(byArray, n, n2);
    }

    public final int doFinal(byte[] byArray, int n) {
        this.digest.doFinal(this.outputBuf, this.blockLength);
        if (this.opadState != null) {
            ((Memoable)((Object)this.digest)).reset(this.opadState);
            this.digest.update(this.outputBuf, this.blockLength, this.digest.getDigestSize());
        } else {
            this.digest.update(this.outputBuf, 0, this.outputBuf.length);
        }
        int n2 = this.digest.doFinal(byArray, 0);
        for (n = this.blockLength; n < this.outputBuf.length; ++n) {
            this.outputBuf[n] = 0;
        }
        if (this.ipadState != null) {
            ((Memoable)((Object)this.digest)).reset(this.ipadState);
        } else {
            this.digest.update(this.inputPad, 0, this.inputPad.length);
        }
        return n2;
    }

    public final void reset() {
        this.digest.reset();
        this.digest.update(this.inputPad, 0, this.inputPad.length);
    }

    private static void xorPad(byte[] byArray, int n, byte by) {
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2++;
            byArray[n3] = (byte)(byArray[n3] ^ by);
        }
    }

    static {
        int n = 32;
        blockLengths.put("GOST3411", 32);
        n = 16;
        blockLengths.put("MD2", 16);
        n = 64;
        blockLengths.put("MD4", 64);
        n = 64;
        blockLengths.put("MD5", 64);
        n = 64;
        blockLengths.put("RIPEMD128", 64);
        n = 64;
        blockLengths.put("RIPEMD160", 64);
        n = 64;
        blockLengths.put("SHA-1", 64);
        n = 64;
        blockLengths.put("SHA-224", 64);
        n = 64;
        blockLengths.put("SHA-256", 64);
        n = 128;
        blockLengths.put("SHA-384", 128);
        n = 128;
        blockLengths.put("SHA-512", 128);
        n = 64;
        blockLengths.put("Tiger", 64);
        n = 64;
        blockLengths.put("Whirlpool", 64);
    }
}

