/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.params;

import java.math.BigInteger;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.DHValidationParameters;
import org.bouncycastle.util.Properties;

public class DHParameters
implements CipherParameters {
    private BigInteger g;
    private BigInteger p;
    private BigInteger q;
    private BigInteger j;
    private int m;
    private int l;
    private DHValidationParameters validation;

    public DHParameters(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n, int n2, BigInteger bigInteger4, DHValidationParameters dHValidationParameters) {
        if (n > bigInteger.bitLength() && !Properties.isOverrideSet("org.bouncycastle.dh.allow_unsafe_p_value")) {
            throw new IllegalArgumentException("unsafe p value so small specific l required");
        }
        this.g = bigInteger2;
        this.p = bigInteger;
        this.q = bigInteger3;
        this.m = n;
        this.l = 0;
        this.j = null;
        this.validation = dHValidationParameters;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DHParameters)) {
            return false;
        }
        object = (DHParameters)object;
        Object object2 = this;
        if (((DHParameters)object2).q != null) {
            DHParameters dHParameters = this;
            object2 = dHParameters;
            object2 = object;
            if (!dHParameters.q.equals(((DHParameters)object2).q)) {
                return false;
            }
        } else {
            object2 = object;
            if (((DHParameters)object2).q != null) {
                return false;
            }
        }
        object2 = object;
        if (((DHParameters)object2).p.equals(this.p)) {
            object2 = object;
            if (((DHParameters)object2).g.equals(this.g)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int n;
        DHParameters dHParameters = this;
        DHParameters dHParameters2 = dHParameters;
        dHParameters2 = this;
        int n2 = dHParameters.p.hashCode() ^ dHParameters2.g.hashCode();
        dHParameters2 = this;
        if (dHParameters2.q != null) {
            dHParameters2 = this;
            n = dHParameters2.q.hashCode();
        } else {
            n = 0;
        }
        return n2 ^ n;
    }
}

