/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.params;

import org.bouncycastle.util.Arrays;

public final class DSAValidationParameters {
    private int usageIndex;
    private byte[] seed;
    private int counter;

    public DSAValidationParameters(byte[] byArray, int n) {
        this(byArray, n, -1);
    }

    private DSAValidationParameters(byte[] byArray, int n, int n2) {
        this.seed = Arrays.clone(byArray);
        this.counter = n;
        this.usageIndex = -1;
    }

    public final int getCounter() {
        return this.counter;
    }

    public final byte[] getSeed() {
        return Arrays.clone(this.seed);
    }

    public final int hashCode() {
        return this.counter ^ Arrays.hashCode(this.seed);
    }

    public final boolean equals(Object object) {
        if (!(object instanceof DSAValidationParameters)) {
            return false;
        }
        object = (DSAValidationParameters)object;
        if (((DSAValidationParameters)object).counter != this.counter) {
            return false;
        }
        byte[] byArray = ((DSAValidationParameters)object).seed;
        object = this.seed;
        return java.util.Arrays.equals(this.seed, byArray);
    }
}

