/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.symmetric.util;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jcajce.provider.symmetric.util.ClassUtil;

public class GcmSpecUtil {
    static final Class gcmSpecClass = ClassUtil.loadClass(GcmSpecUtil.class, "javax.crypto.spec.GCMParameterSpec");
    static final Method tLen;
    static final Method iv;

    private static Method extractMethod(String string) {
        try {
            return (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(string){
                private /* synthetic */ String val$name;
                {
                    this.val$name = string;
                }

                public final Object run() throws Exception {
                    return gcmSpecClass.getDeclaredMethod(this.val$name, new Class[0]);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            return null;
        }
    }

    static AEADParameters extractAeadParameters(KeyParameter keyParameter, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        try {
            return (AEADParameters)AccessController.doPrivileged(new PrivilegedExceptionAction(keyParameter, algorithmParameterSpec){
                private /* synthetic */ KeyParameter val$keyParam;
                private /* synthetic */ AlgorithmParameterSpec val$params;
                {
                    this.val$keyParam = keyParameter;
                    this.val$params = algorithmParameterSpec;
                }

                public final Object run() throws Exception {
                    return new AEADParameters(this.val$keyParam, (Integer)tLen.invoke((Object)this.val$params, new Object[0]), (byte[])iv.invoke((Object)this.val$params, new Object[0]));
                }
            });
        }
        catch (Exception exception) {
            throw new InvalidAlgorithmParameterException("Cannot process GCMParameterSpec.");
        }
    }

    static {
        if (gcmSpecClass != null) {
            tLen = GcmSpecUtil.extractMethod("getTLen");
            iv = GcmSpecUtil.extractMethod("getIV");
        } else {
            tLen = null;
            iv = null;
        }
    }
}

