/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.asn1;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.pqc.crypto.rainbow.Layer;
import org.bouncycastle.pqc.crypto.rainbow.util.RainbowUtil;

public final class RainbowPrivateKey
extends ASN1Object {
    private ASN1Integer version;
    private ASN1ObjectIdentifier oid;
    private byte[][] invA1;
    private byte[] b1;
    private byte[][] invA2;
    private byte[] b2;
    private byte[] vi;
    private Layer[] layers;

    private RainbowPrivateKey(ASN1Sequence aSN1Sequence) {
        Object object;
        int n;
        if (aSN1Sequence.getObjectAt(0) instanceof ASN1Integer) {
            this.version = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0));
        } else {
            this.oid = ASN1ObjectIdentifier.getInstance$31c7e78d(aSN1Sequence.getObjectAt(0));
        }
        Object object2 = (ASN1Sequence)aSN1Sequence.getObjectAt(1);
        this.invA1 = new byte[((ASN1Sequence)object2).size()][];
        for (int i = 0; i < ((ASN1Sequence)object2).size(); ++i) {
            this.invA1[i] = ((ASN1OctetString)((ASN1Sequence)object2).getObjectAt(i)).getOctets();
        }
        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.getObjectAt(2);
        this.b1 = ((ASN1OctetString)aSN1Sequence2.getObjectAt(0)).getOctets();
        object2 = (ASN1Sequence)aSN1Sequence.getObjectAt(3);
        this.invA2 = new byte[((ASN1Sequence)object2).size()][];
        for (int i = 0; i < ((ASN1Sequence)object2).size(); ++i) {
            this.invA2[i] = ((ASN1OctetString)((ASN1Sequence)object2).getObjectAt(i)).getOctets();
        }
        Object object3 = (ASN1Sequence)aSN1Sequence.getObjectAt(4);
        this.b2 = ((ASN1OctetString)((ASN1Sequence)object3).getObjectAt(0)).getOctets();
        object2 = (ASN1Sequence)aSN1Sequence.getObjectAt(5);
        this.vi = ((ASN1OctetString)((ASN1Sequence)object2).getObjectAt(0)).getOctets();
        aSN1Sequence = (ASN1Sequence)aSN1Sequence.getObjectAt(6);
        object2 = new byte[aSN1Sequence.size()][][][];
        object3 = new byte[aSN1Sequence.size()][][][];
        byte[][][] byArrayArray = new byte[aSN1Sequence.size()][][];
        byte[][] byArrayArray2 = new byte[aSN1Sequence.size()][];
        for (n = 0; n < aSN1Sequence.size(); ++n) {
            int n2;
            ASN1Sequence aSN1Sequence3;
            ASN1Sequence aSN1Sequence4 = (ASN1Sequence)aSN1Sequence.getObjectAt(n);
            object = (ASN1Sequence)aSN1Sequence4.getObjectAt(0);
            object2[n] = new byte[((ASN1Sequence)object).size()][][];
            for (int i = 0; i < ((ASN1Sequence)object).size(); ++i) {
                aSN1Sequence3 = (ASN1Sequence)((ASN1Sequence)object).getObjectAt(i);
                object2[n][i] = new byte[aSN1Sequence3.size()][];
                for (n2 = 0; n2 < aSN1Sequence3.size(); ++n2) {
                    object2[n][i][n2] = ((ASN1OctetString)aSN1Sequence3.getObjectAt(n2)).getOctets();
                }
            }
            ASN1Sequence aSN1Sequence5 = (ASN1Sequence)aSN1Sequence4.getObjectAt(1);
            object3[n] = new byte[aSN1Sequence5.size()][][];
            for (int i = 0; i < aSN1Sequence5.size(); ++i) {
                ASN1Sequence aSN1Sequence6 = (ASN1Sequence)aSN1Sequence5.getObjectAt(i);
                object3[n][i] = new byte[aSN1Sequence6.size()][];
                for (int j = 0; j < aSN1Sequence6.size(); ++j) {
                    object3[n][i][j] = ((ASN1OctetString)aSN1Sequence6.getObjectAt(j)).getOctets();
                }
            }
            aSN1Sequence3 = (ASN1Sequence)aSN1Sequence4.getObjectAt(2);
            byArrayArray[n] = new byte[aSN1Sequence3.size()][];
            for (n2 = 0; n2 < aSN1Sequence3.size(); ++n2) {
                byArrayArray[n][n2] = ((ASN1OctetString)aSN1Sequence3.getObjectAt(n2)).getOctets();
            }
            byArrayArray2[n] = ((ASN1OctetString)aSN1Sequence4.getObjectAt(3)).getOctets();
        }
        n = this.vi.length - 1;
        this.layers = new Layer[n];
        for (int i = 0; i < n; ++i) {
            this.layers[i] = object = new Layer(this.vi[i], this.vi[i + 1], RainbowUtil.convertArray((byte[][][])object2[i]), RainbowUtil.convertArray((byte[][][])object3[i]), RainbowUtil.convertArray(byArrayArray[i]), RainbowUtil.convertArray(byArrayArray2[i]));
        }
    }

    public RainbowPrivateKey(short[][] object, short[] objectArray, short[][] sArray, short[] sArray2, int[] nArray, Layer[] layerArray) {
        this.version = new ASN1Integer(1L);
        this.invA1 = RainbowUtil.convertArray(object);
        this.b1 = RainbowUtil.convertArray(objectArray);
        this.invA2 = RainbowUtil.convertArray(sArray);
        this.b2 = RainbowUtil.convertArray(sArray2);
        object = nArray;
        objectArray = new byte[nArray.length];
        for (int i = 0; i < ((short[][])object).length; ++i) {
            objectArray[i] = (byte)object[i];
        }
        this.vi = (byte[])objectArray;
        this.layers = layerArray;
    }

    public static RainbowPrivateKey getInstance$34d83c4d(ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable instanceof RainbowPrivateKey) {
            return (RainbowPrivateKey)aSN1Encodable;
        }
        if (aSN1Encodable != null) {
            return new RainbowPrivateKey(ASN1Sequence.getInstance(aSN1Encodable));
        }
        return null;
    }

    public final short[][] getInvA1() {
        return RainbowUtil.convertArray(this.invA1);
    }

    public final short[] getB1() {
        return RainbowUtil.convertArray(this.b1);
    }

    public final short[] getB2() {
        return RainbowUtil.convertArray(this.b2);
    }

    public final short[][] getInvA2() {
        return RainbowUtil.convertArray(this.invA2);
    }

    public final Layer[] getLayers() {
        return this.layers;
    }

    public final int[] getVi() {
        byte[] byArray = this.vi;
        int[] nArray = new int[this.vi.length];
        for (int i = 0; i < byArray.length; ++i) {
            nArray[i] = byArray[i] & 0xFF;
        }
        return nArray;
    }

    public final ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.version != null) {
            aSN1EncodableVector.add(this.version);
        } else {
            aSN1EncodableVector.add(this.oid);
        }
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        for (int i = 0; i < this.invA1.length; ++i) {
            aSN1EncodableVector2.add(new DEROctetString(this.invA1[i]));
        }
        aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector2));
        ASN1EncodableVector aSN1EncodableVector3 = new ASN1EncodableVector();
        aSN1EncodableVector3.add(new DEROctetString(this.b1));
        aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector3));
        aSN1EncodableVector2 = new ASN1EncodableVector();
        for (int i = 0; i < this.invA2.length; ++i) {
            aSN1EncodableVector2.add(new DEROctetString(this.invA2[i]));
        }
        aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector2));
        ASN1EncodableVector aSN1EncodableVector4 = new ASN1EncodableVector();
        aSN1EncodableVector4.add(new DEROctetString(this.b2));
        aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector4));
        aSN1EncodableVector2 = new ASN1EncodableVector();
        aSN1EncodableVector2.add(new DEROctetString(this.vi));
        aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector2));
        aSN1EncodableVector2 = new ASN1EncodableVector();
        for (int i = 0; i < this.layers.length; ++i) {
            int n;
            ASN1EncodableVector aSN1EncodableVector5;
            ASN1EncodableVector aSN1EncodableVector6 = new ASN1EncodableVector();
            Object object = RainbowUtil.convertArray(this.layers[i].getCoeffAlpha());
            ASN1EncodableVector aSN1EncodableVector7 = new ASN1EncodableVector();
            for (int j = 0; j < ((byte[][][])object).length; ++j) {
                aSN1EncodableVector5 = new ASN1EncodableVector();
                for (n = 0; n < object[j].length; ++n) {
                    aSN1EncodableVector5.add(new DEROctetString(object[j][n]));
                }
                aSN1EncodableVector7.add(new DERSequence(aSN1EncodableVector5));
            }
            aSN1EncodableVector6.add(new DERSequence(aSN1EncodableVector7));
            byte[][][] byArray = RainbowUtil.convertArray(this.layers[i].getCoeffBeta());
            aSN1EncodableVector5 = new ASN1EncodableVector();
            for (n = 0; n < byArray.length; ++n) {
                object = new ASN1EncodableVector();
                for (int j = 0; j < byArray[n].length; ++j) {
                    ((ASN1EncodableVector)object).add(new DEROctetString(byArray[n][j]));
                }
                aSN1EncodableVector5.add(new DERSequence((ASN1EncodableVector)object));
            }
            aSN1EncodableVector6.add(new DERSequence(aSN1EncodableVector5));
            byte[][] byArray2 = RainbowUtil.convertArray(this.layers[i].getCoeffGamma());
            object = new ASN1EncodableVector();
            for (int j = 0; j < byArray2.length; ++j) {
                ((ASN1EncodableVector)object).add(new DEROctetString(byArray2[j]));
            }
            aSN1EncodableVector6.add(new DERSequence((ASN1EncodableVector)object));
            aSN1EncodableVector6.add(new DEROctetString(RainbowUtil.convertArray(this.layers[i].getCoeffEta())));
            aSN1EncodableVector2.add(new DERSequence(aSN1EncodableVector6));
        }
        aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector2));
        return new DERSequence(aSN1EncodableVector);
    }
}

