/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.asn1;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.util.Arrays;

public final class XMSSMTPrivateKey
extends ASN1Object {
    private final int version;
    private final long index;
    private final long maxIndex;
    private final byte[] secretKeySeed;
    private final byte[] secretKeyPRF;
    private final byte[] publicSeed;
    private final byte[] root;
    private final byte[] bdsState;

    public XMSSMTPrivateKey(long l, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5) {
        this.version = 0;
        this.index = l;
        this.secretKeySeed = Arrays.clone(byArray);
        this.secretKeyPRF = Arrays.clone(byArray2);
        this.publicSeed = Arrays.clone(byArray3);
        this.root = Arrays.clone(byArray4);
        this.bdsState = Arrays.clone(byArray5);
        this.maxIndex = -1L;
    }

    public XMSSMTPrivateKey(long l, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, long l2) {
        this.version = 1;
        this.index = l;
        this.secretKeySeed = Arrays.clone(byArray);
        this.secretKeyPRF = Arrays.clone(byArray2);
        this.publicSeed = Arrays.clone(byArray3);
        this.root = Arrays.clone(byArray4);
        this.bdsState = Arrays.clone(byArray5);
        this.maxIndex = l2;
    }

    private XMSSMTPrivateKey(ASN1Sequence aSN1Sequence) {
        ASN1Primitive aSN1Primitive = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0));
        if (!((ASN1Integer)aSN1Primitive).hasValue(0) && !((ASN1Integer)aSN1Primitive).hasValue(1)) {
            throw new IllegalArgumentException("unknown version of sequence");
        }
        this.version = ((ASN1Integer)aSN1Primitive).intValueExact();
        if (aSN1Sequence.size() != 2 && aSN1Sequence.size() != 3) {
            throw new IllegalArgumentException("key sequence wrong size");
        }
        aSN1Primitive = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(1));
        this.index = ASN1Integer.getInstance(((ASN1Sequence)aSN1Primitive).getObjectAt(0)).longValueExact();
        this.secretKeySeed = Arrays.clone(DEROctetString.getInstance(((ASN1Sequence)aSN1Primitive).getObjectAt(1)).getOctets());
        this.secretKeyPRF = Arrays.clone(DEROctetString.getInstance(((ASN1Sequence)aSN1Primitive).getObjectAt(2)).getOctets());
        this.publicSeed = Arrays.clone(DEROctetString.getInstance(((ASN1Sequence)aSN1Primitive).getObjectAt(3)).getOctets());
        this.root = Arrays.clone(DEROctetString.getInstance(((ASN1Sequence)aSN1Primitive).getObjectAt(4)).getOctets());
        if (((ASN1Sequence)aSN1Primitive).size() == 6) {
            if (((ASN1TaggedObject)(aSN1Primitive = ASN1TaggedObject.getInstance$74894196(((ASN1Sequence)aSN1Primitive).getObjectAt(5)))).getTagNo() != 0) {
                throw new IllegalArgumentException("unknown tag in XMSSPrivateKey");
            }
            this.maxIndex = ASN1Integer.getInstance((ASN1TaggedObject)aSN1Primitive, false).longValueExact();
        } else if (((ASN1Sequence)aSN1Primitive).size() == 5) {
            this.maxIndex = -1L;
        } else {
            throw new IllegalArgumentException("keySeq should be 5 or 6 in length");
        }
        if (aSN1Sequence.size() == 3) {
            this.bdsState = Arrays.clone(DEROctetString.getInstance(ASN1TaggedObject.getInstance$74894196(aSN1Sequence.getObjectAt(2)), true).getOctets());
            return;
        }
        this.bdsState = null;
    }

    public static XMSSMTPrivateKey getInstance$407d0d5f(ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable instanceof XMSSMTPrivateKey) {
            return (XMSSMTPrivateKey)aSN1Encodable;
        }
        if (aSN1Encodable != null) {
            return new XMSSMTPrivateKey(ASN1Sequence.getInstance(aSN1Encodable));
        }
        return null;
    }

    public final int getVersion() {
        return this.version;
    }

    public final long getIndex() {
        return this.index;
    }

    public final long getMaxIndex() {
        return this.maxIndex;
    }

    public final byte[] getSecretKeySeed() {
        return Arrays.clone(this.secretKeySeed);
    }

    public final byte[] getSecretKeyPRF() {
        return Arrays.clone(this.secretKeyPRF);
    }

    public final byte[] getPublicSeed() {
        return Arrays.clone(this.publicSeed);
    }

    public final byte[] getRoot() {
        return Arrays.clone(this.root);
    }

    public final byte[] getBdsState() {
        return Arrays.clone(this.bdsState);
    }

    public final ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.maxIndex >= 0L) {
            aSN1EncodableVector.add(new ASN1Integer(1L));
        } else {
            aSN1EncodableVector.add(new ASN1Integer(0L));
        }
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        aSN1EncodableVector2.add(new ASN1Integer(this.index));
        aSN1EncodableVector2.add(new DEROctetString(this.secretKeySeed));
        aSN1EncodableVector2.add(new DEROctetString(this.secretKeyPRF));
        aSN1EncodableVector2.add(new DEROctetString(this.publicSeed));
        aSN1EncodableVector2.add(new DEROctetString(this.root));
        if (this.maxIndex >= 0L) {
            aSN1EncodableVector2.add(new DERTaggedObject(false, 0, new ASN1Integer(this.maxIndex)));
        }
        aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector2));
        aSN1EncodableVector.add(new DERTaggedObject(true, 0, new DEROctetString(this.bdsState)));
        return new DERSequence(aSN1EncodableVector);
    }
}

