/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.lms;

import java.io.ByteArrayOutputStream;
import org.bouncycastle.util.Encodable;

public final class Composer {
    private final ByteArrayOutputStream bos = new ByteArrayOutputStream();

    private Composer() {
    }

    public static Composer compose() {
        return new Composer();
    }

    public final Composer u64str(long l) {
        this.u32str((int)(l >>> 32));
        this.u32str((int)l);
        return this;
    }

    public final Composer u32str(int n) {
        this.bos.write((byte)(n >>> 24));
        this.bos.write((byte)(n >>> 16));
        this.bos.write((byte)(n >>> 8));
        this.bos.write((byte)n);
        return this;
    }

    public final Composer u16str(int n) {
        this.bos.write(-128);
        this.bos.write(-128);
        return this;
    }

    public final Composer bytes(Encodable encodable) {
        try {
            this.bos.write(encodable.getEncoded());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
        return this;
    }

    public final Composer bytes(byte[][] byArray) {
        try {
            for (byte[] byArray2 : byArray) {
                this.bos.write(byArray2);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
        return this;
    }

    public final Composer bytes(byte[] byArray) {
        try {
            this.bos.write(byArray);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
        return this;
    }

    public final byte[] build() {
        return this.bos.toByteArray();
    }

    public final Composer padUntil(int n, int n2) {
        while (this.bos.size() < n2) {
            this.bos.write(0);
        }
        return this;
    }

    public final Composer bool(boolean bl) {
        this.bos.write(bl ? 1 : 0);
        return this;
    }
}

