/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.lms;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.pqc.crypto.lms.Composer;
import org.bouncycastle.pqc.crypto.lms.HSSPublicKeyParameters;
import org.bouncycastle.pqc.crypto.lms.LMSKeyParameters;
import org.bouncycastle.pqc.crypto.lms.LMSPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.lms.LMSSignature;
import org.bouncycastle.util.io.Streams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HSSPrivateKeyParameters
extends LMSKeyParameters {
    private final int l;
    private final boolean isShard;
    private List<LMSPrivateKeyParameters> keys;
    private List<LMSSignature> sig;
    private final long indexLimit;
    private long index = 0L;
    private HSSPublicKeyParameters publicKey;

    private HSSPrivateKeyParameters(int n, List<LMSPrivateKeyParameters> list2, List<LMSSignature> list3, long l, long l2, boolean bl) {
        super(true);
        this.l = n;
        this.keys = Collections.unmodifiableList(list2);
        this.sig = Collections.unmodifiableList(list3);
        this.index = l;
        this.indexLimit = l2;
        this.isShard = bl;
    }

    public static HSSPrivateKeyParameters getInstance(byte[] object, byte[] byArray) throws IOException {
        object = HSSPrivateKeyParameters.getInstance(object);
        v0.publicKey = HSSPublicKeyParameters.getInstance(byArray);
        return object;
    }

    public static HSSPrivateKeyParameters getInstance(Object object) throws IOException {
        while (true) {
            if (object instanceof HSSPrivateKeyParameters) {
                return (HSSPrivateKeyParameters)object;
            }
            if (object instanceof DataInputStream) {
                int n;
                if (((DataInputStream)object).readInt() != 0) {
                    throw new IllegalStateException("unknown version for hss private key");
                }
                int n2 = ((DataInputStream)object).readInt();
                long l = ((DataInputStream)object).readLong();
                long l2 = ((DataInputStream)object).readLong();
                boolean bl = ((DataInputStream)object).readBoolean();
                ArrayList<LMSPrivateKeyParameters> arrayList = new ArrayList<LMSPrivateKeyParameters>();
                ArrayList<LMSSignature> arrayList2 = new ArrayList<LMSSignature>();
                for (n = 0; n < n2; ++n) {
                    arrayList.add(LMSPrivateKeyParameters.getInstance(object));
                }
                for (n = 0; n < n2 - 1; ++n) {
                    arrayList2.add(LMSSignature.getInstance(object));
                }
                return new HSSPrivateKeyParameters(n2, arrayList, arrayList2, l, l2, bl);
            }
            if (object instanceof byte[]) {
                HSSPrivateKeyParameters hSSPrivateKeyParameters;
                InputStream inputStream = null;
                try {
                    inputStream = new DataInputStream(new ByteArrayInputStream((byte[])object));
                    hSSPrivateKeyParameters = HSSPrivateKeyParameters.getInstance(inputStream);
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    throw throwable;
                }
                inputStream.close();
                return hSSPrivateKeyParameters;
            }
            if (!(object instanceof InputStream)) break;
            object = Streams.readAll((InputStream)object);
        }
        throw new IllegalArgumentException("cannot parse " + object);
    }

    public final int getL() {
        return this.l;
    }

    private static HSSPrivateKeyParameters makeCopy(HSSPrivateKeyParameters hSSPrivateKeyParameters) {
        try {
            return HSSPrivateKeyParameters.getInstance(((LMSKeyParameters)hSSPrivateKeyParameters).getEncoded());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }

    public final synchronized HSSPublicKeyParameters getPublicKey() {
        HSSPrivateKeyParameters hSSPrivateKeyParameters = this;
        return new HSSPublicKeyParameters(this.l, hSSPrivateKeyParameters.keys.get(0).getPublicKey());
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (HSSPrivateKeyParameters)object;
        if (this.l != ((HSSPrivateKeyParameters)object).l) {
            return false;
        }
        if (this.isShard != ((HSSPrivateKeyParameters)object).isShard) {
            return false;
        }
        if (this.indexLimit != ((HSSPrivateKeyParameters)object).indexLimit) {
            return false;
        }
        if (this.index != ((HSSPrivateKeyParameters)object).index) {
            return false;
        }
        if (!this.keys.equals(((HSSPrivateKeyParameters)object).keys)) {
            return false;
        }
        return this.sig.equals(((HSSPrivateKeyParameters)object).sig);
    }

    @Override
    public final synchronized byte[] getEncoded() throws IOException {
        Composer composer = Composer.compose().u32str(0).u32str(this.l).u64str(this.index).u64str(this.indexLimit).bool(this.isShard);
        for (LMSPrivateKeyParameters encodable : this.keys) {
            composer.bytes(encodable);
        }
        for (LMSSignature lMSSignature : this.sig) {
            composer.bytes(lMSSignature);
        }
        return composer.build();
    }

    public final int hashCode() {
        int n = this.l;
        n = n * 31 + (this.isShard ? 1 : 0);
        n = n * 31 + this.keys.hashCode();
        n = n * 31 + this.sig.hashCode();
        n = n * 31 + (int)(this.indexLimit ^ this.indexLimit >>> 32);
        n = n * 31 + (int)(this.index ^ this.index >>> 32);
        return n;
    }

    protected final Object clone() throws CloneNotSupportedException {
        return HSSPrivateKeyParameters.makeCopy(this);
    }
}

