/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.lms;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.pqc.crypto.lms.Composer;
import org.bouncycastle.pqc.crypto.lms.LMSKeyParameters;
import org.bouncycastle.pqc.crypto.lms.LMSPublicKeyParameters;
import org.bouncycastle.util.io.Streams;

public final class HSSPublicKeyParameters
extends LMSKeyParameters {
    private final int l;
    private final LMSPublicKeyParameters lmsPublicKey;

    public HSSPublicKeyParameters(int n, LMSPublicKeyParameters lMSPublicKeyParameters) {
        super(false);
        this.l = n;
        this.lmsPublicKey = lMSPublicKeyParameters;
    }

    public static HSSPublicKeyParameters getInstance(Object object) throws IOException {
        while (true) {
            if (object instanceof HSSPublicKeyParameters) {
                return (HSSPublicKeyParameters)object;
            }
            if (object instanceof DataInputStream) {
                int n = ((DataInputStream)object).readInt();
                object = LMSPublicKeyParameters.getInstance(object);
                return new HSSPublicKeyParameters(n, (LMSPublicKeyParameters)object);
            }
            if (object instanceof byte[]) {
                InputStream inputStream = null;
                try {
                    inputStream = new DataInputStream(new ByteArrayInputStream((byte[])object));
                    object = HSSPublicKeyParameters.getInstance(inputStream);
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    throw throwable;
                }
                inputStream.close();
                return object;
            }
            if (!(object instanceof InputStream)) break;
            object = Streams.readAll((InputStream)object);
        }
        throw new IllegalArgumentException("cannot parse " + object);
    }

    public final int getL() {
        return this.l;
    }

    public final LMSPublicKeyParameters getLMSPublicKey() {
        return this.lmsPublicKey;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (HSSPublicKeyParameters)object;
        if (this.l != ((HSSPublicKeyParameters)object).l) {
            return false;
        }
        return this.lmsPublicKey.equals(((HSSPublicKeyParameters)object).lmsPublicKey);
    }

    public final int hashCode() {
        int n = this.l;
        n = n * 31 + this.lmsPublicKey.hashCode();
        return n;
    }

    public final byte[] getEncoded() throws IOException {
        return Composer.compose().u32str(this.l).bytes(((LMSKeyParameters)this.lmsPublicKey).getEncoded()).build();
    }
}

