/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.mceliece;

import org.bouncycastle.pqc.crypto.mceliece.McElieceKeyParameters;
import org.bouncycastle.pqc.math.linearalgebra.GF2Matrix;
import org.bouncycastle.pqc.math.linearalgebra.GF2mField;
import org.bouncycastle.pqc.math.linearalgebra.GoppaCode;
import org.bouncycastle.pqc.math.linearalgebra.Permutation;
import org.bouncycastle.pqc.math.linearalgebra.PolynomialGF2mSmallM;
import org.bouncycastle.pqc.math.linearalgebra.PolynomialRingGF2m;

public final class McEliecePrivateKeyParameters
extends McElieceKeyParameters {
    private int n;
    private int k;
    private GF2mField field;
    private PolynomialGF2mSmallM goppaPoly;
    private GF2Matrix sInv;
    private Permutation p1;
    private Permutation p2;
    private GF2Matrix h;
    private PolynomialGF2mSmallM[] qInv;

    public McEliecePrivateKeyParameters(int n, int n2, GF2mField gF2mField, PolynomialGF2mSmallM polynomialGF2mSmallM, Permutation permutation, Permutation permutation2, GF2Matrix gF2Matrix) {
        super(true, null);
        this.k = n2;
        this.n = n;
        this.field = gF2mField;
        this.goppaPoly = polynomialGF2mSmallM;
        this.sInv = gF2Matrix;
        this.p1 = permutation;
        this.p2 = permutation2;
        this.h = GoppaCode.createCanonicalCheckMatrix(gF2mField, polynomialGF2mSmallM);
        PolynomialRingGF2m polynomialRingGF2m = new PolynomialRingGF2m(gF2mField, polynomialGF2mSmallM);
        this.qInv = polynomialRingGF2m.getSquareRootMatrix();
    }

    public final int getN() {
        return this.n;
    }

    public final int getK() {
        return this.k;
    }

    public final GF2mField getField() {
        return this.field;
    }

    public final PolynomialGF2mSmallM getGoppaPoly() {
        return this.goppaPoly;
    }

    public final GF2Matrix getSInv() {
        return this.sInv;
    }

    public final Permutation getP1() {
        return this.p1;
    }

    public final Permutation getP2() {
        return this.p2;
    }
}

