/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.isara.IsaraObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.pqc.asn1.McElieceCCA2PublicKey;
import org.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import org.bouncycastle.pqc.asn1.SPHINCS256KeyParams;
import org.bouncycastle.pqc.asn1.XMSSKeyParams;
import org.bouncycastle.pqc.asn1.XMSSMTKeyParams;
import org.bouncycastle.pqc.asn1.XMSSPublicKey;
import org.bouncycastle.pqc.crypto.lms.HSSPublicKeyParameters;
import org.bouncycastle.pqc.crypto.lms.LMSPublicKeyParameters;
import org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PublicKeyParameters;
import org.bouncycastle.pqc.crypto.newhope.NHPublicKeyParameters;
import org.bouncycastle.pqc.crypto.qtesla.QTESLAPublicKeyParameters;
import org.bouncycastle.pqc.crypto.sphincs.SPHINCSPublicKeyParameters;
import org.bouncycastle.pqc.crypto.util.Utils;
import org.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSMTPublicKeyParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSPublicKeyParameters;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

public final class PublicKeyFactory {
    private static Map converters = new HashMap<ASN1ObjectIdentifier, QTeslaConverter>();

    public static AsymmetricKeyParameter createKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        SubjectPublicKeyInfo subjectPublicKeyInfo2 = subjectPublicKeyInfo;
        subjectPublicKeyInfo = null;
        subjectPublicKeyInfo = subjectPublicKeyInfo2;
        AlgorithmIdentifier algorithmIdentifier = subjectPublicKeyInfo2.getAlgorithm();
        SubjectPublicKeyInfoConverter subjectPublicKeyInfoConverter = (SubjectPublicKeyInfoConverter)converters.get(algorithmIdentifier.getAlgorithm());
        if (subjectPublicKeyInfoConverter != null) {
            return subjectPublicKeyInfoConverter.getPublicKeyParameters$61fb46e9(subjectPublicKeyInfo);
        }
        throw new IOException("algorithm identifier in public key not recognised: " + algorithmIdentifier.getAlgorithm());
    }

    static {
        converters.put(PQCObjectIdentifiers.qTESLA_p_I, new QTeslaConverter(0));
        converters.put(PQCObjectIdentifiers.qTESLA_p_III, new QTeslaConverter(0));
        converters.put(PQCObjectIdentifiers.sphincs256, new SPHINCSConverter(0));
        converters.put(PQCObjectIdentifiers.newHope, new NHConverter(0));
        converters.put(PQCObjectIdentifiers.xmss, new XMSSConverter(0));
        converters.put(PQCObjectIdentifiers.xmss_mt, new XMSSMTConverter(0));
        converters.put(IsaraObjectIdentifiers.id_alg_xmss, new XMSSConverter(0));
        converters.put(IsaraObjectIdentifiers.id_alg_xmssmt, new XMSSMTConverter(0));
        converters.put(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig, new LMSConverter(0));
        converters.put(PQCObjectIdentifiers.mcElieceCca2, new McElieceCCA2Converter(0));
    }

    private static final class LMSConverter
    extends SubjectPublicKeyInfoConverter {
        private LMSConverter() {
            super((byte)0);
        }

        final AsymmetricKeyParameter getPublicKeyParameters$61fb46e9(SubjectPublicKeyInfo object) throws IOException {
            byte[] byArray = ASN1OctetString.getInstance(((SubjectPublicKeyInfo)object).parsePublicKey()).getOctets();
            object = byArray;
            if (Pack.bigEndianToInt(byArray, 0) == 1) {
                return LMSPublicKeyParameters.getInstance(Arrays.copyOfRange((byte[])object, 4, ((Object)object).length));
            }
            if (((Object)object).length == 64) {
                object = Arrays.copyOfRange((byte[])object, 4, ((Object)object).length);
            }
            return HSSPublicKeyParameters.getInstance(object);
        }

        /* synthetic */ LMSConverter(byte by) {
            this();
        }
    }

    private static final class McElieceCCA2Converter
    extends SubjectPublicKeyInfoConverter {
        private McElieceCCA2Converter() {
            super((byte)0);
        }

        final AsymmetricKeyParameter getPublicKeyParameters$61fb46e9(SubjectPublicKeyInfo aSN1Object) throws IOException {
            aSN1Object = McElieceCCA2PublicKey.getInstance$699ef8b5(((SubjectPublicKeyInfo)aSN1Object).parsePublicKey());
            return new McElieceCCA2PublicKeyParameters(((McElieceCCA2PublicKey)aSN1Object).getN(), ((McElieceCCA2PublicKey)aSN1Object).getT(), ((McElieceCCA2PublicKey)aSN1Object).getG(), Utils.getDigestName(((McElieceCCA2PublicKey)aSN1Object).getDigest().getAlgorithm()));
        }

        /* synthetic */ McElieceCCA2Converter(byte by) {
            this();
        }
    }

    private static final class NHConverter
    extends SubjectPublicKeyInfoConverter {
        private NHConverter() {
            super((byte)0);
        }

        final AsymmetricKeyParameter getPublicKeyParameters$61fb46e9(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
            return new NHPublicKeyParameters(subjectPublicKeyInfo.getPublicKeyData().getBytes());
        }

        /* synthetic */ NHConverter(byte by) {
            this();
        }
    }

    private static final class QTeslaConverter
    extends SubjectPublicKeyInfoConverter {
        private QTeslaConverter() {
            super((byte)0);
        }

        final AsymmetricKeyParameter getPublicKeyParameters$61fb46e9(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
            return new QTESLAPublicKeyParameters(Utils.qTeslaLookupSecurityCategory(subjectPublicKeyInfo.getAlgorithm()), subjectPublicKeyInfo.getPublicKeyData().getOctets());
        }

        /* synthetic */ QTeslaConverter(byte by) {
            this();
        }
    }

    private static final class SPHINCSConverter
    extends SubjectPublicKeyInfoConverter {
        private SPHINCSConverter() {
            super((byte)0);
        }

        final AsymmetricKeyParameter getPublicKeyParameters$61fb46e9(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
            return new SPHINCSPublicKeyParameters(subjectPublicKeyInfo.getPublicKeyData().getBytes(), Utils.sphincs256LookupTreeAlgName(SPHINCS256KeyParams.getInstance$789c2f4d(subjectPublicKeyInfo.getAlgorithm().getParameters())));
        }

        /* synthetic */ SPHINCSConverter(byte by) {
            this();
        }
    }

    private static abstract class SubjectPublicKeyInfoConverter {
        private SubjectPublicKeyInfoConverter() {
        }

        abstract AsymmetricKeyParameter getPublicKeyParameters$61fb46e9(SubjectPublicKeyInfo var1) throws IOException;

        /* synthetic */ SubjectPublicKeyInfoConverter(byte by) {
            this();
        }
    }

    private static final class XMSSConverter
    extends SubjectPublicKeyInfoConverter {
        private XMSSConverter() {
            super((byte)0);
        }

        final AsymmetricKeyParameter getPublicKeyParameters$61fb46e9(SubjectPublicKeyInfo aSN1Object) throws IOException {
            XMSSKeyParams xMSSKeyParams = XMSSKeyParams.getInstance$58408def(((SubjectPublicKeyInfo)aSN1Object).getAlgorithm().getParameters());
            if (xMSSKeyParams != null) {
                ASN1ObjectIdentifier aSN1ObjectIdentifier = xMSSKeyParams.getTreeDigest().getAlgorithm();
                aSN1Object = XMSSPublicKey.getInstance$1d4c9262(((SubjectPublicKeyInfo)aSN1Object).parsePublicKey());
                return new XMSSPublicKeyParameters.Builder(new XMSSParameters(xMSSKeyParams.getHeight(), Utils.getDigest$d59b23a(aSN1ObjectIdentifier))).withPublicSeed(((XMSSPublicKey)aSN1Object).getPublicSeed()).withRoot(((XMSSPublicKey)aSN1Object).getRoot()).build();
            }
            byte[] byArray = ASN1OctetString.getInstance(((SubjectPublicKeyInfo)aSN1Object).parsePublicKey()).getOctets();
            return new XMSSPublicKeyParameters.Builder(XMSSParameters.lookupByOID(Pack.bigEndianToInt(byArray, 0))).withPublicKey(byArray).build();
        }

        /* synthetic */ XMSSConverter(byte by) {
            this();
        }
    }

    private static final class XMSSMTConverter
    extends SubjectPublicKeyInfoConverter {
        private XMSSMTConverter() {
            super((byte)0);
        }

        final AsymmetricKeyParameter getPublicKeyParameters$61fb46e9(SubjectPublicKeyInfo aSN1Object) throws IOException {
            XMSSMTKeyParams xMSSMTKeyParams = XMSSMTKeyParams.getInstance$71ba6896(((SubjectPublicKeyInfo)aSN1Object).getAlgorithm().getParameters());
            if (xMSSMTKeyParams != null) {
                ASN1ObjectIdentifier aSN1ObjectIdentifier = xMSSMTKeyParams.getTreeDigest().getAlgorithm();
                aSN1Object = XMSSPublicKey.getInstance$1d4c9262(((SubjectPublicKeyInfo)aSN1Object).parsePublicKey());
                return new XMSSMTPublicKeyParameters.Builder(new XMSSMTParameters(xMSSMTKeyParams.getHeight(), xMSSMTKeyParams.getLayers(), Utils.getDigest$d59b23a(aSN1ObjectIdentifier))).withPublicSeed(((XMSSPublicKey)aSN1Object).getPublicSeed()).withRoot(((XMSSPublicKey)aSN1Object).getRoot()).build();
            }
            byte[] byArray = ASN1OctetString.getInstance(((SubjectPublicKeyInfo)aSN1Object).parsePublicKey()).getOctets();
            return new XMSSMTPublicKeyParameters.Builder(XMSSMTParameters.lookupByOID(Pack.bigEndianToInt(byArray, 0))).withPublicKey(byArray).build();
        }

        /* synthetic */ XMSSMTConverter(byte by) {
            this();
        }
    }
}

