/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.util;

import java.io.IOException;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.isara.IsaraObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.pqc.asn1.McElieceCCA2PublicKey;
import org.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import org.bouncycastle.pqc.asn1.SPHINCS256KeyParams;
import org.bouncycastle.pqc.asn1.XMSSKeyParams;
import org.bouncycastle.pqc.asn1.XMSSMTKeyParams;
import org.bouncycastle.pqc.asn1.XMSSMTPublicKey;
import org.bouncycastle.pqc.asn1.XMSSPublicKey;
import org.bouncycastle.pqc.crypto.lms.Composer;
import org.bouncycastle.pqc.crypto.lms.HSSPublicKeyParameters;
import org.bouncycastle.pqc.crypto.lms.LMSPublicKeyParameters;
import org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2KeyParameters;
import org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PublicKeyParameters;
import org.bouncycastle.pqc.crypto.newhope.NHPublicKeyParameters;
import org.bouncycastle.pqc.crypto.qtesla.QTESLAPublicKeyParameters;
import org.bouncycastle.pqc.crypto.sphincs.SPHINCSKeyParameters;
import org.bouncycastle.pqc.crypto.sphincs.SPHINCSPublicKeyParameters;
import org.bouncycastle.pqc.crypto.util.Utils;
import org.bouncycastle.pqc.crypto.xmss.XMSSKeyParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSMTKeyParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSMTPublicKeyParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSPublicKeyParameters;
import org.bouncycastle.util.Encodable;

public final class SubjectPublicKeyInfoFactory {
    public static SubjectPublicKeyInfo createSubjectPublicKeyInfo(AsymmetricKeyParameter asymmetricKeyParameter) throws IOException {
        if (asymmetricKeyParameter instanceof QTESLAPublicKeyParameters) {
            asymmetricKeyParameter = (QTESLAPublicKeyParameters)asymmetricKeyParameter;
            AlgorithmIdentifier algorithmIdentifier = Utils.qTeslaLookupAlgID(((QTESLAPublicKeyParameters)asymmetricKeyParameter).getSecurityCategory());
            return new SubjectPublicKeyInfo(algorithmIdentifier, ((QTESLAPublicKeyParameters)asymmetricKeyParameter).getPublicData());
        }
        if (asymmetricKeyParameter instanceof SPHINCSPublicKeyParameters) {
            asymmetricKeyParameter = (SPHINCSPublicKeyParameters)asymmetricKeyParameter;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.sphincs256, new SPHINCS256KeyParams(Utils.sphincs256LookupTreeAlgID(((SPHINCSKeyParameters)asymmetricKeyParameter).getTreeDigest())));
            return new SubjectPublicKeyInfo(algorithmIdentifier, ((SPHINCSPublicKeyParameters)asymmetricKeyParameter).getKeyData());
        }
        if (asymmetricKeyParameter instanceof NHPublicKeyParameters) {
            asymmetricKeyParameter = (NHPublicKeyParameters)asymmetricKeyParameter;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.newHope);
            return new SubjectPublicKeyInfo(algorithmIdentifier, ((NHPublicKeyParameters)asymmetricKeyParameter).getPubData());
        }
        if (asymmetricKeyParameter instanceof LMSPublicKeyParameters) {
            asymmetricKeyParameter = (LMSPublicKeyParameters)asymmetricKeyParameter;
            byte[] byArray = Composer.compose().u32str(1).bytes((Encodable)((Object)asymmetricKeyParameter)).build();
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig);
            return new SubjectPublicKeyInfo(algorithmIdentifier, new DEROctetString(byArray));
        }
        if (asymmetricKeyParameter instanceof HSSPublicKeyParameters) {
            asymmetricKeyParameter = (HSSPublicKeyParameters)asymmetricKeyParameter;
            byte[] byArray = Composer.compose().u32str(((HSSPublicKeyParameters)asymmetricKeyParameter).getL()).bytes(((HSSPublicKeyParameters)asymmetricKeyParameter).getLMSPublicKey()).build();
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig);
            return new SubjectPublicKeyInfo(algorithmIdentifier, new DEROctetString(byArray));
        }
        if (asymmetricKeyParameter instanceof XMSSPublicKeyParameters) {
            asymmetricKeyParameter = (XMSSPublicKeyParameters)asymmetricKeyParameter;
            byte[] byArray = ((XMSSPublicKeyParameters)asymmetricKeyParameter).getPublicSeed();
            byte[] byArray2 = ((XMSSPublicKeyParameters)asymmetricKeyParameter).getRoot();
            byte[] byArray3 = ((XMSSPublicKeyParameters)asymmetricKeyParameter).getEncoded();
            if (byArray3.length > byArray.length + byArray2.length) {
                AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(IsaraObjectIdentifiers.id_alg_xmss);
                return new SubjectPublicKeyInfo(algorithmIdentifier, new DEROctetString(byArray3));
            }
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.xmss, new XMSSKeyParams(((XMSSPublicKeyParameters)asymmetricKeyParameter).getParameters().getHeight(), Utils.xmssLookupTreeAlgID(((XMSSKeyParameters)asymmetricKeyParameter).getTreeDigest())));
            return new SubjectPublicKeyInfo(algorithmIdentifier, new XMSSPublicKey(byArray, byArray2));
        }
        if (asymmetricKeyParameter instanceof XMSSMTPublicKeyParameters) {
            asymmetricKeyParameter = (XMSSMTPublicKeyParameters)asymmetricKeyParameter;
            byte[] byArray = ((XMSSMTPublicKeyParameters)asymmetricKeyParameter).getPublicSeed();
            byte[] byArray4 = ((XMSSMTPublicKeyParameters)asymmetricKeyParameter).getRoot();
            byte[] byArray5 = ((XMSSMTPublicKeyParameters)asymmetricKeyParameter).getEncoded();
            if (byArray5.length > byArray.length + byArray4.length) {
                AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(IsaraObjectIdentifiers.id_alg_xmssmt);
                return new SubjectPublicKeyInfo(algorithmIdentifier, new DEROctetString(byArray5));
            }
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.xmss_mt, new XMSSMTKeyParams(((XMSSMTPublicKeyParameters)asymmetricKeyParameter).getParameters().getHeight(), ((XMSSMTPublicKeyParameters)asymmetricKeyParameter).getParameters().getLayers(), Utils.xmssLookupTreeAlgID(((XMSSMTKeyParameters)asymmetricKeyParameter).getTreeDigest())));
            return new SubjectPublicKeyInfo(algorithmIdentifier, new XMSSMTPublicKey(((XMSSMTPublicKeyParameters)asymmetricKeyParameter).getPublicSeed(), ((XMSSMTPublicKeyParameters)asymmetricKeyParameter).getRoot()));
        }
        if (asymmetricKeyParameter instanceof McElieceCCA2PublicKeyParameters) {
            asymmetricKeyParameter = (McElieceCCA2PublicKeyParameters)asymmetricKeyParameter;
            McElieceCCA2PublicKey mcElieceCCA2PublicKey = new McElieceCCA2PublicKey(((McElieceCCA2PublicKeyParameters)asymmetricKeyParameter).getN(), ((McElieceCCA2PublicKeyParameters)asymmetricKeyParameter).getT(), ((McElieceCCA2PublicKeyParameters)asymmetricKeyParameter).getG(), Utils.getAlgorithmIdentifier(((McElieceCCA2KeyParameters)asymmetricKeyParameter).getDigest()));
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.mcElieceCca2);
            return new SubjectPublicKeyInfo(algorithmIdentifier, mcElieceCCA2PublicKey);
        }
        throw new IOException("key parameters not recognized");
    }
}

