/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.xmss;

import org.bouncycastle.pqc.crypto.xmss.KeyedHashFunctions;
import org.bouncycastle.pqc.crypto.xmss.OTSHashAddress;
import org.bouncycastle.pqc.crypto.xmss.WOTSPlusParameters;
import org.bouncycastle.pqc.crypto.xmss.WOTSPlusPublicKeyParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSAddress;
import org.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import org.bouncycastle.util.Arrays;

final class WOTSPlus {
    private final WOTSPlusParameters params;
    private final KeyedHashFunctions khf;
    private byte[] secretKeySeed;
    private byte[] publicSeed;

    WOTSPlus(WOTSPlusParameters wOTSPlusParameters) {
        if (wOTSPlusParameters == null) {
            throw new NullPointerException("params == null");
        }
        this.params = wOTSPlusParameters;
        int n = wOTSPlusParameters.getTreeDigestSize();
        this.khf = new KeyedHashFunctions(wOTSPlusParameters.getTreeDigest(), n);
        this.secretKeySeed = new byte[n];
        this.publicSeed = new byte[n];
    }

    final void importKeys(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            throw new NullPointerException("secretKeySeed == null");
        }
        if (byArray.length != this.params.getTreeDigestSize()) {
            throw new IllegalArgumentException("size of secretKeySeed needs to be equal to size of digest");
        }
        if (byArray2 == null) {
            throw new NullPointerException("publicSeed == null");
        }
        if (byArray2.length != this.params.getTreeDigestSize()) {
            throw new IllegalArgumentException("size of publicSeed needs to be equal to size of digest");
        }
        this.secretKeySeed = byArray;
        this.publicSeed = byArray2;
    }

    private byte[] chain(byte[] byArray, int n, int n2, OTSHashAddress object) {
        int n3 = this.params.getTreeDigestSize();
        if (byArray == null) {
            throw new NullPointerException("startHash == null");
        }
        if (byArray.length != n3) {
            throw new IllegalArgumentException("startHash needs to be " + n3 + "bytes");
        }
        if (object == null) {
            throw new NullPointerException("otsHashAddress == null");
        }
        if (((OTSHashAddress)object).toByteArray() == null) {
            throw new NullPointerException("otsHashAddress byte array == null");
        }
        if (n + n2 > this.params.getWinternitzParameter() - 1) {
            throw new IllegalArgumentException("max chain length must not be greater than w");
        }
        if (n2 == 0) {
            return byArray;
        }
        byArray = this.chain(byArray, n, n2 - 1, (OTSHashAddress)object);
        object = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(((XMSSAddress)object).getLayerAddress())).withTreeAddress(((XMSSAddress)object).getTreeAddress())).withOTSAddress(((OTSHashAddress)object).getOTSAddress()).withChainAddress(((OTSHashAddress)object).getChainAddress()).withHashAddress(n + n2 - 1).withKeyAndMask(0)).build();
        byte[] byArray2 = this.khf.PRF(this.publicSeed, ((OTSHashAddress)object).toByteArray());
        object = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(((XMSSAddress)object).getLayerAddress())).withTreeAddress(((XMSSAddress)object).getTreeAddress())).withOTSAddress(((OTSHashAddress)object).getOTSAddress()).withChainAddress(((OTSHashAddress)object).getChainAddress()).withHashAddress(((OTSHashAddress)object).getHashAddress()).withKeyAndMask(1)).build();
        byte[] byArray3 = this.khf.PRF(this.publicSeed, ((OTSHashAddress)object).toByteArray());
        object = new byte[n3];
        for (int i = 0; i < n3; ++i) {
            object[i] = (byte)(byArray[i] ^ byArray3[i]);
        }
        byArray = this.khf.F(byArray2, (byte[])object);
        return byArray;
    }

    protected final byte[] getWOTSPlusSecretKey(byte[] byArray, OTSHashAddress oTSHashAddress) {
        oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(oTSHashAddress.getLayerAddress())).withTreeAddress(oTSHashAddress.getTreeAddress())).withOTSAddress(oTSHashAddress.getOTSAddress()).build();
        return this.khf.PRF(byArray, oTSHashAddress.toByteArray());
    }

    protected final WOTSPlusParameters getParams() {
        return this.params;
    }

    protected final KeyedHashFunctions getKhf() {
        return this.khf;
    }

    protected final byte[] getPublicSeed() {
        return Arrays.clone(this.publicSeed);
    }

    final WOTSPlusPublicKeyParameters getPublicKey(OTSHashAddress oTSHashAddress) {
        if (oTSHashAddress == null) {
            throw new NullPointerException("otsHashAddress == null");
        }
        byte[][] byArrayArray = new byte[this.params.getLen()][];
        for (int i = 0; i < this.params.getLen(); ++i) {
            oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(oTSHashAddress.getLayerAddress())).withTreeAddress(oTSHashAddress.getTreeAddress())).withOTSAddress(oTSHashAddress.getOTSAddress()).withChainAddress(i).withHashAddress(oTSHashAddress.getHashAddress()).withKeyAndMask(oTSHashAddress.getKeyAndMask())).build();
            int n = i;
            WOTSPlus wOTSPlus = this;
            if (n < 0 || n >= wOTSPlus.params.getLen()) {
                throw new IllegalArgumentException("index out of bounds");
            }
            byArrayArray[i] = wOTSPlus.chain(wOTSPlus.khf.PRF(wOTSPlus.secretKeySeed, XMSSUtil.toBytesBigEndian(n, 32)), 0, this.params.getWinternitzParameter() - 1, oTSHashAddress);
        }
        return new WOTSPlusPublicKeyParameters(this.params, byArrayArray);
    }
}

