/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.xmss;

import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.pqc.crypto.xmss.DigestUtil;
import org.bouncycastle.pqc.crypto.xmss.WOTSPlusOid;
import org.bouncycastle.pqc.crypto.xmss.XMSSUtil;

final class WOTSPlusParameters {
    private final WOTSPlusOid oid$68c067dd;
    private final int digestSize;
    private final int winternitzParameter;
    private final int len;
    private final int len1;
    private final int len2;
    private final ASN1ObjectIdentifier treeDigest;

    protected WOTSPlusParameters(ASN1ObjectIdentifier object) {
        if (object == null) {
            throw new NullPointerException("treeDigest == null");
        }
        this.treeDigest = object;
        Object object2 = object = DigestUtil.getDigest$d59b23a((ASN1ObjectIdentifier)object);
        if (object2 == null) {
            throw new NullPointerException("digest == null");
        }
        String string = object2.getAlgorithmName();
        this.digestSize = string.equals("SHAKE128") ? 32 : (string.equals("SHAKE256") ? 64 : object2.getDigestSize());
        this.winternitzParameter = 16;
        this.len1 = (int)Math.ceil((double)(8 * this.digestSize) / (double)XMSSUtil.log2(this.winternitzParameter));
        this.len2 = XMSSUtil.log2(this.len1 * (this.winternitzParameter - 1)) / XMSSUtil.log2(this.winternitzParameter) + 1;
        this.len = this.len1 + this.len2;
        this.oid$68c067dd = WOTSPlusOid.lookup(object.getAlgorithmName(), this.digestSize, this.winternitzParameter, this.len);
        if (this.oid$68c067dd == null) {
            throw new IllegalArgumentException("cannot find OID for digest algorithm: " + object.getAlgorithmName());
        }
    }

    protected final int getTreeDigestSize() {
        return this.digestSize;
    }

    protected final int getWinternitzParameter() {
        return this.winternitzParameter;
    }

    protected final int getLen() {
        return this.len;
    }

    public final ASN1ObjectIdentifier getTreeDigest() {
        return this.treeDigest;
    }
}

