/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.xmss;

import java.io.IOException;
import org.bouncycastle.pqc.crypto.xmss.BDSStateMap;
import org.bouncycastle.pqc.crypto.xmss.XMSSMTKeyParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Encodable;

public final class XMSSMTPrivateKeyParameters
extends XMSSMTKeyParameters
implements Encodable {
    private final XMSSMTParameters params;
    private final byte[] secretKeySeed;
    private final byte[] secretKeyPRF;
    private final byte[] publicSeed;
    private final byte[] root;
    private volatile long index;
    private volatile BDSStateMap bdsState;

    private XMSSMTPrivateKeyParameters(Builder builder) {
        super(true, builder.params.getTreeDigest());
        this.params = builder.params;
        if (this.params == null) {
            throw new NullPointerException("params == null");
        }
        int n = this.params.getTreeDigestSize();
        byte[] byArray = builder.privateKey;
        if (byArray != null) {
            if (builder.xmss == null) {
                throw new NullPointerException("xmss == null");
            }
            int n2 = this.params.getHeight();
            int n3 = (n2 + 7) / 8;
            int n4 = n;
            int n5 = n;
            int n6 = n;
            int n7 = n;
            this.index = XMSSUtil.bytesToXBigEndian(byArray, 0, n3);
            if (!XMSSUtil.isIndexValid(n2, this.index)) {
                throw new IllegalArgumentException("index out of bounds");
            }
            int n8 = n3 + 0;
            this.secretKeySeed = XMSSUtil.extractBytesAtOffset(byArray, n8, n4);
            this.secretKeyPRF = XMSSUtil.extractBytesAtOffset(byArray, n8 += n4, n5);
            this.publicSeed = XMSSUtil.extractBytesAtOffset(byArray, n8 += n5, n6);
            this.root = XMSSUtil.extractBytesAtOffset(byArray, n8 += n6, n7);
            Object object = XMSSUtil.extractBytesAtOffset(byArray, n8 += n7, byArray.length - n8);
            try {
                object = (BDSStateMap)XMSSUtil.deserialize((byte[])object, BDSStateMap.class);
                this.bdsState = ((BDSStateMap)object).withWOTSDigest(builder.xmss.getTreeDigestOID());
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException.getMessage(), iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException(classNotFoundException.getMessage(), classNotFoundException);
            }
        } else {
            this.index = builder.index;
            byte[] byArray2 = builder.secretKeySeed;
            if (byArray2 != null) {
                if (byArray2.length != n) {
                    throw new IllegalArgumentException("size of secretKeySeed needs to be equal size of digest");
                }
                this.secretKeySeed = byArray2;
            } else {
                this.secretKeySeed = new byte[n];
            }
            byte[] byArray3 = builder.secretKeyPRF;
            if (byArray3 != null) {
                if (byArray3.length != n) {
                    throw new IllegalArgumentException("size of secretKeyPRF needs to be equal size of digest");
                }
                this.secretKeyPRF = byArray3;
            } else {
                this.secretKeyPRF = new byte[n];
            }
            byte[] byArray4 = builder.publicSeed;
            if (byArray4 != null) {
                if (byArray4.length != n) {
                    throw new IllegalArgumentException("size of publicSeed needs to be equal size of digest");
                }
                this.publicSeed = byArray4;
            } else {
                this.publicSeed = new byte[n];
            }
            byte[] byArray5 = builder.root;
            if (byArray5 != null) {
                if (byArray5.length != n) {
                    throw new IllegalArgumentException("size of root needs to be equal size of digest");
                }
                this.root = byArray5;
            } else {
                this.root = new byte[n];
            }
            BDSStateMap bDSStateMap = builder.bdsState;
            if (bDSStateMap != null) {
                this.bdsState = bDSStateMap;
            } else {
                long l = builder.index;
                n = this.params.getHeight();
                this.bdsState = XMSSUtil.isIndexValid(n, l) && byArray4 != null && byArray2 != null ? new BDSStateMap(this.params, builder.index, byArray4, byArray2) : new BDSStateMap(builder.maxIndex + 1L);
            }
            if (builder.maxIndex >= 0L && builder.maxIndex != this.bdsState.getMaxIndex()) {
                throw new IllegalArgumentException("maxIndex set but not reflected in state");
            }
        }
    }

    public final byte[] getEncoded() throws IOException {
        XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = this;
        synchronized (xMSSMTPrivateKeyParameters) {
            return this.toByteArray();
        }
    }

    public final byte[] toByteArray() {
        XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = this;
        synchronized (xMSSMTPrivateKeyParameters) {
            int n = this.params.getTreeDigestSize();
            int n2 = (this.params.getHeight() + 7) / 8;
            int n3 = n;
            int n4 = n;
            int n5 = n;
            n = n2 + n3 + n4 + n5 + n;
            byte[] byArray = new byte[n];
            byte[] byArray2 = XMSSUtil.toBytesBigEndian(this.index, n2);
            XMSSUtil.copyBytesAtOffset(byArray, byArray2, 0);
            XMSSUtil.copyBytesAtOffset(byArray, this.secretKeySeed, n2 += 0);
            XMSSUtil.copyBytesAtOffset(byArray, this.secretKeyPRF, n2 += n3);
            XMSSUtil.copyBytesAtOffset(byArray, this.publicSeed, n2 += n4);
            XMSSUtil.copyBytesAtOffset(byArray, this.root, n2 += n5);
            try {
                return Arrays.concatenate(byArray, XMSSUtil.serialize(this.bdsState));
            }
            catch (IOException iOException) {
                throw new IllegalStateException("error serializing bds state: " + iOException.getMessage(), iOException);
            }
        }
    }

    public final XMSSMTParameters getParameters() {
        return this.params;
    }

    /* synthetic */ XMSSMTPrivateKeyParameters(Builder builder, byte by) {
        this(builder);
    }

    public static final class Builder {
        private final XMSSMTParameters params;
        private long index = 0L;
        private long maxIndex = -1L;
        private byte[] secretKeySeed = null;
        private byte[] secretKeyPRF = null;
        private byte[] publicSeed = null;
        private byte[] root = null;
        private BDSStateMap bdsState = null;
        private byte[] privateKey = null;
        private XMSSParameters xmss = null;

        public Builder(XMSSMTParameters xMSSMTParameters) {
            this.params = xMSSMTParameters;
        }

        public final Builder withIndex(long l) {
            this.index = l;
            return this;
        }

        public final Builder withMaxIndex(long l) {
            this.maxIndex = l;
            return this;
        }

        public final Builder withSecretKeySeed(byte[] byArray) {
            this.secretKeySeed = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public final Builder withSecretKeyPRF(byte[] byArray) {
            this.secretKeyPRF = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public final Builder withPublicSeed(byte[] byArray) {
            this.publicSeed = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public final Builder withRoot(byte[] byArray) {
            this.root = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public final Builder withBDSState(BDSStateMap bDSStateMap) {
            this.bdsState = bDSStateMap.getMaxIndex() == 0L ? new BDSStateMap(bDSStateMap, (1L << this.params.getHeight()) - 1L) : bDSStateMap;
            return this;
        }

        public final XMSSMTPrivateKeyParameters build() {
            return new XMSSMTPrivateKeyParameters(this, 0);
        }
    }
}

