/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.xmss;

import java.io.IOException;
import org.bouncycastle.pqc.crypto.xmss.BDS;
import org.bouncycastle.pqc.crypto.xmss.OTSHashAddress;
import org.bouncycastle.pqc.crypto.xmss.XMSSKeyParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Encodable;
import org.bouncycastle.util.Pack;

public final class XMSSPrivateKeyParameters
extends XMSSKeyParameters
implements Encodable {
    private final XMSSParameters params;
    private final byte[] secretKeySeed;
    private final byte[] secretKeyPRF;
    private final byte[] publicSeed;
    private final byte[] root;
    private volatile BDS bdsState;

    private XMSSPrivateKeyParameters(Builder builder) {
        super(true, builder.params.getTreeDigest());
        this.params = builder.params;
        if (this.params == null) {
            throw new NullPointerException("params == null");
        }
        int n = this.params.getTreeDigestSize();
        byte[] byArray = builder.privateKey;
        if (byArray != null) {
            int n2 = this.params.getHeight();
            int n3 = n;
            int n4 = n;
            int n5 = n;
            int n6 = Pack.bigEndianToInt(byArray, 0);
            if (!XMSSUtil.isIndexValid(n2, n6)) {
                throw new IllegalArgumentException("index out of bounds");
            }
            this.secretKeySeed = XMSSUtil.extractBytesAtOffset(byArray, 4, n3);
            n2 = n3 + 4;
            this.secretKeyPRF = XMSSUtil.extractBytesAtOffset(byArray, n2, n4);
            this.publicSeed = XMSSUtil.extractBytesAtOffset(byArray, n2 += n4, n5);
            this.root = XMSSUtil.extractBytesAtOffset(byArray, n2 += n5, n);
            Object object = XMSSUtil.extractBytesAtOffset(byArray, n2 += n, byArray.length - n2);
            try {
                BDS bDS = (BDS)XMSSUtil.deserialize((byte[])object, BDS.class);
                object = bDS;
                if (bDS.getIndex() != n6) {
                    throw new IllegalStateException("serialized BDS has wrong index");
                }
                this.bdsState = ((BDS)object).withWOTSDigest(builder.params.getTreeDigestOID());
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException.getMessage(), iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException(classNotFoundException.getMessage(), classNotFoundException);
            }
        } else {
            byte[] byArray2 = builder.secretKeySeed;
            if (byArray2 != null) {
                if (byArray2.length != n) {
                    throw new IllegalArgumentException("size of secretKeySeed needs to be equal size of digest");
                }
                this.secretKeySeed = byArray2;
            } else {
                this.secretKeySeed = new byte[n];
            }
            byArray = builder.secretKeyPRF;
            if (byArray != null) {
                if (byArray.length != n) {
                    throw new IllegalArgumentException("size of secretKeyPRF needs to be equal size of digest");
                }
                this.secretKeyPRF = byArray;
            } else {
                this.secretKeyPRF = new byte[n];
            }
            byte[] byArray3 = builder.publicSeed;
            if (byArray3 != null) {
                if (byArray3.length != n) {
                    throw new IllegalArgumentException("size of publicSeed needs to be equal size of digest");
                }
                this.publicSeed = byArray3;
            } else {
                this.publicSeed = new byte[n];
            }
            byte[] byArray4 = builder.root;
            if (byArray4 != null) {
                if (byArray4.length != n) {
                    throw new IllegalArgumentException("size of root needs to be equal size of digest");
                }
                this.root = byArray4;
            } else {
                this.root = new byte[n];
            }
            BDS bDS = builder.bdsState;
            this.bdsState = bDS != null ? bDS : (builder.index < (1 << this.params.getHeight()) - 2 && byArray3 != null && byArray2 != null ? new BDS(this.params, byArray3, byArray2, (OTSHashAddress)new OTSHashAddress.Builder().build(), builder.index) : new BDS(this.params, (1 << this.params.getHeight()) - 1, builder.index));
            if (builder.maxIndex >= 0 && builder.maxIndex != this.bdsState.getMaxIndex()) {
                throw new IllegalArgumentException("maxIndex set but not reflected in state");
            }
        }
    }

    public final byte[] getEncoded() throws IOException {
        XMSSPrivateKeyParameters xMSSPrivateKeyParameters = this;
        synchronized (xMSSPrivateKeyParameters) {
            return this.toByteArray();
        }
    }

    public final byte[] toByteArray() {
        XMSSPrivateKeyParameters xMSSPrivateKeyParameters = this;
        synchronized (xMSSPrivateKeyParameters) {
            byte[] byArray;
            int n;
            int n2 = n = this.params.getTreeDigestSize();
            int n3 = n;
            int n4 = n;
            n = n2 + 4 + n3 + n4 + n;
            byte[] byArray2 = new byte[n];
            Pack.intToBigEndian(this.bdsState.getIndex(), byArray2, 0);
            XMSSUtil.copyBytesAtOffset(byArray2, this.secretKeySeed, 4);
            XMSSUtil.copyBytesAtOffset(byArray2, this.secretKeyPRF, n2 += 4);
            XMSSUtil.copyBytesAtOffset(byArray2, this.publicSeed, n2 += n3);
            XMSSUtil.copyBytesAtOffset(byArray2, this.root, n2 += n4);
            try {
                byArray = XMSSUtil.serialize(this.bdsState);
            }
            catch (IOException iOException) {
                throw new RuntimeException("error serializing bds state: " + iOException.getMessage());
            }
            return Arrays.concatenate(byArray2, byArray);
        }
    }

    public final XMSSParameters getParameters() {
        return this.params;
    }

    /* synthetic */ XMSSPrivateKeyParameters(Builder builder, byte by) {
        this(builder);
    }

    public static final class Builder {
        private final XMSSParameters params;
        private int index = 0;
        private int maxIndex = -1;
        private byte[] secretKeySeed = null;
        private byte[] secretKeyPRF = null;
        private byte[] publicSeed = null;
        private byte[] root = null;
        private BDS bdsState = null;
        private byte[] privateKey = null;

        public Builder(XMSSParameters xMSSParameters) {
            this.params = xMSSParameters;
        }

        public final Builder withIndex(int n) {
            this.index = n;
            return this;
        }

        public final Builder withMaxIndex(int n) {
            this.maxIndex = n;
            return this;
        }

        public final Builder withSecretKeySeed(byte[] byArray) {
            this.secretKeySeed = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public final Builder withSecretKeyPRF(byte[] byArray) {
            this.secretKeyPRF = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public final Builder withPublicSeed(byte[] byArray) {
            this.publicSeed = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public final Builder withRoot(byte[] byArray) {
            this.root = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public final Builder withBDSState(BDS bDS) {
            this.bdsState = bDS;
            return this;
        }

        public final XMSSPrivateKeyParameters build() {
            return new XMSSPrivateKeyParameters(this, 0);
        }
    }
}

