/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.provider.lms;

import java.io.IOException;
import java.security.PublicKey;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.pqc.crypto.lms.LMSKeyParameters;
import org.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import org.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import org.bouncycastle.pqc.jcajce.interfaces.LMSKey;
import org.bouncycastle.util.Arrays;

public final class BCLMSPublicKey
implements PublicKey,
LMSKey {
    private transient LMSKeyParameters keyParams;

    public BCLMSPublicKey(SubjectPublicKeyInfo object) throws IOException {
        SubjectPublicKeyInfo subjectPublicKeyInfo = object;
        object = this;
        this.keyParams = (LMSKeyParameters)PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }

    public final String getAlgorithm() {
        return "LMS";
    }

    public final byte[] getEncoded() {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(this.keyParams);
            return subjectPublicKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public final String getFormat() {
        return "X.509";
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCLMSPublicKey) {
            object = (BCLMSPublicKey)object;
            try {
                byte[] byArray = this.keyParams.getEncoded();
                byte[] byArray2 = ((BCLMSPublicKey)object).keyParams.getEncoded();
                object = byArray;
                return java.util.Arrays.equals(byArray, byArray2);
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return false;
    }

    public final int hashCode() {
        try {
            return Arrays.hashCode(this.keyParams.getEncoded());
        }
        catch (IOException iOException) {
            return -1;
        }
    }
}

