/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.provider.mceliece;

import java.io.IOException;
import java.security.PublicKey;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.pqc.asn1.McElieceCCA2PublicKey;
import org.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PublicKeyParameters;
import org.bouncycastle.pqc.jcajce.provider.mceliece.Utils;

public final class BCMcElieceCCA2PublicKey
implements PublicKey,
CipherParameters {
    private McElieceCCA2PublicKeyParameters params;

    public BCMcElieceCCA2PublicKey(McElieceCCA2PublicKeyParameters mcElieceCCA2PublicKeyParameters) {
        this.params = mcElieceCCA2PublicKeyParameters;
    }

    public final String getAlgorithm() {
        return "McEliece-CCA2";
    }

    public final String toString() {
        String string = "McEliecePublicKey:\n";
        string = string + " length of the code         : " + this.params.getN() + "\n";
        string = string + " error correction capability: " + this.params.getT() + "\n";
        string = string + " generator matrix           : " + this.params.getG().toString();
        return string;
    }

    public final boolean equals(Object object) {
        if (object == null || !(object instanceof BCMcElieceCCA2PublicKey)) {
            return false;
        }
        Object object2 = object = (BCMcElieceCCA2PublicKey)object;
        if (this.params.getN() == ((BCMcElieceCCA2PublicKey)object2).params.getN()) {
            object2 = object;
            if (this.params.getT() == ((BCMcElieceCCA2PublicKey)object2).params.getT()) {
                object2 = object;
                if (this.params.getG().equals(((BCMcElieceCCA2PublicKey)object2).params.getG())) {
                    return true;
                }
            }
        }
        return false;
    }

    public final int hashCode() {
        return 37 * (this.params.getN() + 37 * this.params.getT()) + this.params.getG().hashCode();
    }

    public final byte[] getEncoded() {
        ASN1Object aSN1Object = new McElieceCCA2PublicKey(this.params.getN(), this.params.getT(), this.params.getG(), Utils.getDigAlgId(this.params.getDigest()));
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.mcElieceCca2);
        try {
            aSN1Object = new SubjectPublicKeyInfo(algorithmIdentifier, aSN1Object);
            return aSN1Object.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public final String getFormat() {
        return "X.509";
    }
}

