/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.provider.mceliece;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jcajce.provider.util.AsymmetricKeyInfoConverter;
import org.bouncycastle.pqc.asn1.McElieceCCA2PrivateKey;
import org.bouncycastle.pqc.asn1.McElieceCCA2PublicKey;
import org.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PrivateKeyParameters;
import org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PublicKeyParameters;
import org.bouncycastle.pqc.jcajce.provider.mceliece.BCMcElieceCCA2PrivateKey;
import org.bouncycastle.pqc.jcajce.provider.mceliece.BCMcElieceCCA2PublicKey;
import org.bouncycastle.pqc.jcajce.provider.mceliece.Utils;

public final class McElieceCCA2KeyFactorySpi
extends KeyFactorySpi
implements AsymmetricKeyInfoConverter {
    protected final PublicKey engineGeneratePublic(KeySpec object) throws InvalidKeySpecException {
        if (object instanceof X509EncodedKeySpec) {
            object = ((X509EncodedKeySpec)object).getEncoded();
            try {
                object = SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray((byte[])object));
            }
            catch (IOException iOException) {
                throw new InvalidKeySpecException(iOException.toString());
            }
            try {
                if (PQCObjectIdentifiers.mcElieceCca2.equals(((SubjectPublicKeyInfo)object).getAlgorithm().getAlgorithm())) {
                    object = McElieceCCA2PublicKey.getInstance$699ef8b5(((SubjectPublicKeyInfo)object).parsePublicKey());
                    return new BCMcElieceCCA2PublicKey(new McElieceCCA2PublicKeyParameters(((McElieceCCA2PublicKey)object).getN(), ((McElieceCCA2PublicKey)object).getT(), ((McElieceCCA2PublicKey)object).getG(), Utils.getDigest(((McElieceCCA2PublicKey)object).getDigest()).getAlgorithmName()));
                }
                throw new InvalidKeySpecException("Unable to recognise OID in McEliece private key");
            }
            catch (IOException iOException) {
                throw new InvalidKeySpecException("Unable to decode X509EncodedKeySpec: " + iOException.getMessage());
            }
        }
        throw new InvalidKeySpecException("Unsupported key specification: " + object.getClass() + ".");
    }

    protected final PrivateKey engineGeneratePrivate(KeySpec object) throws InvalidKeySpecException {
        if (object instanceof PKCS8EncodedKeySpec) {
            object = ((PKCS8EncodedKeySpec)object).getEncoded();
            try {
                object = PrivateKeyInfo.getInstance$57c4e802(ASN1Primitive.fromByteArray((byte[])object));
            }
            catch (IOException iOException) {
                throw new InvalidKeySpecException("Unable to decode PKCS8EncodedKeySpec: " + iOException);
            }
            try {
                if (PQCObjectIdentifiers.mcElieceCca2.equals(((PrivateKeyInfo)object).getPrivateKeyAlgorithm().getAlgorithm())) {
                    object = McElieceCCA2PrivateKey.getInstance$7ebe9511(((PrivateKeyInfo)object).parsePrivateKey$7b6dd9a4());
                    return new BCMcElieceCCA2PrivateKey(new McElieceCCA2PrivateKeyParameters(((McElieceCCA2PrivateKey)object).getN(), ((McElieceCCA2PrivateKey)object).getK(), ((McElieceCCA2PrivateKey)object).getField(), ((McElieceCCA2PrivateKey)object).getGoppaPoly(), ((McElieceCCA2PrivateKey)object).getP(), Utils.getDigest(((McElieceCCA2PrivateKey)object).getDigest()).getAlgorithmName()));
                }
                throw new InvalidKeySpecException("Unable to recognise OID in McEliece public key");
            }
            catch (IOException iOException) {
                throw new InvalidKeySpecException("Unable to decode PKCS8EncodedKeySpec.");
            }
        }
        throw new InvalidKeySpecException("Unsupported key specification: " + object.getClass() + ".");
    }

    protected final KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        return null;
    }

    protected final Key engineTranslateKey(Key key) throws InvalidKeyException {
        return null;
    }
}

