/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.provider.qtesla;

import java.io.IOException;
import java.security.PublicKey;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.pqc.crypto.qtesla.QTESLAPublicKeyParameters;
import org.bouncycastle.pqc.crypto.qtesla.QTESLASecurityCategory;
import org.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import org.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import org.bouncycastle.util.Arrays;

public final class BCqTESLAPublicKey
implements PublicKey {
    private transient QTESLAPublicKeyParameters keyParams;

    public BCqTESLAPublicKey(SubjectPublicKeyInfo object) throws IOException {
        SubjectPublicKeyInfo subjectPublicKeyInfo = object;
        object = this;
        this.keyParams = (QTESLAPublicKeyParameters)PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }

    public final String getAlgorithm() {
        return QTESLASecurityCategory.getName(this.keyParams.getSecurityCategory());
    }

    public final byte[] getEncoded() {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(this.keyParams);
            return subjectPublicKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public final String getFormat() {
        return "X.509";
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCqTESLAPublicKey) {
            object = (BCqTESLAPublicKey)object;
            if (this.keyParams.getSecurityCategory() == ((BCqTESLAPublicKey)object).keyParams.getSecurityCategory()) {
                byte[] byArray = this.keyParams.getPublicData();
                byte[] byArray2 = ((BCqTESLAPublicKey)object).keyParams.getPublicData();
                object = byArray;
                if (java.util.Arrays.equals(byArray, byArray2)) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public final int hashCode() {
        return this.keyParams.getSecurityCategory() + 37 * Arrays.hashCode(this.keyParams.getPublicData());
    }
}

