/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.provider.rainbow;

import java.security.PublicKey;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import org.bouncycastle.pqc.asn1.RainbowPublicKey;
import org.bouncycastle.pqc.crypto.rainbow.util.RainbowUtil;
import org.bouncycastle.pqc.jcajce.provider.util.KeyUtil;
import org.bouncycastle.pqc.jcajce.spec.RainbowPublicKeySpec;
import org.bouncycastle.util.Arrays;

public final class BCRainbowPublicKey
implements PublicKey {
    private short[][] coeffquadratic;
    private short[][] coeffsingular;
    private short[] coeffscalar;
    private int docLength;

    public BCRainbowPublicKey(int n, short[][] sArray, short[][] sArray2, short[] sArray3) {
        this.docLength = n;
        this.coeffquadratic = sArray;
        this.coeffsingular = sArray2;
        this.coeffscalar = sArray3;
    }

    public BCRainbowPublicKey(RainbowPublicKeySpec rainbowPublicKeySpec) {
        this(rainbowPublicKeySpec.getDocLength(), rainbowPublicKeySpec.getCoeffQuadratic(), rainbowPublicKeySpec.getCoeffSingular(), rainbowPublicKeySpec.getCoeffScalar());
    }

    public final int getDocLength() {
        return this.docLength;
    }

    public final short[][] getCoeffQuadratic() {
        return this.coeffquadratic;
    }

    public final short[][] getCoeffSingular() {
        short[][] sArrayArray = new short[this.coeffsingular.length][];
        for (int i = 0; i != this.coeffsingular.length; ++i) {
            sArrayArray[i] = Arrays.clone(this.coeffsingular[i]);
        }
        return sArrayArray;
    }

    public final short[] getCoeffScalar() {
        return Arrays.clone(this.coeffscalar);
    }

    public final boolean equals(Object object) {
        if (object == null || !(object instanceof BCRainbowPublicKey)) {
            return false;
        }
        Object object2 = object = (BCRainbowPublicKey)object;
        if (this.docLength == ((BCRainbowPublicKey)object2).docLength) {
            object2 = object;
            if (RainbowUtil.equals(this.coeffquadratic, ((BCRainbowPublicKey)object2).coeffquadratic) && RainbowUtil.equals(this.coeffsingular, ((BCRainbowPublicKey)object).getCoeffSingular())) {
                object2 = object;
                if (RainbowUtil.equals(this.coeffscalar, Arrays.clone(((BCRainbowPublicKey)object2).coeffscalar))) {
                    return true;
                }
            }
        }
        return false;
    }

    public final int hashCode() {
        int n = this.docLength;
        n = n * 37 + Arrays.hashCode(this.coeffquadratic);
        n = n * 37 + Arrays.hashCode(this.coeffsingular);
        n = n * 37 + Arrays.hashCode(this.coeffscalar);
        return n;
    }

    public final String getAlgorithm() {
        return "Rainbow";
    }

    public final String getFormat() {
        return "X.509";
    }

    public final byte[] getEncoded() {
        RainbowPublicKey rainbowPublicKey = new RainbowPublicKey(this.docLength, this.coeffquadratic, this.coeffsingular, this.coeffscalar);
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.rainbow, DERNull.INSTANCE);
        return KeyUtil.getEncodedSubjectPublicKeyInfo$6727b351(algorithmIdentifier, rainbowPublicKey);
    }
}

