/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.provider.sphincs;

import java.io.IOException;
import java.security.PublicKey;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import org.bouncycastle.pqc.asn1.SPHINCS256KeyParams;
import org.bouncycastle.pqc.crypto.sphincs.SPHINCSPublicKeyParameters;
import org.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import org.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import org.bouncycastle.pqc.jcajce.interfaces.SPHINCSKey;
import org.bouncycastle.util.Arrays;

public final class BCSphincs256PublicKey
implements PublicKey,
SPHINCSKey {
    private transient ASN1ObjectIdentifier treeDigest;
    private transient SPHINCSPublicKeyParameters params;

    public BCSphincs256PublicKey(SubjectPublicKeyInfo object) throws IOException {
        SubjectPublicKeyInfo subjectPublicKeyInfo = object;
        object = this;
        this.treeDigest = SPHINCS256KeyParams.getInstance$789c2f4d(subjectPublicKeyInfo.getAlgorithm().getParameters()).getTreeDigest().getAlgorithm();
        ((BCSphincs256PublicKey)object).params = (SPHINCSPublicKeyParameters)PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCSphincs256PublicKey) {
            object = (BCSphincs256PublicKey)object;
            if (this.treeDigest.equals(((BCSphincs256PublicKey)object).treeDigest)) {
                byte[] byArray = this.params.getKeyData();
                byte[] byArray2 = ((BCSphincs256PublicKey)object).params.getKeyData();
                object = byArray;
                if (java.util.Arrays.equals(byArray, byArray2)) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public final int hashCode() {
        return ((ASN1Object)this.treeDigest).hashCode() + 37 * Arrays.hashCode(this.params.getKeyData());
    }

    public final String getAlgorithm() {
        return "SPHINCS-256";
    }

    public final byte[] getEncoded() {
        try {
            ASN1Object aSN1Object;
            if (this.params.getTreeDigest() != null) {
                aSN1Object = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(this.params);
            } else {
                aSN1Object = new AlgorithmIdentifier(PQCObjectIdentifiers.sphincs256, new SPHINCS256KeyParams(new AlgorithmIdentifier(this.treeDigest)));
                aSN1Object = new SubjectPublicKeyInfo((AlgorithmIdentifier)aSN1Object, this.params.getKeyData());
            }
            return aSN1Object.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public final String getFormat() {
        return "X.509";
    }
}

