/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.provider.xmss;

import java.io.IOException;
import java.security.PrivateKey;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.pqc.asn1.XMSSKeyParams;
import org.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import org.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import org.bouncycastle.pqc.crypto.xmss.XMSSPrivateKeyParameters;
import org.bouncycastle.pqc.jcajce.interfaces.XMSSPrivateKey;
import org.bouncycastle.util.Arrays;

public final class BCXMSSPrivateKey
implements PrivateKey,
XMSSPrivateKey {
    private transient XMSSPrivateKeyParameters keyParams;
    private transient ASN1ObjectIdentifier treeDigest;
    private transient ASN1Set attributes;

    public BCXMSSPrivateKey(PrivateKeyInfo object) throws IOException {
        PrivateKeyInfo privateKeyInfo = object;
        object = this;
        this.attributes = privateKeyInfo.getAttributes();
        XMSSKeyParams xMSSKeyParams = XMSSKeyParams.getInstance$58408def(privateKeyInfo.getPrivateKeyAlgorithm().getParameters());
        ((BCXMSSPrivateKey)object).treeDigest = xMSSKeyParams.getTreeDigest().getAlgorithm();
        ((BCXMSSPrivateKey)object).keyParams = (XMSSPrivateKeyParameters)PrivateKeyFactory.createKey(privateKeyInfo);
    }

    public final String getAlgorithm() {
        return "XMSS";
    }

    public final String getFormat() {
        return "PKCS#8";
    }

    public final byte[] getEncoded() {
        try {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(this.keyParams, this.attributes);
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCXMSSPrivateKey) {
            object = (BCXMSSPrivateKey)object;
            if (this.treeDigest.equals(((BCXMSSPrivateKey)object).treeDigest)) {
                byte[] byArray = this.keyParams.toByteArray();
                byte[] byArray2 = ((BCXMSSPrivateKey)object).keyParams.toByteArray();
                object = byArray;
                if (java.util.Arrays.equals(byArray, byArray2)) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public final int hashCode() {
        return ((ASN1Object)this.treeDigest).hashCode() + 37 * Arrays.hashCode(this.keyParams.toByteArray());
    }
}

