/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.linearalgebra;

import org.bouncycastle.pqc.math.linearalgebra.PolynomialRingGF2;

public final class GF2mField {
    private int degree;
    private int polynomial;

    public GF2mField(byte[] byArray) {
        boolean bl;
        block6: {
            this.degree = 0;
            if (byArray.length != 4) {
                throw new IllegalArgumentException("byte array is not an encoded finite field");
            }
            this.polynomial = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 24;
            int n = this.polynomial;
            if (n == 0) {
                bl = false;
            } else {
                int n2 = PolynomialRingGF2.degree(n) >>> 1;
                int n3 = 2;
                for (int i = 0; i < n2; ++i) {
                    int n4 = n3;
                    n3 = PolynomialRingGF2.modMultiply(n4, n4, n);
                    int n5 = n;
                    int n6 = n3 ^ 2;
                    while (n5 != 0) {
                        int n7 = PolynomialRingGF2.remainder(n6, n5);
                        n6 = n5;
                        n5 = n7;
                    }
                    if (n6 == 1) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        if (!bl) {
            throw new IllegalArgumentException("byte array is not an encoded finite field");
        }
        this.degree = PolynomialRingGF2.degree(this.polynomial);
    }

    public final int getDegree() {
        return this.degree;
    }

    public final byte[] getEncoded() {
        int n = this.polynomial;
        byte[] byArray = new byte[4];
        byte[] byArray2 = byArray;
        byArray[0] = (byte)n;
        byArray2[1] = (byte)(n >>> 8);
        byArray2[2] = (byte)(n >>> 16);
        byArray2[3] = (byte)(n >>> 24);
        return byArray2;
    }

    public final int mult(int n, int n2) {
        return PolynomialRingGF2.modMultiply(n, n2, this.polynomial);
    }

    private int exp(int n, int n2) {
        if (n2 == 0) {
            return 1;
        }
        if (n == 0) {
            return 0;
        }
        if (n == 1) {
            return 1;
        }
        int n3 = 1;
        if (n2 < 0) {
            n = this.inverse(n);
            n2 = -n2;
        }
        while (n2 != 0) {
            if ((n2 & 1) == 1) {
                n3 = this.mult(n3, n);
            }
            int n4 = n;
            n = this.mult(n4, n4);
            n2 >>>= 1;
        }
        return n3;
    }

    public final int inverse(int n) {
        int n2 = (1 << this.degree) - 2;
        return this.exp(n, n2);
    }

    public final boolean isElementOfThisField(int n) {
        if (this.degree == 31) {
            return n >= 0;
        }
        return n >= 0 && n < 1 << this.degree;
    }

    public final String elementToStr(int n) {
        String string = "";
        for (int i = 0; i < this.degree; ++i) {
            string = ((byte)n & 1) == 0 ? "0" + string : "1" + string;
            n >>>= 1;
        }
        return string;
    }

    public final boolean equals(Object object) {
        if (object == null || !(object instanceof GF2mField)) {
            return false;
        }
        object = (GF2mField)object;
        return this.degree == ((GF2mField)object).degree && this.polynomial == ((GF2mField)object).polynomial;
    }

    public final int hashCode() {
        return this.polynomial;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder("Finite Field GF(2^").append(this.degree).append(") = GF(2)[X]/<");
        int n = this.polynomial;
        String string = "";
        if (n == 0) {
            string = "0";
        } else {
            byte by = (byte)(n & 1);
            if (by == 1) {
                string = "1";
            }
            n >>>= 1;
            int n2 = 1;
            while (n != 0) {
                by = (byte)(n & 1);
                if (by == 1) {
                    string = string + "+x^" + n2;
                }
                n >>>= 1;
                ++n2;
            }
        }
        String string2 = stringBuilder.append(string).append("> ").toString();
        return string2;
    }
}

