/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.linearalgebra;

import org.bouncycastle.pqc.math.linearalgebra.IntUtils;
import org.bouncycastle.pqc.math.linearalgebra.IntegerFunctions;
import org.bouncycastle.pqc.math.linearalgebra.LittleEndianConversions;
import org.bouncycastle.util.Arrays;

public final class Permutation {
    private int[] perm;

    public Permutation(byte[] byArray) {
        boolean bl;
        block7: {
            int n;
            Object[] objectArray;
            int n2;
            int n3;
            if (byArray.length <= 4) {
                throw new IllegalArgumentException("invalid encoding");
            }
            int n4 = LittleEndianConversions.OS2IP(byArray, 0);
            if (byArray.length != 4 + n4 * (n3 = IntegerFunctions.ceilLog256(n4 - 1))) {
                throw new IllegalArgumentException("invalid encoding");
            }
            this.perm = new int[n4];
            for (int i = 0; i < n4; ++i) {
                n2 = n3;
                int n5 = 4 + i * n3;
                objectArray = byArray;
                int n6 = 0;
                for (n = n2 - 1; n >= 0; --n) {
                    n6 |= (objectArray[n5 + n] & 0xFF) << n * 8;
                }
                this.perm[i] = n6;
            }
            objectArray = this.perm;
            n2 = this.perm.length;
            boolean[] blArray = new boolean[n2];
            for (n = 0; n < n2; ++n) {
                if (objectArray[n] < 0 || objectArray[n] >= n2 || blArray[objectArray[n]]) {
                    bl = false;
                    break block7;
                }
                blArray[objectArray[n]] = true;
            }
            bl = true;
        }
        if (!bl) {
            throw new IllegalArgumentException("invalid encoding");
        }
    }

    public final byte[] getEncoded() {
        int n = this.perm.length;
        int n2 = IntegerFunctions.ceilLog256(n - 1);
        byte[] byArray = new byte[4 + n * n2];
        LittleEndianConversions.I2OSP(n, byArray, 0);
        for (int i = 0; i < n; ++i) {
            int n3 = n2;
            int n4 = 4 + i * n2;
            byte[] byArray2 = byArray;
            int n5 = this.perm[i];
            --n3;
            while (n3 >= 0) {
                byArray2[n4 + n3] = (byte)(n5 >>> n3 * 8);
                --n3;
            }
        }
        return byArray;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof Permutation)) {
            return false;
        }
        object = (Permutation)object;
        return IntUtils.equals(this.perm, ((Permutation)object).perm);
    }

    public final String toString() {
        String string = "[" + this.perm[0];
        for (int i = 1; i < this.perm.length; ++i) {
            string = string + ", " + this.perm[i];
        }
        string = string + "]";
        return string;
    }

    public final int hashCode() {
        return Arrays.hashCode(this.perm);
    }
}

