/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util.encoders;

import java.io.IOException;

public final class HexEncoder {
    private byte[] encodingTable = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private byte[] decodingTable = new byte[128];

    public HexEncoder() {
        int n;
        HexEncoder hexEncoder = this;
        for (n = 0; n < hexEncoder.decodingTable.length; ++n) {
            hexEncoder.decodingTable[n] = -1;
        }
        for (n = 0; n < hexEncoder.encodingTable.length; ++n) {
            hexEncoder.decodingTable[hexEncoder.encodingTable[n]] = (byte)n;
        }
        hexEncoder.decodingTable[65] = hexEncoder.decodingTable[97];
        hexEncoder.decodingTable[66] = hexEncoder.decodingTable[98];
        hexEncoder.decodingTable[67] = hexEncoder.decodingTable[99];
        hexEncoder.decodingTable[68] = hexEncoder.decodingTable[100];
        hexEncoder.decodingTable[69] = hexEncoder.decodingTable[101];
        hexEncoder.decodingTable[70] = hexEncoder.decodingTable[102];
    }

    public final int encode(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IOException {
        n3 = n;
        n += n2;
        n2 = 0;
        while (n3 < n) {
            int n4 = byArray[n3++] & 0xFF;
            byArray2[n2++] = this.encodingTable[n4 >>> 4];
            byArray2[n2++] = this.encodingTable[n4 & 0xF];
        }
        return n2;
    }

    final byte[] decodeStrict(String string, int n, int n2) throws IOException {
        if (string == null) {
            throw new NullPointerException("'str' cannot be null");
        }
        if (n2 < 0 || 0 > string.length() - n2) {
            throw new IndexOutOfBoundsException("invalid offset and/or length specified");
        }
        if (0 != (n2 & 1)) {
            throw new IOException("a hexadecimal encoding must have an even number of characters");
        }
        n = n2 >>> 1;
        byte[] byArray = new byte[n];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            byte by;
            int n4 = this.decodingTable[string.charAt(n3++)];
            if ((n4 = n4 << 4 | (by = this.decodingTable[string.charAt(n3++)])) < 0) {
                throw new IOException("invalid characters encountered in Hex string");
            }
            byArray[i] = (byte)n4;
        }
        return byArray;
    }
}

