/*
 * Decompiled with CFR 0.152.
 */
package shaded.scala.collection;

import java.io.Serializable;
import shaded.scala.Function0;
import shaded.scala.Function1;
import shaded.scala.PartialFunction;
import shaded.scala.Tuple2;
import shaded.scala.collection.AbstractIterable;
import shaded.scala.collection.AbstractIterator;
import shaded.scala.collection.AbstractView;
import shaded.scala.collection.Iterable;
import shaded.scala.collection.IterableFactory;
import shaded.scala.collection.IterableOnce;
import shaded.scala.collection.IterableOps;
import shaded.scala.collection.Iterator;
import shaded.scala.collection.Iterator$;
import shaded.scala.collection.SeqOps;
import shaded.scala.collection.View$;
import shaded.scala.collection.immutable.Seq;
import shaded.scala.collection.mutable.ArrayBuffer;

public interface View<A>
extends Serializable,
Iterable<A> {
    public static /* synthetic */ View view$$691b2bff(AbstractView $this) {
        return View.super.view();
    }

    @Override
    default public View<A> view() {
        return this;
    }

    public static /* synthetic */ IterableFactory iterableFactory$(View $this) {
        return $this.iterableFactory();
    }

    @Override
    default public IterableFactory<View> iterableFactory() {
        return View$.MODULE$;
    }

    public static /* synthetic */ View empty$(View $this) {
        return $this.empty();
    }

    @Override
    default public View<A> empty() {
        return this.iterableFactory().empty();
    }

    public static /* synthetic */ String toString$(View $this) {
        return $this.toString();
    }

    @Override
    default public String toString() {
        return new StringBuilder(16).append(this.className()).append("(<not computed>)").toString();
    }

    public static /* synthetic */ String stringPrefix$$11ebf811(AbstractView $this) {
        return View.super.stringPrefix();
    }

    @Override
    default public String stringPrefix() {
        return "View";
    }

    public static class Appended<A>
    extends AbstractView<A> {
        private final IterableOps<A, ?, Object> underlying;
        private final A elem;

        @Override
        public Iterator<A> iterator() {
            return new Concat<A>(this.underlying, new Single<A>(this.elem)).iterator();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int knownSize() {
            int size = this.underlying.knownSize();
            if (size >= 0) {
                void var1_1;
                return (int)(var1_1 + true);
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         * WARNING - void declaration
         */
        public Appended(SeqOps underlying, Object elem) {
            void var2_2;
            void var1_1;
            this.underlying = var1_1;
            this.elem = var2_2;
        }
    }

    public static final class Collect<A, B>
    extends AbstractView<B> {
        private final IterableOps<A, ?, Object> underlying;
        private final PartialFunction<A, B> pf;

        @Override
        public final Iterator<B> iterator() {
            return this.underlying.iterator().collect(this.pf);
        }

        /*
         * WARNING - void declaration
         */
        public Collect(IterableOps<A, ?, Object> underlying, PartialFunction<A, B> pf) {
            void var2_2;
            void var1_1;
            this.underlying = var1_1;
            this.pf = var2_2;
        }
    }

    public static final class Concat<A>
    extends AbstractView<A> {
        private final IterableOps<A, ?, Object> prefix;
        private final IterableOps<A, ?, Object> suffix;

        @Override
        public final Iterator<A> iterator() {
            Iterator iterator = this.prefix.iterator();
            Function0<Iterator> & Serializable intersect = (Function0<Iterator> & Serializable)() -> $this.suffix.iterator();
            if (iterator == null) {
                throw null;
            }
            return iterator.concat(intersect);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int knownSize() {
            int prefixSize = this.prefix.knownSize();
            if (prefixSize >= 0) {
                int suffixSize = this.suffix.knownSize();
                if (suffixSize >= 0) {
                    void var2_2;
                    void var1_1;
                    return (int)(var1_1 + var2_2);
                }
                return -1;
            }
            return -1;
        }

        @Override
        public final boolean isEmpty() {
            return this.prefix.isEmpty() && this.suffix.isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        public Concat(IterableOps<A, ?, Object> prefix, IterableOps<A, ?, Object> suffix) {
            void var2_2;
            void var1_1;
            this.prefix = var1_1;
            this.suffix = var2_2;
        }
    }

    public static class Drop<A>
    extends AbstractView<A> {
        private final IterableOps<A, ?, Object> underlying;
        private final int n;
        private final int normN;

        @Override
        public Iterator<A> iterator() {
            return this.underlying.iterator().drop(this.n);
        }

        public final int normN() {
            return this.normN;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int knownSize() {
            int size = this.underlying.knownSize();
            if (size >= 0) {
                void var1_1;
                Drop drop = this;
                void var1_3 = var1_1 - drop.normN;
                return Math.max((int)var1_3, 0);
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return this.iterator().isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        public Drop(IterableOps<A, ?, Object> underlying, int n) {
            void var2_2;
            void var1_1;
            this.underlying = var1_1;
            this.n = n;
            this.normN = Math.max((int)var2_2, 0);
        }
    }

    public static class DropRight<A>
    extends AbstractView<A> {
        private final IterableOps<A, ?, Object> underlying;
        private final int n;
        private final int normN;

        @Override
        public Iterator<A> iterator() {
            return View$.dropRightIterator(this.underlying.iterator(), this.n);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int knownSize() {
            int size = this.underlying.knownSize();
            if (size >= 0) {
                void var1_1;
                DropRight dropRight = this;
                void var1_3 = var1_1 - dropRight.normN;
                return Math.max((int)var1_3, 0);
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            if (((AbstractIterable)this).knownSize() >= 0) {
                return ((AbstractIterable)this).knownSize() == 0;
            }
            return this.iterator().isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        public DropRight(IterableOps<A, ?, Object> underlying, int n) {
            void var2_2;
            void var1_1;
            this.underlying = var1_1;
            this.n = n;
            this.normN = Math.max((int)var2_2, 0);
        }
    }

    private static final class DropRightIterator<A>
    extends AbstractIterator<A> {
        private Iterator<A> underlying;
        private final int maxlen;
        private int len;
        private int pos;
        private ArrayBuffer<Object> buf;

        @Override
        public final int knownSize() {
            return this.len;
        }

        @Override
        public final boolean hasNext() {
            DropRightIterator dropRightIterator = this;
            if (dropRightIterator.buf == null) {
                int n = dropRightIterator.maxlen;
                dropRightIterator.buf = new ArrayBuffer(Math.min(n, 256));
                while (dropRightIterator.pos < dropRightIterator.maxlen && dropRightIterator.underlying.hasNext()) {
                    dropRightIterator.buf.addOne((Object)dropRightIterator.underlying.next());
                    ++dropRightIterator.pos;
                }
                if (!dropRightIterator.underlying.hasNext()) {
                    dropRightIterator.len = 0;
                }
                dropRightIterator.pos = 0;
            }
            return this.len != 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final A next() {
            void var1_1;
            if (!this.hasNext()) {
                return (A)Iterator$.scala$collection$Iterator$$_empty$1b393d2f.next();
            }
            Object x = this.buf.apply(this.pos);
            if (this.len == -1) {
                this.buf.update(this.pos, this.underlying.next());
                if (!this.underlying.hasNext()) {
                    this.len = 0;
                }
            } else {
                --this.len;
            }
            ++this.pos;
            if (this.pos == this.maxlen) {
                this.pos = 0;
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public DropRightIterator(Iterator<A> underlying, int maxlen) {
            void var2_2;
            void var1_1;
            this.underlying = var1_1;
            this.maxlen = var2_2;
            this.len = -1;
            this.pos = 0;
        }
    }

    public static final class Elems<A>
    extends AbstractView<A> {
        private final Seq<A> xs;

        @Override
        public final Iterator<A> iterator() {
            return this.xs.iterator();
        }

        @Override
        public final int knownSize() {
            return this.xs.knownSize();
        }

        @Override
        public final boolean isEmpty() {
            return this.xs.isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        public Elems(Seq<A> xs) {
            void var1_1;
            this.xs = var1_1;
        }
    }

    public static final class Fill<A>
    extends AbstractView<A> {
        private final int n;
        private final Function0<A> elem;

        /*
         * WARNING - void declaration
         */
        @Override
        public final Iterator<A> iterator() {
            void var2_1;
            void var1_2;
            Function0<A> fill_elem = this.elem;
            int fill_len = this.n;
            return new AbstractIterator<A>((int)var1_2, (Function0)var2_1){
                private int i;
                private final int len$2;
                private final Function0 elem$4;

                public final int knownSize() {
                    int n = this.len$2 - this.i;
                    return Math.max(n, 0);
                }

                public final boolean hasNext() {
                    return this.i < this.len$2;
                }

                public final A next() {
                    if (this.hasNext()) {
                        ++this.i;
                        return (A)this.elem$4.apply();
                    }
                    return (A)Iterator$.scala$collection$Iterator$$_empty$1b393d2f.next();
                }
                {
                    void var2_2;
                    void var1_1;
                    this.len$2 = var1_1;
                    this.elem$4 = var2_2;
                    this.i = 0;
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int knownSize() {
            void var1_1;
            int max$extension_that = this.n;
            return Math.max(0, (int)var1_1);
        }

        @Override
        public final boolean isEmpty() {
            return this.n <= 0;
        }

        /*
         * WARNING - void declaration
         */
        public Fill(int n, Function0<A> elem) {
            void var2_2;
            void var1_1;
            this.n = var1_1;
            this.elem = var2_2;
        }
    }

    public static final class Filter<A>
    extends AbstractView<A> {
        private final IterableOps<A, ?, Object> underlying;
        private final Function1<A, Object> p;
        private final boolean isFlipped;

        @Override
        public final Iterator<A> iterator() {
            Filter filter = this;
            Filter filter2 = filter;
            Filter filter3 = this;
            filter2 = filter3;
            filter2 = this;
            return filter.underlying.iterator().filterImpl(filter3.p, filter2.isFlipped);
        }

        @Override
        public final int knownSize() {
            Filter filter = this;
            if (filter.underlying.knownSize() == 0) {
                return 0;
            }
            return -1;
        }

        @Override
        public final boolean isEmpty() {
            return this.iterator().isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        public Filter(IterableOps<A, ?, Object> underlying, Function1<A, Object> p, boolean isFlipped) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.underlying = var1_1;
            this.p = var2_2;
            this.isFlipped = var3_3;
        }
    }

    public static final class FlatMap<A, B>
    extends AbstractView<B> {
        private final IterableOps<A, ?, Object> underlying;
        private final Function1<A, IterableOnce<B>> f;

        @Override
        public final Iterator<B> iterator() {
            return this.underlying.iterator().flatMap(this.f);
        }

        @Override
        public final int knownSize() {
            if (this.underlying.knownSize() == 0) {
                return 0;
            }
            return -1;
        }

        @Override
        public final boolean isEmpty() {
            return this.iterator().isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        public FlatMap(IterableOps<A, ?, Object> underlying, Function1<A, IterableOnce<B>> f) {
            void var2_2;
            void var1_1;
            this.underlying = var1_1;
            this.f = var2_2;
        }
    }

    public static class Map<A, B>
    extends AbstractView<B> {
        private final IterableOps<A, ?, Object> underlying;
        private final Function1<A, B> f;

        @Override
        public Iterator<B> iterator() {
            return this.underlying.iterator().map(this.f);
        }

        @Override
        public int knownSize() {
            return this.underlying.knownSize();
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        public Map(IterableOps<A, ?, Object> underlying, Function1<A, B> f) {
            void var2_2;
            void var1_1;
            this.underlying = var1_1;
            this.f = var2_2;
        }
    }

    public static class Prepended<A>
    extends AbstractView<A> {
        private final A elem;
        private final IterableOps<A, ?, Object> underlying;

        @Override
        public Iterator<A> iterator() {
            return new Concat<A>(new Single<A>(this.elem), this.underlying).iterator();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int knownSize() {
            int size = this.underlying.knownSize();
            if (size >= 0) {
                void var1_1;
                return (int)(var1_1 + true);
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         * WARNING - void declaration
         */
        public Prepended(Object elem, SeqOps underlying) {
            void var2_2;
            void var1_1;
            this.elem = var1_1;
            this.underlying = var2_2;
        }
    }

    public static final class Single<A>
    extends AbstractView<A> {
        private final A a;

        /*
         * WARNING - void declaration
         */
        @Override
        public final Iterator<A> iterator() {
            void var1_1;
            A single_a = this.a;
            return new AbstractIterator<A>(var1_1){
                private boolean consumed;
                private final Object a$1;

                public final boolean hasNext() {
                    return !this.consumed;
                }

                public final A next() {
                    if (this.consumed) {
                        return (A)Iterator$.scala$collection$Iterator$$_empty$1b393d2f.next();
                    }
                    this.consumed = true;
                    return (A)this.a$1;
                }

                /*
                 * WARNING - void declaration
                 */
                public final Iterator<A> sliceIterator(int from, int until) {
                    void var2_2;
                    void var1_1;
                    if (this.consumed || var1_1 > 0 || var2_2 == false) {
                        return Iterator$.scala$collection$Iterator$$_empty$1b393d2f;
                    }
                    return this;
                }
                {
                    void var1_1;
                    this.a$1 = var1_1;
                    this.consumed = false;
                }
            };
        }

        @Override
        public final int knownSize() {
            return 1;
        }

        @Override
        public final boolean isEmpty() {
            return false;
        }

        /*
         * WARNING - void declaration
         */
        public Single(A a) {
            void var1_1;
            this.a = var1_1;
        }
    }

    public static class Take<A>
    extends AbstractView<A> {
        private final IterableOps<A, ?, Object> underlying;
        private final int n;
        private final int normN;

        @Override
        public Iterator<A> iterator() {
            return this.underlying.iterator().take(this.n);
        }

        public final int normN() {
            return this.normN;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int knownSize() {
            int size = this.underlying.knownSize();
            if (size >= 0) {
                void var2_3;
                void var1_1;
                Take take = this;
                int min$extension_that = take.normN;
                return Math.min((int)var1_1, (int)var2_3);
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return this.iterator().isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        public Take(IterableOps<A, ?, Object> underlying, int n) {
            void var2_2;
            void var1_1;
            this.underlying = var1_1;
            this.n = n;
            this.normN = Math.max((int)var2_2, 0);
        }
    }

    public static final class Updated<A>
    extends AbstractView<A> {
        public final IterableOps<A, ?, Object> scala$collection$View$Updated$$underlying;
        public final int scala$collection$View$Updated$$index;
        public final A scala$collection$View$Updated$$elem;

        @Override
        public final Iterator<A> iterator() {
            return new AbstractIterator<A>(this){
                private final Iterator<A> it;
                private int i;
                private final /* synthetic */ Updated $outer;

                /*
                 * WARNING - void declaration
                 */
                public final A next() {
                    void var1_1;
                    A a;
                    if (this.i == this.$outer.scala$collection$View$Updated$$index) {
                        this.it.next();
                        a = this.$outer.scala$collection$View$Updated$$elem;
                    } else {
                        a = this.it.next();
                    }
                    A value = a;
                    ++this.i;
                    return var1_1;
                }

                public final boolean hasNext() {
                    if (this.it.hasNext()) {
                        return true;
                    }
                    if (this.$outer.scala$collection$View$Updated$$index >= this.i) {
                        throw new IndexOutOfBoundsException(Integer.toString(this.$outer.scala$collection$View$Updated$$index));
                    }
                    return false;
                }
                {
                    void var1_1;
                    this.$outer = $outer;
                    this.it = var1_1.scala$collection$View$Updated$$underlying.iterator();
                    this.i = 0;
                }
            };
        }

        @Override
        public final int knownSize() {
            return this.scala$collection$View$Updated$$underlying.knownSize();
        }

        @Override
        public final boolean isEmpty() {
            return this.iterator().isEmpty();
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         * WARNING - void declaration
         */
        public Updated(SeqOps underlying, int index, Object elem) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.scala$collection$View$Updated$$underlying = var1_1;
            this.scala$collection$View$Updated$$index = var2_2;
            this.scala$collection$View$Updated$$elem = var3_3;
        }
    }

    public static final class Zip<A, B>
    extends AbstractView<Tuple2<A, B>> {
        private final IterableOps<A, ?, Object> underlying;
        private final Iterable<B> other;

        @Override
        public final Iterator<Tuple2<A, B>> iterator() {
            return this.underlying.iterator().zip(this.other);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int knownSize() {
            void var2_2;
            void var1_1;
            int s1 = this.underlying.knownSize();
            if (s1 == 0) {
                return 0;
            }
            int s2 = this.other.knownSize();
            if (s2 == 0) {
                return 0;
            }
            return Math.min((int)var1_1, (int)var2_2);
        }

        @Override
        public final boolean isEmpty() {
            return this.underlying.isEmpty() || this.other.isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        public Zip(IterableOps<A, ?, Object> underlying, Iterable<B> other) {
            void var2_2;
            void var1_1;
            this.underlying = var1_1;
            this.other = var2_2;
        }
    }

    public static final class ZipWithIndex<A>
    extends AbstractView<Tuple2<A, Object>> {
        private final IterableOps<A, ?, Object> underlying;

        @Override
        public final Iterator<Tuple2<A, Object>> iterator() {
            return this.underlying.iterator().zipWithIndex();
        }

        @Override
        public final int knownSize() {
            return this.underlying.knownSize();
        }

        @Override
        public final boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        public ZipWithIndex(IterableOps<A, ?, Object> underlying) {
            void var1_1;
            this.underlying = var1_1;
        }
    }
}

