/*
 * Decompiled with CFR 0.152.
 */
package shaded.scala.collection.immutable;

import java.io.Serializable;
import shaded.scala.Function1;
import shaded.scala.Function2;
import shaded.scala.Option;
import shaded.scala.PartialFunction;
import shaded.scala.collection.AbstractIterable;
import shaded.scala.collection.IndexedSeq;
import shaded.scala.collection.IndexedSeqOps;
import shaded.scala.collection.IndexedSeqView;
import shaded.scala.collection.Iterable;
import shaded.scala.collection.IterableOnce;
import shaded.scala.collection.IterableOnceOps;
import shaded.scala.collection.Iterator;
import shaded.scala.collection.Seq;
import shaded.scala.collection.SeqFactory;
import shaded.scala.collection.SeqOps;
import shaded.scala.collection.StrictOptimizedIterableOps;
import shaded.scala.collection.StrictOptimizedSeqOps;
import shaded.scala.collection.StringOps$;
import shaded.scala.collection.generic.CommonErrors$;
import shaded.scala.collection.immutable.AbstractSeq;
import shaded.scala.collection.immutable.Range$;
import shaded.scala.collection.immutable.RangeIterator;
import shaded.scala.math.Ordering;
import shaded.scala.runtime.BoxesRunTime;
import shaded.scala.runtime.Nothing$;
import shaded.scala.runtime.ScalaRunTime$;
import shaded.scala.runtime.java8.JFunction1$mcVI$sp;
import shaded.scala.util.hashing.MurmurHash3;
import shaded.scala.util.hashing.MurmurHash3$;

public abstract class Range
extends AbstractSeq<Object>
implements Serializable,
shaded.scala.collection.immutable.IndexedSeq<Object>,
shaded.scala.collection.immutable.StrictOptimizedSeqOps<Object, shaded.scala.collection.immutable.IndexedSeq, shaded.scala.collection.immutable.IndexedSeq<Object>> {
    private final int start;
    private final int end;
    private final int step;
    private final boolean isEmpty;
    private int scala$collection$immutable$Range$$numRangeElements;
    private int scala$collection$immutable$Range$$lastElement;

    /*
     * WARNING - void declaration
     */
    @Override
    public final /* synthetic */ Object scala$collection$immutable$StrictOptimizedSeqOps$$super$sorted(Ordering ord) {
        void var1_1;
        return SeqOps.sorted$$301783dc(this, (Ordering)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object updated(int index, Object elem) {
        void var2_2;
        void var1_1;
        return shaded.scala.collection.immutable.StrictOptimizedSeqOps.updated$(this, (int)var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object prepended(Object elem) {
        void var1_1;
        return StrictOptimizedSeqOps.prepended$(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object appended(Object elem) {
        void var1_1;
        return StrictOptimizedSeqOps.appended$(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object appendedAll(IterableOnce suffix) {
        void var1_1;
        return StrictOptimizedSeqOps.appendedAll$(this, (IterableOnce)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object flatMap(Function1 f) {
        void var1_1;
        return StrictOptimizedIterableOps.flatMap$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object collect(PartialFunction pf) {
        void var1_1;
        return StrictOptimizedIterableOps.collect$(this, (PartialFunction)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object flatten(Function1 toIterableOnce) {
        void var1_1;
        return StrictOptimizedIterableOps.flatten$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object zip(IterableOnce that) {
        void var1_1;
        return StrictOptimizedIterableOps.zip$(this, (IterableOnce)var1_1);
    }

    @Override
    public final Object zipWithIndex() {
        return StrictOptimizedIterableOps.zipWithIndex$(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object filter(Function1 pred) {
        void var1_1;
        return StrictOptimizedIterableOps.filter$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object filterNot(Function1 pred) {
        void var1_1;
        return StrictOptimizedIterableOps.filterNot$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object filterImpl(Function1 pred, boolean isFlipped) {
        void var2_2;
        void var1_1;
        return StrictOptimizedIterableOps.filterImpl$(this, (Function1)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final /* synthetic */ boolean scala$collection$immutable$IndexedSeq$$super$canEqual(Object that) {
        void var1_1;
        return Seq.canEqual$(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final /* synthetic */ boolean scala$collection$immutable$IndexedSeq$$super$sameElements(IterableOnce that) {
        void var1_1;
        return SeqOps.sameElements$(this, (IterableOnce)var1_1);
    }

    @Override
    public final shaded.scala.collection.immutable.IndexedSeq<Object> toIndexedSeq() {
        return shaded.scala.collection.immutable.IndexedSeq.toIndexedSeq$(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean canEqual(Object that) {
        void var1_1;
        return shaded.scala.collection.immutable.IndexedSeq.canEqual$(this, (Object)var1_1);
    }

    @Override
    public final SeqFactory<shaded.scala.collection.immutable.IndexedSeq> iterableFactory() {
        return shaded.scala.collection.immutable.IndexedSeq.iterableFactory$(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final /* synthetic */ Object scala$collection$immutable$IndexedSeqOps$$super$slice(int from, int until) {
        void var2_2;
        void var1_1;
        return IndexedSeqOps.slice$(this, (int)var1_1, (int)var2_2);
    }

    @Override
    public final String stringPrefix() {
        return IndexedSeq.stringPrefix$(this);
    }

    @Override
    public final Iterator<Object> reverseIterator() {
        return IndexedSeqOps.reverseIterator$(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <B$> B$ foldRight(B$ z, Function2<Object, B$, B$> op) {
        void var2_2;
        void var1_1;
        return (B$)IndexedSeqOps.foldRight$(this, (Object)var1_1, (Function2)var2_2);
    }

    @Override
    public final IndexedSeqView<Object> view() {
        return IndexedSeqOps.view$(this);
    }

    @Override
    public final Iterable<Object> reversed() {
        return IndexedSeqOps.reversed$(this);
    }

    @Override
    public final Option<Object> headOption() {
        return IndexedSeqOps.headOption$(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int lengthCompare(int len) {
        void var1_1;
        return IndexedSeqOps.lengthCompare$(this, (int)var1_1);
    }

    @Override
    public final int knownSize() {
        return IndexedSeqOps.knownSize$(this);
    }

    public final int step() {
        return this.step;
    }

    @Override
    public final Iterator<Object> iterator() {
        Range range = this;
        Range range2 = range;
        range2 = this;
        return new RangeIterator(range.start, range2.step, this.scala$collection$immutable$Range$$lastElement, ((AbstractIterable)this).isEmpty());
    }

    private long gap() {
        Range range = this;
        Range range2 = range;
        range2 = this;
        return (long)range.end - (long)range2.start;
    }

    private boolean isExact() {
        Range range = this;
        return this.gap() % (long)range.step == 0L;
    }

    public abstract boolean isInclusive();

    @Override
    public final boolean isEmpty() {
        return this.isEmpty;
    }

    @Override
    public final int length() {
        if (this.scala$collection$immutable$Range$$numRangeElements < 0) {
            throw this.fail();
        }
        return this.scala$collection$immutable$Range$$numRangeElements;
    }

    @Override
    private int last() {
        if (((AbstractIterable)this).isEmpty()) {
            throw Range$.scala$collection$immutable$Range$$emptyRangeError("last");
        }
        return this.scala$collection$immutable$Range$$lastElement;
    }

    @Override
    private int head() {
        if (((AbstractIterable)this).isEmpty()) {
            throw Range$.scala$collection$immutable$Range$$emptyRangeError("head");
        }
        Range range = this;
        return range.start;
    }

    private void scala$collection$immutable$Range$$validateMaxLength() {
        if (this.scala$collection$immutable$Range$$numRangeElements < 0) {
            throw this.fail();
        }
    }

    private String description() {
        Object[] objectArray = new Object[4];
        Range range = this;
        objectArray[0] = range.start;
        objectArray[1] = this.isInclusive() ? "to" : "until";
        range = this;
        objectArray[2] = range.end;
        range = this;
        objectArray[3] = range.step;
        return StringOps$.format$extension$291847e0("%d %s %d by %s", ScalaRunTime$.genericWrapArray(objectArray));
    }

    private Nothing$ fail() {
        throw new IllegalArgumentException(new StringBuilder(54).append(this.description()).append(": seqs cannot contain more than Int.MaxValue elements.").toString());
    }

    @Override
    public final <U> void foreach(Function1<Object, U> f) {
        if (!((AbstractIterable)this).isEmpty()) {
            Range range = this;
            int i2 = range.start;
            while (true) {
                f.apply(i2);
                if (i2 == this.scala$collection$immutable$Range$$lastElement) {
                    return;
                }
                Range i2 = this;
                i2 += i2.step;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <B> int indexOf(B elem222, int from) {
        void var2_5;
        void var1_1;
        if (elem222 instanceof Integer) {
            int n;
            Range elem222 = this;
            int elem222 = BoxesRunTime.unboxToInt(elem222);
            int n2 = elem222;
            if (elem222.contains(n2)) {
                Range range = elem222;
                Range range2 = range;
                range2 = elem222;
                n = (n2 - range.start) / range2.step;
            } else {
                int pos;
                n = pos = -1;
            }
            if (n >= from) {
                void var1_4;
                return (int)var1_4;
            }
            return -1;
        }
        return SeqOps.indexOf$(this, var1_1, (int)var2_5);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <B> boolean sameElements(IterableOnce<B> that) {
        void var1_1;
        if (that instanceof Range) {
            that = that;
            int n = this.length();
            switch (n) {
                case 0: {
                    return ((AbstractIterable)that).isEmpty();
                }
                case 1: {
                    if (that.length() == 1) {
                        Range range = this;
                        Range range2 = range;
                        range2 = that;
                        if (range.start == range2.start) {
                            return true;
                        }
                    }
                    return false;
                }
            }
            if (that.length() == n) {
                Range range = this;
                Range range3 = range;
                range3 = that;
                if (range.start == range3.start) {
                    Range range4 = this;
                    range3 = range4;
                    range3 = that;
                    if (range4.step == range3.step) {
                        return true;
                    }
                }
            }
            return false;
        }
        return shaded.scala.collection.immutable.IndexedSeq.sameElements$(this, (IterableOnce)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    private Range take(int n) {
        void var1_1;
        if (n <= 0 || ((AbstractIterable)this).isEmpty()) {
            Range range = this;
            return range.newEmptyRange(range.start);
        }
        if (n >= this.scala$collection$immutable$Range$$numRangeElements && this.scala$collection$immutable$Range$$numRangeElements >= 0) {
            return this;
        }
        Range range = this;
        Range range2 = range;
        range2 = this;
        return new Inclusive(range.start, this.locationAfterN((int)(var1_1 - true)), range2.step);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    private Range drop(int n2) {
        void var1_1;
        if (n2 <= 0 || ((AbstractIterable)this).isEmpty()) {
            return this;
        }
        if (n2 >= this.scala$collection$immutable$Range$$numRangeElements && this.scala$collection$immutable$Range$$numRangeElements >= 0) {
            Range n2 = this;
            return n2.newEmptyRange(n2.end);
        }
        Range range = this;
        Range range2 = range;
        range2 = this;
        boolean bl = this.isInclusive();
        int n3 = range2.step;
        int n4 = range.end;
        int n5 = this.locationAfterN((int)var1_1);
        if (bl) {
            return new Inclusive(n5, n4, n3);
        }
        return new Exclusive(n5, n4, n3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    private Range dropRight(int n) {
        void var3_4;
        void var1_1;
        void var2_3;
        Range range;
        block7: {
            block6: {
                int y;
                block5: {
                    if (n <= 0) {
                        return this;
                    }
                    if (this.scala$collection$immutable$Range$$numRangeElements >= 0) {
                        Range range2 = this;
                        return range2.take(range2.scala$collection$immutable$Range$$numRangeElements - n);
                    }
                    range = this;
                    y = this.last() - range.step * n;
                    range = this;
                    if (range.step <= 0) break block5;
                    range = this;
                    if (y < range.start) break block6;
                }
                range = this;
                if (range.step >= 0) break block7;
                range = this;
                if (y <= range.start) break block7;
            }
            range = this;
            return range.newEmptyRange(range.start);
        }
        Range range3 = this;
        range = range3;
        range = this;
        int inclusive_step = range.step;
        int inclusive_start = range3.start;
        return new Inclusive((int)var2_3, (int)var1_1, (int)var3_4);
    }

    /*
     * WARNING - void declaration
     */
    private int locationAfterN(int n) {
        void var1_1;
        Range range = this;
        Range range2 = range;
        range2 = this;
        return range.start + range2.step * var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Exclusive newEmptyRange(int value) {
        void var1_1;
        void v0 = var1_1;
        Range range = this;
        return new Exclusive((int)v0, (int)v0, range.step);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    private boolean contains(int x) {
        block21: {
            block20: {
                void var1_1;
                Range range;
                block19: {
                    block18: {
                        block13: {
                            block17: {
                                block16: {
                                    block15: {
                                        block14: {
                                            range = this;
                                            if (x == range.end && !this.isInclusive()) {
                                                return false;
                                            }
                                            range = this;
                                            if (range.step <= 0) break block13;
                                            range = this;
                                            if (x < range.start) break block14;
                                            range = this;
                                            if (x <= range.end) break block15;
                                        }
                                        return false;
                                    }
                                    range = this;
                                    if (range.step == 1) break block16;
                                    Range range2 = this;
                                    range = range2;
                                    range = this;
                                    if (Integer.remainderUnsigned(x - range2.start, range.step) != 0) break block17;
                                }
                                return true;
                            }
                            return false;
                        }
                        range = this;
                        if (x < range.end) break block18;
                        range = this;
                        if (x <= range.start) break block19;
                    }
                    return false;
                }
                range = this;
                if (range.step == -1) break block20;
                Range range3 = this;
                range = range3;
                range = this;
                if (Integer.remainderUnsigned(range3.start - var1_1, -range.step) != 0) break block21;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <B> boolean contains(B elem2) {
        void var1_1;
        if (elem2 instanceof Integer) {
            int elem2 = BoxesRunTime.unboxToInt(elem2);
            return this.contains(elem2);
        }
        return SeqOps.contains$(this, var1_1);
    }

    @Override
    public final int applyPreferredMaxLength() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean equals(Object other) {
        void var1_1;
        block4: {
            block5: {
                block6: {
                    void var2_3;
                    int l0;
                    if (!(other instanceof Range)) break block4;
                    other = (Range)other;
                    if (((AbstractIterable)this).isEmpty()) {
                        return ((AbstractIterable)other).isEmpty();
                    }
                    Object object = other;
                    if (!IterableOnceOps.nonEmpty$((IterableOnceOps)object)) break block5;
                    Range range = this;
                    object = range;
                    object = other;
                    if (range.start != ((Range)object).start || (l0 = this.last()) != ((Range)other).last()) break block5;
                    object = this;
                    if (((Range)object).start == var2_3) break block6;
                    Range range2 = this;
                    object = range2;
                    object = other;
                    if (range2.step != ((Range)object).step) break block5;
                }
                return true;
            }
            return false;
        }
        return Seq.equals$(this, var1_1);
    }

    @Override
    public final int hashCode() {
        if (this.length() >= 2) {
            Range range = this;
            Object object = range;
            object = this;
            int n = this.scala$collection$immutable$Range$$lastElement;
            int n2 = ((Range)object).step;
            int n3 = range.start;
            object = MurmurHash3$.MODULE$;
            return ((MurmurHash3)object).rangeHash(n3, n2, n, MurmurHash3$.seqSeed());
        }
        return MurmurHash3$.MODULE$.seqHash(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String toString() {
        void var2_3;
        void var1_1;
        String string;
        String preposition = this.isInclusive() ? "to" : "until";
        Range range = this;
        if (range.step == 1) {
            string = "";
        } else {
            String stepped;
            range = this;
            string = stepped = new StringBuilder(4).append(" by ").append(range.step).toString();
        }
        String prefix = ((AbstractIterable)this).isEmpty() ? "empty " : (!this.isExact() ? "inexact " : "");
        StringBuilder stringBuilder = new StringBuilder(8).append((String)((Object)range)).append("Range ");
        Range range2 = this;
        range = range2;
        range = this;
        return stringBuilder.append(range2.start).append(" ").append((String)var1_1).append(" ").append(range.end).append((String)var2_3).toString();
    }

    @Override
    public final String className() {
        return "Range";
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public final void foreach$mVc$sp$5eaf9fac(JFunction1$mcVI$sp f) {
        if (!((AbstractIterable)this).isEmpty()) {
            Range range = this;
            int i2 = range.start;
            while (true) {
                f.apply$mcVI$sp(i2);
                if (i2 == this.scala$collection$immutable$Range$$lastElement) {
                    return;
                }
                Range i2 = this;
                i2 += i2.step;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int apply$mcII$sp(int idx) throws IndexOutOfBoundsException {
        void var1_1;
        this.scala$collection$immutable$Range$$validateMaxLength();
        if (idx < 0 || idx >= this.scala$collection$immutable$Range$$numRangeElements) {
            throw CommonErrors$.indexOutOfBounds(idx, this.scala$collection$immutable$Range$$numRangeElements - 1);
        }
        Range range = this;
        Range range2 = range;
        range2 = this;
        return range.start + range2.step * var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Range(int start, int end, int step) {
        int n;
        int n2;
        this.start = start;
        this.end = end;
        this.step = step;
        boolean bl = this.isEmpty = start > end && step > 0 || start < end && step < 0 || start == end && !this.isInclusive();
        if (step == 0) {
            throw new IllegalArgumentException("step cannot be 0.");
        }
        if (((AbstractIterable)this).isEmpty()) {
            n2 = 0;
        } else {
            Range range = start = this;
            long l = start.gap() / (long)range.step;
            long len = l + (long)(start.isInclusive() || !start.isExact() ? 1 : 0);
            n2 = len > Integer.MAX_VALUE ? -1 : (int)len;
        }
        this.scala$collection$immutable$Range$$numRangeElements = n2;
        switch (step) {
            case 1: {
                if (this.isInclusive()) {
                    n = end;
                    break;
                }
                n = end - 1;
                break;
            }
            case -1: {
                if (this.isInclusive()) {
                    n = end;
                    break;
                }
                n = end + 1;
                break;
            }
            default: {
                void var3_4;
                void var2_3;
                void var1_1;
                int remainder = (int)(this.gap() % (long)step);
                n = remainder != 0 ? end - var1_1 : (this.isInclusive() ? end : var2_3 - var3_4);
            }
        }
        this.scala$collection$immutable$Range$$lastElement = n;
    }

    public static final class Exclusive
    extends Range {
        @Override
        public final boolean isInclusive() {
            return false;
        }

        /*
         * WARNING - void declaration
         */
        public Exclusive(int start, int end, int step) {
            super((int)var1_1, (int)var2_2, (int)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }
    }

    public static final class Inclusive
    extends Range {
        @Override
        public final boolean isInclusive() {
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public Inclusive(int start, int end, int step) {
            super((int)var1_1, (int)var2_2, (int)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }
    }
}

