/*
 * Decompiled with CFR 0.152.
 */
package shaded.scala.math;

import java.math.BigInteger;
import shaded.scala.math.BigDecimal;
import shaded.scala.math.BigInt$;
import shaded.scala.math.Ordered;
import shaded.scala.math.ScalaNumber;
import shaded.scala.math.ScalaNumericAnyConversions;
import shaded.scala.math.ScalaNumericConversions;
import shaded.scala.runtime.BoxesRunTime;
import shaded.scala.runtime.Statics;

public final class BigInt
extends ScalaNumber
implements Ordered<BigInt>,
ScalaNumericConversions {
    private BigInteger _bigInteger;
    private final long _long;

    /*
     * WARNING - void declaration
     */
    @Override
    public final int compareTo(Object that) {
        void var1_1;
        return Ordered.compareTo$(this, var1_1);
    }

    @Override
    public final byte toByte() {
        return ScalaNumericAnyConversions.toByte$(this);
    }

    @Override
    public final short toShort() {
        return ScalaNumericAnyConversions.toShort$(this);
    }

    @Override
    public final int toInt() {
        return ScalaNumericAnyConversions.toInt$(this);
    }

    @Override
    public final long toLong() {
        return ScalaNumericAnyConversions.toLong$(this);
    }

    @Override
    public final float toFloat() {
        return ScalaNumericAnyConversions.toFloat$(this);
    }

    @Override
    public final double toDouble() {
        return ScalaNumericAnyConversions.toDouble$(this);
    }

    @Override
    public final int unifiedPrimitiveHashcode() {
        return ScalaNumericAnyConversions.unifiedPrimitiveHashcode$(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean unifiedPrimitiveEquals(Object x) {
        void var1_1;
        return ScalaNumericAnyConversions.unifiedPrimitiveEquals$(this, var1_1);
    }

    private boolean longEncoding() {
        BigInt bigInt = this;
        return bigInt._long != Long.MIN_VALUE;
    }

    private BigInteger bigInteger() {
        BigInteger write2;
        BigInt bigInt = this;
        Number read = bigInt._bigInteger;
        if (read != null) {
            return read;
        }
        read = this;
        BigInteger bigInteger = write2 = BigInteger.valueOf(((BigInt)read)._long);
        BigInt bigInt2 = this;
        this._bigInteger = bigInteger;
        return bigInt;
    }

    public final int hashCode() {
        if (this.isValidLong()) {
            return ScalaNumericAnyConversions.unifiedPrimitiveHashcode$(this);
        }
        return Statics.anyHash(this.bigInteger());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object that2) {
        void var1_1;
        if (that2 instanceof BigInt) {
            that2 = (BigInt)that2;
            return this.equals((BigInt)that2);
        }
        if (that2 instanceof BigDecimal) {
            return ((BigDecimal)that2).equals(this);
        }
        if (that2 instanceof Double) {
            double d = BoxesRunTime.unboxToDouble(that2);
            BigInt bigInt = this;
            int n = bigInt.bitLength();
            if (n > 53) {
                int n2 = bigInt.lowestSetBit();
                if (n > 1024) return false;
                if (n2 < n - 53) return false;
                if (n2 >= 1024) return false;
            }
            if (bigInt.bitLengthOverflow()) return false;
            boolean bl = true;
            if (!bl) return false;
            if (this.doubleValue() != d) return false;
            return true;
        }
        if (that2 instanceof Float) {
            float that2 = BoxesRunTime.unboxToFloat(that2);
            BigInt bigInt = this;
            int n = bigInt.bitLength();
            if (n > 24) {
                int n3 = bigInt.lowestSetBit();
                if (n > 128) return false;
                if (n3 < n - 24) return false;
                if (n3 >= 128) return false;
            }
            if (bigInt.bitLengthOverflow()) return false;
            boolean bl = true;
            if (!bl) return false;
            if (this.floatValue() != that2) return false;
            return true;
        }
        if (!this.isValidLong()) return false;
        if (!ScalaNumericAnyConversions.unifiedPrimitiveEquals$(this, var1_1)) return false;
        return true;
    }

    @Override
    public final boolean isValidByte() {
        BigInt bigInt = this;
        if (bigInt._long >= -128L) {
            bigInt = this;
            if (bigInt._long <= 127L) {
                return true;
            }
        }
        return false;
    }

    @Override
    public final boolean isValidShort() {
        BigInt bigInt = this;
        if (bigInt._long >= -32768L) {
            bigInt = this;
            if (bigInt._long <= 32767L) {
                return true;
            }
        }
        return false;
    }

    @Override
    public final boolean isValidChar() {
        BigInt bigInt = this;
        if (bigInt._long >= 0L) {
            bigInt = this;
            if (bigInt._long <= 65535L) {
                return true;
            }
        }
        return false;
    }

    @Override
    public final boolean isValidInt() {
        BigInt bigInt = this;
        if (bigInt._long >= Integer.MIN_VALUE) {
            bigInt = this;
            if (bigInt._long <= Integer.MAX_VALUE) {
                return true;
            }
        }
        return false;
    }

    private boolean isValidLong() {
        block3: {
            block2: {
                if (this.longEncoding()) break block2;
                BigInt bigInt = this;
                if (!BoxesRunTime.equalsNumNum(bigInt._bigInteger, BigInt$.MODULE$.scala$math$BigInt$$longMinValueBigInteger())) break block3;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean bitLengthOverflow() {
        BigInteger shifted = this.bigInteger().shiftRight(Integer.MAX_VALUE);
        if (shifted.signum() != 0) {
            void var1_1;
            if (!var1_1.equals(BigInt$.MODULE$.scala$math$BigInt$$minusOne())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public final boolean isWhole() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(BigInt that) {
        if (this.longEncoding()) {
            if (that.longEncoding()) {
                BigInt bigInt = this;
                BigInt bigInt2 = bigInt;
                bigInt2 = that;
                if (bigInt._long == bigInt2._long) {
                    return true;
                }
            }
            return false;
        }
        if (!that.longEncoding()) {
            BigInt bigInt;
            void var1_1;
            BigInt bigInt3 = this;
            bigInt3 = var1_1;
            if (BoxesRunTime.equalsNumNum(bigInt._bigInteger, bigInt3._bigInteger)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int compare(BigInt that) {
        void var1_1;
        if (this.longEncoding()) {
            if (that.longEncoding()) {
                BigInt bigInt = this;
                BigInt bigInt2 = bigInt;
                bigInt2 = that;
                return Long.compare(bigInt._long, bigInt2._long);
            }
            BigInt bigInt = that;
            return -bigInt._bigInteger.signum();
        }
        if (that.longEncoding()) {
            BigInt bigInt = this;
            return bigInt._bigInteger.signum();
        }
        BigInt bigInt = this;
        BigInt bigInt3 = bigInt;
        bigInt3 = var1_1;
        return bigInt._bigInteger.compareTo(bigInt3._bigInteger);
    }

    /*
     * WARNING - void declaration
     */
    public final BigInt $plus(BigInt that) {
        void var1_1;
        if (this.longEncoding() && that.longEncoding()) {
            void var2_4;
            BigInt bigInt = this;
            long x = bigInt._long;
            bigInt = that;
            long y = bigInt._long;
            long z = x + y;
            if (((x ^ y ^ 0xFFFFFFFFFFFFFFFFL) & (var2_4 ^ z)) >= 0L) {
                return BigInt$.MODULE$.apply(z);
            }
        }
        return BigInt$.MODULE$.apply(this.bigInteger().add(var1_1.bigInteger()));
    }

    /*
     * WARNING - void declaration
     */
    public final BigInt $minus(BigInt that) {
        void var1_1;
        if (this.longEncoding() && that.longEncoding()) {
            void var2_4;
            BigInt bigInt = this;
            long x = bigInt._long;
            bigInt = that;
            long y = bigInt._long;
            long z = x - y;
            if (((x ^ y) & (var2_4 ^ z)) >= 0L) {
                return BigInt$.MODULE$.apply(z);
            }
        }
        return BigInt$.MODULE$.apply(this.bigInteger().subtract(var1_1.bigInteger()));
    }

    /*
     * WARNING - void declaration
     */
    public final BigInt $times(BigInt that) {
        void var1_1;
        if (this.longEncoding() && that.longEncoding()) {
            void var2_4;
            BigInt bigInt = this;
            long x = bigInt._long;
            bigInt = that;
            long y = bigInt._long;
            long z = x * y;
            if (x == 0L || y == z / var2_4) {
                return BigInt$.MODULE$.apply(z);
            }
        }
        return BigInt$.MODULE$.apply(this.bigInteger().multiply(var1_1.bigInteger()));
    }

    /*
     * WARNING - void declaration
     */
    public final BigInt $div(BigInt that) {
        void var1_1;
        if (this.longEncoding() && that.longEncoding()) {
            BigInt bigInt = this;
            BigInt bigInt2 = bigInt;
            bigInt2 = that;
            return BigInt$.MODULE$.apply(bigInt._long / bigInt2._long);
        }
        return BigInt$.MODULE$.apply(this.bigInteger().divide(var1_1.bigInteger()));
    }

    /*
     * WARNING - void declaration
     */
    public final BigInt $percent(BigInt that) {
        void var1_1;
        if (this.longEncoding() && that.longEncoding()) {
            BigInt bigInt = this;
            BigInt bigInt2 = bigInt;
            bigInt2 = that;
            return BigInt$.MODULE$.apply(bigInt._long % bigInt2._long);
        }
        return BigInt$.MODULE$.apply(this.bigInteger().remainder(var1_1.bigInteger()));
    }

    public final BigInt unary_$minus() {
        if (this.longEncoding()) {
            BigInt bigInt = this;
            return BigInt$.MODULE$.apply(-bigInt._long);
        }
        return BigInt$.MODULE$.apply(this.bigInteger().negate());
    }

    private int lowestSetBit() {
        if (this.longEncoding()) {
            BigInt bigInt = this;
            if (bigInt._long == 0L) {
                return -1;
            }
            bigInt = this;
            return Long.numberOfTrailingZeros(bigInt._long);
        }
        return this.bigInteger().getLowestSetBit();
    }

    public final int bitLength() {
        if (this.longEncoding()) {
            BigInt bigInt = this;
            if (bigInt._long < 0L) {
                bigInt = this;
                return 64 - Long.numberOfLeadingZeros(-(bigInt._long + 1L));
            }
            bigInt = this;
            return 64 - Long.numberOfLeadingZeros(bigInt._long);
        }
        BigInt bigInt = this;
        return bigInt._bigInteger.bitLength();
    }

    @Override
    public final byte byteValue() {
        return (byte)this.intValue();
    }

    @Override
    public final short shortValue() {
        return (short)this.intValue();
    }

    @Override
    public final int intValue() {
        if (this.longEncoding()) {
            BigInt bigInt = this;
            return (int)bigInt._long;
        }
        return this.bigInteger().intValue();
    }

    @Override
    public final long longValue() {
        if (this.longEncoding()) {
            BigInt bigInt = this;
            return bigInt._long;
        }
        BigInt bigInt = this;
        return bigInt._bigInteger.longValue();
    }

    @Override
    public final float floatValue() {
        return this.bigInteger().floatValue();
    }

    @Override
    public final double doubleValue() {
        if (this.isValidLong()) {
            BigInt bigInt = this;
            if (-9007199254740992L <= bigInt._long) {
                bigInt = this;
                if (bigInt._long <= 0x20000000000000L) {
                    bigInt = this;
                    return bigInt._long;
                }
            }
        }
        return this.bigInteger().doubleValue();
    }

    public final String toString() {
        if (this.longEncoding()) {
            BigInt bigInt = this;
            return Long.toString(bigInt._long);
        }
        BigInt bigInt = this;
        return bigInt._bigInteger.toString();
    }

    /*
     * WARNING - void declaration
     */
    public BigInt(BigInteger _bigInteger, long _long) {
        void var2_2;
        void var1_1;
        this._bigInteger = var1_1;
        this._long = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public BigInt(BigInteger bigInteger) {
        void var1_1;
        BigInteger bigInteger2 = bigInteger;
        this(bigInteger2, bigInteger2.bitLength() <= 63 ? var1_1.longValue() : Long.MIN_VALUE);
    }
}

