/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.type;

import com.github.javaparser.Range;
import com.github.javaparser.TokenRange;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import com.github.javaparser.ast.observer.ObservableProperty;
import com.github.javaparser.ast.type.ReferenceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.CloneVisitor;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Pair;
import com.github.javaparser.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ArrayType
extends ReferenceType
implements NodeWithAnnotations<ArrayType> {
    private Type componentType;
    private Origin origin;

    /*
     * WARNING - void declaration
     */
    public ArrayType(TokenRange tokenRange, Type componentType, Origin origin, NodeList<AnnotationExpr> annotations) {
        super((TokenRange)((Object)arrayType2), annotations);
        ArrayType arrayType;
        void var3_3;
        void var2_2;
        ArrayType arrayType2;
        this.setComponentType((Type)var2_2);
        var2_2 = var3_3;
        arrayType2 = this;
        Utils.assertNotNull(var2_2);
        if (var2_2 == arrayType2.origin) {
            arrayType = arrayType2;
        } else {
            arrayType2.notifyPropertyChange(ObservableProperty.ORIGIN, arrayType2.origin, var2_2);
            arrayType2.origin = var2_2;
            arrayType = arrayType2;
        }
        this.customInitialization();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <R, A> R accept(GenericVisitor<R, A> v, A arg2) {
        void var2_2;
        return v.visit(this, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <A> void accept(VoidVisitor<A> v, A arg2) {
        void var2_2;
        v.visit(this, var2_2);
    }

    public final Type getComponentType() {
        return this.componentType;
    }

    /*
     * WARNING - void declaration
     */
    private ArrayType setComponentType(Type componentType) {
        void var1_1;
        Utils.assertNotNull(componentType);
        if (componentType == this.componentType) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.COMPONENT_TYPE, this.componentType, componentType);
        if (this.componentType != null) {
            this.componentType.setParentNode(null);
        }
        this.componentType = componentType;
        this.setAsParentNodeOf((Node)var1_1);
        return this;
    }

    @SafeVarargs
    public static Type wrapInArrayTypes(Type type, List<ArrayBracketPair> ... arrayBracketPairLists) {
        Type type2;
        TokenRange outerMostTokenRange = null;
        for (int i = arrayBracketPairLists.length - 1; i >= 0; --i) {
            List<ArrayBracketPair> arrayBracketPairList = arrayBracketPairLists[i];
            if (arrayBracketPairList == null) continue;
            for (int j = arrayBracketPairList.size() - 1; j >= 0; --j) {
                ArrayBracketPair pair = arrayBracketPairList.get(j);
                if (type.getTokenRange().isPresent() && pair.getTokenRange().isPresent()) {
                    TokenRange tokenRange;
                    TokenRange tokenRange2 = new TokenRange(type.getTokenRange().get().getBegin(), pair.getTokenRange().get().getEnd());
                    TokenRange tokenRange3 = tokenRange2;
                    tokenRange3 = outerMostTokenRange;
                    outerMostTokenRange = tokenRange2;
                    if (tokenRange3 == null) {
                        tokenRange = outerMostTokenRange;
                    } else {
                        Range range = tokenRange3.getEnd().getRange().get();
                        Range range2 = outerMostTokenRange.getEnd().getRange().get();
                        tokenRange = range2.begin.isAfter(range.end) ? outerMostTokenRange : new TokenRange(outerMostTokenRange.getBegin(), tokenRange3.getEnd());
                    }
                    outerMostTokenRange = tokenRange;
                }
                type = new ArrayType(outerMostTokenRange, type, pair.getOrigin(), pair.getAnnotations());
            }
        }
        return type2;
    }

    /*
     * WARNING - void declaration
     */
    public static Pair<Type, List<ArrayBracketPair>> unwrapArrayTypes(Type type) {
        void var1_1;
        Type type2;
        ArrayList<ArrayBracketPair> arrayBracketPairs = new ArrayList<ArrayBracketPair>(0);
        while (type instanceof ArrayType) {
            void var2_2;
            ArrayType arrayType = (ArrayType)type;
            TokenRange tokenRange = type.getTokenRange().orElse(null);
            type = arrayType;
            arrayBracketPairs.add(new ArrayBracketPair(tokenRange, ((ArrayType)type).origin, arrayType.getAnnotations()));
            type = var2_2;
            type = ((ArrayType)type).componentType;
        }
        return new Pair<Type, void>(type2, var1_1);
    }

    public final Origin getOrigin() {
        return this.origin;
    }

    @Override
    public String asString() {
        return this.componentType.asString() + "[]";
    }

    @Override
    private ArrayType clone() {
        return (ArrayType)this.accept(new CloneVisitor(), null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean replace(Node node, Node replacementNode) {
        void var2_2;
        void var1_1;
        if (node == null) {
            return false;
        }
        if (node == this.componentType) {
            this.setComponentType((Type)replacementNode);
            return true;
        }
        return super.replace((Node)var1_1, (Node)var2_2);
    }

    @Override
    public final boolean isArrayType() {
        return true;
    }

    @Override
    public final int getArrayLevel() {
        ArrayType arrayType = this;
        return 1 + arrayType.componentType.getArrayLevel();
    }

    public static final class ArrayBracketPair {
        private TokenRange tokenRange;
        private NodeList<AnnotationExpr> annotations = new NodeList();
        private Origin origin;

        /*
         * WARNING - void declaration
         */
        public ArrayBracketPair(TokenRange tokenRange, Origin origin, NodeList<AnnotationExpr> annotations) {
            void var2_2;
            void var3_3;
            ArrayBracketPair arrayBracketPair;
            void var4_4 = arrayBracketPair;
            arrayBracketPair = this;
            this.tokenRange = var4_4;
            var4_4 = var3_3;
            arrayBracketPair = this;
            this.annotations = (NodeList)Utils.assertNotNull(var4_4);
            var4_4 = var2_2;
            arrayBracketPair = this;
            this.origin = (Origin)Utils.assertNotNull(var4_4);
        }

        public final NodeList<AnnotationExpr> getAnnotations() {
            return this.annotations;
        }

        public final Optional<TokenRange> getTokenRange() {
            return Optional.ofNullable(this.tokenRange);
        }

        public final Origin getOrigin() {
            return this.origin;
        }
    }

    public static final class Origin
    extends Enum<Origin> {
        public static final /* enum */ Origin NAME = new Origin();
        public static final /* enum */ Origin TYPE = new Origin();

        static {
            Origin[] originArray = new Origin[]{NAME, TYPE};
        }
    }
}

