/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.printer;

import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.ReceiverParameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.nodeTypes.NodeWithTypeArguments;
import com.github.javaparser.ast.nodeTypes.NodeWithVariables;
import com.github.javaparser.ast.nodeTypes.SwitchNode;
import com.github.javaparser.ast.stmt.SwitchEntry;
import com.github.javaparser.ast.type.ArrayType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.TypeParameter;
import com.github.javaparser.ast.visitor.Visitable;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.printer.SourcePrinter;
import com.github.javaparser.printer.configuration.ConfigurationOption;
import com.github.javaparser.printer.configuration.DefaultConfigurationOption;
import com.github.javaparser.printer.configuration.DefaultPrinterConfiguration;
import com.github.javaparser.printer.configuration.PrinterConfiguration;
import com.github.javaparser.utils.PositionUtils;
import com.github.javaparser.utils.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class DefaultPrettyPrinterVisitor
implements VoidVisitor<Void> {
    private static Pattern RTRIM = Pattern.compile("\\s+$");
    private PrinterConfiguration configuration;
    private SourcePrinter printer;

    /*
     * WARNING - void declaration
     */
    public DefaultPrettyPrinterVisitor(PrinterConfiguration configuration, SourcePrinter printer) {
        void var2_2;
        void var1_1;
        this.configuration = var1_1;
        this.printer = var2_2;
    }

    public final String toString() {
        return this.printer.toString();
    }

    /*
     * WARNING - void declaration
     */
    private void printModifiers(NodeList<Modifier> modifiers) {
        if (modifiers.size() > 0) {
            void var1_1;
            this.printer.print(var1_1.stream().map(Modifier::getKeyword).map(Modifier.Keyword::asString).collect(Collectors.joining(" ")) + " ");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void printMembers(NodeList<BodyDeclaration<?>> members, Void arg2) {
        for (BodyDeclaration<?> member : members) {
            void var3_3;
            this.printer.println();
            var3_3.accept(this, arg2);
            this.printer.println();
        }
    }

    private void printMemberAnnotations(NodeList<AnnotationExpr> annotations, Void arg2) {
        Iterator iterator;
        if (annotations.isEmpty()) {
            return;
        }
        iterator = ((NodeList)((Object)iterator)).iterator();
        while (iterator.hasNext()) {
            AnnotationExpr annotationExpr = (AnnotationExpr)iterator.next();
            annotationExpr.accept(this, arg2);
            this.printer.println();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void printAnnotations(NodeList<AnnotationExpr> annotations, boolean prefixWithASpace, Void arg2) {
        Iterator iterator;
        void var2_2;
        if (annotations.isEmpty()) {
            return;
        }
        if (var2_2 != false) {
            this.printer.print(" ");
        }
        iterator = ((NodeList)((Object)iterator)).iterator();
        while (iterator.hasNext()) {
            AnnotationExpr annotationExpr = (AnnotationExpr)iterator.next();
            annotationExpr.accept(this, arg2);
            this.printer.print(" ");
        }
    }

    private void printTypeArgs(NodeWithTypeArguments<?> nodeWithTypeArguments, Void arg2) {
        NodeList typeArguments = nodeWithTypeArguments.getTypeArguments().orElse(null);
        if (!Utils.isNullOrEmpty(typeArguments)) {
            this.printer.print("<");
            Iterator i = typeArguments.iterator();
            while (i.hasNext()) {
                Type type = (Type)i.next();
                type.accept(this, arg2);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
            this.printer.print(">");
        }
    }

    private void printTypeParameters(NodeList<TypeParameter> args, Void arg2) {
        if (!Utils.isNullOrEmpty(args)) {
            this.printer.print("<");
            Iterator<TypeParameter> i = args.iterator();
            while (i.hasNext()) {
                TypeParameter typeParameter = i.next();
                typeParameter.accept(this, arg2);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
            this.printer.print(">");
        }
    }

    /*
     * WARNING - void declaration
     */
    private <T extends Expression> void printArguments(NodeList<T> args, Void arg2) {
        this.printer.print("(");
        if (!Utils.isNullOrEmpty(args)) {
            void var3_3;
            boolean columnAlignParameters = args.size() > 1 && this.getOption(DefaultPrinterConfiguration.ConfigOption.COLUMN_ALIGN_PARAMETERS).isPresent();
            if (columnAlignParameters) {
                this.printer.indentWithAlignTo(this.printer.getCursor().column);
            }
            Iterator<T> i = args.iterator();
            while (i.hasNext()) {
                Expression expression = (Expression)i.next();
                expression.accept(this, arg2);
                if (!i.hasNext()) continue;
                this.printer.print(",");
                if (columnAlignParameters) {
                    this.printer.println();
                    continue;
                }
                this.printer.print(" ");
            }
            if (var3_3 != false) {
                this.printer.unindent();
            }
        }
        this.printer.print(")");
    }

    private void printPrePostFixOptionalList(NodeList<? extends Visitable> args, Void arg2, String prefix, String separator, String postfix) {
        if (!args.isEmpty()) {
            Visitable visitable;
            this.printer.print((String)((Object)visitable));
            Iterator<? extends Visitable> i = args.iterator();
            while (i.hasNext()) {
                visitable = i.next();
                visitable.accept(this, arg2);
                if (!i.hasNext()) continue;
                this.printer.print(separator);
            }
            this.printer.print(postfix);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void printComment(Optional<Comment> comment, Void arg2) {
        void var2_2;
        comment.ifPresent(arg_0 -> this.lambda$printComment$0((Void)var2_2, arg_0));
    }

    private void printSwitchNode(SwitchNode n, Void arg2) {
        this.printComment(n.getComment(), arg2);
        this.printer.print("switch(");
        n.getSelector().accept(this, arg2);
        this.printer.println(") {");
        if (n.getEntries() != null) {
            Iterator<SwitchEntry> iterator;
            DefaultPrettyPrinterVisitor defaultPrettyPrinterVisitor = this;
            defaultPrettyPrinterVisitor.indentIf(defaultPrettyPrinterVisitor.getOption(DefaultPrinterConfiguration.ConfigOption.INDENT_CASE_IN_SWITCH).isPresent());
            for (SwitchEntry switchEntry : iterator.getEntries()) {
                switchEntry.accept(this, arg2);
            }
            DefaultPrettyPrinterVisitor defaultPrettyPrinterVisitor2 = this;
            defaultPrettyPrinterVisitor2.unindentIf(defaultPrettyPrinterVisitor2.getOption(DefaultPrinterConfiguration.ConfigOption.INDENT_CASE_IN_SWITCH).isPresent());
        }
        this.printer.print("}");
    }

    private void printOrphanCommentsBeforeThisChildNode(Node node) {
        int i;
        if (!this.getOption(DefaultPrinterConfiguration.ConfigOption.PRINT_COMMENTS).isPresent()) {
            return;
        }
        if (node instanceof Comment) {
            return;
        }
        Node parent = node.getParentNode().orElse(null);
        if (parent == null) {
            return;
        }
        ArrayList<Node> everything = new ArrayList<Node>(parent.getChildNodes());
        PositionUtils.sortByBeginPosition(everything);
        int positionOfTheChild = -1;
        for (int i2 = 0; i2 < everything.size(); ++i2) {
            if (everything.get(i2) != node) continue;
            positionOfTheChild = i2;
            break;
        }
        if (positionOfTheChild == -1) {
            throw new AssertionError((Object)"I am not a child of my parent.");
        }
        int positionOfPreviousChild = -1;
        for (i = positionOfTheChild - 1; i >= 0 && positionOfPreviousChild == -1; --i) {
            if (everything.get(i) instanceof Comment) continue;
            positionOfPreviousChild = i;
        }
        for (i = positionOfPreviousChild + 1; i < positionOfTheChild; ++i) {
            Node nodeToPrint = (Node)everything.get(i);
            if (!(nodeToPrint instanceof Comment)) {
                throw new RuntimeException("Expected comment, instead " + nodeToPrint.getClass() + ". Position of previous child: " + positionOfPreviousChild + ", position of child " + positionOfTheChild);
            }
            nodeToPrint.accept(this, null);
        }
    }

    private void printOrphanCommentsEnding(Node node) {
        if (!this.getOption(DefaultPrinterConfiguration.ConfigOption.PRINT_COMMENTS).isPresent()) {
            return;
        }
        ArrayList<Node> everything = new ArrayList<Node>(node.getChildNodes());
        PositionUtils.sortByBeginPosition(everything);
        if (everything.isEmpty()) {
            return;
        }
        int commentsAtEnd = 0;
        boolean findingComments22 = true;
        while (findingComments22 && commentsAtEnd < everything.size()) {
            ArrayList<Node> arrayList = everything;
            Node findingComments22 = (Node)arrayList.get(arrayList.size() - 1 - commentsAtEnd);
            findingComments22 = findingComments22 instanceof Comment;
            if (!findingComments22) continue;
            ++commentsAtEnd;
        }
        for (int i = 0; i < commentsAtEnd; ++i) {
            ArrayList<Node> arrayList = everything;
            ((Node)arrayList.get(arrayList.size() - commentsAtEnd + i)).accept(this, null);
        }
    }

    private void indentIf(boolean expr) {
        if (expr) {
            this.printer.indent();
        }
    }

    private void unindentIf(boolean expr) {
        if (expr) {
            this.printer.unindent();
        }
    }

    /*
     * WARNING - void declaration
     */
    private Optional<ConfigurationOption> getOption(DefaultPrinterConfiguration.ConfigOption cOption) {
        void var1_1;
        return this.configuration.get$2fe6467a(new DefaultConfigurationOption((DefaultPrinterConfiguration.ConfigOption)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$visit$10(Void arg2, MethodDeclaration n, ReceiverParameter rp) {
        void var2_2;
        void var1_1;
        rp.accept(this, var1_1);
        if (!Utils.isNullOrEmpty(var2_2.getParameters())) {
            this.printer.print(", ");
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$visit$9(Void arg2, ConstructorDeclaration n, ReceiverParameter rp) {
        void var2_2;
        void var1_1;
        rp.accept(this, var1_1);
        if (!Utils.isNullOrEmpty(var2_2.getParameters())) {
            this.printer.print(", ");
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$visit$8(Void arg2, AtomicBoolean columnAlignFirstMethodChain, AtomicBoolean methodCallWithScopeInScope, AtomicBoolean lastMethodInCallChain, Expression scope) {
        void var2_2;
        void var1_1;
        scope.accept(this, var1_1);
        if (var2_2.get()) {
            void var3_3;
            if (var3_3.get()) {
                this.printer.println();
            } else if (!lastMethodInCallChain.get()) {
                this.printer.reindentWithAlignToCursor();
            }
        }
        this.printer.print(".");
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$visit$5(VariableDeclarator n, Void arg2, NodeWithVariables ancestor) {
        void var2_2;
        void var1_1;
        ancestor.getMaximumCommonType().ifPresent(arg_0 -> this.lambda$null$4((VariableDeclarator)var1_1, (Void)var2_2, arg_0));
    }

    private /* synthetic */ void lambda$null$4(VariableDeclarator n, Void arg2, Type commonType) {
        Type type = n.getType();
        ArrayType arrayType = null;
        for (int i = commonType.getArrayLevel(); i < type.getArrayLevel(); ++i) {
            arrayType = arrayType == null ? (ArrayType)type : (ArrayType)arrayType.getComponentType();
            this.printAnnotations(arrayType.getAnnotations(), true, arg2);
            this.printer.print("[]");
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$printComment$0(Void arg2, Comment c) {
        void var1_1;
        c.accept(this, var1_1);
    }
}

