/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import java.io.Serializable;
import java.util.NoSuchElementException;

abstract class Cut<C extends Comparable>
implements Serializable,
Comparable<Cut<C>> {
    final C endpoint;

    /*
     * WARNING - void declaration
     */
    Cut(C endpoint) {
        void var1_1;
        this.endpoint = var1_1;
    }

    abstract boolean isLessThan(C var1);

    abstract BoundType typeAsLowerBound();

    abstract BoundType typeAsUpperBound();

    abstract void describeAsLowerBound(StringBuilder var1);

    abstract void describeAsUpperBound(StringBuilder var1);

    Cut<C> canonical(DiscreteDomain<C> domain) {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(Cut<C> that) {
        void var1_1;
        if (that == BelowAll.INSTANCE) {
            return 1;
        }
        if (that == AboveAll.INSTANCE) {
            return -1;
        }
        int result = Range.compareOrThrow(this.endpoint, that.endpoint);
        if (result != 0) {
            void var2_2;
            return (int)var2_2;
        }
        return Boolean.compare(this instanceof AboveValue, var1_1 instanceof AboveValue);
    }

    C endpoint() {
        return this.endpoint;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        if (obj instanceof Cut) {
            Cut that = (Cut)obj;
            try {
                void var1_1;
                int n = this.compareTo((Cut<C>)var1_1);
                return n == 0;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }
        return false;
    }

    public abstract int hashCode();

    static <C extends Comparable> Cut<C> belowAll$5559d39b() {
        return BelowAll.INSTANCE;
    }

    static <C extends Comparable> Cut<C> aboveAll$5559d39b() {
        return AboveAll.INSTANCE;
    }

    static <C extends Comparable> Cut<C> belowValue$6a7d55c6(C endpoint) {
        C c;
        return new BelowValue<C>(c);
    }

    static <C extends Comparable> Cut<C> aboveValue$6a7d55c6(C endpoint) {
        C c;
        return new AboveValue<C>(c);
    }

    private static final class AboveValue<C extends Comparable>
    extends Cut<C> {
        /*
         * WARNING - void declaration
         */
        AboveValue(C endpoint) {
            super((Comparable)Preconditions.checkNotNull(var1_1));
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean isLessThan(C value) {
            void var1_1;
            return Range.compareOrThrow(this.endpoint, (Comparable)var1_1) < 0;
        }

        @Override
        final BoundType typeAsLowerBound() {
            return BoundType.OPEN;
        }

        @Override
        final BoundType typeAsUpperBound() {
            return BoundType.CLOSED;
        }

        @Override
        final void describeAsLowerBound(StringBuilder sb) {
            sb.append('(').append(this.endpoint);
        }

        @Override
        final void describeAsUpperBound(StringBuilder sb) {
            sb.append(this.endpoint).append(']');
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final Cut<C> canonical(DiscreteDomain<C> domain) {
            DiscreteDomain discreteDomain = domain;
            domain = this;
            C next = discreteDomain.next(((Cut)domain).endpoint);
            if (next != null) {
                void var1_1;
                return AboveValue.belowValue$6a7d55c6((Comparable)var1_1);
            }
            return AboveAll.INSTANCE;
        }

        @Override
        public final int hashCode() {
            return ~this.endpoint.hashCode();
        }

        public final String toString() {
            return "/" + this.endpoint + "\\";
        }
    }

    private static final class BelowAll
    extends Cut<Comparable<?>> {
        private static final BelowAll INSTANCE = new BelowAll();

        private BelowAll() {
            super("");
        }

        @Override
        final Comparable<?> endpoint() {
            throw new IllegalStateException("range unbounded on this side");
        }

        @Override
        final boolean isLessThan(Comparable<?> value) {
            return true;
        }

        @Override
        final BoundType typeAsLowerBound() {
            throw new IllegalStateException();
        }

        @Override
        final BoundType typeAsUpperBound() {
            throw new AssertionError((Object)"this statement should be unreachable");
        }

        @Override
        final void describeAsLowerBound(StringBuilder sb) {
            sb.append("(-\u221e");
        }

        @Override
        final void describeAsUpperBound(StringBuilder sb) {
            throw new AssertionError();
        }

        @Override
        final Cut<Comparable<?>> canonical(DiscreteDomain<Comparable<?>> domain) {
            try {
                return Cut.belowValue$6a7d55c6(domain.minValue());
            }
            catch (NoSuchElementException noSuchElementException) {
                return this;
            }
        }

        @Override
        public final int compareTo(Cut<Comparable<?>> o) {
            if (o == this) {
                return 0;
            }
            return -1;
        }

        @Override
        public final int hashCode() {
            return System.identityHashCode(this);
        }

        public final String toString() {
            return "-\u221e";
        }
    }

    private static final class AboveAll
    extends Cut<Comparable<?>> {
        private static final AboveAll INSTANCE = new AboveAll();

        private AboveAll() {
            super("");
        }

        @Override
        final Comparable<?> endpoint() {
            throw new IllegalStateException("range unbounded on this side");
        }

        @Override
        final boolean isLessThan(Comparable<?> value) {
            return false;
        }

        @Override
        final BoundType typeAsLowerBound() {
            throw new AssertionError((Object)"this statement should be unreachable");
        }

        @Override
        final BoundType typeAsUpperBound() {
            throw new IllegalStateException();
        }

        @Override
        final void describeAsLowerBound(StringBuilder sb) {
            throw new AssertionError();
        }

        @Override
        final void describeAsUpperBound(StringBuilder sb) {
            sb.append("+\u221e)");
        }

        @Override
        public final int compareTo(Cut<Comparable<?>> o) {
            if (o == this) {
                return 0;
            }
            return 1;
        }

        @Override
        public final int hashCode() {
            return System.identityHashCode(this);
        }

        public final String toString() {
            return "+\u221e";
        }
    }

    private static final class BelowValue<C extends Comparable>
    extends Cut<C> {
        /*
         * WARNING - void declaration
         */
        BelowValue(C endpoint) {
            super((Comparable)Preconditions.checkNotNull(var1_1));
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean isLessThan(C value) {
            void var1_1;
            return Range.compareOrThrow(this.endpoint, (Comparable)var1_1) <= 0;
        }

        @Override
        final BoundType typeAsLowerBound() {
            return BoundType.CLOSED;
        }

        @Override
        final BoundType typeAsUpperBound() {
            return BoundType.OPEN;
        }

        @Override
        final void describeAsLowerBound(StringBuilder sb) {
            sb.append('[').append(this.endpoint);
        }

        @Override
        final void describeAsUpperBound(StringBuilder sb) {
            sb.append(this.endpoint).append(')');
        }

        @Override
        public final int hashCode() {
            return this.endpoint.hashCode();
        }

        public final String toString() {
            return "\\" + this.endpoint + "/";
        }
    }
}

