/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.RegularImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;

final class ImmutableEnumSet<E extends Enum<E>>
extends ImmutableSet<E> {
    private final transient EnumSet<E> delegate;
    private transient int hashCode;

    static <E extends Enum<E>> ImmutableSet<E> asImmutable(EnumSet<E> set) {
        EnumSet<E> enumSet;
        switch (set.size()) {
            case 0: {
                return RegularImmutableSet.EMPTY;
            }
            case 1: {
                return ImmutableSet.of$24b303f3((Object)((Enum)Iterables.getOnlyElement(set)));
            }
        }
        return new ImmutableEnumSet<E>(enumSet);
    }

    /*
     * WARNING - void declaration
     */
    private ImmutableEnumSet(EnumSet<E> delegate) {
        void var1_1;
        this.delegate = var1_1;
    }

    @Override
    final boolean isPartialView() {
        return false;
    }

    @Override
    public final UnmodifiableIterator<E> iterator() {
        UnmodifiableIterator unmodifiableIterator = this.delegate.iterator();
        Preconditions.checkNotNull(unmodifiableIterator);
        if (unmodifiableIterator instanceof UnmodifiableIterator) {
            unmodifiableIterator = unmodifiableIterator;
            return unmodifiableIterator;
        }
        return new UnmodifiableIterator<T>(unmodifiableIterator){
            private /* synthetic */ Iterator val$iterator;
            {
                this.val$iterator = iterator;
            }

            public final boolean hasNext() {
                return this.val$iterator.hasNext();
            }

            public final T next() {
                return (T)this.val$iterator.next();
            }
        };
    }

    @Override
    public final Spliterator<E> spliterator() {
        return this.delegate.spliterator();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void forEach(Consumer<? super E> action) {
        void var1_1;
        this.delegate.forEach(var1_1);
    }

    @Override
    public final int size() {
        return this.delegate.size();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean contains(Object object) {
        void var1_1;
        return this.delegate.contains(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean containsAll(Collection<?> collection) {
        void var1_1;
        if (collection instanceof ImmutableEnumSet) {
            collection = ((ImmutableEnumSet)collection).delegate;
        }
        return this.delegate.containsAll((Collection<?>)var1_1);
    }

    @Override
    public final boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean equals(Object object) {
        void var1_1;
        if (object == this) {
            return true;
        }
        if (object instanceof ImmutableEnumSet) {
            object = ((ImmutableEnumSet)((Object)object)).delegate;
        }
        return this.delegate.equals(var1_1);
    }

    @Override
    final boolean isHashCodeFast() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int hashCode() {
        void var1_1;
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = this.delegate.hashCode();
            return this.hashCode;
        }
        return (int)var1_1;
    }

    @Override
    public final String toString() {
        return this.delegate.toString();
    }
}

