/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.CollectSpliterators;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMapEntry;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.RegularImmutableMap;
import com.google.common.collect.Sets;
import com.google.common.collect.SingletonImmutableBiMap;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.Function;

public abstract class ImmutableMap<K, V>
implements Serializable,
Map<K, V> {
    static final Map.Entry<?, ?>[] EMPTY_ENTRY_ARRAY = new Map.Entry[0];
    private transient ImmutableSet<Map.Entry<K, V>> entrySet;
    private transient ImmutableSet<K> keySet;
    private transient ImmutableCollection<V> values;

    public static <K, V> ImmutableMap<K, V> of() {
        return RegularImmutableMap.EMPTY$6c6b9e54;
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableMap<K, V> of$58d7f51d(K k1, V v1) {
        void var1_1;
        K k = k1;
        return new SingletonImmutableBiMap<K, void>(k, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static <K, V> Map.Entry<K, V> entryOf$5733d0c(K key, V value) {
        void var1_1;
        K k;
        return new ImmutableMapEntry<K, void>(k, var1_1);
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    /*
     * WARNING - void declaration
     */
    static IllegalArgumentException conflictException(String conflictDescription, Object entry1, Object entry2) {
        void var2_2;
        void var1_1;
        String string;
        return new IllegalArgumentException("Multiple entries with same " + string + ": " + var1_1 + " and " + var2_2);
    }

    ImmutableMap() {
    }

    @Override
    @Deprecated
    public final V put(K k, V v) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final V putIfAbsent(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean replace(K key, V oldValue, V newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final V replace(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> function) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void putAll(Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final V remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsKey(Object key) {
        void var1_1;
        return this.get(var1_1) != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsValue(Object value) {
        void var1_1;
        return ((ImmutableCollection)this.values()).contains(var1_1);
    }

    @Override
    public abstract V get(Object var1);

    /*
     * WARNING - void declaration
     */
    @Override
    public final V getOrDefault(Object key, V defaultValue) {
        void var2_2;
        V result = this.get(key);
        if (result != null) {
            void var1_1;
            return var1_1;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ImmutableSet<Map.Entry<K, V>> entrySet() {
        void var1_1;
        ImmutableSet<Map.Entry<K, V>> result = this.entrySet;
        if (result == null) {
            this.entrySet = this.createEntrySet();
            return this.entrySet;
        }
        return var1_1;
    }

    abstract ImmutableSet<Map.Entry<K, V>> createEntrySet();

    /*
     * WARNING - void declaration
     */
    @Override
    public ImmutableSet<K> keySet() {
        void var1_1;
        ImmutableSet<K> result = this.keySet;
        if (result == null) {
            this.keySet = this.createKeySet();
            return this.keySet;
        }
        return var1_1;
    }

    abstract ImmutableSet<K> createKeySet();

    final Spliterator<K> keySpliterator() {
        return CollectSpliterators.map$6379d89(((ImmutableCollection)((Object)this.entrySet())).spliterator(), Map.Entry::getKey);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ImmutableCollection<V> values() {
        void var1_1;
        ImmutableCollection<V> result = this.values;
        if (result == null) {
            this.values = this.createValues();
            return this.values;
        }
        return var1_1;
    }

    abstract ImmutableCollection<V> createValues();

    @Override
    public boolean equals(Object object) {
        ImmutableMap immutableMap = this;
        Map map = immutableMap;
        if (immutableMap == map) {
            return true;
        }
        if (map instanceof Map) {
            map = map;
            return immutableMap.entrySet().equals(map.entrySet());
        }
        return false;
    }

    abstract boolean isPartialView();

    @Override
    public int hashCode() {
        return Sets.hashCodeImpl(this.entrySet());
    }

    static boolean isHashCodeFast() {
        return false;
    }

    public String toString() {
        return Maps.toStringImpl(this);
    }

    public static final class Builder<K, V> {
        private Comparator<? super V> valueComparator;
        private Map.Entry<K, V>[] entries;
        private int size;
        private boolean entriesUsed;

        public Builder() {
            this(4);
        }

        /*
         * WARNING - void declaration
         */
        Builder(int initialCapacity) {
            void var1_1;
            this.entries = new Map.Entry[var1_1];
            this.size = 0;
            this.entriesUsed = false;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder<K, V> put(K key, V value) {
            void var1_1;
            void var2_2;
            Builder builder = this;
            int n = builder.size + 1;
            Builder builder2 = builder;
            if (n > builder2.entries.length) {
                builder2.entries = Arrays.copyOf(builder2.entries, ImmutableCollection.Builder.expandedCapacity(builder2.entries.length, n));
                builder2.entriesUsed = false;
            }
            ImmutableMapEntry entry = ImmutableMap.entryOf$5733d0c(key, (Object)var2_2);
            this.entries[this.size++] = var1_1;
            return this;
        }

        public final ImmutableMap<K, V> buildOrThrow() {
            boolean bl = true;
            Builder builder = this;
            switch (builder.size) {
                case 0: {
                    return ImmutableMap.of();
                }
                case 1: {
                    Map.Entry<K, V> entry = Objects.requireNonNull(builder.entries[0]);
                    return ImmutableMap.of$58d7f51d(entry.getKey(), entry.getValue());
                }
            }
            int n = builder.size;
            Comparator<? super V> cfr_ignored_0 = builder.valueComparator;
            Map.Entry<K, V>[] entryArray = builder.entries;
            builder.entriesUsed = true;
            return RegularImmutableMap.fromEntryArray(n, entryArray, true);
        }
    }
}

