/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.Hashing;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableEnumSet;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.JdkBackedImmutableSet;
import com.google.common.collect.RegularImmutableAsList;
import com.google.common.collect.RegularImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.SingletonImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.math.IntMath;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;

public abstract class ImmutableSet<E>
extends ImmutableCollection<E>
implements Set<E> {
    public static <E> ImmutableSet<E> of$19e5980f() {
        return RegularImmutableSet.EMPTY;
    }

    public static <E> ImmutableSet<E> of$24b303f3(E e1) {
        E e;
        return new SingletonImmutableSet<E>(e);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ImmutableSet<E> of(E e1, E e2, E e3) {
        void var2_2;
        void var1_1;
        E e;
        return new RegularSetBuilderImpl<E>(3).add(e).add(var1_1).add(var2_2).review().build();
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ImmutableSet<E> of(E e1, E e2, E e3, E e4) {
        void var3_3;
        void var2_2;
        void var1_1;
        E e;
        return new RegularSetBuilderImpl<E>(4).add(e).add(var1_1).add(var2_2).add(var3_3).review().build();
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <E> ImmutableSet<E> of(E e1, E e2, E e3, E e4, E e5, E e6, E ... others) {
        void var3_4;
        void var2_3;
        void var1_2;
        int cfr_ignored_0 = others.length;
        Preconditions.checkArgument(true, "the total number of elements must fit in an int");
        int cfr_ignored_1 = others.length;
        RegularSetBuilderImpl<E> regularSetBuilderImpl = new RegularSetBuilderImpl<E>(16);
        SetBuilderImpl<void> builder = ((SetBuilderImpl)regularSetBuilderImpl).add(e1).add(var1_2).add(var2_3).add(var3_4).add((void)e5).add((void)e6);
        for (int i = 0; i < others.length; ++i) {
            builder = builder.add((void)others[i]);
        }
        return builder.review().build();
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ImmutableSet<E> copyOf(Collection<? extends E> elements) {
        void var1_3;
        void var0_1;
        if (elements instanceof ImmutableSet && !(elements instanceof SortedSet)) {
            ImmutableSet set = (ImmutableSet)((Object)elements);
            if (!set.isPartialView()) {
                return set;
            }
        } else if (elements instanceof EnumSet) {
            elements = elements;
            return ImmutableEnumSet.asImmutable(EnumSet.copyOf(elements));
        }
        if (elements.isEmpty()) {
            return RegularImmutableSet.EMPTY;
        }
        Object[] array = elements.toArray();
        int expectedSize = elements instanceof Set ? array.length : ((elements = array.length) < 4 ? elements : Math.max(4, IntMath.sqrt(elements, RoundingMode.CEILING)));
        void var1_4 = var0_1;
        void var0_2 = var1_3;
        switch (((void)var0_2).length) {
            case 0: {
                return RegularImmutableSet.EMPTY;
            }
            case 1: {
                return ImmutableSet.of$24b303f3((Object)var0_2[0]);
            }
        }
        SetBuilderImpl setBuilderImpl = new RegularSetBuilderImpl<void>((int)var1_4);
        for (int i = 0; i < ((void)var0_2).length; ++i) {
            setBuilderImpl = ((SetBuilderImpl)setBuilderImpl).add(var0_2[i]);
        }
        return ((SetBuilderImpl)setBuilderImpl).review().build();
    }

    ImmutableSet() {
    }

    boolean isHashCodeFast() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object object) {
        void var1_1;
        if (object == this) {
            return true;
        }
        if (object instanceof ImmutableSet && this.isHashCodeFast() && ((ImmutableSet)object).isHashCodeFast() && this.hashCode() != object.hashCode()) {
            return false;
        }
        return Sets.equalsImpl(this, var1_1);
    }

    @Override
    public int hashCode() {
        return Sets.hashCodeImpl(this);
    }

    @Override
    public abstract UnmodifiableIterator<E> iterator();

    public static <E> Builder<E> builder() {
        return new Builder();
    }

    public static <E> Builder<E> builderWithExpectedSize(int expectedSize) {
        int n;
        CollectPreconditions.checkNonnegative(expectedSize, "expectedSize");
        return new Builder(n);
    }

    /*
     * WARNING - void declaration
     */
    static int chooseTableSize(int setSize) {
        int n;
        if ((setSize = Math.max(setSize, 2)) < 0x2CCCCCCC) {
            void var1_1;
            int tableSize = Integer.highestOneBit(setSize - 1) << 1;
            while ((double)tableSize * 0.7 < (double)setSize) {
                tableSize <<= 1;
            }
            return (int)var1_1;
        }
        Preconditions.checkArgument(n < 0x40000000, "collection too large");
        return 0x40000000;
    }

    private static final class RegularSetBuilderImpl<E>
    extends SetBuilderImpl<E> {
        private Object[] hashTable;
        private int maxRunBeforeFallback;
        private int expandTableThreshold;
        private int hashCode;

        /*
         * WARNING - void declaration
         */
        RegularSetBuilderImpl(int expectedCapacity) {
            super((int)var1_1);
            void var1_1;
            this.hashTable = null;
            this.maxRunBeforeFallback = 0;
            this.expandTableThreshold = 0;
        }

        /*
         * WARNING - void declaration
         */
        private RegularSetBuilderImpl(RegularSetBuilderImpl<E> toCopy) {
            super(toCopy);
            void var1_1;
            this.hashTable = toCopy.hashTable == null ? null : (Object[])toCopy.hashTable.clone();
            this.maxRunBeforeFallback = toCopy.maxRunBeforeFallback;
            this.expandTableThreshold = toCopy.expandTableThreshold;
            this.hashCode = var1_1.hashCode;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final SetBuilderImpl<E> add(E e) {
            void var1_1;
            Preconditions.checkNotNull(e);
            if (this.hashTable == null) {
                void var2_2;
                if (this.distinct == 0) {
                    this.addDedupedElement(e);
                    return this;
                }
                RegularSetBuilderImpl regularSetBuilderImpl = this;
                regularSetBuilderImpl.ensureTableCapacity(regularSetBuilderImpl.dedupedElements.length);
                Object elem = this.dedupedElements[0];
                --this.distinct;
                return this.insertInHashTable(var2_2).add((void)e);
            }
            return this.insertInHashTable(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private SetBuilderImpl<E> insertInHashTable(E e) {
            void var1_1;
            Objects.requireNonNull(this.hashTable);
            int eHash = e.hashCode();
            int i0 = Hashing.smear(eHash);
            int mask = this.hashTable.length - 1;
            int i = i0;
            while (i - i0 < this.maxRunBeforeFallback) {
                int index = i & mask;
                Object tableEntry = this.hashTable[index];
                if (tableEntry == null) {
                    this.addDedupedElement(e);
                    this.hashTable[index] = e;
                    this.hashCode += eHash;
                    RegularSetBuilderImpl regularSetBuilderImpl = this;
                    regularSetBuilderImpl.ensureTableCapacity(regularSetBuilderImpl.distinct);
                    return this;
                }
                if (tableEntry.equals(e)) {
                    return this;
                }
                ++i;
            }
            return new JdkBackedSetBuilderImpl<void>(this).add(var1_1);
        }

        @Override
        final SetBuilderImpl<E> copy() {
            return new RegularSetBuilderImpl<E>(this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final SetBuilderImpl<E> review() {
            boolean bl;
            block7: {
                if (this.hashTable == null) {
                    return this;
                }
                int targetTableSize = ImmutableSet.chooseTableSize(this.distinct);
                if (targetTableSize << 1 < this.hashTable.length) {
                    void var1_1;
                    this.hashTable = RegularSetBuilderImpl.rebuildHashTable(targetTableSize, this.dedupedElements, this.distinct);
                    this.maxRunBeforeFallback = RegularSetBuilderImpl.maxRunBeforeFallback(targetTableSize);
                    this.expandTableThreshold = (int)(0.7 * (double)var1_1);
                }
                Object[] objectArray = this.hashTable;
                int n = RegularSetBuilderImpl.maxRunBeforeFallback(this.hashTable.length);
                int n2 = objectArray.length - 1;
                int n3 = 0;
                int n4 = 0;
                block0: while (n3 < objectArray.length) {
                    if (n3 == n4 && objectArray[n3] == null) {
                        if (objectArray[n3 + n - 1 & n2] == null) {
                            n3 += n;
                        }
                        n4 = ++n3;
                        continue;
                    }
                    for (int i = n3 + n - 1; i >= n4; --i) {
                        if (objectArray[i & n2] != null) continue;
                        n4 = n3 + n;
                        n3 = i + 1;
                        continue block0;
                    }
                    bl = true;
                    break block7;
                }
                bl = false;
            }
            if (bl) {
                return new JdkBackedSetBuilderImpl(this);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final ImmutableSet<E> build() {
            void var1_1;
            switch (this.distinct) {
                case 0: {
                    return ImmutableSet.of$19e5980f();
                }
                case 1: {
                    return ImmutableSet.of$24b303f3(Objects.requireNonNull(this.dedupedElements[0]));
                }
            }
            E[] elements = this.distinct == this.dedupedElements.length ? this.dedupedElements : Arrays.copyOf(this.dedupedElements, this.distinct);
            return new RegularImmutableSet((Object[])var1_1, this.hashCode, Objects.requireNonNull(this.hashTable), this.hashTable.length - 1);
        }

        /*
         * WARNING - void declaration
         */
        private static Object[] rebuildHashTable(int newTableSize, Object[] elements, int n) {
            void var0_1;
            Object[] hashTable = new Object[newTableSize];
            int mask = hashTable.length - 1;
            for (int i = 0; i < n; ++i) {
                int n2;
                Object e = Objects.requireNonNull(elements[i]);
                int j = n2 = Hashing.smear(e.hashCode());
                while (true) {
                    int index;
                    if (hashTable[index = j & mask] == null) break;
                    ++j;
                }
                hashTable[index] = e;
            }
            return var0_1;
        }

        /*
         * WARNING - void declaration
         */
        private void ensureTableCapacity(int minCapacity) {
            void var1_1;
            int newTableSize;
            if (this.hashTable == null) {
                newTableSize = ImmutableSet.chooseTableSize(minCapacity);
                this.hashTable = new Object[newTableSize];
            } else if (newTableSize > this.expandTableThreshold && this.hashTable.length < 0x40000000) {
                newTableSize = this.hashTable.length << 1;
                this.hashTable = RegularSetBuilderImpl.rebuildHashTable(newTableSize, this.dedupedElements, this.distinct);
            } else {
                return;
            }
            this.maxRunBeforeFallback = RegularSetBuilderImpl.maxRunBeforeFallback(newTableSize);
            this.expandTableThreshold = (int)(0.7 * (double)var1_1);
        }

        private static int maxRunBeforeFallback(int tableSize) {
            int n;
            return 13 * IntMath.log2(n, RoundingMode.UNNECESSARY);
        }
    }

    private static abstract class SetBuilderImpl<E> {
        E[] dedupedElements;
        int distinct;

        /*
         * WARNING - void declaration
         */
        SetBuilderImpl(int expectedCapacity) {
            void var1_1;
            this.dedupedElements = new Object[var1_1];
            this.distinct = 0;
        }

        /*
         * WARNING - void declaration
         */
        SetBuilderImpl(SetBuilderImpl<E> toCopy) {
            void var1_1;
            this.dedupedElements = Arrays.copyOf(toCopy.dedupedElements, toCopy.dedupedElements.length);
            this.distinct = var1_1.distinct;
        }

        /*
         * WARNING - void declaration
         */
        final void addDedupedElement(E e) {
            void var1_1;
            SetBuilderImpl setBuilderImpl = this;
            int n = setBuilderImpl.distinct + 1;
            SetBuilderImpl setBuilderImpl2 = setBuilderImpl;
            if (n > setBuilderImpl2.dedupedElements.length) {
                n = ImmutableCollection.Builder.expandedCapacity(setBuilderImpl2.dedupedElements.length, n);
                setBuilderImpl2.dedupedElements = Arrays.copyOf(setBuilderImpl2.dedupedElements, n);
            }
            this.dedupedElements[this.distinct++] = var1_1;
        }

        abstract SetBuilderImpl<E> add(E var1);

        abstract SetBuilderImpl<E> copy();

        SetBuilderImpl<E> review() {
            return this;
        }

        abstract ImmutableSet<E> build();
    }

    public static class Builder<E>
    extends ImmutableCollection.Builder<E> {
        private SetBuilderImpl<E> impl;
        boolean forceCopy;

        public Builder() {
            this(0);
        }

        /*
         * WARNING - void declaration
         */
        Builder(int capacity) {
            if (capacity > 0) {
                void var1_1;
                this.impl = new RegularSetBuilderImpl((int)var1_1);
                return;
            }
            this.impl = EmptySetBuilderImpl.instance$218749aa();
        }

        Builder(byte by) {
            this.impl = null;
        }

        final void copyIfNecessary() {
            if (this.forceCopy) {
                this.copy();
                this.forceCopy = false;
            }
        }

        void copy() {
            Objects.requireNonNull(this.impl);
            this.impl = this.impl.copy();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Builder<E> add(E element) {
            void var1_1;
            Objects.requireNonNull(this.impl);
            Preconditions.checkNotNull(element);
            this.copyIfNecessary();
            this.impl = this.impl.add(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Builder<E> addAll(Iterable<? extends E> elements) {
            void var1_1;
            super.addAll(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Builder<E> addAll(Iterator<? extends E> elements) {
            void var1_1;
            super.addAll(var1_1);
            return this;
        }

        Builder<E> combine(Builder<E> other) {
            SetBuilderImpl setBuilderImpl;
            Objects.requireNonNull(this.impl);
            Objects.requireNonNull(other.impl);
            this.copyIfNecessary();
            SetBuilderImpl<E> setBuilderImpl2 = ((Builder)((Object)setBuilderImpl)).impl;
            setBuilderImpl = this.impl;
            for (int i = 0; i < setBuilderImpl2.distinct; ++i) {
                setBuilderImpl = setBuilderImpl.add(Objects.requireNonNull(setBuilderImpl2.dedupedElements[i]));
            }
            this.impl = setBuilderImpl;
            return this;
        }

        public ImmutableSet<E> build() {
            Objects.requireNonNull(this.impl);
            this.forceCopy = true;
            this.impl = this.impl.review();
            return this.impl.build();
        }
    }

    private static final class JdkBackedSetBuilderImpl<E>
    extends SetBuilderImpl<E> {
        private final Set<Object> delegate;

        JdkBackedSetBuilderImpl(SetBuilderImpl<E> toCopy) {
            super(toCopy);
            this.delegate = Sets.newHashSetWithExpectedSize(this.distinct);
            for (int i = 0; i < this.distinct; ++i) {
                this.delegate.add(Objects.requireNonNull(this.dedupedElements[i]));
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final SetBuilderImpl<E> add(E e) {
            Preconditions.checkNotNull(e);
            if (this.delegate.add(e)) {
                void var1_1;
                this.addDedupedElement(var1_1);
            }
            return this;
        }

        @Override
        final SetBuilderImpl<E> copy() {
            return new JdkBackedSetBuilderImpl<E>(this);
        }

        @Override
        final ImmutableSet<E> build() {
            switch (this.distinct) {
                case 0: {
                    return ImmutableSet.of$19e5980f();
                }
                case 1: {
                    return ImmutableSet.of$24b303f3(Objects.requireNonNull(this.dedupedElements[0]));
                }
            }
            return new JdkBackedImmutableSet(this.delegate, ImmutableList.asImmutableList(this.dedupedElements, this.distinct));
        }
    }

    private static final class EmptySetBuilderImpl<E>
    extends SetBuilderImpl<E> {
        private static final EmptySetBuilderImpl<Object> INSTANCE = new EmptySetBuilderImpl();

        static <E> SetBuilderImpl<E> instance$218749aa() {
            return INSTANCE;
        }

        private EmptySetBuilderImpl() {
            super(0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final SetBuilderImpl<E> add(E e) {
            void var1_1;
            return new RegularSetBuilderImpl<void>(4).add(var1_1);
        }

        @Override
        final SetBuilderImpl<E> copy() {
            return this;
        }

        @Override
        final ImmutableSet<E> build() {
            return ImmutableSet.of$19e5980f();
        }
    }

    static abstract class CachingAsList<E>
    extends ImmutableSet<E> {
        private transient ImmutableList<E> asList;

        CachingAsList() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ImmutableList<E> asList() {
            void var1_1;
            ImmutableList<E> result = this.asList;
            if (result == null) {
                this.asList = this.createAsList();
                return this.asList;
            }
            return var1_1;
        }

        ImmutableList<E> createAsList() {
            CachingAsList cachingAsList = this;
            return new RegularImmutableAsList(cachingAsList, cachingAsList.toArray());
        }
    }
}

