/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.NaturalOrdering;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Ordering;
import com.google.common.collect.RegularImmutableSortedSet;
import com.google.common.collect.SortedIterable;
import com.google.common.collect.SortedIterables;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.NavigableSet;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;

public abstract class ImmutableSortedSet<E>
extends ImmutableSet.CachingAsList<E>
implements SortedIterable<E>,
NavigableSet<E> {
    final transient Comparator<? super E> comparator;
    private transient ImmutableSortedSet<E> descendingSet;

    static <E> RegularImmutableSortedSet<E> emptySet(Comparator<? super E> comparator) {
        Comparator<? super E> comparator2;
        if (Ordering.natural$75ffd5c5().equals(comparator)) {
            comparator = RegularImmutableSortedSet.NATURAL_EMPTY_SET;
            return comparator;
        }
        return new RegularImmutableSortedSet<E>(ImmutableList.of(), comparator2);
    }

    public static <E> ImmutableSortedSet<E> copyOf(Collection<? extends E> elements) {
        NaturalOrdering naturalOrdering;
        NaturalOrdering naturalOrdering2 = Ordering.natural$75ffd5c5();
        Object object = naturalOrdering2;
        object = naturalOrdering;
        naturalOrdering = naturalOrdering2;
        return ImmutableSortedSet.copyOf(naturalOrdering2, object);
    }

    /*
     * WARNING - void declaration
     */
    private static <E> ImmutableSortedSet<E> copyOf(Comparator<? super E> comparator, Iterable<? extends E> elements) {
        void var2_5;
        Comparator<E> comparator2;
        void var1_1;
        ImmutableSortedSet original;
        Preconditions.checkNotNull(comparator);
        boolean bl = SortedIterables.hasSameComparator(comparator, elements);
        if (bl && elements instanceof ImmutableSortedSet && !(original = (ImmutableSortedSet)elements).isPartialView()) {
            return original;
        }
        Object[] array = Iterables.toArray(var1_1);
        int n = array.length;
        if (n == 0) {
            return ImmutableSortedSet.emptySet(comparator2);
        }
        ObjectArrays.checkElementsNotNull((Object[])var2_5, n);
        Arrays.sort(var2_5, 0, n, comparator2);
        int n2 = 1;
        for (int i = 1; i < n; ++i) {
            void var5_8 = var2_5[i];
            void var6_9 = var2_5[n2 - 1];
            if (comparator2.compare(var5_8, var6_9) == 0) continue;
            var2_5[n2++] = var5_8;
        }
        Arrays.fill((Object[])var2_5, n2, n, null);
        return new RegularImmutableSortedSet(ImmutableList.asImmutableList((Object[])var2_5, n2), comparator2);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ImmutableSortedSet<E> copyOf(Comparator<? super E> comparator, Collection<? extends E> elements) {
        void var1_1;
        return ImmutableSortedSet.copyOf(comparator, var1_1);
    }

    public static <E> Builder<E> orderedBy(Comparator<E> comparator) {
        Comparator<E> comparator2;
        return new Builder<E>(comparator2);
    }

    /*
     * WARNING - void declaration
     */
    final int unsafeCompare(Object a, Object b) {
        Comparator<E> comparator;
        void var2_2;
        Comparator<E> comparator2 = this.comparator;
        void var3_3 = var2_2;
        var2_2 = comparator;
        comparator = comparator2;
        comparator = comparator2;
        return comparator2.compare(var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    ImmutableSortedSet(Comparator<? super E> comparator) {
        void var1_1;
        this.comparator = var1_1;
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    private ImmutableSortedSet<E> headSet(E toElement, boolean inclusive) {
        void var2_2;
        void var1_1;
        return this.headSetImpl$18f4013e(Preconditions.checkNotNull(var1_1), (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    private ImmutableSortedSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(fromElement);
        Preconditions.checkNotNull(toElement);
        Preconditions.checkArgument(this.comparator.compare(fromElement, toElement) <= 0);
        return this.subSetImpl(var1_1, (boolean)var2_2, var3_3, toInclusive);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    private ImmutableSortedSet<E> tailSet(E fromElement, boolean inclusive) {
        void var2_2;
        void var1_1;
        return this.tailSetImpl$18f4013e(Preconditions.checkNotNull(var1_1), (boolean)var2_2);
    }

    abstract ImmutableSortedSet<E> headSetImpl$18f4013e(E var1, boolean var2);

    abstract ImmutableSortedSet<E> subSetImpl(E var1, boolean var2, E var3, boolean var4);

    abstract ImmutableSortedSet<E> tailSetImpl$18f4013e(E var1, boolean var2);

    /*
     * WARNING - void declaration
     */
    @Override
    public E lower(E e) {
        void var1_1;
        return Iterators.getNext(((ImmutableSortedSet)this.headSet((Object)var1_1, false)).descendingIterator(), null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E floor(E e) {
        void var1_1;
        return Iterators.getNext(((ImmutableSortedSet)this.headSet((Object)var1_1, true)).descendingIterator(), null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E ceiling(E e) {
        void var1_1;
        return (E)Iterables.getFirst$4f661e18((ImmutableSortedSet)this.tailSet((Object)var1_1, true), null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E higher(E e) {
        void var1_1;
        return (E)Iterables.getFirst$4f661e18((ImmutableSortedSet)this.tailSet((Object)var1_1, false), null);
    }

    @Override
    public E first() {
        return ((ImmutableCollection)this).iterator().next();
    }

    @Override
    public E last() {
        return this.descendingIterator().next();
    }

    @Override
    @Deprecated
    public final E pollFirst() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final E pollLast() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ImmutableSortedSet<E> descendingSet() {
        void var1_1;
        RegularImmutableSortedSet result = this.descendingSet;
        if (result == null) {
            result = this.descendingSet = this.createDescendingSet$64ffd814();
            this.descendingSet.descendingSet = this;
        }
        return var1_1;
    }

    abstract ImmutableSortedSet<E> createDescendingSet$64ffd814();

    @Override
    public Spliterator<E> spliterator() {
        ImmutableSortedSet immutableSortedSet = this;
        return new Spliterators.AbstractSpliterator<E>(immutableSortedSet, immutableSortedSet.size(), 1365){
            private UnmodifiableIterator<E> iterator;
            private /* synthetic */ ImmutableSortedSet this$0;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super((long)var2_2, 1365);
                this.iterator = ((ImmutableCollection)this.this$0).iterator();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final boolean tryAdvance(Consumer<? super E> action) {
                if (this.iterator.hasNext()) {
                    void var1_1;
                    var1_1.accept(this.iterator.next());
                    return true;
                }
                return false;
            }

            @Override
            public final Comparator<? super E> getComparator() {
                return this.this$0.comparator;
            }
        };
    }

    @Override
    public abstract UnmodifiableIterator<E> descendingIterator();

    abstract int indexOf(Object var1);

    public static final class Builder<E>
    extends ImmutableSet.Builder<E> {
        private final Comparator<? super E> comparator;
        private E[] elements;
        private int n;

        /*
         * WARNING - void declaration
         */
        public Builder(Comparator<? super E> comparator) {
            this((Comparator<E>)var1_1, 4);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        Builder(Comparator<? super E> comparator, int expectedSize) {
            super((byte)0);
            void var2_2;
            void var1_1;
            this.comparator = (Comparator)Preconditions.checkNotNull(var1_1);
            this.elements = new Object[var2_2];
            this.n = 0;
        }

        @Override
        final void copy() {
            this.elements = Arrays.copyOf(this.elements, this.elements.length);
        }

        /*
         * WARNING - void declaration
         */
        private void sortAndDedup() {
            void var1_1;
            if (this.n == 0) {
                return;
            }
            Arrays.sort(this.elements, 0, this.n, this.comparator);
            int unique = 1;
            for (int i = 1; i < this.n; ++i) {
                void var3_3;
                int cmp = this.comparator.compare(this.elements[unique - 1], this.elements[i]);
                if (cmp < 0) {
                    this.elements[unique++] = this.elements[i];
                    continue;
                }
                if (var3_3 > 0) {
                    throw new AssertionError((Object)("Comparator " + this.comparator + " compare method violates its contract"));
                }
            }
            Arrays.fill(this.elements, unique, this.n, null);
            this.n = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Builder<E> add(E element) {
            void var1_1;
            Preconditions.checkNotNull(element);
            this.copyIfNecessary();
            if (this.n == this.elements.length) {
                this.sortAndDedup();
                int newLength = ImmutableCollection.Builder.expandedCapacity(this.n, this.n + 1);
                if (newLength > this.elements.length) {
                    void var2_2;
                    this.elements = Arrays.copyOf(this.elements, (int)var2_2);
                }
            }
            this.elements[this.n++] = var1_1;
            return this;
        }

        public final ImmutableSortedSet<E> build$64ffd814() {
            this.sortAndDedup();
            if (this.n == 0) {
                return ImmutableSortedSet.emptySet(this.comparator);
            }
            this.forceCopy = true;
            return new RegularImmutableSortedSet<E>(ImmutableList.asImmutableList(this.elements, this.n), this.comparator);
        }
    }
}

