/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Ascii;
import com.google.common.base.Equivalence;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.MapMakerInternalMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class MapMaker {
    private boolean useCustomMap;
    private int initialCapacity = -1;
    private int concurrencyLevel = -1;
    private MapMakerInternalMap.Strength keyStrength;
    private MapMakerInternalMap.Strength valueStrength;
    Equivalence<Object> keyEquivalence;

    final int getInitialCapacity() {
        if (this.initialCapacity == -1) {
            return 16;
        }
        return this.initialCapacity;
    }

    final int getConcurrencyLevel() {
        if (this.concurrencyLevel == -1) {
            return 4;
        }
        return this.concurrencyLevel;
    }

    final MapMakerInternalMap.Strength getKeyStrength() {
        return MoreObjects.firstNonNull(this.keyStrength, MapMakerInternalMap.Strength.STRONG$405cd320);
    }

    public final MapMaker weakValues() {
        MapMakerInternalMap.Strength.2 var2_1 = MapMakerInternalMap.Strength.WEAK$405cd320;
        MapMaker mapMaker = this;
        MapMakerInternalMap.Strength strength = mapMaker.valueStrength;
        String string = "Value strength was already set to %s";
        boolean bl = mapMaker.valueStrength == null;
        if (!bl) {
            throw new IllegalStateException(Strings.lenientFormat(string, new Object[]{strength}));
        }
        mapMaker.valueStrength = Preconditions.checkNotNull(var2_1);
        if (var2_1 != MapMakerInternalMap.Strength.STRONG$405cd320) {
            mapMaker.useCustomMap = true;
        }
        return mapMaker;
    }

    final MapMakerInternalMap.Strength getValueStrength() {
        return MoreObjects.firstNonNull(this.valueStrength, MapMakerInternalMap.Strength.STRONG$405cd320);
    }

    public final <K, V> ConcurrentMap<K, V> makeMap() {
        if (!this.useCustomMap) {
            return new ConcurrentHashMap(this.getInitialCapacity(), 0.75f, this.getConcurrencyLevel());
        }
        return MapMakerInternalMap.create(this);
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        MoreObjects.ToStringHelper s = MoreObjects.toStringHelper(this);
        if (this.initialCapacity != -1) {
            s.add("initialCapacity", this.initialCapacity);
        }
        if (this.concurrencyLevel != -1) {
            s.add("concurrencyLevel", this.concurrencyLevel);
        }
        if (this.valueStrength != null) {
            String string;
            block6: {
                Object object = this.valueStrength.toString();
                int n = ((String)object).length();
                for (int i = 0; i < n; ++i) {
                    if (!Ascii.isUpperCase(((String)object).charAt(i))) continue;
                    object = ((String)object).toCharArray();
                    while (i < n) {
                        Object object2 = object[i];
                        if (Ascii.isUpperCase((char)object2)) {
                            object[i] = (char)(object2 ^ 0x20);
                        }
                        ++i;
                    }
                    string = String.valueOf((char[])object);
                    break block6;
                }
                string = object;
            }
            s.add("valueStrength", string);
        }
        return var1_1.toString();
    }
}

