/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Equivalence;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMapEntry;
import com.google.common.collect.MapMaker;
import com.google.common.collect.MapMakerInternalMap$StrongValueEntry;
import com.google.common.primitives.Ints;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;

final class MapMakerInternalMap<K, V, E extends InternalEntry<K, V, E>, S extends Segment<K, V, E, S>>
extends AbstractMap<K, V>
implements Serializable,
ConcurrentMap<K, V> {
    private transient int segmentMask;
    private transient int segmentShift;
    final transient Segment<K, V, E, S>[] segments;
    private int concurrencyLevel;
    final Equivalence<Object> keyEquivalence;
    final transient InternalEntryHelper<K, V, E, S> entryHelper;
    private static WeakValueReference<Object, Object, DummyInternalEntry> UNSET_WEAK_VALUE_REFERENCE$7605ad4f = new WeakValueReference<Object, Object, DummyInternalEntry>(){

        @Override
        public final void clear() {
        }

        @Override
        public final Object get() {
            return null;
        }
    };
    private transient Set<K> keySet$5a95723b;
    private transient Collection<V> values$5036ee31;
    private transient Set<Map.Entry<K, V>> entrySet$5a95723b;

    private MapMakerInternalMap(MapMaker builder, InternalEntryHelper<K, V, E, S> entryHelper) {
        int segmentSize;
        int n;
        int segmentCount;
        this.concurrencyLevel = Math.min(builder.getConcurrencyLevel(), 65536);
        MapMaker mapMaker = builder;
        this.keyEquivalence = MoreObjects.firstNonNull(mapMaker.keyEquivalence, mapMaker.getKeyStrength().defaultEquivalence());
        this.entryHelper = entryHelper;
        int initialCapacity = Math.min(builder.getInitialCapacity(), 0x40000000);
        int segmentShift = 0;
        for (segmentCount = 1; segmentCount < this.concurrencyLevel; segmentCount <<= 1) {
            ++segmentShift;
        }
        this.segmentShift = 32 - segmentShift;
        this.segmentMask = segmentCount - 1;
        int n2 = segmentCount;
        this.segments = new Segment[n2];
        int segmentCapacity = initialCapacity / segmentCount;
        if (segmentCapacity * n < initialCapacity) {
            ++segmentCapacity;
        }
        for (segmentSize = 1; segmentSize < segmentCapacity; segmentSize <<= 1) {
        }
        for (int i = 0; i < this.segments.length; ++i) {
            n = segmentSize;
            MapMakerInternalMap mapMakerInternalMap = this;
            this.segments[i] = mapMakerInternalMap.entryHelper.newSegment(mapMakerInternalMap, n);
        }
    }

    static <K, V> MapMakerInternalMap<K, V, ? extends InternalEntry<K, V, ?>, ?> create(MapMaker builder) {
        if (builder.getKeyStrength() == Strength.STRONG$405cd320 && builder.getValueStrength() == Strength.STRONG$405cd320) {
            return new MapMakerInternalMap(builder, StrongKeyStrongValueEntry.Helper.instance());
        }
        if (builder.getKeyStrength() == Strength.STRONG$405cd320 && builder.getValueStrength() == Strength.WEAK$405cd320) {
            return new MapMakerInternalMap(builder, StrongKeyWeakValueEntry.Helper.instance());
        }
        if (builder.getKeyStrength() == Strength.WEAK$405cd320 && builder.getValueStrength() == Strength.STRONG$405cd320) {
            return new MapMakerInternalMap(builder, WeakKeyStrongValueEntry.Helper.instance());
        }
        if (builder.getKeyStrength() == Strength.WEAK$405cd320 && builder.getValueStrength() == Strength.WEAK$405cd320) {
            MapMaker mapMaker;
            return new MapMakerInternalMap(mapMaker, WeakKeyWeakValueEntry.Helper.instance());
        }
        throw new AssertionError();
    }

    static <K, V, E extends InternalEntry<K, V, E>> WeakValueReference<K, V, E> unsetWeakValueReference() {
        return UNSET_WEAK_VALUE_REFERENCE$7605ad4f;
    }

    /*
     * WARNING - void declaration
     */
    private int hash(Object key) {
        void var1_1;
        int n = this.keyEquivalence.hash(var1_1);
        int n2 = n;
        n2 = n;
        n2 = n + (n2 << 15 ^ 0xFFFFCD7D);
        n2 ^= n2 >>> 10;
        n2 += n2 << 3;
        n2 ^= n2 >>> 6;
        n2 += (n2 << 2) + (n2 << 14);
        return n2 ^ n2 >>> 16;
    }

    /*
     * WARNING - void declaration
     */
    final Segment<K, V, E, S> segmentFor(int hash) {
        void var1_1;
        return this.segments[var1_1 >>> this.segmentShift & this.segmentMask];
    }

    static V getLiveValue(E entry) {
        Object e;
        if (entry.getKey() == null) {
            return null;
        }
        return e.getValue();
    }

    final Equivalence<Object> valueEquivalence() {
        return this.entryHelper.valueStrength().defaultEquivalence();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean isEmpty() {
        int i;
        long sum = 0L;
        Segment<K, V, E, S>[] segments = this.segments;
        for (i = 0; i < segments.length; ++i) {
            if (segments[i].count != 0) {
                return false;
            }
            sum += (long)segments[i].modCount;
        }
        if (sum != 0L) {
            void var1_1;
            for (i = 0; i < segments.length; ++i) {
                if (segments[i].count != 0) {
                    return false;
                }
                sum -= (long)segments[i].modCount;
            }
            return var1_1 == 0L;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int size() {
        void var2_2;
        Segment<K, V, E, S>[] segments = this.segments;
        long sum = 0L;
        for (int i = 0; i < segments.length; ++i) {
            sum += (long)segments[i].count;
        }
        return Ints.saturatedCast((long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V get(Object key) {
        void var2_2;
        void var1_1;
        if (key == null) {
            return null;
        }
        int hash = this.hash(key);
        return this.segmentFor(hash).get(var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean containsKey(Object key) {
        void var2_2;
        void var1_1;
        if (key == null) {
            return false;
        }
        int hash = this.hash(key);
        return this.segmentFor(hash).containsKey(var1_1, (int)var2_2);
    }

    @Override
    public final boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        Segment<K, V, E, S>[] segments = this.segments;
        long last = -1L;
        for (int i = 0; i < 3; ++i) {
            long sum = 0L;
            Segment<K, V, E, S>[] segmentArray = segments;
            int n = segments.length;
            for (int j = 0; j < n; ++j) {
                Segment<K, V, E, S> segment = segmentArray[j];
                int cfr_ignored_0 = segment.count;
                AtomicReferenceArray table = segment.table;
                for (int j2 = 0; j2 < table.length(); ++j2) {
                    for (InternalEntry e = (InternalEntry)table.get(j2); e != null; e = e.getNext()) {
                        InternalEntry v;
                        InternalEntry internalEntry;
                        InternalEntry internalEntry2 = e;
                        Segment<K, V, E, S> segment2 = segment;
                        if (internalEntry2.getKey() == null) {
                            segment2.tryDrainReferenceQueues();
                            internalEntry = null;
                        } else if ((internalEntry2 = internalEntry2.getValue()) == null) {
                            segment2.tryDrainReferenceQueues();
                            internalEntry = null;
                        } else {
                            internalEntry = v = internalEntry2;
                        }
                        if (internalEntry == null || !this.valueEquivalence().equivalent(value, v)) continue;
                        return true;
                    }
                }
                sum += (long)segment.modCount;
            }
            if (sum == last) break;
            last = sum;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V put(K key, V value) {
        void var2_2;
        void var3_3;
        void var1_1;
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(value);
        int hash = this.hash(key);
        return this.segmentFor(hash).put(var1_1, (int)var3_3, var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V putIfAbsent(K key, V value) {
        void var2_2;
        void var3_3;
        void var1_1;
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(value);
        int hash = this.hash(key);
        return this.segmentFor(hash).put(var1_1, (int)var3_3, var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            void var2_2;
            this.put(e.getKey(), var2_2.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V remove(Object key) {
        void var2_2;
        void var1_1;
        if (key == null) {
            return null;
        }
        int hash = this.hash(key);
        return this.segmentFor(hash).remove(var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean remove(Object key, Object value) {
        void var2_2;
        void var3_3;
        void var1_1;
        if (key == null || value == null) {
            return false;
        }
        int hash = this.hash(key);
        return this.segmentFor(hash).remove(var1_1, (int)var3_3, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean replace(K key, V oldValue, V newValue) {
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(newValue);
        if (oldValue == null) {
            return false;
        }
        int hash = this.hash(key);
        return this.segmentFor(hash).replace(var1_1, hash, var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V replace(K key, V value) {
        void var2_2;
        void var3_3;
        void var1_1;
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(value);
        int hash = this.hash(key);
        return this.segmentFor(hash).replace(var1_1, (int)var3_3, var2_2);
    }

    @Override
    public final void clear() {
        Segment<K, V, E, S>[] segmentArray = this.segments;
        int n = this.segments.length;
        for (int i = 0; i < n; ++i) {
            Segment<K, V, E, S> segment = segmentArray[i];
            Segment<K, V, E, S> segment2 = segment;
            segment2 = segment;
            if (segment.count == 0) continue;
            segment2.lock();
            try {
                AtomicReferenceArray atomicReferenceArray = segment2.table;
                for (int j = 0; j < atomicReferenceArray.length(); ++j) {
                    atomicReferenceArray.set(j, null);
                }
                segment2.maybeClearReferenceQueues();
                segment2.readCount.set(0);
                ++segment2.modCount;
                segment2.count = 0;
                continue;
            }
            finally {
                segment2.unlock();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Set<K> keySet() {
        Set<K> ks = this.keySet$5a95723b;
        if (ks != null) {
            void var1_1;
            return var1_1;
        }
        this.keySet$5a95723b = new KeySet(this);
        return this.keySet$5a95723b;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Collection<V> values() {
        Collection<V> vs = this.values$5036ee31;
        if (vs != null) {
            void var1_1;
            return var1_1;
        }
        this.values$5036ee31 = new Values(this);
        return this.values$5036ee31;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> es = this.entrySet$5a95723b;
        if (es != null) {
            void var1_1;
            return var1_1;
        }
        this.entrySet$5a95723b = new EntrySet(this);
        return this.entrySet$5a95723b;
    }

    static interface InternalEntryHelper<K, V, E extends InternalEntry<K, V, E>, S extends Segment<K, V, E, S>> {
        public Strength valueStrength();

        public S newSegment(MapMakerInternalMap<K, V, E, S> var1, int var2);

        public E newEntry(S var1, K var2, int var3, E var4);

        public E copy(S var1, E var2, E var3);

        public void setValue(S var1, E var2, V var3);
    }

    static abstract class Segment<K, V, E extends InternalEntry<K, V, E>, S extends Segment<K, V, E, S>>
    extends ReentrantLock {
        private MapMakerInternalMap<K, V, E, S> map;
        volatile int count;
        int modCount;
        private int threshold;
        volatile AtomicReferenceArray<E> table;
        final AtomicInteger readCount = new AtomicInteger();

        /*
         * WARNING - void declaration
         */
        Segment(MapMakerInternalMap<K, V, E, S> map, int initialCapacity) {
            void var2_2;
            Segment segment;
            this.map = segment;
            AtomicReferenceArray<E> atomicReferenceArray = Segment.newEntryArray((int)var2_2);
            segment = this;
            this.threshold = atomicReferenceArray.length() * 3 / 4;
            segment.table = atomicReferenceArray;
        }

        abstract S self();

        void maybeDrainReferenceQueues() {
        }

        void maybeClearReferenceQueues() {
        }

        /*
         * WARNING - void declaration
         */
        private void setValue(E entry, V value) {
            void var2_2;
            void var1_1;
            this.map.entryHelper.setValue(this.self(), var1_1, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        private E copyEntry(E original, E newNext) {
            void var2_2;
            void var1_1;
            return this.map.entryHelper.copy(this.self(), var1_1, var2_2);
        }

        private static AtomicReferenceArray<E> newEntryArray(int size) {
            int n;
            return new AtomicReferenceArray(n);
        }

        final void tryDrainReferenceQueues() {
            if (this.tryLock()) {
                try {
                    this.maybeDrainReferenceQueues();
                    return;
                }
                finally {
                    this.unlock();
                }
            }
        }

        final void drainKeyReferenceQueue(ReferenceQueue<K> keyReferenceQueue) {
            Reference<K> ref;
            int i = 0;
            while ((ref = keyReferenceQueue.poll()) != null) {
                MapMakerInternalMap<K, V, E, S> mapMakerInternalMap;
                InternalEntry entry = (InternalEntry)((Object)ref);
                void var4_4 = mapMakerInternalMap;
                mapMakerInternalMap = this.map;
                int n = var4_4.getHash();
                mapMakerInternalMap.segmentFor(n).reclaimKey(var4_4, n);
                if (++i != 16) continue;
            }
        }

        final void drainValueReferenceQueue(ReferenceQueue<V> valueReferenceQueue) {
            Reference<V> ref;
            int i = 0;
            while ((ref = valueReferenceQueue.poll()) != null) {
                MapMakerInternalMap<K, V, E, S> mapMakerInternalMap;
                WeakValueReference valueReference = (WeakValueReference)((Object)ref);
                void var4_4 = mapMakerInternalMap;
                mapMakerInternalMap = this.map;
                Object e = var4_4.getEntry();
                int n = e.getHash();
                mapMakerInternalMap.segmentFor(n).reclaimValue((K)e.getKey(), n, (WeakValueReference<K, V, E>)var4_4);
                if (++i != 16) continue;
            }
        }

        static <T> void clearReferenceQueue(ReferenceQueue<T> referenceQueue) {
            while (referenceQueue.poll() != null) {
            }
        }

        private E getEntry(Object key, int hash) {
            if (this.count != 0) {
                int n = hash;
                Serializable serializable = this;
                serializable = ((Segment)serializable).table;
                for (InternalEntry e = (InternalEntry)((AtomicReferenceArray)serializable).get(n & ((AtomicReferenceArray)serializable).length() - 1); e != null; e = e.getNext()) {
                    if (e.getHash() != hash) continue;
                    Object entryKey = e.getKey();
                    if (entryKey == null) {
                        this.tryDrainReferenceQueues();
                        continue;
                    }
                    if (!this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    return (E)e;
                }
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        final V get(Object key, int hash) {
            try {
                void var1_1;
                void var2_3;
                void var3_5 = var2_3;
                Object object = key;
                key = this;
                E e = ((Segment)key).getEntry(object, (int)var3_5);
                if (e == null) {
                    return null;
                }
                Object value = e.getValue();
                if (value == null) {
                    this.tryDrainReferenceQueues();
                }
                return var1_1;
            }
            finally {
                this.postReadCleanup();
            }
        }

        /*
         * WARNING - void declaration
         */
        final boolean containsKey(Object key, int hash) {
            try {
                if (this.count != 0) {
                    void var1_1;
                    void var2_4;
                    key = this;
                    Object object = key;
                    void var3_6 = var2_4;
                    E e = ((Segment)key).getEntry(object, (int)var3_6);
                    boolean bl = e != null && var1_1.getValue() != null;
                    return bl;
                }
                return false;
            }
            finally {
                this.postReadCleanup();
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        final V put(K key, int hash, V value, boolean onlyIfAbsent) {
            block16: {
                block17: {
                    this.lock();
                    var5_6 = this;
                    var5_6.runLockedCleanup();
                    newCount = this.count + 1;
                    if (newCount > this.threshold) {
                        newCount = this;
                        var6_9 = newCount.table;
                        var7_10 = var6_9.length();
                        if (var7_10 < 0x40000000) {
                            var8_11 = newCount.count;
                            var9_13 = Segment.newEntryArray(var7_10 << 1);
                            newCount.threshold = var9_13.length() * 3 / 4;
                            var10_14 = var9_13.length() - 1;
                            for (var11_16 = 0; var11_16 < var7_10; ++var11_16) {
                                var12_17 = (InternalEntry)var6_9.get(var11_16);
                                if (var12_17 == null) continue;
                                var13_18 /* !! */  = var12_17.getNext();
                                var14_19 = var12_17.getHash() & var10_14;
                                if (var13_18 /* !! */  == null) {
                                    var9_13.set(var14_19, var12_17);
                                    continue;
                                }
                                var15_20 = var12_17;
                                while (var13_18 /* !! */  != null) {
                                    var16_21 = var13_18 /* !! */ .getHash() & var10_14;
                                    if (var16_21 != var14_19) {
                                        var14_19 = var16_21;
                                        var15_20 = var13_18 /* !! */ ;
                                    }
                                    var13_18 /* !! */  = var13_18 /* !! */ .getNext();
                                }
                                var9_13.set(var14_19, (InternalEntry)var15_20);
                                for (var13_18 /* !! */  = var12_17; var13_18 /* !! */  != var15_20; var13_18 /* !! */  = var13_18 /* !! */ .getNext()) {
                                    var16_21 = var13_18 /* !! */ .getHash() & var10_14;
                                    var12_17 = (InternalEntry)var9_13.get(var16_21);
                                    if ((var12_17 = newCount.copyEntry(var13_18 /* !! */ , var12_17)) != null) {
                                        var9_13.set(var16_21, var12_17);
                                        continue;
                                    }
                                    --var8_11;
                                }
                            }
                            newCount.table = var9_13;
                            newCount.count = var8_11;
                        }
                        newCount = this.count + 1;
                    }
                    table = this.table;
                    index = hash & table.length() - 1;
                    first = (InternalEntry)table.get(index);
                    e = first;
lbl48:
                    // 2 sources

                    while (e != null) {
                        entryKey = e.getKey();
                        if (e.getHash() == hash && entryKey != null && this.map.keyEquivalence.equivalent(key, entryKey)) {
                            entryValue = e.getValue();
                            if (entryValue != null) break block16;
                            ++this.modCount;
                            this.setValue(e, value);
                            this.count = newCount = this.count;
                            break block17;
                        }
                        ** GOTO lbl-1000
                    }
                    ** GOTO lbl74
                }
                this.unlock();
                return null;
            }
            if (onlyIfAbsent) {
                this.unlock();
                return entryValue;
            }
            ** try [egrp 1[TRYBLOCK] [1 : 458->477)] { 
lbl69:
            // 1 sources

            ++this.modCount;
            this.setValue(e, value);
            return var1_1;
lbl-1000:
            // 1 sources

            {
                e = e.getNext();
                ** GOTO lbl48
lbl74:
                // 1 sources

                ++this.modCount;
                newEntry = this.map.entryHelper.newEntry(this.self(), var1_1, (int)var2_3, first);
                this.setValue(newEntry, var3_4);
                table.set(index, newEntry);
                this.count = newCount;
            }
            this.unlock();
            return null;
lbl81:
            // 1 sources

            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - void declaration
         */
        final boolean replace(K key, int hash, V oldValue, V newValue) {
            this.lock();
            try {
                Segment segment = this;
                segment.runLockedCleanup();
                AtomicReferenceArray<void> table = this.table;
                int index = hash & table.length() - 1;
                InternalEntry first = (InternalEntry)table.get(index);
                for (InternalEntry e = first; e != null; e = e.getNext()) {
                    void var1_1;
                    Object entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    Object entryValue = e.getValue();
                    if (entryValue == null) {
                        if (Segment.isCollected(e)) {
                            void var1_2;
                            void var2_5;
                            ++this.modCount;
                            InternalEntry newFirst = this.removeFromChain(first, e);
                            int newCount = this.count - 1;
                            table.set(index, var2_5);
                            this.count = var1_2;
                        }
                        return false;
                    }
                    if (this.map.valueEquivalence().equivalent(oldValue, var1_1)) {
                        ++this.modCount;
                        this.setValue(e, newValue);
                        return true;
                    }
                    return false;
                }
                return false;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - void declaration
         */
        final V replace(K key, int hash, V newValue) {
            this.lock();
            try {
                Segment segment = this;
                segment.runLockedCleanup();
                AtomicReferenceArray<void> table = this.table;
                int index = hash & table.length() - 1;
                InternalEntry first = (InternalEntry)table.get(index);
                for (InternalEntry e = first; e != null; e = e.getNext()) {
                    void var1_1;
                    Object entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    Object entryValue = e.getValue();
                    if (entryValue == null) {
                        if (Segment.isCollected(e)) {
                            void var1_2;
                            void var2_5;
                            ++this.modCount;
                            InternalEntry newFirst = this.removeFromChain(first, e);
                            int newCount = this.count - 1;
                            table.set(index, var2_5);
                            this.count = var1_2;
                        }
                        return null;
                    }
                    ++this.modCount;
                    this.setValue(e, newValue);
                    return var1_1;
                }
                return null;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - void declaration
         */
        final V remove(Object key, int hash) {
            this.lock();
            try {
                Segment segment = this;
                segment.runLockedCleanup();
                AtomicReferenceArray table = this.table;
                int index = hash & table.length() - 1;
                InternalEntry first = (InternalEntry)table.get(index);
                for (InternalEntry e = first; e != null; e = e.getNext()) {
                    void var2_6;
                    void var1_2;
                    Object entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    Object entryValue = e.getValue();
                    if (entryValue == null && !Segment.isCollected(e)) {
                        return null;
                    }
                    ++this.modCount;
                    InternalEntry newFirst = this.removeFromChain(first, e);
                    int newCount = this.count - 1;
                    table.set(index, newFirst);
                    this.count = var1_2;
                    void var1_3 = var2_6;
                    return var1_3;
                }
                return null;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - void declaration
         */
        final boolean remove(Object key, int hash, Object value) {
            this.lock();
            try {
                Segment segment = this;
                segment.runLockedCleanup();
                AtomicReferenceArray<void> table = this.table;
                int index = hash & table.length() - 1;
                InternalEntry first = (InternalEntry)table.get(index);
                for (InternalEntry e = first; e != null; e = e.getNext()) {
                    void var2_4;
                    void var1_2;
                    void var3_5;
                    Object entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    Object entryValue = e.getValue();
                    boolean explicitRemoval = false;
                    if (this.map.valueEquivalence().equivalent(value, entryValue)) {
                        explicitRemoval = true;
                    } else if (!Segment.isCollected(e)) {
                        return false;
                    }
                    ++this.modCount;
                    InternalEntry newFirst = this.removeFromChain(first, e);
                    int newCount = this.count - 1;
                    table.set(index, var3_5);
                    this.count = var1_2;
                    var1_2 = var2_4;
                    return (boolean)var1_2;
                }
                return false;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - void declaration
         */
        private E removeFromChain(E first, E entry) {
            void var3_3;
            Object e;
            int newCount = this.count;
            Object newFirst = entry.getNext();
            while (e != entry) {
                void next = this.copyEntry(e, newFirst);
                if (next != null) {
                    newFirst = next;
                } else {
                    --newCount;
                }
                e = e.getNext();
            }
            this.count = var3_3;
            return newFirst;
        }

        /*
         * WARNING - void declaration
         */
        final boolean reclaimKey(E entry, int hash) {
            this.lock();
            try {
                InternalEntry first;
                AtomicReferenceArray<InternalEntry> table = this.table;
                int index = hash & table.length() - 1;
                for (InternalEntry e = first = (InternalEntry)table.get(index); e != null; e = e.getNext()) {
                    void var1_2;
                    if (e != entry) continue;
                    ++this.modCount;
                    InternalEntry newFirst = this.removeFromChain(first, e);
                    int newCount = this.count - 1;
                    table.set(index, newFirst);
                    this.count = var1_2;
                    return true;
                }
                return false;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - void declaration
         */
        final boolean reclaimValue(K key, int hash, WeakValueReference<K, V, E> valueReference) {
            this.lock();
            try {
                InternalEntry first;
                AtomicReferenceArray<void> table = this.table;
                int index = hash & table.length() - 1;
                for (InternalEntry e = first = (InternalEntry)table.get(index); e != null; e = e.getNext()) {
                    Object entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    key = ((WeakValueEntry)e).getValueReference();
                    if (key == valueReference) {
                        void var1_2;
                        void var2_5;
                        ++this.modCount;
                        InternalEntry newFirst = this.removeFromChain(first, e);
                        int newCount = this.count - 1;
                        table.set(index, var2_5);
                        this.count = var1_2;
                        return true;
                    }
                    return false;
                }
                return false;
            }
            finally {
                this.unlock();
            }
        }

        static <K, V, E extends InternalEntry<K, V, E>> boolean isCollected(E entry) {
            return entry.getValue() == null;
        }

        final void postReadCleanup() {
            if ((this.readCount.incrementAndGet() & 0x3F) == 0) {
                Segment segment = this;
                segment.runLockedCleanup();
            }
        }

        private void runLockedCleanup() {
            if (this.tryLock()) {
                try {
                    this.maybeDrainReferenceQueues();
                    this.readCount.set(0);
                    return;
                }
                finally {
                    this.unlock();
                }
            }
        }
    }

    static abstract class Strength
    extends Enum<Strength> {
        public static final /* enum */ 1 STRONG$405cd320 = new Strength(){

            @Override
            final Equivalence<Object> defaultEquivalence() {
                return Equivalence.equals$1d3fc346();
            }
        };
        public static final /* enum */ 2 WEAK$405cd320 = new Strength(){

            @Override
            final Equivalence<Object> defaultEquivalence() {
                return Equivalence.identity$1d3fc346();
            }
        };

        private Strength() {
        }

        abstract Equivalence<Object> defaultEquivalence();

        /*
         * WARNING - void declaration
         */
        /* synthetic */ Strength(String x0, int x1, byte by) {
            this();
            void var2_2;
            void var1_1;
        }

        static {
            Strength[] strengthArray = new Strength[]{STRONG$405cd320, WEAK$405cd320};
        }
    }

    static class StrongKeyStrongValueEntry<K, V>
    extends AbstractStrongKeyEntry<K, V, StrongKeyStrongValueEntry<K, V>>
    implements MapMakerInternalMap$StrongValueEntry<K, V, StrongKeyStrongValueEntry<K, V>> {
        private volatile V value = null;

        /*
         * WARNING - void declaration
         */
        private StrongKeyStrongValueEntry(K key, int hash) {
            super(var1_1, (int)var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ StrongKeyStrongValueEntry(Object x0, int x1, byte by) {
            this(var1_1, (int)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ Object access$202(StrongKeyStrongValueEntry x0, Object x1) {
            void var1_1;
            x0.value = var1_1;
            return x0.value;
        }

        static final class Helper<K, V>
        implements InternalEntryHelper<K, V, StrongKeyStrongValueEntry<K, V>, StrongKeyStrongValueSegment<K, V>> {
            private static final Helper<?, ?> INSTANCE = new Helper();

            Helper() {
            }

            static <K, V> Helper<K, V> instance() {
                return INSTANCE;
            }

            @Override
            public final Strength valueStrength() {
                return Strength.STRONG$405cd320;
            }

            /*
             * WARNING - void declaration
             */
            private static StrongKeyStrongValueEntry<K, V> newEntry$39f94e60(K key, int hash, StrongKeyStrongValueEntry<K, V> next) {
                void var2_2;
                void var1_1;
                Object k;
                if (next == null) {
                    return new StrongKeyStrongValueEntry(key, hash, 0);
                }
                return new LinkedStrongKeyStrongValueEntry(k, (int)var1_1, var2_2);
            }
        }

        private static final class LinkedStrongKeyStrongValueEntry<K, V>
        extends StrongKeyStrongValueEntry<K, V> {
            private final StrongKeyStrongValueEntry<K, V> next;

            /*
             * WARNING - void declaration
             */
            LinkedStrongKeyStrongValueEntry(K key, int hash, StrongKeyStrongValueEntry<K, V> next) {
                super(var1_1, (int)var2_2, (byte)0);
                void var3_3;
                void var2_2;
                void var1_1;
                this.next = var3_3;
            }
        }
    }

    static class StrongKeyWeakValueEntry<K, V>
    extends AbstractStrongKeyEntry<K, V, StrongKeyWeakValueEntry<K, V>>
    implements WeakValueEntry<K, V, StrongKeyWeakValueEntry<K, V>> {
        private volatile WeakValueReference<K, V, StrongKeyWeakValueEntry<K, V>> valueReference = MapMakerInternalMap.unsetWeakValueReference();

        /*
         * WARNING - void declaration
         */
        private StrongKeyWeakValueEntry(K key, int hash) {
            super(var1_1, (int)var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        public final V getValue() {
            return this.valueReference.get();
        }

        @Override
        public final WeakValueReference<K, V, StrongKeyWeakValueEntry<K, V>> getValueReference() {
            return this.valueReference;
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ StrongKeyWeakValueEntry(Object x0, int x1, byte by) {
            this(var1_1, (int)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ WeakValueReference access$402(StrongKeyWeakValueEntry x0, WeakValueReference x1) {
            void var1_1;
            x0.valueReference = var1_1;
            return x0.valueReference;
        }

        static final class Helper<K, V>
        implements InternalEntryHelper<K, V, StrongKeyWeakValueEntry<K, V>, StrongKeyWeakValueSegment<K, V>> {
            private static final Helper<?, ?> INSTANCE = new Helper();

            Helper() {
            }

            static <K, V> Helper<K, V> instance() {
                return INSTANCE;
            }

            @Override
            public final Strength valueStrength() {
                return Strength.WEAK$405cd320;
            }

            /*
             * WARNING - void declaration
             */
            private static StrongKeyWeakValueEntry<K, V> newEntry$2126e9d(K key, int hash, StrongKeyWeakValueEntry<K, V> next) {
                void var2_2;
                void var1_1;
                Object k;
                if (next == null) {
                    return new StrongKeyWeakValueEntry(key, hash, 0);
                }
                return new LinkedStrongKeyWeakValueEntry(k, (int)var1_1, var2_2);
            }
        }

        private static final class LinkedStrongKeyWeakValueEntry<K, V>
        extends StrongKeyWeakValueEntry<K, V> {
            private final StrongKeyWeakValueEntry<K, V> next;

            /*
             * WARNING - void declaration
             */
            LinkedStrongKeyWeakValueEntry(K key, int hash, StrongKeyWeakValueEntry<K, V> next) {
                super(var1_1, (int)var2_2, (byte)0);
                void var3_3;
                void var2_2;
                void var1_1;
                this.next = var3_3;
            }
        }
    }

    static class WeakKeyStrongValueEntry<K, V>
    extends AbstractWeakKeyEntry<K, V, WeakKeyStrongValueEntry<K, V>>
    implements MapMakerInternalMap$StrongValueEntry<K, V, WeakKeyStrongValueEntry<K, V>> {
        private volatile V value = null;

        /*
         * WARNING - void declaration
         */
        private WeakKeyStrongValueEntry(ReferenceQueue<K> queue, K key, int hash) {
            super(var1_1, var2_2, (int)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ WeakKeyStrongValueEntry(ReferenceQueue x0, Object x1, int x2, byte by) {
            this((ReferenceQueue<void>)var1_1, var2_2, (int)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ Object access$1102(WeakKeyStrongValueEntry x0, Object x1) {
            void var1_1;
            x0.value = var1_1;
            return x0.value;
        }

        static final class Helper<K, V>
        implements InternalEntryHelper<K, V, WeakKeyStrongValueEntry<K, V>, WeakKeyStrongValueSegment<K, V>> {
            private static final Helper<?, ?> INSTANCE = new Helper();

            Helper() {
            }

            static <K, V> Helper<K, V> instance() {
                return INSTANCE;
            }

            @Override
            public final Strength valueStrength() {
                return Strength.STRONG$405cd320;
            }

            /*
             * WARNING - void declaration
             */
            private static WeakKeyStrongValueEntry<K, V> newEntry(WeakKeyStrongValueSegment<K, V> segment, K key, int hash, WeakKeyStrongValueEntry<K, V> next) {
                void var3_3;
                void var2_2;
                void var1_1;
                WeakKeyStrongValueSegment weakKeyStrongValueSegment;
                if (next == null) {
                    return new WeakKeyStrongValueEntry(segment.queueForKeys, key, hash, 0);
                }
                return new LinkedWeakKeyStrongValueEntry(weakKeyStrongValueSegment.queueForKeys, var1_1, (int)var2_2, (WeakKeyStrongValueEntry)var3_3, 0);
            }
        }

        private static final class LinkedWeakKeyStrongValueEntry<K, V>
        extends WeakKeyStrongValueEntry<K, V> {
            private final WeakKeyStrongValueEntry<K, V> next;

            /*
             * WARNING - void declaration
             */
            private LinkedWeakKeyStrongValueEntry(ReferenceQueue<K> queue, K key, int hash, WeakKeyStrongValueEntry<K, V> next) {
                super((ReferenceQueue)var1_1, var2_2, (int)var3_3, (byte)0);
                void var3_3;
                void var2_2;
                void var1_1;
                this.next = next;
            }

            /*
             * WARNING - void declaration
             */
            /* synthetic */ LinkedWeakKeyStrongValueEntry(ReferenceQueue x0, Object x1, int x2, WeakKeyStrongValueEntry x3, byte by) {
                this((ReferenceQueue<void>)var1_1, var2_2, (int)var3_3, x3);
                void var3_3;
                void var2_2;
                void var1_1;
            }
        }
    }

    static class WeakKeyWeakValueEntry<K, V>
    extends AbstractWeakKeyEntry<K, V, WeakKeyWeakValueEntry<K, V>>
    implements WeakValueEntry<K, V, WeakKeyWeakValueEntry<K, V>> {
        private volatile WeakValueReference<K, V, WeakKeyWeakValueEntry<K, V>> valueReference = MapMakerInternalMap.unsetWeakValueReference();

        /*
         * WARNING - void declaration
         */
        WeakKeyWeakValueEntry(ReferenceQueue<K> queue, K key, int hash) {
            super(var1_1, var2_2, (int)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        @Override
        public final V getValue() {
            return this.valueReference.get();
        }

        @Override
        public final WeakValueReference<K, V, WeakKeyWeakValueEntry<K, V>> getValueReference() {
            return this.valueReference;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ WeakValueReference access$1402(WeakKeyWeakValueEntry x0, WeakValueReference x1) {
            void var1_1;
            x0.valueReference = var1_1;
            return x0.valueReference;
        }

        static final class Helper<K, V>
        implements InternalEntryHelper<K, V, WeakKeyWeakValueEntry<K, V>, WeakKeyWeakValueSegment<K, V>> {
            private static final Helper<?, ?> INSTANCE = new Helper();

            Helper() {
            }

            static <K, V> Helper<K, V> instance() {
                return INSTANCE;
            }

            @Override
            public final Strength valueStrength() {
                return Strength.WEAK$405cd320;
            }

            /*
             * WARNING - void declaration
             */
            private static WeakKeyWeakValueEntry<K, V> newEntry(WeakKeyWeakValueSegment<K, V> segment, K key, int hash, WeakKeyWeakValueEntry<K, V> next) {
                void var3_3;
                void var2_2;
                void var1_1;
                WeakKeyWeakValueSegment weakKeyWeakValueSegment;
                if (next == null) {
                    return new WeakKeyWeakValueEntry(segment.queueForKeys, key, hash);
                }
                return new LinkedWeakKeyWeakValueEntry(weakKeyWeakValueSegment.queueForKeys, var1_1, (int)var2_2, var3_3);
            }
        }

        private static final class LinkedWeakKeyWeakValueEntry<K, V>
        extends WeakKeyWeakValueEntry<K, V> {
            private final WeakKeyWeakValueEntry<K, V> next;

            /*
             * WARNING - void declaration
             */
            LinkedWeakKeyWeakValueEntry(ReferenceQueue<K> queue, K key, int hash, WeakKeyWeakValueEntry<K, V> next) {
                super(var1_1, var2_2, (int)var3_3);
                void var3_3;
                void var2_2;
                void var1_1;
                this.next = next;
            }
        }
    }

    static interface WeakValueReference<K, V, E extends InternalEntry<K, V, E>> {
        public V get();

        public E getEntry();

        public void clear();

        public WeakValueReference<K, V, E> copyFor$7f1cb107(ReferenceQueue<V> var1, E var2);
    }

    static interface InternalEntry<K, V, E extends InternalEntry<K, V, E>> {
        public E getNext();

        public int getHash();

        public K getKey();

        public V getValue();
    }

    final class KeySet
    extends AbstractSet<K> {
        private /* synthetic */ MapMakerInternalMap this$0;

        /*
         * WARNING - void declaration
         */
        KeySet(MapMakerInternalMap this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public final Iterator<K> iterator() {
            return new KeyIterator(this.this$0);
        }

        @Override
        public final int size() {
            return this.this$0.size();
        }

        @Override
        public final boolean isEmpty() {
            return this.this$0.isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(Object o) {
            void var1_1;
            return this.this$0.containsKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean remove(Object o) {
            void var1_1;
            return this.this$0.remove(var1_1) != null;
        }

        @Override
        public final void clear() {
            this.this$0.clear();
        }
    }

    final class Values
    extends AbstractCollection<V> {
        private /* synthetic */ MapMakerInternalMap this$0;

        /*
         * WARNING - void declaration
         */
        Values(MapMakerInternalMap this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public final Iterator<V> iterator() {
            return new ValueIterator(this.this$0);
        }

        @Override
        public final int size() {
            return this.this$0.size();
        }

        @Override
        public final boolean isEmpty() {
            return this.this$0.isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(Object o) {
            void var1_1;
            return this.this$0.containsValue(var1_1);
        }

        @Override
        public final void clear() {
            this.this$0.clear();
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private /* synthetic */ MapMakerInternalMap this$0;

        /*
         * WARNING - void declaration
         */
        EntrySet(MapMakerInternalMap this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public final Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(this.this$0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(Object o) {
            void var2_2;
            void var1_1;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null) {
                return false;
            }
            Object v = this.this$0.get(key);
            return v != null && this.this$0.valueEquivalence().equivalent(var1_1.getValue(), var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean remove(Object o) {
            void var1_1;
            void var2_2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            return key != null && this.this$0.remove(var2_2, var1_1.getValue());
        }

        @Override
        public final int size() {
            return this.this$0.size();
        }

        @Override
        public final boolean isEmpty() {
            return this.this$0.isEmpty();
        }

        @Override
        public final void clear() {
            this.this$0.clear();
        }
    }

    final class EntryIterator
    extends HashIterator<Map.Entry<K, V>> {
        private /* synthetic */ MapMakerInternalMap this$0;

        /*
         * WARNING - void declaration
         */
        EntryIterator(MapMakerInternalMap this$0) {
            void var1_1;
            this.this$0 = this$0;
            super((MapMakerInternalMap)var1_1);
        }
    }

    final class WriteThroughEntry
    extends AbstractMapEntry<K, V> {
        private K key;
        private V value;
        private /* synthetic */ MapMakerInternalMap this$0;

        /*
         * WARNING - void declaration
         */
        WriteThroughEntry(MapMakerInternalMap this$0, K key, V value) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.key = var2_2;
            this.value = var3_3;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(Object object) {
            if (object instanceof Map.Entry) {
                void var1_1;
                Map.Entry that = (Map.Entry)object;
                return this.key.equals(that.getKey()) && this.value.equals(var1_1.getValue());
            }
            return false;
        }

        @Override
        public final int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final V setValue(V newValue) {
            void var2_2;
            void var1_1;
            Object oldValue = this.this$0.put(this.key, newValue);
            this.value = var1_1;
            return var2_2;
        }
    }

    final class ValueIterator
    extends HashIterator<V> {
        private /* synthetic */ MapMakerInternalMap this$0;

        /*
         * WARNING - void declaration
         */
        ValueIterator(MapMakerInternalMap this$0) {
            void var1_1;
            this.this$0 = this$0;
            super((MapMakerInternalMap)var1_1);
        }

        @Override
        public final V next() {
            return this.nextEntry().getValue();
        }
    }

    final class KeyIterator
    extends HashIterator<K> {
        private /* synthetic */ MapMakerInternalMap this$0;

        /*
         * WARNING - void declaration
         */
        KeyIterator(MapMakerInternalMap this$0) {
            void var1_1;
            this.this$0 = this$0;
            super((MapMakerInternalMap)var1_1);
        }

        @Override
        public final K next() {
            return this.nextEntry().getKey();
        }
    }

    abstract class HashIterator<T>
    implements Iterator<T> {
        private int nextSegmentIndex;
        private int nextTableIndex;
        private Segment<K, V, E, S> currentSegment;
        private AtomicReferenceArray<E> currentTable;
        private E nextEntry;
        private WriteThroughEntry nextExternal;
        private WriteThroughEntry lastReturned;
        private /* synthetic */ MapMakerInternalMap this$0;

        /*
         * WARNING - void declaration
         */
        HashIterator(MapMakerInternalMap this$0) {
            void var1_1;
            this.this$0 = this$0;
            this.nextSegmentIndex = var1_1.segments.length - 1;
            this.nextTableIndex = -1;
            this.advance();
        }

        private void advance() {
            this.nextExternal = null;
            if (this.nextInChain()) {
                return;
            }
            if (this.nextInTable()) {
                return;
            }
            while (this.nextSegmentIndex >= 0) {
                this.currentSegment = this.this$0.segments[this.nextSegmentIndex--];
                if (this.currentSegment.count == 0) continue;
                this.currentTable = this.currentSegment.table;
                this.nextTableIndex = this.currentTable.length() - 1;
                if (!this.nextInTable()) continue;
                return;
            }
        }

        private boolean nextInChain() {
            if (this.nextEntry != null) {
                this.nextEntry = this.nextEntry.getNext();
                while (this.nextEntry != null) {
                    HashIterator hashIterator = this;
                    if (hashIterator.advanceTo(hashIterator.nextEntry)) {
                        return true;
                    }
                    this.nextEntry = this.nextEntry.getNext();
                }
            }
            return false;
        }

        private boolean nextInTable() {
            while (this.nextTableIndex >= 0) {
                if ((this.nextEntry = (InternalEntry)this.currentTable.get(this.nextTableIndex--)) == null) continue;
                HashIterator hashIterator = this;
                if (!hashIterator.advanceTo(hashIterator.nextEntry) && !this.nextInChain()) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private boolean advanceTo(E entry) {
            try {
                Object key = entry.getKey();
                Object value = MapMakerInternalMap.getLiveValue(entry);
                if (value != null) {
                    void var1_1;
                    void var2_3;
                    this.nextExternal = new WriteThroughEntry(this.this$0, var2_3, var1_1);
                    return true;
                }
                return false;
            }
            finally {
                this.currentSegment.postReadCleanup();
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextExternal != null;
        }

        final WriteThroughEntry nextEntry() {
            if (this.nextExternal == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextExternal;
            this.advance();
            return this.lastReturned;
        }

        @Override
        public void remove() {
            boolean bl = this.lastReturned != null;
            Preconditions.checkState(bl, "no calls to next() since the last call to remove()");
            this.this$0.remove(this.lastReturned.getKey());
            this.lastReturned = null;
        }
    }

    static final class WeakKeyWeakValueSegment<K, V>
    extends Segment<K, V, WeakKeyWeakValueEntry<K, V>, WeakKeyWeakValueSegment<K, V>> {
        private final ReferenceQueue<K> queueForKeys = new ReferenceQueue();
        private final ReferenceQueue<V> queueForValues = new ReferenceQueue();

        /*
         * WARNING - void declaration
         */
        WeakKeyWeakValueSegment(MapMakerInternalMap<K, V, WeakKeyWeakValueEntry<K, V>, WeakKeyWeakValueSegment<K, V>> map, int initialCapacity) {
            super(var1_1, (int)var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        final void maybeDrainReferenceQueues() {
            WeakKeyWeakValueSegment weakKeyWeakValueSegment = this;
            weakKeyWeakValueSegment.drainKeyReferenceQueue(weakKeyWeakValueSegment.queueForKeys);
            WeakKeyWeakValueSegment weakKeyWeakValueSegment2 = this;
            weakKeyWeakValueSegment2.drainValueReferenceQueue(weakKeyWeakValueSegment2.queueForValues);
        }

        @Override
        final void maybeClearReferenceQueues() {
            WeakKeyWeakValueSegment.clearReferenceQueue(this.queueForKeys);
        }
    }

    static final class WeakKeyStrongValueSegment<K, V>
    extends Segment<K, V, WeakKeyStrongValueEntry<K, V>, WeakKeyStrongValueSegment<K, V>> {
        private final ReferenceQueue<K> queueForKeys = new ReferenceQueue();

        /*
         * WARNING - void declaration
         */
        WeakKeyStrongValueSegment(MapMakerInternalMap<K, V, WeakKeyStrongValueEntry<K, V>, WeakKeyStrongValueSegment<K, V>> map, int initialCapacity) {
            super(var1_1, (int)var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        final void maybeDrainReferenceQueues() {
            WeakKeyStrongValueSegment weakKeyStrongValueSegment = this;
            weakKeyStrongValueSegment.drainKeyReferenceQueue(weakKeyStrongValueSegment.queueForKeys);
        }

        @Override
        final void maybeClearReferenceQueues() {
            WeakKeyStrongValueSegment.clearReferenceQueue(this.queueForKeys);
        }
    }

    static final class StrongKeyWeakValueSegment<K, V>
    extends Segment<K, V, StrongKeyWeakValueEntry<K, V>, StrongKeyWeakValueSegment<K, V>> {
        private final ReferenceQueue<V> queueForValues = new ReferenceQueue();

        /*
         * WARNING - void declaration
         */
        StrongKeyWeakValueSegment(MapMakerInternalMap<K, V, StrongKeyWeakValueEntry<K, V>, StrongKeyWeakValueSegment<K, V>> map, int initialCapacity) {
            super(var1_1, (int)var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        final void maybeDrainReferenceQueues() {
            StrongKeyWeakValueSegment strongKeyWeakValueSegment = this;
            strongKeyWeakValueSegment.drainValueReferenceQueue(strongKeyWeakValueSegment.queueForValues);
        }

        @Override
        final void maybeClearReferenceQueues() {
            StrongKeyWeakValueSegment.clearReferenceQueue(this.queueForValues);
        }
    }

    static final class StrongKeyStrongValueSegment<K, V>
    extends Segment<K, V, StrongKeyStrongValueEntry<K, V>, StrongKeyStrongValueSegment<K, V>> {
        /*
         * WARNING - void declaration
         */
        StrongKeyStrongValueSegment(MapMakerInternalMap<K, V, StrongKeyStrongValueEntry<K, V>, StrongKeyStrongValueSegment<K, V>> map, int initialCapacity) {
            super(var1_1, (int)var2_2);
            void var2_2;
            void var1_1;
        }
    }

    static final class WeakValueReferenceImpl<K, V, E extends InternalEntry<K, V, E>>
    extends WeakReference<V>
    implements WeakValueReference<K, V, E> {
        private E entry;

        /*
         * WARNING - void declaration
         */
        WeakValueReferenceImpl(ReferenceQueue<V> queue, V referent, E entry) {
            super(var2_2, var1_1);
            void var3_3;
            void var1_1;
            void var2_2;
            this.entry = var3_3;
        }

        @Override
        public final E getEntry() {
            return this.entry;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final WeakValueReference<K, V, E> copyFor$7f1cb107(ReferenceQueue<V> queue, E entry) {
            void var2_2;
            void var1_1;
            return new WeakValueReferenceImpl(var1_1, this.get(), var2_2);
        }
    }

    static final class DummyInternalEntry
    implements InternalEntry<Object, Object, DummyInternalEntry> {
        private DummyInternalEntry() {
            throw new AssertionError();
        }

        @Override
        public final int getHash() {
            throw new AssertionError();
        }

        @Override
        public final Object getKey() {
            throw new AssertionError();
        }

        @Override
        public final Object getValue() {
            throw new AssertionError();
        }
    }

    static abstract class AbstractWeakKeyEntry<K, V, E extends InternalEntry<K, V, E>>
    extends WeakReference<K>
    implements InternalEntry<K, V, E> {
        final int hash;

        /*
         * WARNING - void declaration
         */
        AbstractWeakKeyEntry(ReferenceQueue<K> queue, K key, int hash) {
            super(var2_2, var1_1);
            void var3_3;
            void var1_1;
            void var2_2;
            this.hash = var3_3;
        }

        @Override
        public final K getKey() {
            return (K)this.get();
        }

        @Override
        public final int getHash() {
            return this.hash;
        }

        @Override
        public E getNext() {
            return null;
        }
    }

    static interface WeakValueEntry<K, V, E extends InternalEntry<K, V, E>>
    extends InternalEntry<K, V, E> {
        public WeakValueReference<K, V, E> getValueReference();
    }

    static abstract class AbstractStrongKeyEntry<K, V, E extends InternalEntry<K, V, E>>
    implements InternalEntry<K, V, E> {
        final K key;
        final int hash;

        /*
         * WARNING - void declaration
         */
        AbstractStrongKeyEntry(K key, int hash) {
            void var2_2;
            void var1_1;
            this.key = var1_1;
            this.hash = var2_2;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final int getHash() {
            return this.hash;
        }

        @Override
        public E getNext() {
            return null;
        }
    }
}

