/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.Hashing;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.RegularImmutableAsList;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Spliterator;
import java.util.Spliterators;

final class RegularImmutableSet<E>
extends ImmutableSet.CachingAsList<E> {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    static final RegularImmutableSet<Object> EMPTY = new RegularImmutableSet(EMPTY_ARRAY, 0, EMPTY_ARRAY, 0);
    private final transient Object[] elements;
    private final transient int hashCode;
    private transient Object[] table;
    private final transient int mask;

    /*
     * WARNING - void declaration
     */
    RegularImmutableSet(Object[] elements, int hashCode, Object[] table, int mask) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.elements = var1_1;
        this.hashCode = var2_2;
        this.table = var3_3;
        this.mask = mask;
    }

    @Override
    public final boolean contains(Object target) {
        Object[] table = this.table;
        if (target == null || table.length == 0) {
            return false;
        }
        Object object = target;
        int i = Hashing.smear(object == null ? 0 : object.hashCode());
        Object candidate;
        while ((candidate = table[i &= this.mask]) != null) {
            if (candidate.equals(target)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public final int size() {
        return this.elements.length;
    }

    @Override
    public final UnmodifiableIterator<E> iterator() {
        Object[] objectArray = this.elements;
        return Iterators.forArrayWithPosition(this.elements, 0);
    }

    @Override
    public final Spliterator<E> spliterator() {
        return Spliterators.spliterator(this.elements, 1297);
    }

    @Override
    final Object[] internalArray() {
        return this.elements;
    }

    @Override
    final int internalArrayStart() {
        return 0;
    }

    @Override
    final int internalArrayEnd() {
        return this.elements.length;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final int copyIntoArray(Object[] dst, int offset) {
        void var2_2;
        void var1_1;
        System.arraycopy(this.elements, 0, var1_1, offset, this.elements.length);
        return (int)(var2_2 + this.elements.length);
    }

    @Override
    final ImmutableList<E> createAsList() {
        if (this.table.length == 0) {
            return ImmutableList.of();
        }
        RegularImmutableSet regularImmutableSet = this;
        return new RegularImmutableAsList(regularImmutableSet, regularImmutableSet.elements);
    }

    @Override
    final boolean isPartialView() {
        return false;
    }

    @Override
    public final int hashCode() {
        return this.hashCode;
    }

    @Override
    final boolean isHashCodeFast() {
        return true;
    }
}

