/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Queue;

public final class ByteStreams {
    /*
     * WARNING - void declaration
     */
    public static long copy(InputStream from, OutputStream to) throws IOException {
        void var3_3;
        int r;
        Preconditions.checkNotNull(from);
        Preconditions.checkNotNull(to);
        byte[] buf = new byte[8192];
        long total = 0L;
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
            total += (long)r;
        }
        return (long)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] combineBuffers(Queue<byte[]> bufs, int totalLen) {
        void var2_2;
        if (bufs.isEmpty()) {
            return new byte[0];
        }
        byte[] result = bufs.remove();
        if (result.length == totalLen) {
            return result;
        }
        int remaining = totalLen - result.length;
        result = Arrays.copyOf(result, totalLen);
        while (remaining > 0) {
            byte[] buf = bufs.remove();
            int bytesToCopy = Math.min(remaining, buf.length);
            int resultOffset = totalLen - remaining;
            System.arraycopy(buf, 0, result, resultOffset, bytesToCopy);
            remaining -= bytesToCopy;
        }
        return var2_2;
    }

    public static byte[] toByteArray(InputStream in) throws IOException {
        InputStream inputStream;
        Preconditions.checkNotNull(in);
        int n = 0;
        ArrayDeque<byte[]> arrayDeque = new ArrayDeque<byte[]>(20);
        int n2 = Math.min(8192, Math.max(128, Integer.highestOneBit(0) << 1));
        while (n < 0x7FFFFFF7) {
            byte[] byArray = new byte[Math.min(n2, 0x7FFFFFF7 - n)];
            arrayDeque.add(byArray);
            int n3 = 0;
            while (n3 < byArray.length) {
                int n4 = inputStream.read(byArray, n3, byArray.length - n3);
                if (n4 == -1) {
                    return ByteStreams.combineBuffers(arrayDeque, n);
                }
                n3 += n4;
                n += n4;
            }
            int n5 = n2;
            int n6 = n5 < 4096 ? 4 : 2;
            n2 = n5;
            n2 = Ints.saturatedCast((long)n5 * (long)n6);
        }
        if (inputStream.read() == -1) {
            return ByteStreams.combineBuffers(arrayDeque, 0x7FFFFFF7);
        }
        throw new OutOfMemoryError("input is too large to fit in a byte array");
    }

    static {
        new OutputStream(){

            @Override
            public final void write(int b) {
            }

            @Override
            public final void write(byte[] b) {
                Preconditions.checkNotNull(b);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void write(byte[] b, int off, int len) {
                void var1_1;
                void var3_3;
                void var2_2;
                Preconditions.checkNotNull(b);
                void v0 = var2_2;
                Preconditions.checkPositionIndexes((int)v0, (int)(v0 + var3_3), ((void)var1_1).length);
            }

            public final String toString() {
                return "ByteStreams.nullOutputStream()";
            }
        };
    }
}

