/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.base.Preconditions;
import com.google.common.math.MathPreconditions;
import java.math.RoundingMode;

public final class IntMath {
    /*
     * WARNING - void declaration
     */
    private static int lessThanBranchFree(int x, int y) {
        void var1_1;
        return ~(~(x - var1_1)) >>> 31;
    }

    /*
     * WARNING - void declaration
     */
    public static int log2(int x, RoundingMode mode) {
        int n = x;
        String string = "x";
        if (n <= 0) {
            throw new IllegalArgumentException(string + " (" + n + ") must be > 0");
        }
        switch (mode) {
            case UNNECESSARY: {
                int n2 = x;
                int n3 = n2;
                MathPreconditions.checkRoundingUnnecessary(n2 > 0 & (n3 & n3 - 1) == 0);
            }
            case DOWN: 
            case FLOOR: {
                return 31 - Integer.numberOfLeadingZeros(x);
            }
            case UP: 
            case CEILING: {
                return 32 - Integer.numberOfLeadingZeros(x - 1);
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                int n4;
                void var2_6;
                int n5;
                int leadingZeros = Integer.numberOfLeadingZeros(x);
                int cmp = -1257966797 >>> leadingZeros;
                n5 = 31 - n5;
                return n5 + IntMath.lessThanBranchFree((int)var2_6, n4);
            }
        }
        throw new AssertionError();
    }

    /*
     * WARNING - void declaration
     */
    public static int sqrt(int x, RoundingMode mode) {
        int n = x;
        String string = "x";
        if (n < 0) {
            throw new IllegalArgumentException(string + " (" + n + ") must be >= 0");
        }
        int n2 = x;
        int sqrtFloor = (int)Math.sqrt(n2);
        switch (mode) {
            case UNNECESSARY: {
                int n3 = sqrtFloor;
                MathPreconditions.checkRoundingUnnecessary(n3 * n3 == x);
            }
            case DOWN: 
            case FLOOR: {
                return sqrtFloor;
            }
            case UP: 
            case CEILING: {
                int n4 = sqrtFloor;
                return n4 + IntMath.lessThanBranchFree(n4 * sqrtFloor, x);
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                int n5;
                void var1_2;
                int n6 = sqrtFloor;
                int halfSquare = n6 * n6 + sqrtFloor;
                return n2 + IntMath.lessThanBranchFree((int)var1_2, n5);
            }
        }
        throw new AssertionError();
    }

    /*
     * WARNING - void declaration
     */
    public static int divide(int p, int q, RoundingMode mode) {
        void var3_3;
        void var1_1;
        Preconditions.checkNotNull(mode);
        if (q == 0) {
            throw new ArithmeticException("/ by zero");
        }
        int div2 = p / q;
        int rem = p - q * div2;
        if (rem == 0) {
            return div2;
        }
        int signum = 1 | (p ^ q) >> 31;
        switch (mode) {
            case UNNECESSARY: {
                MathPreconditions.checkRoundingUnnecessary(rem == 0);
            }
            case DOWN: {
                int increment = 0;
                break;
            }
            case UP: {
                int increment = 1;
                break;
            }
            case CEILING: {
                int increment = signum > 0 ? 1 : 0;
                break;
            }
            case FLOOR: {
                int increment = signum < 0 ? 1 : 0;
                break;
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                int increment;
                int absRem = Math.abs(rem);
                int cmpRemToHalfDivisor = absRem - (Math.abs(increment) - absRem);
                if (cmpRemToHalfDivisor == 0) {
                    void var2_2;
                    increment = mode == RoundingMode.HALF_UP || var2_2 == RoundingMode.HALF_EVEN & (div2 & 1) != 0 ? 1 : 0;
                    break;
                }
                increment = increment > 0 ? 1 : 0;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (var1_1 != false) {
            int n;
            return div2 + n;
        }
        return (int)var3_3;
    }
}

