/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Newlines {
    private static final ImmutableSet<String> BREAKS = ImmutableSet.of("\r\n", "\n", "\r");

    public static int count(String input) {
        return Iterators.size(Newlines.lineOffsetIterator(input)) - 1;
    }

    public static int firstBreak(String input) {
        Iterator<Integer> it = Newlines.lineOffsetIterator(input);
        it.next();
        if (it.hasNext()) {
            Iterator<Integer> iterator;
            return (Integer)iterator.next();
        }
        return -1;
    }

    public static boolean isNewline(String input) {
        String string;
        return BREAKS.contains(string);
    }

    /*
     * WARNING - void declaration
     */
    public static int hasNewlineAt(String input, int idx) {
        for (String b : BREAKS) {
            void var3_3;
            if (!input.startsWith(b, idx)) continue;
            return var3_3.length();
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static String getLineEnding(String input) {
        for (String b : BREAKS) {
            void var2_2;
            if (!input.endsWith(b)) continue;
            return var2_2;
        }
        return null;
    }

    public static String guessLineSeparator(String text) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '\r': {
                    if (i + 1 < text.length() && text.charAt(i + 1) == '\n') {
                        return "\r\n";
                    }
                    return "\r";
                }
                case '\n': {
                    return "\n";
                }
            }
        }
        return "\n";
    }

    public static boolean containsBreaks(String text) {
        CharMatcher charMatcher;
        String string = charMatcher;
        charMatcher = CharMatcher.anyOf("\n\r");
        return !charMatcher.matchesNoneOf(string);
    }

    public static Iterator<Integer> lineOffsetIterator(String input) {
        String string;
        return new LineOffsetIterator(string);
    }

    public static Iterator<String> lineIterator(String input) {
        String string;
        return new LineIterator(string);
    }

    private static class LineOffsetIterator
    implements Iterator<Integer> {
        private int curr = 0;
        private int idx = 0;
        private final String input;

        /*
         * WARNING - void declaration
         */
        private LineOffsetIterator(String input) {
            void var1_1;
            this.input = var1_1;
        }

        @Override
        public boolean hasNext() {
            return this.curr != -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Integer next() {
            void var1_1;
            if (this.curr == -1) {
                throw new NoSuchElementException();
            }
            int result = this.curr;
            this.advance();
            return (int)var1_1;
        }

        private void advance() {
            while (this.idx < this.input.length()) {
                char c = this.input.charAt(this.idx);
                switch (c) {
                    case '\r': {
                        if (this.idx + 1 < this.input.length() && this.input.charAt(this.idx + 1) == '\n') {
                            ++this.idx;
                        }
                    }
                    case '\n': {
                        ++this.idx;
                        this.curr = this.idx;
                        return;
                    }
                }
                ++this.idx;
            }
            this.curr = -1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    private static class LineIterator
    implements Iterator<String> {
        int idx;
        String curr;
        private final String input;
        private final Iterator<Integer> indices;

        /*
         * WARNING - void declaration
         */
        private LineIterator(String input) {
            void var1_1;
            this.input = input;
            this.indices = Newlines.lineOffsetIterator((String)var1_1);
            this.idx = this.indices.next();
        }

        /*
         * WARNING - void declaration
         */
        private void advance() {
            void var1_1;
            int last = this.idx;
            if (this.indices.hasNext()) {
                this.idx = this.indices.next();
            } else if (this.hasNext()) {
                this.idx = this.input.length();
            } else {
                throw new NoSuchElementException();
            }
            this.curr = this.input.substring((int)var1_1, this.idx);
        }

        @Override
        public boolean hasNext() {
            return this.idx < this.input.length();
        }

        @Override
        public String next() {
            this.advance();
            return this.curr;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

