/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat;

import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.googlejavaformat.CloseOp;
import com.google.googlejavaformat.Doc;
import com.google.googlejavaformat.FormatterDiagnostic;
import com.google.googlejavaformat.FormattingError;
import com.google.googlejavaformat.Indent;
import com.google.googlejavaformat.Input;
import com.google.googlejavaformat.Op;
import com.google.googlejavaformat.OpenOp;
import com.google.googlejavaformat.Output;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public final class OpsBuilder {
    private final Input input;
    private final List<Op> ops = new ArrayList<Op>();
    private final Output output;
    private static final Indent.Const ZERO = Indent.Const.ZERO;
    private int tokenI = 0;
    private int inputPosition = Integer.MIN_VALUE;
    int depth = 0;
    private int lastPartialFormatBoundary = -1;
    private static final Doc.Space SPACE = Doc.Space.make();

    /*
     * WARNING - void declaration
     */
    public final int actualSize(int position, int length) {
        int n;
        void var3_5;
        void var1_1;
        Input.Token startToken = this.input.getPositionTokenMap().get(position);
        int start = startToken.getTok().getPosition();
        for (Input.Tok tok : startToken.getToksBefore()) {
            if (!tok.isComment()) continue;
            start = Math.min(start, tok.getPosition());
        }
        Input.Token endToken = this.input.getPositionTokenMap().get((int)(var1_1 + length - true));
        int n2 = endToken.getTok().getPosition() + endToken.getTok().length();
        for (Input.Tok tok : var3_5.getToksAfter()) {
            void var2_4;
            if (!tok.isComment()) continue;
            n = Math.max(n, tok.getPosition() + var2_4.length());
        }
        return (int)(n - start);
    }

    /*
     * WARNING - void declaration
     */
    public final Integer actualStartColumn(int position) {
        void var2_3;
        Iterator iterator;
        Input.Token startToken = this.input.getPositionTokenMap().get(position);
        int start = startToken.getTok().getPosition();
        int line0 = this.input.getLineNumber(start);
        for (Input.Tok tok : iterator.getToksBefore()) {
            if (line0 != this.input.getLineNumber(tok.getPosition())) {
                return start;
            }
            if (!tok.isComment()) continue;
            start = Math.min(start, tok.getPosition());
        }
        return (int)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public final void add(Op op) {
        void var1_1;
        if (op instanceof OpenOp) {
            ++this.depth;
        } else if (op instanceof CloseOp) {
            --this.depth;
            if (this.depth < 0) {
                throw new AssertionError();
            }
        }
        this.ops.add((Op)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void addAll(List<Op> ops) {
        for (Op op : ops) {
            void var2_2;
            this.add((Op)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public OpsBuilder(Input input, Output output) {
        void var2_2;
        void var1_1;
        this.input = var1_1;
        this.output = var2_2;
    }

    public final Input getInput() {
        return this.input;
    }

    public final int depth() {
        return this.depth;
    }

    /*
     * WARNING - void declaration
     */
    public final void checkClosed(int previous) {
        void var1_1;
        if (this.depth != var1_1) {
            throw new FormattingError(this.diagnostic(String.format("saw %d unclosed ops", this.depth)));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final FormatterDiagnostic diagnostic(String message) {
        void var1_1;
        return this.input.createDiagnostic(this.inputPosition, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void sync(int inputPosition) {
        if (inputPosition > this.inputPosition) {
            void var3_4;
            ImmutableList<? extends Input.Token> tokens = this.input.getTokens();
            int tokensN = tokens.size();
            this.inputPosition = inputPosition;
            if (this.tokenI < var3_4 && inputPosition > ((Input.Token)tokens.get(this.tokenI)).getTok().getPosition()) {
                void var1_2;
                void var2_3;
                Input.Token token = (Input.Token)var2_3.get(this.tokenI++);
                throw new FormattingError(this.diagnostic(String.format("did not generate token \"%s\"", var1_2.getTok().getText())));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void drain() {
        void var1_1;
        int inputPosition = this.input.getText().length() + 1;
        if (inputPosition > this.inputPosition) {
            ImmutableList<? extends Input.Token> tokens = this.input.getTokens();
            int tokensN = tokens.size();
            while (this.tokenI < tokensN && inputPosition > ((Input.Token)tokens.get(this.tokenI)).getTok().getPosition()) {
                Input.Token token = (Input.Token)tokens.get(this.tokenI++);
                this.add(Doc.Token.make(token, Doc.Token.RealOrImaginary.IMAGINARY, ZERO, Optional.empty()));
            }
        }
        this.inputPosition = var1_1;
        this.checkClosed(0);
    }

    /*
     * WARNING - void declaration
     */
    public final void open(Indent plusIndent) {
        void var1_1;
        this.add(OpenOp.make((Indent)var1_1));
    }

    public final void close() {
        this.add(CloseOp.make());
    }

    public final Optional<String> peekToken() {
        return this.peekToken(0);
    }

    /*
     * WARNING - void declaration
     */
    public final Optional<String> peekToken(int skip) {
        int idx = this.tokenI + skip;
        ImmutableList<? extends Input.Token> tokens = this.input.getTokens();
        if (idx < tokens.size()) {
            void var1_1;
            void var2_2;
            return Optional.of(((Input.Token)var2_2.get((int)var1_1)).getTok().getOriginalText());
        }
        return Optional.empty();
    }

    /*
     * WARNING - void declaration
     */
    public final ImmutableList<Input.Tok> peekTokens(int startPosition, Predicate<Input.Tok> predicate) {
        void var1_2;
        Input.Tok tok;
        ImmutableList<? extends Input.Token> tokens = this.input.getTokens();
        int n = ((Input.Token)tokens.get(this.tokenI)).getTok().getPosition() == startPosition ? 1 : 0;
        Object e = tokens.get(this.tokenI);
        int n2 = startPosition;
        String string = "Expected the current token to be at position %s, found: %s";
        startPosition = n;
        if (n == 0) {
            throw new IllegalStateException(Strings.lenientFormat(string, n2, e));
        }
        ImmutableList.Builder result = ImmutableList.builder();
        for (int idx = this.tokenI; idx < tokens.size() && predicate.apply(tok = ((Input.Token)tokens.get(idx)).getTok()); ++idx) {
            result.add(tok);
        }
        return var1_2.build();
    }

    /*
     * WARNING - void declaration
     */
    public final void guessToken(String token) {
        void var1_1;
        this.token((String)var1_1, Doc.Token.RealOrImaginary.IMAGINARY, ZERO, Optional.empty());
    }

    /*
     * WARNING - void declaration
     */
    public final void token(String token, Doc.Token.RealOrImaginary realOrImaginary, Indent plusIndentCommentsBefore, Optional<Indent> breakAndIndentTrailingComment) {
        void var2_2;
        ImmutableList<? extends Input.Token> tokens = this.input.getTokens();
        if (token.equals(this.peekToken().orElse(null))) {
            void var3_3;
            this.add(Doc.Token.make((Input.Token)tokens.get(this.tokenI++), Doc.Token.RealOrImaginary.REAL, (Indent)var3_3, breakAndIndentTrailingComment));
            return;
        }
        if (var2_2.isReal()) {
            void var1_1;
            throw new FormattingError(this.diagnostic(String.format("expected token: '%s'; generated %s instead", this.peekToken().orElse(null), var1_1)));
        }
    }

    public final void op(String op) {
        int opN = op.length();
        int i = 0;
        while (i < opN) {
            int n = i++;
            this.token(op.substring(n, n + 1), Doc.Token.RealOrImaginary.REAL, ZERO, Optional.empty());
        }
    }

    public final void space() {
        this.add(Doc.Space.make());
    }

    public final void breakOp() {
        this.breakOp(Doc.FillMode.UNIFIED, "", ZERO);
    }

    /*
     * WARNING - void declaration
     */
    public final void breakOp(Indent plusIndent) {
        void var1_1;
        this.breakOp(Doc.FillMode.UNIFIED, "", (Indent)var1_1);
    }

    public final void breakToFill() {
        this.breakOp(Doc.FillMode.INDEPENDENT, "", ZERO);
    }

    public final void forcedBreak() {
        this.breakOp(Doc.FillMode.FORCED, "", ZERO);
    }

    /*
     * WARNING - void declaration
     */
    public final void forcedBreak(Indent plusIndent) {
        void var1_1;
        this.breakOp(Doc.FillMode.FORCED, "", (Indent)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void breakOp(String flat) {
        void var1_1;
        this.breakOp(Doc.FillMode.UNIFIED, (String)var1_1, ZERO);
    }

    /*
     * WARNING - void declaration
     */
    public final void breakToFill(String flat) {
        void var1_1;
        this.breakOp(Doc.FillMode.INDEPENDENT, (String)var1_1, ZERO);
    }

    /*
     * WARNING - void declaration
     */
    public final void breakOp(Doc.FillMode fillMode, String flat, Indent plusIndent) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.breakOp((Doc.FillMode)var1_1, (String)var2_2, (Indent)var3_3, Optional.empty());
    }

    /*
     * WARNING - void declaration
     */
    public final void breakOp(Doc.FillMode fillMode, String flat, Indent plusIndent, Optional<Output.BreakTag> optionalTag) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.add(Doc.Break.make((Doc.FillMode)var1_1, (String)var2_2, (Indent)var3_3, optionalTag));
    }

    /*
     * WARNING - void declaration
     */
    public final void markForPartialFormat() {
        void var2_2;
        void var1_1;
        if (this.lastPartialFormatBoundary == -1) {
            this.lastPartialFormatBoundary = this.tokenI;
            return;
        }
        if (this.tokenI == this.lastPartialFormatBoundary) {
            return;
        }
        Input.Token start = (Input.Token)this.input.getTokens().get(this.lastPartialFormatBoundary);
        Input.Token end = (Input.Token)this.input.getTokens().get(this.tokenI - 1);
        this.output.markForPartialFormat((Input.Token)var1_1, (Input.Token)var2_2);
        this.lastPartialFormatBoundary = this.tokenI;
    }

    /*
     * WARNING - void declaration
     */
    public final void blankLineWanted(BlankLineWanted wanted) {
        void var1_1;
        this.output.blankLine(OpsBuilder.getI((Input.Token)this.input.getTokens().get(this.tokenI)), (BlankLineWanted)var1_1);
    }

    private static int getI(Input.Token token) {
        Input.Token token2;
        for (Input.Tok tok : token.getToksBefore()) {
            if (tok.getIndex() < 0) continue;
            return tok.getIndex();
        }
        return token2.getTok().getIndex();
    }

    /*
     * WARNING - void declaration
     */
    public final ImmutableList<Op> build() {
        void var3_4;
        void var2_2;
        void var1_1;
        this.markForPartialFormat();
        ArrayListMultimap<Integer, Op> tokOps = ArrayListMultimap.create();
        int opsN = this.ops.size();
        for (int i = 0; i < opsN; ++i) {
            Iterator breakAfter22;
            int newlines;
            int j;
            Op op = this.ops.get(i);
            if (!(op instanceof Doc.Token)) continue;
            Doc.Token tokenOp = (Doc.Token)op;
            Input.Token token = tokenOp.getToken();
            for (j = i; j > 0 && this.ops.get(j - 1) instanceof OpenOp; --j) {
            }
            int k = i;
            while (k + 1 < opsN && this.ops.get(k + 1) instanceof CloseOp) {
                ++k;
            }
            if (tokenOp.realOrImaginary().isReal()) {
                boolean bl;
                newlines = 0;
                boolean space = false;
                boolean lastWasComment = false;
                boolean bl2 = false;
                for (Input.Tok tok : token.getToksBefore()) {
                    if (tok.isNewline()) {
                        ++newlines;
                        continue;
                    }
                    if (!tok.isComment()) continue;
                    tokOps.put(j, Doc.Break.make(tok.isSlashSlashComment() ? Doc.FillMode.FORCED : Doc.FillMode.UNIFIED, "", tokenOp.getPlusIndentCommentsBefore()));
                    tokOps.putAll(j, OpsBuilder.makeComment(tok));
                    space = tok.isSlashStarComment();
                    newlines = 0;
                    lastWasComment = true;
                    if (tok.isJavadocComment()) {
                        tokOps.put(j, Doc.Break.makeForced());
                    }
                    bl = tok.isSlashSlashComment() || tok.isSlashStarComment() && !tok.isJavadocComment();
                }
                if (bl && newlines > 1) {
                    this.output.blankLine(token.getTok().getIndex(), BlankLineWanted.YES);
                }
                if (lastWasComment && newlines > 0) {
                    tokOps.put(j, Doc.Break.makeForced());
                } else if (space) {
                    tokOps.put(j, SPACE);
                }
                for (Input.Tok tok : token.getToksAfter()) {
                    if (!tok.isComment()) continue;
                    boolean breakAfter22 = tok.isJavadocComment() || tok.isSlashStarComment() && tokenOp.breakAndIndentTrailingComment().isPresent();
                    if (breakAfter22) {
                        tokOps.put(k + 1, Doc.Break.make(Doc.FillMode.FORCED, "", tokenOp.breakAndIndentTrailingComment().orElse(Indent.Const.ZERO)));
                    } else {
                        tokOps.put(k + 1, SPACE);
                    }
                    tokOps.putAll(k + 1, OpsBuilder.makeComment(tok));
                    if (!breakAfter22) continue;
                    tokOps.put(k + 1, Doc.Break.make(Doc.FillMode.FORCED, "", ZERO));
                }
                continue;
            }
            newlines = 0;
            boolean lastWasComment = false;
            for (Input.Tok tok : breakAfter22.getToksBefore()) {
                if (tok.isNewline()) {
                    ++newlines;
                } else if (tok.isComment()) {
                    newlines = 0;
                    lastWasComment = tok.isComment();
                }
                if (lastWasComment && newlines > 0) {
                    tokOps.put(j, Doc.Break.makeForced());
                }
                tokOps.put(j, Doc.Tok.make(tok));
            }
            for (Input.Tok tok : breakAfter22.getToksAfter()) {
                tokOps.put(k + 1, Doc.Tok.make(tok));
            }
        }
        ImmutableList.Builder newOps = ImmutableList.builder();
        boolean afterForcedBreak = false;
        for (int i = 0; i < opsN; ++i) {
            for (Op op : tokOps.get(i)) {
                if (afterForcedBreak && op instanceof Doc.Space) continue;
                newOps.add(op);
                afterForcedBreak = OpsBuilder.isForcedBreak(op);
            }
            Op op = this.ops.get(i);
            if (afterForcedBreak && (op instanceof Doc.Space || op instanceof Doc.Break && ((Doc.Break)op).getPlusIndent() == 0 && " ".equals(((Doc)((Object)op)).getFlat()))) continue;
            newOps.add(op);
            if (op instanceof OpenOp) continue;
            afterForcedBreak = OpsBuilder.isForcedBreak(op);
        }
        for (Op op : var1_1.get((int)var2_2)) {
            if (afterForcedBreak && op instanceof Doc.Space) continue;
            newOps.add(op);
            afterForcedBreak = OpsBuilder.isForcedBreak(op);
        }
        return var3_4.build();
    }

    private static boolean isForcedBreak(Op op) {
        Op op2;
        return op instanceof Doc.Break && ((Doc.Break)op2).isForced();
    }

    private static List<Op> makeComment(Input.Tok comment) {
        Input.Tok tok;
        if (comment.isSlashStarComment()) {
            return ImmutableList.of$714caac3((Object)Doc.Tok.make(comment));
        }
        return ImmutableList.of$3de3b3a1(Doc.Tok.make(tok), Doc.Break.makeForced());
    }

    public final String toString() {
        return MoreObjects.toStringHelper(this).add("input", this.input).add("ops", this.ops).add("output", this.output).add("tokenI", this.tokenI).add("inputPosition", this.inputPosition).toString();
    }

    public static abstract class BlankLineWanted {
        public static final BlankLineWanted YES = new SimpleBlankLine(Optional.of(Boolean.TRUE));
        public static final BlankLineWanted NO = new SimpleBlankLine(Optional.of(Boolean.FALSE));
        public static final BlankLineWanted PRESERVE = new SimpleBlankLine(Optional.empty());

        public abstract Optional<Boolean> wanted();

        public abstract BlankLineWanted merge(BlankLineWanted var1);

        public static BlankLineWanted conditional(Output.BreakTag breakTag) {
            Output.BreakTag breakTag2;
            return new ConditionalBlankLine(ImmutableList.of$714caac3((Object)breakTag2));
        }

        private static final class ConditionalBlankLine
        extends BlankLineWanted {
            private final ImmutableList<Output.BreakTag> tags;

            /*
             * WARNING - void declaration
             */
            ConditionalBlankLine(Iterable<Output.BreakTag> tags) {
                void var1_1;
                this.tags = ImmutableList.copyOf(var1_1);
            }

            @Override
            public final Optional<Boolean> wanted() {
                for (Output.BreakTag breakTag : this.tags) {
                    if (!breakTag.wasBreakTaken()) continue;
                    return Optional.of(Boolean.TRUE);
                }
                return Optional.empty();
            }

            @Override
            public final BlankLineWanted merge(BlankLineWanted other) {
                ImmutableList<Output.BreakTag> immutableList;
                if (!(other instanceof ConditionalBlankLine)) {
                    return other;
                }
                ImmutableList<Output.BreakTag> immutableList2 = ((ConditionalBlankLine)((Object)immutableList)).tags;
                immutableList = this.tags;
                return new ConditionalBlankLine(FluentIterable.concat(immutableList, immutableList2));
            }
        }

        private static final class SimpleBlankLine
        extends BlankLineWanted {
            private final Optional<Boolean> wanted;

            /*
             * WARNING - void declaration
             */
            SimpleBlankLine(Optional<Boolean> wanted) {
                void var1_1;
                this.wanted = var1_1;
            }

            @Override
            public final Optional<Boolean> wanted() {
                return this.wanted;
            }

            @Override
            public final BlankLineWanted merge(BlankLineWanted other) {
                return this;
            }
        }
    }
}

