/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.Optional;

final class CommandLineOptions {
    private final ImmutableList<String> files;
    private final boolean inPlace;
    private final ImmutableRangeSet<Integer> lines;
    private final ImmutableList<Integer> offsets;
    private final ImmutableList<Integer> lengths;
    private final boolean aosp;
    private final boolean version;
    private final boolean help;
    private final boolean stdin;
    private final boolean fixImportsOnly;
    private final boolean sortImports;
    private final boolean removeUnusedImports;
    private final boolean dryRun;
    private final boolean setExitIfChanged;
    private final Optional<String> assumeFilename;
    private final boolean reflowLongStrings;
    private final boolean formatJavadoc;

    /*
     * WARNING - void declaration
     */
    CommandLineOptions(ImmutableList<String> files, boolean inPlace, ImmutableRangeSet<Integer> lines, ImmutableList<Integer> offsets, ImmutableList<Integer> lengths, boolean aosp, boolean version, boolean help, boolean stdin, boolean fixImportsOnly, boolean sortImports, boolean removeUnusedImports, boolean dryRun, boolean setExitIfChanged, Optional<String> assumeFilename, boolean reflowLongStrings, boolean formatJavadoc) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.files = var1_1;
        this.inPlace = var2_2;
        this.lines = var3_3;
        this.offsets = offsets;
        this.lengths = lengths;
        this.aosp = aosp;
        this.version = version;
        this.help = help;
        this.stdin = stdin;
        this.fixImportsOnly = fixImportsOnly;
        this.sortImports = sortImports;
        this.removeUnusedImports = removeUnusedImports;
        this.dryRun = dryRun;
        this.setExitIfChanged = setExitIfChanged;
        this.assumeFilename = assumeFilename;
        this.reflowLongStrings = reflowLongStrings;
        this.formatJavadoc = formatJavadoc;
    }

    final ImmutableList<String> files() {
        return this.files;
    }

    final boolean inPlace() {
        return this.inPlace;
    }

    final ImmutableRangeSet<Integer> lines() {
        return this.lines;
    }

    final ImmutableList<Integer> offsets() {
        return this.offsets;
    }

    final ImmutableList<Integer> lengths() {
        return this.lengths;
    }

    final boolean aosp() {
        return this.aosp;
    }

    final boolean version() {
        return this.version;
    }

    final boolean help() {
        return this.help;
    }

    final boolean stdin() {
        return this.stdin;
    }

    final boolean fixImportsOnly() {
        return this.fixImportsOnly;
    }

    final boolean sortImports() {
        return this.sortImports;
    }

    final boolean removeUnusedImports() {
        return this.removeUnusedImports;
    }

    final boolean dryRun() {
        return this.dryRun;
    }

    final boolean setExitIfChanged() {
        return this.setExitIfChanged;
    }

    final Optional<String> assumeFilename() {
        return this.assumeFilename;
    }

    final boolean reflowLongStrings() {
        return this.reflowLongStrings;
    }

    final boolean isSelection() {
        return !this.lines().isEmpty() || !this.offsets().isEmpty() || !this.lengths().isEmpty();
    }

    final boolean formatJavadoc() {
        return this.formatJavadoc;
    }

    static Builder builder() {
        return new Builder();
    }

    static class Builder {
        private final ImmutableList.Builder<String> files = ImmutableList.builder();
        private final RangeSet<Integer> lines = TreeRangeSet.create();
        private final ImmutableList.Builder<Integer> offsets = ImmutableList.builder();
        private final ImmutableList.Builder<Integer> lengths = ImmutableList.builder();
        private boolean inPlace = false;
        private boolean aosp = false;
        private boolean version = false;
        private boolean help = false;
        private boolean stdin = false;
        private boolean fixImportsOnly = false;
        private boolean sortImports = true;
        private boolean removeUnusedImports = true;
        private boolean dryRun = false;
        private boolean setExitIfChanged = false;
        private Optional<String> assumeFilename = Optional.empty();
        private boolean reflowLongStrings = true;
        private boolean formatJavadoc = true;

        Builder() {
        }

        ImmutableList.Builder<String> filesBuilder() {
            return this.files;
        }

        /*
         * WARNING - void declaration
         */
        Builder inPlace(boolean inPlace) {
            void var1_1;
            this.inPlace = var1_1;
            return this;
        }

        RangeSet<Integer> linesBuilder() {
            return this.lines;
        }

        /*
         * WARNING - void declaration
         */
        Builder addOffset(Integer offset) {
            void var1_1;
            this.offsets.add(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        Builder addLength(Integer length) {
            void var1_1;
            this.lengths.add(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        Builder aosp(boolean aosp) {
            void var1_1;
            this.aosp = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        Builder version(boolean version) {
            void var1_1;
            this.version = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        Builder help(boolean help) {
            void var1_1;
            this.help = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        Builder stdin(boolean stdin) {
            void var1_1;
            this.stdin = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        Builder fixImportsOnly(boolean fixImportsOnly) {
            void var1_1;
            this.fixImportsOnly = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        Builder sortImports(boolean sortImports) {
            void var1_1;
            this.sortImports = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        Builder removeUnusedImports(boolean removeUnusedImports) {
            void var1_1;
            this.removeUnusedImports = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        Builder dryRun(boolean dryRun) {
            void var1_1;
            this.dryRun = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        Builder setExitIfChanged(boolean setExitIfChanged) {
            void var1_1;
            this.setExitIfChanged = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        Builder assumeFilename(String assumeFilename) {
            void var1_1;
            this.assumeFilename = Optional.of(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        Builder reflowLongStrings(boolean reflowLongStrings) {
            void var1_1;
            this.reflowLongStrings = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        Builder formatJavadoc(boolean formatJavadoc) {
            void var1_1;
            this.formatJavadoc = var1_1;
            return this;
        }

        CommandLineOptions build() {
            return new CommandLineOptions(this.files.build(), this.inPlace, ImmutableRangeSet.copyOf(this.lines), this.offsets.build(), this.lengths.build(), this.aosp, this.version, this.help, this.stdin, this.fixImportsOnly, this.sortImports, this.removeUnusedImports, this.dryRun, this.setExitIfChanged, this.assumeFilename, this.reflowLongStrings, this.formatJavadoc);
        }
    }
}

