/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.googlejavaformat.java.CommandLineOptions;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

final class CommandLineOptionsParser {
    private static final Splitter COMMA_SPLITTER = Splitter.on(',');
    private static final Splitter COLON_SPLITTER = Splitter.on(':');
    private static final Splitter ARG_SPLITTER = Splitter.on(CharMatcher.breakingWhitespace()).omitEmptyStrings().trimResults();

    CommandLineOptionsParser() {
    }

    /*
     * WARNING - void declaration
     */
    static CommandLineOptions parse(Iterable<String> options) {
        void var1_1;
        CommandLineOptions.Builder optionsBuilder = CommandLineOptions.builder();
        ArrayList<String> expandedOptions = new ArrayList<String>();
        CommandLineOptionsParser.expandParamsFiles(options, expandedOptions);
        Iterator it = expandedOptions.iterator();
        block52: while (it.hasNext()) {
            void var3_3;
            String value;
            String flag;
            String option = (String)it.next();
            if (!option.startsWith("-")) {
                ((ImmutableList.Builder)optionsBuilder.filesBuilder().add((Object)option)).addAll(it);
                break;
            }
            int idx = option.indexOf(61);
            if (idx >= 0) {
                flag = option.substring(0, idx);
                value = option.substring(idx + 1);
            } else {
                flag = value;
                value = null;
            }
            switch (flag) {
                case "-i": 
                case "-r": 
                case "-replace": 
                case "--replace": {
                    optionsBuilder.inPlace(true);
                    continue block52;
                }
                case "--lines": 
                case "-lines": 
                case "--line": 
                case "-line": {
                    CommandLineOptionsParser.parseRangeSet(optionsBuilder.linesBuilder(), CommandLineOptionsParser.getValue(flag, it, value));
                    continue block52;
                }
                case "--offset": 
                case "-offset": {
                    optionsBuilder.addOffset(CommandLineOptionsParser.parseInteger(it, flag, value));
                    continue block52;
                }
                case "--length": 
                case "-length": {
                    optionsBuilder.addLength(CommandLineOptionsParser.parseInteger(it, flag, value));
                    continue block52;
                }
                case "--aosp": 
                case "-aosp": 
                case "-a": {
                    optionsBuilder.aosp(true);
                    continue block52;
                }
                case "--version": 
                case "-version": 
                case "-v": {
                    optionsBuilder.version(true);
                    continue block52;
                }
                case "--help": 
                case "-help": 
                case "-h": {
                    optionsBuilder.help(true);
                    continue block52;
                }
                case "--fix-imports-only": {
                    optionsBuilder.fixImportsOnly(true);
                    continue block52;
                }
                case "--skip-sorting-imports": {
                    optionsBuilder.sortImports(false);
                    continue block52;
                }
                case "--skip-removing-unused-imports": {
                    optionsBuilder.removeUnusedImports(false);
                    continue block52;
                }
                case "--skip-reflowing-long-strings": {
                    optionsBuilder.reflowLongStrings(false);
                    continue block52;
                }
                case "--skip-javadoc-formatting": {
                    optionsBuilder.formatJavadoc(false);
                    continue block52;
                }
                case "-": {
                    optionsBuilder.stdin(true);
                    continue block52;
                }
                case "-n": 
                case "--dry-run": {
                    optionsBuilder.dryRun(true);
                    continue block52;
                }
                case "--set-exit-if-changed": {
                    optionsBuilder.setExitIfChanged(true);
                    continue block52;
                }
                case "-assume-filename": 
                case "--assume-filename": {
                    void var2_2;
                    optionsBuilder.assumeFilename(CommandLineOptionsParser.getValue(flag, it, (String)var2_2));
                    continue block52;
                }
            }
            throw new IllegalArgumentException("unexpected flag: " + (String)var3_3);
        }
        return var1_1.build();
    }

    /*
     * WARNING - void declaration
     */
    private static Integer parseInteger(Iterator<String> it, String flag, String value) {
        try {
            return Integer.valueOf(CommandLineOptionsParser.getValue(flag, it, value));
        }
        catch (NumberFormatException e) {
            void var0_1;
            void var2_3;
            void var1_2;
            throw new IllegalArgumentException(String.format("invalid integer value for %s: %s", var1_2, var2_3), (Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String getValue(String flag, Iterator<String> it, String value) {
        void var1_1;
        if (value != null) {
            void var2_2;
            return var2_2;
        }
        if (!it.hasNext()) {
            String string;
            throw new IllegalArgumentException("required value was not provided for: " + string);
        }
        return (String)var1_1.next();
    }

    /*
     * WARNING - void declaration
     */
    private static void parseRangeSet(RangeSet<Integer> result, String ranges) {
        Iterator iterator;
        for (String range : COMMA_SPLITTER.split$7a1f82da((CharSequence)((Object)iterator))) {
            void var2_2;
            result.add(CommandLineOptionsParser.parseRange((String)var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Range<Integer> parseRange(String arg2) {
        String string;
        List<String> args = COLON_SPLITTER.splitToList(arg2);
        switch (args.size()) {
            case 1: {
                int line = Integer.parseInt(args.get(0)) - 1;
                return Range.closedOpen(line, line + 1);
            }
            case 2: {
                void var1_4;
                void var0_2;
                int line0 = Integer.parseInt(args.get(0)) - 1;
                int line1 = Integer.parseInt(args.get(1)) - 1;
                return Range.closedOpen((int)var0_2, (int)(var1_4 + true));
            }
        }
        throw new IllegalArgumentException(string);
    }

    /*
     * WARNING - void declaration
     */
    private static void expandParamsFiles(Iterable<String> args, List<String> expanded) {
        for (String arg2 : args) {
            if (arg2.isEmpty()) continue;
            if (!arg2.startsWith("@")) {
                expanded.add(arg2);
                continue;
            }
            if (arg2.startsWith("@@")) {
                expanded.add(arg2.substring(1));
                continue;
            }
            Path path = Paths.get(arg2.substring(1), new String[0]);
            try {
                String sequence = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
                CommandLineOptionsParser.expandParamsFiles(ARG_SPLITTER.split$7a1f82da(sequence), expanded);
            }
            catch (IOException e) {
                void var3_4;
                void var2_2;
                throw new UncheckedIOException(String.valueOf(var2_2) + ": could not read file: " + e.getMessage(), (IOException)var3_4);
            }
        }
    }
}

