/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import com.google.googlejavaformat.CommentsHelper;
import com.google.googlejavaformat.Input;
import com.google.googlejavaformat.Newlines;
import com.google.googlejavaformat.java.JavaFormatterOptions;
import com.google.googlejavaformat.java.javadoc.JavadocFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JavaCommentsHelper
implements CommentsHelper {
    private final String lineSeparator;
    private final JavaFormatterOptions options;
    private static final Pattern LINE_COMMENT_MISSING_SPACE_PREFIX = Pattern.compile("^(//+)(?!noinspection|\\$NON-NLS-\\d+\\$)[^\\s/]");

    /*
     * WARNING - void declaration
     */
    public JavaCommentsHelper(String lineSeparator, JavaFormatterOptions options) {
        void var2_2;
        void var1_1;
        this.lineSeparator = var1_1;
        this.options = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String rewrite(Input.Tok tok, int maxWidth, int column0) {
        void var3_4;
        void var1_1;
        if (!tok.isComment()) {
            return tok.getOriginalText();
        }
        String text = tok.getOriginalText();
        if (tok.isJavadocComment() && this.options.formatJavadoc()) {
            text = JavadocFormatter.formatJavadoc(text, column0);
        }
        ArrayList<String> lines = new ArrayList<String>();
        Iterator<String> it = Newlines.lineIterator(text);
        while (it.hasNext()) {
            lines.add(CharMatcher.whitespace().trimTrailingFrom(it.next()));
        }
        if (tok.isSlashSlashComment()) {
            return this.indentLineComments(lines, column0);
        }
        return CommentsHelper.reformatParameterComment((Input.Tok)var1_1).orElseGet(() -> this.lambda$rewrite$0(lines, (int)var3_4));
    }

    /*
     * WARNING - void declaration
     */
    private String preserveIndentation(List<String> lines, int column0) {
        void var3_3;
        int i;
        StringBuilder builder = new StringBuilder();
        int startCol = -1;
        for (i = 1; i < lines.size(); ++i) {
            int lineIdx = CharMatcher.whitespace().negate().indexIn(lines.get(i));
            if (lineIdx < 0 || startCol != -1 && lineIdx >= startCol) continue;
            startCol = lineIdx;
        }
        builder.append(lines.get(0));
        for (i = 1; i < lines.size(); ++i) {
            builder.append(this.lineSeparator).append(Strings.repeat(" ", column0));
            if (lines.get(i).length() >= startCol) {
                builder.append(lines.get(i).substring(startCol));
                continue;
            }
            builder.append(lines.get(i));
        }
        return var3_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    private String indentLineComments(List<String> lines, int column0) {
        void var3_4;
        lines = this.wrapLineComments(lines, column0);
        StringBuilder builder = new StringBuilder();
        builder.append(lines.get(0).trim());
        String indentString = Strings.repeat(" ", column0);
        for (int i = 1; i < lines.size(); ++i) {
            builder.append(this.lineSeparator).append(indentString).append(lines.get(i).trim());
        }
        return var3_4.toString();
    }

    /*
     * WARNING - void declaration
     */
    private List<String> wrapLineComments(List<String> lines, int column0) {
        void var3_3;
        Iterator iterator;
        ArrayList<String> result = new ArrayList<String>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object line = (String)iterator.next();
            Matcher matcher = LINE_COMMENT_MISSING_SPACE_PREFIX.matcher((CharSequence)line);
            if (matcher.find()) {
                int length = matcher.group(1).length();
                line = Strings.repeat("/", length) + " " + ((String)line).substring(length);
            }
            if (((String)line).startsWith("// MOE:")) {
                result.add((String)line);
                continue;
            }
            while (((String)line).length() + column0 > 100) {
                int idx;
                for (idx = 100 - column0; idx >= 2 && !CharMatcher.whitespace().matches(((String)line).charAt(idx)); --idx) {
                }
                if (idx <= 2) break;
                result.add(((String)line).substring(0, idx));
                line = "//" + ((String)line).substring(idx);
            }
            result.add((String)line);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private String indentJavadoc(List<String> lines, int column0) {
        void var3_4;
        StringBuilder builder = new StringBuilder();
        builder.append(lines.get(0).trim());
        int indent = column0 + 1;
        String indentString = Strings.repeat(" ", indent);
        for (int i = 1; i < lines.size(); ++i) {
            builder.append(this.lineSeparator).append(indentString);
            String line = lines.get(i).trim();
            if (!line.startsWith("*")) {
                builder.append("* ");
            }
            builder.append(line);
        }
        return var3_4.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static boolean javadocShaped(List<String> lines) {
        void var1_1;
        Iterator<String> it = lines.iterator();
        if (!it.hasNext()) {
            return false;
        }
        String first = ((String)it.next()).trim();
        if (first.startsWith("/**")) {
            return true;
        }
        if (!var1_1.startsWith("/*")) {
            return false;
        }
        while (it.hasNext()) {
            if (((String)it.next()).trim().startsWith("*")) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ String lambda$rewrite$0(List lines, int column0) {
        void var2_2;
        void var1_1;
        if (JavaCommentsHelper.javadocShaped(lines)) {
            return this.indentJavadoc(lines, column0);
        }
        return this.preserveIndentation((List<String>)var1_1, (int)var2_2);
    }
}

