/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.googlejavaformat.Input;
import com.google.googlejavaformat.Newlines;
import com.google.googlejavaformat.java.FormatterException;
import com.google.googlejavaformat.java.JavaOutput;
import com.google.googlejavaformat.java.JavacTokens;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

public final class JavaInput
extends Input {
    private final String text;
    private int kN;
    private final ImmutableMap<Integer, Integer> positionToColumnMap;
    private final ImmutableList<Token> tokens;
    private final ImmutableRangeMap<Integer, Token> positionTokenMap;
    private final Token[] kToToken;
    private JCTree.JCCompilationUnit unit;

    /*
     * WARNING - void declaration
     */
    public JavaInput(String text) throws FormatterException {
        void var1_1;
        this.text = Preconditions.checkNotNull(text);
        this.setLines(ImmutableList.copyOf(Newlines.lineIterator(text)));
        ImmutableList<Tok> toks = this.buildToks(text);
        this.positionToColumnMap = JavaInput.makePositionToColumnMap(toks);
        this.tokens = JavaInput.buildTokens(toks);
        ImmutableRangeMap.Builder<Integer, Token> tokenLocations = ImmutableRangeMap.builder();
        for (Token token : this.tokens) {
            Input.Tok end = JavaOutput.endTok(token);
            int n = end.getPosition();
            if (!end.getText().isEmpty()) {
                n += end.length() - 1;
            }
            tokenLocations.put$25167b06(Range.closed(JavaOutput.startTok(token).getPosition(), n), token);
        }
        this.positionTokenMap = var1_1.build();
        this.kToToken = new Token[this.kN + 1];
        for (Token token : this.tokens) {
            for (Input.Tok tok : token.getToksBefore()) {
                if (tok.getIndex() < 0) continue;
                this.kToToken[tok.getIndex()] = token;
            }
            this.kToToken[token.getTok().getIndex()] = token;
            for (Input.Tok tok : token.getToksAfter()) {
                if (tok.getIndex() < 0) continue;
                this.kToToken[tok.getIndex()] = token;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static ImmutableMap<Integer, Integer> makePositionToColumnMap(List<Tok> toks) {
        void var1_1;
        Iterator<Tok> iterator;
        ImmutableMap.Builder<Integer, Integer> builder = ImmutableMap.builder();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            Tok tok = (Tok)iterator.next();
            builder.put(tok.getPosition(), var2_2.getColumn());
        }
        return var1_1.buildOrThrow();
    }

    @Override
    public final String getText() {
        return this.text;
    }

    @Override
    public final ImmutableMap<Integer, Integer> getPositionToColumnMap() {
        return this.positionToColumnMap;
    }

    /*
     * WARNING - void declaration
     */
    private ImmutableList<Tok> buildToks(String text) throws FormatterException {
        void var1_1;
        ImmutableList<Tok> toks = JavaInput.buildToks(text, ImmutableSet.of$19e5980f());
        this.kN = Iterables.getLast(toks).getIndex();
        this.computeRanges(toks);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static ImmutableList<Tok> buildToks(final String text, ImmutableSet<Tokens.TokenKind> stopTokens) throws FormatterException {
        void var3_4;
        JavacTokens.RawTok t;
        Iterator iterator;
        stopTokens = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(stopTokens)).add(Tokens.TokenKind.EOF)).build();
        Context context = new Context();
        Options.instance(context).put("--enable-preview", "true");
        JavacFileManager fileManager = new JavacFileManager(context, false, StandardCharsets.UTF_8);
        context.put(JavaFileManager.class, fileManager);
        DiagnosticCollector diagnosticCollector = new DiagnosticCollector();
        context.put(DiagnosticListener.class, diagnosticCollector);
        Log log = Log.instance(context);
        log.useSource(new SimpleJavaFileObject(URI.create("Source.java"), JavaFileObject.Kind.SOURCE){
            {
                void var2_2;
                void var1_1;
                super((URI)var1_1, (JavaFileObject.Kind)var2_2);
            }

            @Override
            public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
                return text;
            }
        });
        Log.DeferredDiagnosticHandler diagnostics = new Log.DeferredDiagnosticHandler(log);
        ImmutableList<JavacTokens.RawTok> rawToks = JavacTokens.getTokens(text, context, stopTokens);
        if (diagnostics.getDiagnostics().stream().anyMatch(d -> d.getKind() == Diagnostic.Kind.ERROR)) {
            return ImmutableList.of$714caac3((Object)new Tok(0, "", "", 0, 0, true, null));
        }
        int kN = 0;
        ArrayList<Tok> toks = new ArrayList<Tok>();
        int charI = 0;
        int columnI = 0;
        iterator = ((ImmutableCollection)((Object)iterator)).iterator();
        while (iterator.hasNext() && !stopTokens.contains((t = (JavacTokens.RawTok)iterator.next()).kind())) {
            boolean isNumbered;
            int isToken;
            int charI0 = t.pos();
            String originalTokText = text.substring(charI0, t.endPos());
            String tokText = t.kind() == Tokens.TokenKind.STRINGLITERAL ? t.stringVal() : originalTokText;
            char tokText0 = tokText.charAt(0);
            String extraNewline = null;
            ArrayList<String> strings = new ArrayList<String>();
            if (Character.isWhitespace(tokText0)) {
                isToken = 0;
                isNumbered = false;
                Iterator<String> it = Newlines.lineIterator(originalTokText);
                while (it.hasNext()) {
                    String line = it.next();
                    String newline = Newlines.getLineEnding(line);
                    if (newline != null) {
                        String spaces = line.substring(0, line.length() - newline.length());
                        if (!spaces.isEmpty()) {
                            strings.add(spaces);
                        }
                        strings.add(newline);
                        continue;
                    }
                    if (line.isEmpty()) continue;
                    strings.add(line);
                }
            } else if (tokText.startsWith("'") || tokText.startsWith("\"")) {
                isToken = 1;
                isNumbered = true;
                strings.add(originalTokText);
            } else if (tokText.startsWith("//") || tokText.startsWith("/*")) {
                if (tokText.startsWith("//") && (originalTokText.endsWith("\n") || originalTokText.endsWith("\r"))) {
                    extraNewline = Newlines.getLineEnding(originalTokText);
                    tokText = tokText.substring(0, tokText.length() - extraNewline.length());
                    originalTokText = originalTokText.substring(0, originalTokText.length() - extraNewline.length());
                }
                isToken = 0;
                isNumbered = true;
                strings.add(originalTokText);
            } else if (Character.isJavaIdentifierStart((char)isToken) || Character.isDigit((char)isToken) || isToken == 46 && tokText.length() > 1 && Character.isDigit(tokText.charAt(1))) {
                isToken = 1;
                isNumbered = true;
                strings.add(tokText);
            } else {
                isToken = 1;
                isNumbered = true;
                char[] cArray = tokText.toCharArray();
                Object object = cArray;
                int line = cArray.length;
                for (int i = 0; i < line; ++i) {
                    Object c = object[i];
                    strings.add(String.valueOf((char)c));
                }
            }
            if (strings.size() == 1) {
                toks.add(new Tok(isNumbered ? kN++ : -1, originalTokText, tokText, charI, columnI, isToken != 0, t.kind()));
                charI += originalTokText.length();
                columnI = JavaInput.updateColumn(columnI, originalTokText);
            } else {
                if (strings.size() != 1 && !tokText.equals(originalTokText)) {
                    throw new FormatterException("Unicode escapes not allowed in whitespace or multi-character operators");
                }
                for (String str : strings) {
                    String string = str;
                    toks.add(new Tok(isNumbered ? kN++ : -1, string, string, charI, columnI, isToken != 0, null));
                    charI += str.length();
                    columnI = JavaInput.updateColumn(columnI, originalTokText);
                }
            }
            if (extraNewline == null) continue;
            String string = extraNewline;
            toks.add(new Tok(-1, string, string, charI, columnI, false, null));
            columnI = 0;
            charI += extraNewline.length();
        }
        toks.add(new Tok((int)var3_4, "", "", charI, columnI, true, null));
        return ImmutableList.copyOf(toks);
    }

    /*
     * WARNING - void declaration
     */
    private static int updateColumn(int columnI, String originalTokText) {
        int n;
        void var1_1;
        void var2_2;
        Integer last = Iterators.getLast(Newlines.lineOffsetIterator(originalTokText));
        columnI = last > 0 ? originalTokText.length() - var2_2.intValue() : (columnI += var1_1.length());
        return n;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static ImmutableList<Token> buildTokens(List<Tok> toks) {
        tokens = ImmutableList.builder();
        k = 0;
        kN = toks.size();
        toksBefore /* !! */  = ImmutableList.builder();
        block14: while (k < kN) {
            while (!toks.get(k).isToken()) {
                tok = toks.get(k++);
                toksBefore /* !! */ .add(tok);
                if (!JavaInput.isParamComment(tok)) continue;
                while (toks.get(k).isNewline()) {
                    ++k;
                }
            }
            tok = toks.get(k++);
            toksAfter = ImmutableList.builder();
            block17: while (k < kN && !toks.get(k).isToken()) {
                if (!toks.get(k).isSlashStarComment()) ** GOTO lbl-1000
                var7_7 = tok.getText();
                var8_8 = -1;
                switch (var7_7.hashCode()) {
                    case 40: {
                        if (!var7_7.equals("(")) break;
                        var8_8 = 0;
                        break;
                    }
                    case 60: {
                        if (!var7_7.equals("<")) break;
                        var8_8 = 1;
                        break;
                    }
                    case 46: {
                        if (!var7_7.equals(".")) break;
                        var8_8 = 2;
                    }
                }
                switch (var8_8) {
                    case 0: 
                    case 1: 
                    case 2: {
                        break block17;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        if (toks.get(k).isJavadocComment()) {
                            var7_7 = tok.getText();
                            var8_8 = -1;
                            switch (var7_7.hashCode()) {
                                case 59: {
                                    if (!var7_7.equals(";")) break;
                                    var8_8 = 0;
                                }
                            }
                            switch (var8_8) {
                                case 0: {
                                    break block17;
                                }
                            }
                        }
                        if (JavaInput.isParamComment(toks.get(k))) {
                            tokens.add(new Token(toksBefore /* !! */ .build(), tok, toksAfter.build()));
                            toksBefore /* !! */  = ImmutableList.builder().add(toks.get(k++));
                            while (toks.get(k).isNewline()) {
                                ++k;
                            }
                            continue block14;
                        }
                        nonTokenAfter = toks.get(k++);
                        toksAfter.add(nonTokenAfter);
                        if (!Newlines.containsBreaks(nonTokenAfter.getText())) continue block17;
                    }
                }
            }
            tokens.add(new Token(toksBefore /* !! */ .build(), tok, toksAfter.build()));
            toksBefore /* !! */  = ImmutableList.builder();
        }
        return var1_1.build();
    }

    private static boolean isParamComment(Tok tok) {
        Tok tok2;
        return tok.isSlashStarComment() && tok2.getText().matches("\\/\\*[A-Za-z0-9\\s_\\-]+=\\s*\\*\\/");
    }

    /*
     * WARNING - void declaration
     */
    final Range<Integer> characterRangeToTokenRange(Range<Integer> characterRange) throws FormatterException {
        void var1_1;
        void nonEmptyRange;
        if (characterRange.upperEndpoint() > this.text.length()) {
            throw new FormatterException(String.format("error: invalid offset (%d) or length (%d); offset + length (%d) > file length (%d)", characterRange.lowerEndpoint(), characterRange.upperEndpoint() - characterRange.lowerEndpoint(), characterRange.upperEndpoint(), this.text.length()));
        }
        nonEmptyRange = characterRange.isEmpty() ? Range.closedOpen(characterRange.lowerEndpoint(), characterRange.lowerEndpoint() + 1) : nonEmptyRange;
        Collection enclosed = ((ImmutableMap)((Input)this).getPositionTokenMap().subRangeMap((Range<Integer>)nonEmptyRange).asMapOfRanges()).values();
        if (((AbstractCollection)enclosed).isEmpty()) {
            return EMPTY_RANGE;
        }
        return Range.closedOpen(((Token)((ImmutableCollection)enclosed).iterator().next()).getTok().getIndex(), ((Token)Iterables.getLast(var1_1)).getTok().getIndex() + 1);
    }

    @Override
    public final int getkN() {
        return this.kN;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Token getToken(int k) {
        void var1_1;
        return this.kToToken[var1_1];
    }

    @Override
    public final ImmutableList<? extends Input.Token> getTokens() {
        return this.tokens;
    }

    public final ImmutableRangeMap<Integer, Token> getPositionTokenMap() {
        return this.positionTokenMap;
    }

    @Override
    public final String toString() {
        return MoreObjects.toStringHelper(this).add("tokens", this.tokens).add("super", super.toString()).toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getLineNumber(int inputPosition) {
        void var1_1;
        Verify.verifyNotNull(this.unit, "Expected compilation unit to be set.", new Object[0]);
        return this.unit.getLineMap().getLineNumber((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getColumnNumber(int inputPosition) {
        void var1_1;
        Verify.verifyNotNull(this.unit, "Expected compilation unit to be set.", new Object[0]);
        return this.unit.getLineMap().getColumnNumber((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setCompilationUnit(JCTree.JCCompilationUnit unit) {
        void var1_1;
        this.unit = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final RangeSet<Integer> characterRangesToTokenRanges(Collection<Range<Integer>> characterRanges) throws FormatterException {
        void var2_2;
        Iterator iterator;
        TreeRangeSet<Integer> tokenRangeSet = TreeRangeSet.create();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            Range characterRange = (Range)iterator.next();
            tokenRangeSet.add(this.characterRangeToTokenRange(var3_3.canonical(DiscreteDomain.integers$69c50eee())));
        }
        return var2_2;
    }

    static final class Token
    implements Input.Token {
        private final Tok tok;
        private final ImmutableList<Tok> toksBefore;
        private final ImmutableList<Tok> toksAfter;

        /*
         * WARNING - void declaration
         */
        Token(List<Tok> toksBefore, Tok tok, List<Tok> toksAfter) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.toksBefore = ImmutableList.copyOf(var1_1);
            this.tok = var2_2;
            this.toksAfter = ImmutableList.copyOf(var3_3);
        }

        @Override
        public final Tok getTok() {
            return this.tok;
        }

        @Override
        public final ImmutableList<? extends Input.Tok> getToksBefore() {
            return this.toksBefore;
        }

        @Override
        public final ImmutableList<? extends Input.Tok> getToksAfter() {
            return this.toksAfter;
        }

        public final String toString() {
            return MoreObjects.toStringHelper(this).add("tok", this.tok).add("toksBefore", this.toksBefore).add("toksAfter", this.toksAfter).toString();
        }
    }

    static final class Tok
    implements Input.Tok {
        private final int index;
        private final String originalText;
        private final String text;
        private final int position;
        private final int columnI;
        private final boolean isToken;
        private final Tokens.TokenKind kind;

        /*
         * WARNING - void declaration
         */
        Tok(int index, String originalText, String text, int position, int columnI, boolean isToken, Tokens.TokenKind kind) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.index = var1_1;
            this.originalText = var2_2;
            this.text = var3_3;
            this.position = position;
            this.columnI = columnI;
            this.isToken = isToken;
            this.kind = kind;
        }

        @Override
        public final int getIndex() {
            return this.index;
        }

        @Override
        public final String getText() {
            return this.text;
        }

        @Override
        public final String getOriginalText() {
            return this.originalText;
        }

        @Override
        public final int length() {
            return this.originalText.length();
        }

        @Override
        public final int getPosition() {
            return this.position;
        }

        @Override
        public final int getColumn() {
            return this.columnI;
        }

        final boolean isToken() {
            return this.isToken;
        }

        @Override
        public final boolean isNewline() {
            return Newlines.isNewline(this.text);
        }

        @Override
        public final boolean isSlashSlashComment() {
            return this.text.startsWith("//");
        }

        @Override
        public final boolean isSlashStarComment() {
            return this.text.startsWith("/*");
        }

        @Override
        public final boolean isJavadocComment() {
            return this.text.startsWith("/**") && this.text.charAt(3) != '*' && this.text.length() > 4;
        }

        @Override
        public final boolean isComment() {
            return this.isSlashSlashComment() || this.isSlashStarComment();
        }

        public final String toString() {
            return MoreObjects.toStringHelper(this).add("index", this.index).add("text", this.text).add("position", this.position).add("columnI", this.columnI).add("isToken", this.isToken).toString();
        }

        public final Tokens.TokenKind kind() {
            return this.kind;
        }
    }
}

