/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.auto.value.AutoOneOf;
import com.google.auto.value.AutoValue;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multiset;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.Range;
import com.google.common.collect.Streams;
import com.google.common.collect.TreeRangeSet;
import com.google.googlejavaformat.CloseOp;
import com.google.googlejavaformat.Doc;
import com.google.googlejavaformat.FormattingError;
import com.google.googlejavaformat.Indent;
import com.google.googlejavaformat.Input;
import com.google.googlejavaformat.Op;
import com.google.googlejavaformat.OpenOp;
import com.google.googlejavaformat.OpsBuilder;
import com.google.googlejavaformat.Output;
import com.google.googlejavaformat.java.AutoOneOf_JavaInputAstVisitor_AnnotationOrModifier;
import com.google.googlejavaformat.java.AutoValue_JavaInputAstVisitor_DeclarationModifiersAndTypeAnnotations;
import com.google.googlejavaformat.java.DimensionHelpers;
import com.google.googlejavaformat.java.Trees;
import com.google.googlejavaformat.java.TypeNameClassifier;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DirectiveTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExportsTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.IntersectionTypeTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.ModuleTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.OpensTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ProvidesTree;
import com.sun.source.tree.RequiresTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.UnionTypeTree;
import com.sun.source.tree.UsesTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Name;
import org.jspecify.annotations.Nullable;

public class JavaInputAstVisitor
extends TreePathScanner<Void, Void> {
    private static final ImmutableMultimap<String, String> TYPE_ANNOTATIONS = JavaInputAstVisitor.typeAnnotations();
    protected final OpsBuilder builder;
    protected static final Indent.Const ZERO = Indent.Const.ZERO;
    protected final int indentMultiplier;
    protected final Indent.Const minusTwo;
    protected final Indent.Const minusFour;
    protected final Indent.Const plusTwo;
    protected final Indent.Const plusFour;
    private final Set<Name> typeAnnotationSimpleNames = new HashSet<Name>();
    private static final int MAX_ITEM_LENGTH_FOR_FILLING = 10;
    private final Deque<Boolean> inExpression = new ArrayDeque<Boolean>(ImmutableList.of$714caac3((Object)Boolean.FALSE));
    protected static final long COMPACT_RECORD_CONSTRUCTOR = 0x8000000000000L;
    protected static final long RECORD = 0x2000000000000000L;
    static final ImmutableSet<String> LOG_METHODS = ImmutableSet.of("at", "atConfig", "atDebug", "atFine", "atFiner", "atFinest", new String[]{"atInfo", "atMostEvery", "atSevere", "atWarning", "every", "log", "logVarargs", "perUnique", "withCause", "withStackTrace"});
    private static final Pattern FORMAT_SPECIFIER = Pattern.compile("%|\\{[0-9]\\}");

    /*
     * WARNING - void declaration
     */
    private static ImmutableSetMultimap<String, String> typeAnnotations() {
        void var0;
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        for (String annotation : ImmutableList.of("org.jspecify.annotations.NonNull", "org.jspecify.annotations.Nullable", "org.jspecify.annotations.Nullable", "org.checkerframework.checker.nullness.qual.NonNull", "org.checkerframework.checker.nullness.qual.Nullable")) {
            void var2_2;
            void var3_3;
            String simpleName = annotation.substring(annotation.lastIndexOf(46) + 1);
            result.put((Object)var3_3, (Object)var2_2);
        }
        return var0.build();
    }

    private static final ImmutableList<Op> breakList(Optional<Output.BreakTag> breakTag) {
        Optional<Output.BreakTag> optional;
        return ImmutableList.of$714caac3((Object)Doc.Break.make(Doc.FillMode.UNIFIED, " ", ZERO, optional));
    }

    private static final ImmutableList<Op> breakFillList(Optional<Output.BreakTag> breakTag) {
        Optional<Output.BreakTag> optional;
        return ImmutableList.of$6786c105(OpenOp.make(ZERO), Doc.Break.make(Doc.FillMode.INDEPENDENT, " ", ZERO, optional), CloseOp.make());
    }

    private static final ImmutableList<Op> forceBreakList(Optional<Output.BreakTag> breakTag) {
        Optional<Output.BreakTag> optional;
        return ImmutableList.of$714caac3((Object)Doc.Break.make(Doc.FillMode.FORCED, "", Indent.Const.ZERO, optional));
    }

    /*
     * WARNING - void declaration
     */
    public JavaInputAstVisitor(OpsBuilder builder, int indentMultiplier) {
        void var2_2;
        void var1_1;
        this.builder = var1_1;
        this.indentMultiplier = indentMultiplier;
        this.minusTwo = Indent.Const.make(-2, indentMultiplier);
        this.minusFour = Indent.Const.make(-4, indentMultiplier);
        this.plusTwo = Indent.Const.make(2, indentMultiplier);
        this.plusFour = Indent.Const.make(4, (int)var2_2);
    }

    private boolean inExpression() {
        return this.inExpression.peekLast();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void scan(Tree tree, Void unused) {
        void var2_5;
        this.inExpression.addLast(tree instanceof ExpressionTree || this.inExpression.peekLast() != false);
        int previous = this.builder.depth();
        try {
            super.scan((Tree)tree, null);
        }
        catch (FormattingError formattingError) {
            tree = formattingError;
            throw formattingError;
        }
        catch (Throwable t) {
            void var1_2;
            throw new FormattingError(this.builder.diagnostic(Throwables.getStackTraceAsString((Throwable)var1_2)));
        }
        finally {
            this.inExpression.removeLast();
        }
        this.builder.checkClosed((int)var2_5);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitCompilationUnit(CompilationUnitTree node, Void unused) {
        void var1_1;
        void var2_3;
        boolean afterFirstToken = false;
        if (node.getPackageName() != null) {
            this.markForPartialFormat();
            this.visitPackage(node.getPackageName(), node.getPackageAnnotations());
            this.builder.forcedBreak();
            afterFirstToken = true;
        }
        this.dropEmptyDeclarations();
        if (!node.getImports().isEmpty()) {
            if (afterFirstToken) {
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.YES);
            }
            for (ImportTree importTree : node.getImports()) {
                this.markForPartialFormat();
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.PRESERVE);
                this.scan((Tree)importTree, null);
                this.builder.forcedBreak();
            }
            afterFirstToken = true;
        }
        this.dropEmptyDeclarations();
        for (Tree tree : node.getTypeDecls()) {
            if (tree.getKind() == Tree.Kind.IMPORT) continue;
            if (afterFirstToken) {
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.YES);
            }
            this.markForPartialFormat();
            this.scan(tree, null);
            this.builder.forcedBreak();
            afterFirstToken = true;
            this.dropEmptyDeclarations();
        }
        this.handleModule((boolean)var2_3, (CompilationUnitTree)var1_1);
        this.markForPartialFormat();
        return null;
    }

    protected void handleModule(boolean afterFirstToken, CompilationUnitTree node) {
    }

    protected void dropEmptyDeclarations() {
        if (this.builder.peekToken().equals(Optional.of(";"))) {
            while (this.builder.peekToken().equals(Optional.of(";"))) {
                this.builder.forcedBreak();
                this.markForPartialFormat();
                this.token(";");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitClass(ClassTree tree, Void unused) {
        switch (tree.getKind()) {
            case ANNOTATION_TYPE: {
                this.visitAnnotationType(tree);
                break;
            }
            case CLASS: 
            case INTERFACE: {
                this.visitClassDeclaration(tree);
                break;
            }
            case ENUM: {
                this.visitEnumDeclaration(tree);
                break;
            }
            default: {
                void var1_1;
                throw new AssertionError((Object)var1_1.getKind());
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void visitAnnotationType(ClassTree node) {
        this.sync(node);
        this.builder.open(ZERO);
        this.typeDeclarationModifiers(node.getModifiers());
        this.builder.open(ZERO);
        this.token("@");
        this.token("interface");
        this.builder.breakOp(" ");
        this.visit(node.getSimpleName());
        this.builder.close();
        this.builder.close();
        if (node.getMembers() == null) {
            this.builder.open(this.plusFour);
            this.token(";");
            this.builder.close();
        } else {
            void var1_1;
            this.addBodyDeclarations(var1_1.getMembers(), BracesOrNot.YES, FirstDeclarationsOrNot.YES);
        }
        this.builder.guessToken(";");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitArrayAccess(ArrayAccessTree node, Void unused) {
        void var1_1;
        this.sync(node);
        this.visitDot((ExpressionTree)var1_1);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitNewArray(NewArrayTree node, Void unused) {
        if (node.getType() != null) {
            void var3_3;
            void var2_2;
            this.builder.open(this.plusFour);
            this.token("new");
            this.builder.space();
            DimensionHelpers.TypeWithDims extractedDims = DimensionHelpers.extractDims(node.getType(), DimensionHelpers.SortedDims.YES);
            Tree base = extractedDims.node;
            ArrayDeque<ExpressionTree> dimExpressions = new ArrayDeque<ExpressionTree>(node.getDimensions());
            ArrayDeque<List<? extends AnnotationTree>> annotations = new ArrayDeque<List<? extends AnnotationTree>>();
            annotations.add(ImmutableList.copyOf(node.getAnnotations()));
            annotations.addAll(node.getDimAnnotations());
            annotations.addAll(var2_2.dims);
            this.scan((Tree)var3_3, null);
            this.builder.open(ZERO);
            this.maybeAddDims(dimExpressions, annotations);
            this.builder.close();
            this.builder.close();
        }
        if (node.getInitializers() != null) {
            void var1_1;
            if (node.getType() != null) {
                this.builder.space();
            }
            this.visitArrayInitializer(var1_1.getInitializers());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public boolean visitArrayInitializer(List<? extends ExpressionTree> expressions) {
        if (expressions.isEmpty()) {
            this.tokenBreakTrailingComment("{", this.plusTwo);
            if (this.builder.peekToken().equals(Optional.of(","))) {
                this.token(",");
            }
            this.token("}", this.plusTwo);
        } else {
            int cols = this.argumentsAreTabular(expressions);
            if (cols != -1) {
                this.builder.open(this.plusTwo);
                this.token("{");
                this.builder.forcedBreak();
                boolean afterFirstToken = false;
                for (Iterable row : Iterables.partition$79fc6ffa(expressions, (int)cols)) {
                    if (afterFirstToken) {
                        this.builder.forcedBreak();
                    }
                    this.builder.open(((ExpressionTree)row.iterator().next()).getKind() == Tree.Kind.NEW_ARRAY || cols == 1 ? ZERO : this.plusFour);
                    boolean firstInRow = true;
                    for (ExpressionTree item : row) {
                        if (!firstInRow) {
                            this.token(",");
                            this.builder.breakToFill(" ");
                        }
                        this.scan((Tree)item, null);
                        firstInRow = false;
                    }
                    this.builder.guessToken(",");
                    this.builder.close();
                    firstInRow = true;
                }
                this.builder.breakOp(this.minusTwo);
                this.builder.close();
                this.token("}", this.plusTwo);
            } else {
                void var3_5;
                Iterator iterator;
                boolean shortItems;
                boolean inMemberValuePair = false;
                TreePath path = this.getCurrentPath();
                for (int i = 0; i < 2 && path != null; path = path.getParentPath(), ++i) {
                    if (path.getLeaf().getKind() != Tree.Kind.ANNOTATION) continue;
                    inMemberValuePair = true;
                    break;
                }
                boolean allowFilledElementsOnOwnLine = (shortItems = this.hasOnlyShortItems(expressions)) || !inMemberValuePair;
                this.builder.open(this.plusTwo);
                this.tokenBreakTrailingComment("{", this.plusTwo);
                JavaInputAstVisitor javaInputAstVisitor = this;
                boolean hasTrailingComma = javaInputAstVisitor.hasTrailingToken(javaInputAstVisitor.builder.getInput(), expressions, ",");
                this.builder.breakOp(hasTrailingComma ? Doc.FillMode.FORCED : Doc.FillMode.UNIFIED, "", ZERO);
                if (allowFilledElementsOnOwnLine) {
                    this.builder.open(ZERO);
                }
                boolean afterFirstToken = false;
                Doc.FillMode fillMode = shortItems ? Doc.FillMode.INDEPENDENT : Doc.FillMode.UNIFIED;
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    ExpressionTree expression = (ExpressionTree)iterator.next();
                    if (afterFirstToken) {
                        this.token(",");
                        this.builder.breakOp(fillMode, " ", ZERO);
                    }
                    this.scan((Tree)expression, null);
                    afterFirstToken = true;
                }
                this.builder.guessToken(",");
                if (var3_5 != false) {
                    this.builder.close();
                }
                this.builder.breakOp(this.minusTwo);
                this.builder.close();
                this.token("}", this.plusTwo);
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean hasOnlyShortItems(List<? extends ExpressionTree> expressions) {
        for (ExpressionTree expressionTree : expressions) {
            void var3_3;
            int startPosition = Trees.getStartPosition(expressionTree);
            if (this.builder.actualSize(startPosition, Trees.getEndPosition(expressionTree, this.getCurrentPath()) - var3_3) < 10) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitArrayType(ArrayTypeTree node, Void unused) {
        void var1_1;
        this.sync(node);
        this.visitAnnotatedArrayType((Tree)var1_1);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void visitAnnotatedArrayType(Tree node) {
        void var1_1;
        DimensionHelpers.TypeWithDims extractedDims = DimensionHelpers.extractDims(node, DimensionHelpers.SortedDims.YES);
        this.builder.open(this.plusFour);
        this.scan(extractedDims.node, null);
        ArrayDeque<List<? extends AnnotationTree>> dims = new ArrayDeque<List<? extends AnnotationTree>>(extractedDims.dims);
        this.maybeAddDims(dims);
        Verify.verify(var1_1.isEmpty());
        this.builder.close();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitAssert(AssertTree node, Void unused) {
        this.sync(node);
        this.builder.open(ZERO);
        this.token("assert");
        this.builder.space();
        this.builder.open(node.getDetail() == null ? ZERO : this.plusFour);
        this.scan((Tree)node.getCondition(), null);
        if (node.getDetail() != null) {
            void var1_1;
            this.builder.breakOp(" ");
            this.token(":");
            this.builder.space();
            this.scan((Tree)var1_1.getDetail(), null);
        }
        this.builder.close();
        this.builder.close();
        this.token(";");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitAssignment(AssignmentTree node, Void unused) {
        void var1_1;
        this.sync(node);
        this.builder.open(this.plusFour);
        this.scan((Tree)node.getVariable(), null);
        this.builder.space();
        this.splitToken(Trees.operatorName(node));
        this.builder.breakOp(" ");
        this.scan((Tree)var1_1.getExpression(), null);
        this.builder.close();
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitBlock(BlockTree node, Void unused) {
        void var1_1;
        this.visitBlock((BlockTree)var1_1, CollapseEmptyOrNot.NO, AllowLeadingBlankLine.NO, AllowTrailingBlankLine.NO);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitCompoundAssignment(CompoundAssignmentTree node, Void unused) {
        void var1_1;
        this.sync(node);
        this.builder.open(this.plusFour);
        this.scan((Tree)node.getVariable(), null);
        this.builder.space();
        this.splitToken(Trees.operatorName(node));
        this.builder.breakOp(" ");
        this.scan((Tree)var1_1.getExpression(), null);
        this.builder.close();
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitBreak(BreakTree node, Void unused) {
        this.sync(node);
        this.builder.open(this.plusFour);
        this.token("break");
        if (node.getLabel() != null) {
            void var1_1;
            this.builder.breakOp(" ");
            this.visit(var1_1.getLabel());
        }
        this.builder.close();
        this.token(";");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitTypeCast(TypeCastTree node, Void unused) {
        void var1_1;
        this.sync(node);
        this.builder.open(this.plusFour);
        this.token("(");
        this.scan(node.getType(), null);
        this.token(")");
        this.builder.breakOp(" ");
        this.scan((Tree)var1_1.getExpression(), null);
        this.builder.close();
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitNewClass(NewClassTree node, Void unused) {
        this.sync(node);
        this.builder.open(ZERO);
        if (node.getEnclosingExpression() != null) {
            this.scan((Tree)node.getEnclosingExpression(), null);
            this.builder.breakOp();
            this.token(".");
        }
        this.token("new");
        this.builder.space();
        this.addTypeArguments(node.getTypeArguments(), this.plusFour);
        if (node.getClassBody() != null) {
            void var2_2;
            ImmutableList<AnnotationTree> annotations = this.visitModifiers(node.getClassBody().getModifiers(), Direction.HORIZONTAL, Optional.empty());
            this.visitAnnotations((List<? extends AnnotationTree>)var2_2, BreakOrNot.NO, BreakOrNot.YES);
        }
        this.scan((Tree)node.getIdentifier(), null);
        this.addArguments(node.getArguments(), this.plusFour);
        this.builder.close();
        if (node.getClassBody() != null) {
            void var1_1;
            this.addBodyDeclarations(var1_1.getClassBody().getMembers(), BracesOrNot.YES, FirstDeclarationsOrNot.YES);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitConditionalExpression(ConditionalExpressionTree node, Void unused) {
        void var1_1;
        this.sync(node);
        this.builder.open(this.plusFour);
        this.scan((Tree)node.getCondition(), null);
        this.builder.breakOp(" ");
        this.token("?");
        this.builder.space();
        this.scan((Tree)node.getTrueExpression(), null);
        this.builder.breakOp(" ");
        this.token(":");
        this.builder.space();
        this.scan((Tree)var1_1.getFalseExpression(), null);
        this.builder.close();
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitContinue(ContinueTree node, Void unused) {
        this.sync(node);
        this.builder.open(this.plusFour);
        this.token("continue");
        if (node.getLabel() != null) {
            void var1_1;
            this.builder.breakOp(" ");
            this.visit(var1_1.getLabel());
        }
        this.token(";");
        this.builder.close();
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitDoWhileLoop(DoWhileLoopTree node, Void unused) {
        void var1_1;
        this.sync(node);
        this.token("do");
        this.visitStatement(node.getStatement(), CollapseEmptyOrNot.YES, AllowLeadingBlankLine.YES, AllowTrailingBlankLine.YES);
        if (node.getStatement().getKind() == Tree.Kind.BLOCK) {
            this.builder.space();
        } else {
            this.builder.breakOp(" ");
        }
        this.token("while");
        this.builder.space();
        this.token("(");
        this.scan((Tree)Trees.skipParen(var1_1.getCondition()), null);
        this.token(")");
        this.token(";");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitEmptyStatement(EmptyStatementTree node, Void unused) {
        void var1_1;
        this.sync((Tree)var1_1);
        this.dropEmptyDeclarations();
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitEnhancedForLoop(EnhancedForLoopTree node, Void unused) {
        void var1_1;
        this.sync(node);
        this.builder.open(ZERO);
        this.token("for");
        this.builder.space();
        this.token("(");
        this.builder.open(ZERO);
        this.visitToDeclare(DeclarationKind.NONE, Direction.HORIZONTAL, node.getVariable(), Optional.of(node.getExpression()), ":", Optional.empty());
        this.builder.close();
        this.token(")");
        this.builder.close();
        this.visitStatement(var1_1.getStatement(), CollapseEmptyOrNot.YES, AllowLeadingBlankLine.YES, AllowTrailingBlankLine.NO);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void visitEnumConstantDeclaration(VariableTree enumConstant) {
        void var1_1;
        Iterator<? extends AnnotationTree> iterator = enumConstant.getModifiers().getAnnotations().iterator();
        while (iterator.hasNext()) {
            void var3_3;
            AnnotationTree annotation = iterator.next();
            this.scan((Tree)var3_3, null);
            this.builder.forcedBreak();
        }
        this.visit(enumConstant.getName());
        NewClassTree init = (NewClassTree)var1_1.getInitializer();
        if (init.getArguments().isEmpty()) {
            this.builder.guessToken("(");
            this.builder.guessToken(")");
        } else {
            this.addArguments(init.getArguments(), this.plusFour);
        }
        if (init.getClassBody() != null) {
            this.addBodyDeclarations(iterator.getClassBody().getMembers(), BracesOrNot.YES, FirstDeclarationsOrNot.YES);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean visitEnumDeclaration(ClassTree node) {
        Iterator<? extends Tree> iterator;
        this.sync(node);
        this.builder.open(ZERO);
        this.typeDeclarationModifiers(node.getModifiers());
        this.builder.open(this.plusFour);
        this.token("enum");
        this.builder.breakOp(" ");
        this.visit(node.getSimpleName());
        this.builder.close();
        this.builder.close();
        if (!node.getImplementsClause().isEmpty()) {
            this.builder.open(this.plusFour);
            this.builder.breakOp(" ");
            this.builder.open(this.plusFour);
            this.token("implements");
            this.builder.breakOp(" ");
            this.builder.open(ZERO);
            boolean afterFirstToken = false;
            iterator = node.getImplementsClause().iterator();
            while (iterator.hasNext()) {
                Tree superInterfaceType = iterator.next();
                if (afterFirstToken) {
                    this.token(",");
                    this.builder.breakToFill(" ");
                }
                this.scan(superInterfaceType, null);
                afterFirstToken = true;
            }
            this.builder.close();
            this.builder.close();
            this.builder.close();
        }
        this.builder.space();
        this.tokenBreakTrailingComment("{", this.plusTwo);
        ArrayList<JCTree.JCVariableDecl> enumConstants = new ArrayList<JCTree.JCVariableDecl>();
        ArrayList<void> members = new ArrayList<void>();
        for (Tree member : node.getMembers()) {
            void var1_3;
            if (member instanceof JCTree.JCVariableDecl) {
                JCTree.JCVariableDecl variableDecl = (JCTree.JCVariableDecl)member;
                if ((variableDecl.mods.flags & 0x4000L) == 16384L) {
                    enumConstants.add(variableDecl);
                    continue;
                }
            }
            members.add(var1_3);
        }
        if (enumConstants.isEmpty() && members.isEmpty()) {
            if (this.builder.peekToken().equals(Optional.of(";"))) {
                this.builder.open(this.plusTwo);
                this.builder.forcedBreak();
                this.token(";");
                this.builder.forcedBreak();
                this.dropEmptyDeclarations();
                this.builder.close();
                this.builder.open(ZERO);
                this.builder.forcedBreak();
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
                this.token("}", this.plusTwo);
                this.builder.close();
            } else {
                this.builder.open(ZERO);
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
                this.token("}");
                this.builder.close();
            }
        } else {
            void var2_6;
            this.builder.open(this.plusTwo);
            this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
            this.builder.forcedBreak();
            this.builder.open(ZERO);
            boolean afterFirstToken = false;
            for (VariableTree enumConstant : var2_6) {
                if (afterFirstToken) {
                    this.token(",");
                    this.builder.forcedBreak();
                    this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.PRESERVE);
                }
                this.markForPartialFormat();
                this.visitEnumConstantDeclaration(enumConstant);
                afterFirstToken = true;
            }
            if (this.builder.peekToken().orElse("").equals(",")) {
                this.token(",");
                this.builder.forcedBreak();
            }
            this.builder.close();
            this.builder.close();
            if (this.builder.peekToken().equals(Optional.of(";"))) {
                this.builder.open(this.plusTwo);
                this.token(";");
                this.builder.forcedBreak();
                this.dropEmptyDeclarations();
                this.builder.close();
            }
            this.builder.open(ZERO);
            this.addBodyDeclarations((List<? extends Tree>)((Object)iterator), BracesOrNot.NO, FirstDeclarationsOrNot.NO);
            this.builder.forcedBreak();
            this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
            this.token("}", this.plusTwo);
            this.builder.close();
        }
        this.builder.guessToken(";");
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitMemberReference(MemberReferenceTree node, Void unused) {
        this.builder.open(this.plusFour);
        this.scan((Tree)node.getQualifierExpression(), null);
        this.builder.breakOp();
        this.builder.op("::");
        this.addTypeArguments(node.getTypeArguments(), this.plusFour);
        switch (node.getMode()) {
            case INVOKE: {
                this.visit(node.getName());
                break;
            }
            case NEW: {
                this.token("new");
                break;
            }
            default: {
                void var1_1;
                throw new AssertionError((Object)var1_1.getMode());
            }
        }
        this.builder.close();
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitExpressionStatement(ExpressionStatementTree node, Void unused) {
        void var1_1;
        this.sync(node);
        this.scan((Tree)var1_1.getExpression(), null);
        this.token(";");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitVariable(VariableTree node, Void unused) {
        void var1_1;
        this.sync(node);
        this.visitVariables(ImmutableList.of$714caac3((Object)node), DeclarationKind.NONE, JavaInputAstVisitor.fieldAnnotationDirection(var1_1.getModifiers()));
        return null;
    }

    /*
     * WARNING - void declaration
     */
    void visitVariables(List<VariableTree> fragments, DeclarationKind declarationKind, Direction annotationDirection) {
        void var3_3;
        void var1_1;
        if (fragments.size() == 1) {
            void var2_2;
            VariableTree fragment = fragments.get(0);
            this.declareOne((DeclarationKind)var2_2, annotationDirection, Optional.of(fragment.getModifiers()), fragment.getType(), fragment.getName(), "", "=", Optional.ofNullable(fragment.getInitializer()), Optional.of(";"), Optional.empty(), Optional.ofNullable(JavaInputAstVisitor.variableFragmentDims(false, 0, var1_1.getType())));
            return;
        }
        this.declareMany((List<VariableTree>)var1_1, (Direction)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static DimensionHelpers.TypeWithDims variableFragmentDims(boolean afterFirstToken, int leadingDims, Tree type) {
        void var0_1;
        void var1_2;
        void var2_3;
        if (type == null) {
            return null;
        }
        if (!afterFirstToken) {
            return DimensionHelpers.extractDims(type, DimensionHelpers.SortedDims.YES);
        }
        DimensionHelpers.TypeWithDims dims = DimensionHelpers.extractDims((Tree)var2_3, DimensionHelpers.SortedDims.NO);
        return new DimensionHelpers.TypeWithDims(null, (ImmutableList<List<AnnotationTree>>)(leadingDims > 0 ? dims.dims.subList(0, dims.dims.size() - var1_2) : var0_1.dims));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitForLoop(ForLoopTree node, Void unused) {
        void var1_1;
        this.sync(node);
        this.token("for");
        this.builder.space();
        this.token("(");
        this.builder.open(this.plusFour);
        this.builder.open(node.getInitializer().size() > 1 && node.getInitializer().get(0).getKind() == Tree.Kind.EXPRESSION_STATEMENT ? this.plusFour : ZERO);
        if (!node.getInitializer().isEmpty()) {
            if (node.getInitializer().get(0).getKind() == Tree.Kind.VARIABLE) {
                Iterators.PeekingImpl it;
                Iterators.PeekingImpl peekingImpl = it = Iterators.peekingIterator$488b6d4d(node.getInitializer().iterator());
                this.visitVariables(JavaInputAstVisitor.variableFragments(peekingImpl, (Tree)peekingImpl.next()), DeclarationKind.NONE, Direction.HORIZONTAL);
            } else {
                boolean afterFirstToken = false;
                this.builder.open(ZERO);
                for (StatementTree statementTree : node.getInitializer()) {
                    if (afterFirstToken) {
                        this.token(",");
                        this.builder.breakOp(" ");
                    }
                    this.scan((Tree)((ExpressionStatementTree)statementTree).getExpression(), null);
                    afterFirstToken = true;
                }
                this.token(";");
                this.builder.close();
            }
        } else {
            this.token(";");
        }
        this.builder.close();
        this.builder.breakOp(" ");
        if (node.getCondition() != null) {
            this.scan((Tree)node.getCondition(), null);
        }
        this.token(";");
        if (!node.getUpdate().isEmpty()) {
            this.builder.breakOp(" ");
            this.builder.open(node.getUpdate().size() <= 1 ? ZERO : this.plusFour);
            boolean firstUpdater = true;
            for (ExpressionStatementTree expressionStatementTree : node.getUpdate()) {
                if (!firstUpdater) {
                    this.token(",");
                    this.builder.breakToFill(" ");
                }
                this.scan((Tree)expressionStatementTree.getExpression(), null);
                firstUpdater = false;
            }
            this.builder.guessToken(";");
            this.builder.close();
        } else {
            this.builder.space();
        }
        this.builder.close();
        this.token(")");
        this.visitStatement(var1_1.getStatement(), CollapseEmptyOrNot.YES, AllowLeadingBlankLine.YES, AllowTrailingBlankLine.NO);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitIf(IfTree node, Void unused) {
        boolean bl;
        this.sync(node);
        ArrayList<ExpressionTree> expressions = new ArrayList<ExpressionTree>();
        ArrayList<StatementTree> statements = new ArrayList<StatementTree>();
        while (true) {
            expressions.add(node.getCondition());
            statements.add(node.getThenStatement());
            if (node.getElseStatement() == null || node.getElseStatement().getKind() != Tree.Kind.IF) break;
            node = (IfTree)node.getElseStatement();
        }
        this.builder.open(ZERO);
        boolean afterFirstToken = false;
        boolean followingBlock = false;
        int expressionsN = expressions.size();
        for (int i = 0; i < expressionsN; ++i) {
            if (afterFirstToken) {
                if (followingBlock) {
                    this.builder.space();
                } else {
                    this.builder.forcedBreak();
                }
                this.token("else");
                this.builder.space();
            }
            this.token("if");
            this.builder.space();
            this.token("(");
            this.scan((Tree)Trees.skipParen((ExpressionTree)expressions.get(i)), null);
            this.token(")");
            boolean onlyClause = expressionsN == 1 && node.getElseStatement() == null;
            boolean trailingClauses = i < expressionsN - 1 || node.getElseStatement() != null;
            this.visitStatement((StatementTree)statements.get(i), CollapseEmptyOrNot.valueOf(onlyClause), AllowLeadingBlankLine.YES, AllowTrailingBlankLine.valueOf(trailingClauses));
            bl = ((StatementTree)statements.get(i)).getKind() == Tree.Kind.BLOCK;
            boolean bl2 = true;
        }
        if (node.getElseStatement() != null) {
            void var1_1;
            if (bl) {
                this.builder.space();
            } else {
                this.builder.forcedBreak();
            }
            this.token("else");
            this.visitStatement(var1_1.getElseStatement(), CollapseEmptyOrNot.NO, AllowLeadingBlankLine.YES, AllowTrailingBlankLine.NO);
        }
        this.builder.close();
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitImport(ImportTree node, Void unused) {
        void var1_1;
        this.checkForTypeAnnotation(node);
        this.sync(node);
        this.token("import");
        this.builder.space();
        if (node.isStatic()) {
            this.token("static");
            this.builder.space();
        }
        this.visitName(var1_1.getQualifiedIdentifier());
        this.token(";");
        this.dropEmptyDeclarations();
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void checkForTypeAnnotation(ImportTree node) {
        void var1_1;
        void var3_3;
        Name simpleName = JavaInputAstVisitor.getSimpleName(node);
        ImmutableSet wellKnownAnnotations = TYPE_ANNOTATIONS.get$513c843(simpleName.toString());
        if (!wellKnownAnnotations.isEmpty() && var3_3.contains(var1_1.getQualifiedIdentifier().toString())) {
            void var2_2;
            this.typeAnnotationSimpleNames.add((Name)var2_2);
        }
    }

    private static Name getSimpleName(ImportTree importTree) {
        ImportTree importTree2;
        if (importTree.getQualifiedIdentifier() instanceof IdentifierTree) {
            return ((IdentifierTree)importTree.getQualifiedIdentifier()).getName();
        }
        return ((MemberSelectTree)importTree2.getQualifiedIdentifier()).getIdentifier();
    }

    @Override
    public Void visitBinary(BinaryTree node, Void unused) {
        this.sync(node);
        ArrayList<ExpressionTree> operands = new ArrayList<ExpressionTree>();
        ArrayList<String> operators = new ArrayList<String>();
        JavaInputAstVisitor.walkInfix(Trees.precedence(node), node, operands, operators);
        Doc.FillMode fillMode = this.hasOnlyShortItems(operands) ? Doc.FillMode.INDEPENDENT : Doc.FillMode.UNIFIED;
        this.builder.open(this.plusFour);
        this.scan((Tree)operands.get(0), null);
        int operatorsN = operators.size();
        for (int i = 0; i < operatorsN; ++i) {
            this.builder.breakOp(fillMode, " ", ZERO);
            this.builder.op((String)operators.get(i));
            this.builder.space();
            this.scan((Tree)operands.get(i + 1), null);
        }
        this.builder.close();
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitInstanceOf(InstanceOfTree node, Void unused) {
        void var1_1;
        this.sync(node);
        this.builder.open(this.plusFour);
        this.scan((Tree)node.getExpression(), null);
        this.builder.breakOp(" ");
        this.builder.open(ZERO);
        this.token("instanceof");
        this.builder.breakOp(" ");
        this.scan(var1_1.getType(), null);
        this.builder.close();
        this.builder.close();
        return null;
    }

    @Override
    public Void visitIntersectionType(IntersectionTypeTree node, Void unused) {
        Iterator<? extends Tree> iterator;
        this.sync(node);
        this.builder.open(this.plusFour);
        boolean afterFirstToken = false;
        for (Tree tree : iterator.getBounds()) {
            if (afterFirstToken) {
                this.builder.breakToFill(" ");
                this.token("&");
                this.builder.space();
            }
            this.scan(tree, null);
            afterFirstToken = true;
        }
        this.builder.close();
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitLabeledStatement(LabeledStatementTree node, Void unused) {
        void var1_1;
        this.sync(node);
        this.builder.open(ZERO);
        this.visit(node.getLabel());
        this.token(":");
        this.builder.forcedBreak();
        this.builder.close();
        this.scan((Tree)var1_1.getStatement(), null);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitLambdaExpression(LambdaExpressionTree node, Void unused) {
        void var2_3;
        void var3_4;
        this.sync(node);
        boolean statementBody = node.getBodyKind() == LambdaExpressionTree.BodyKind.STATEMENT;
        boolean parens = this.builder.peekToken().equals(Optional.of("("));
        this.builder.open(parens ? this.plusFour : ZERO);
        if (parens) {
            this.token("(");
        }
        boolean afterFirstToken = false;
        for (VariableTree variableTree : node.getParameters()) {
            if (afterFirstToken) {
                this.token(",");
                this.builder.breakOp(" ");
            }
            this.visitVariables(ImmutableList.of$714caac3((Object)variableTree), DeclarationKind.NONE, JavaInputAstVisitor.fieldAnnotationDirection(variableTree.getModifiers()));
            afterFirstToken = true;
        }
        if (var3_4 != false) {
            this.token(")");
        }
        this.builder.close();
        this.builder.space();
        this.builder.op("->");
        this.builder.open(statementBody ? ZERO : this.plusFour);
        if (var2_3 != false) {
            this.builder.space();
        } else {
            this.builder.breakOp(" ");
        }
        if (node.getBody().getKind() == Tree.Kind.BLOCK) {
            this.visitBlock((BlockTree)node.getBody(), CollapseEmptyOrNot.YES, AllowLeadingBlankLine.NO, AllowTrailingBlankLine.NO);
        } else {
            void var1_1;
            this.scan(var1_1.getBody(), null);
        }
        this.builder.close();
        return null;
    }

    @Override
    public Void visitAnnotation(AnnotationTree node, Void unused) {
        this.sync(node);
        if (this.visitSingleMemberAnnotation(node)) {
            return null;
        }
        this.builder.open(ZERO);
        this.token("@");
        this.scan(node.getAnnotationType(), null);
        if (!node.getArguments().isEmpty()) {
            Iterator<? extends ExpressionTree> iterator;
            int n;
            boolean afterFirstToken;
            block11: {
                this.builder.open(this.plusFour);
                this.token("(");
                this.builder.breakOp();
                afterFirstToken = false;
                Predicate<ExpressionTree> predicate = JavaInputAstVisitor::isArrayValue;
                Iterator iterator2 = node.getArguments();
                Predicate<ExpressionTree> predicate2 = predicate;
                iterator2 = iterator2.iterator();
                Predicate<ExpressionTree> predicate3 = predicate2;
                Preconditions.checkNotNull(predicate3, "predicate");
                int n2 = 0;
                while (iterator2.hasNext()) {
                    Object t = iterator2.next();
                    if (predicate3.apply((ExpressionTree)t)) {
                        n = n2;
                        break block11;
                    }
                    ++n2;
                }
                n = -1;
            }
            boolean hasArrayInitializer = n != -1;
            for (ExpressionTree expressionTree : iterator.getArguments()) {
                if (afterFirstToken) {
                    this.token(",");
                    if (hasArrayInitializer) {
                        this.builder.forcedBreak();
                    } else {
                        this.builder.breakOp(" ");
                    }
                }
                if (expressionTree instanceof AssignmentTree) {
                    this.visitAnnotationArgument((AssignmentTree)expressionTree);
                } else {
                    this.scan((Tree)expressionTree, null);
                }
                afterFirstToken = true;
            }
            this.token(")");
            this.builder.close();
            this.builder.close();
            return null;
        }
        if (this.builder.peekToken().equals(Optional.of("("))) {
            this.token("(");
            this.token(")");
        }
        this.builder.close();
        return null;
    }

    private static boolean isArrayValue(ExpressionTree argument) {
        ExpressionTree expressionTree;
        if (!(argument instanceof AssignmentTree)) {
            return false;
        }
        ExpressionTree expression = ((AssignmentTree)argument).getExpression();
        return expression instanceof NewArrayTree && ((NewArrayTree)expressionTree).getType() == null;
    }

    /*
     * WARNING - void declaration
     */
    public void visitAnnotationArgument(AssignmentTree node) {
        void var1_1;
        void var2_2;
        boolean isArrayInitializer = node.getExpression().getKind() == Tree.Kind.NEW_ARRAY;
        this.sync(node);
        this.builder.open(isArrayInitializer ? ZERO : this.plusFour);
        this.scan((Tree)node.getVariable(), null);
        this.builder.space();
        this.token("=");
        if (var2_2 != false) {
            this.builder.space();
        } else {
            this.builder.breakOp(" ");
        }
        this.scan((Tree)var1_1.getExpression(), null);
        this.builder.close();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitAnnotatedType(AnnotatedTypeTree node, Void unused) {
        void var2_2;
        this.sync(node);
        ExpressionTree base = node.getUnderlyingType();
        if (base instanceof MemberSelectTree) {
            MemberSelectTree selectTree = (MemberSelectTree)base;
            this.scan((Tree)selectTree.getExpression(), null);
            this.token(".");
            BreakOrNot breakOrNot = BreakOrNot.NO;
            this.visitAnnotations(node.getAnnotations(), breakOrNot, breakOrNot);
            this.builder.breakToFill(" ");
            this.visit(var2_2.getIdentifier());
        } else if (var2_2 instanceof ArrayTypeTree) {
            this.visitAnnotatedArrayType(node);
        } else {
            void var1_1;
            BreakOrNot breakOrNot = BreakOrNot.NO;
            this.visitAnnotations(var1_1.getAnnotations(), breakOrNot, breakOrNot);
            this.builder.breakToFill(" ");
            this.scan((Tree)var2_2, null);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitMethod(MethodTree node, Void unused) {
        void var3_3;
        String name;
        boolean isRecordConstructor;
        this.sync(node);
        List<? extends AnnotationTree> annotations = node.getModifiers().getAnnotations();
        List<Object> returnTypeAnnotations = ImmutableList.of();
        boolean bl = isRecordConstructor = (((JCTree.JCMethodDecl)node).mods.flags & 0x8000000000000L) == 0x8000000000000L;
        if (!node.getTypeParameters().isEmpty() && !annotations.isEmpty()) {
            int typeParameterStart = Trees.getStartPosition(node.getTypeParameters().get(0));
            for (int i = 0; i < annotations.size(); ++i) {
                if (Trees.getStartPosition(annotations.get(i)) <= typeParameterStart) continue;
                returnTypeAnnotations = annotations.subList(i, annotations.size());
                annotations = annotations.subList(0, i);
                break;
            }
        }
        ImmutableList<AnnotationTree> typeAnnotations = this.visitModifiers(node.getModifiers(), annotations, Direction.VERTICAL, Optional.empty());
        if (node.getTypeParameters().isEmpty() && node.getReturnType() != null) {
            returnTypeAnnotations = typeAnnotations;
            typeAnnotations = ImmutableList.of();
        }
        Tree baseReturnType = null;
        ArrayDeque<List<? extends AnnotationTree>> dims = null;
        if (node.getReturnType() != null) {
            DimensionHelpers.TypeWithDims extractedDims = DimensionHelpers.extractDims(node.getReturnType(), DimensionHelpers.SortedDims.YES);
            baseReturnType = extractedDims.node;
            dims = new ArrayDeque<List<? extends AnnotationTree>>(extractedDims.dims);
        } else {
            this.verticalAnnotations(typeAnnotations);
            typeAnnotations = ImmutableList.of();
        }
        this.builder.open(this.plusFour);
        Output.BreakTag breakBeforeName = this.genSym();
        Output.BreakTag breakBeforeType = this.genSym();
        this.builder.open(ZERO);
        boolean afterFirstToken = false;
        if (!typeAnnotations.isEmpty()) {
            BreakOrNot breakOrNot = BreakOrNot.NO;
            this.visitAnnotations(typeAnnotations, breakOrNot, breakOrNot);
            afterFirstToken = true;
        }
        if (!node.getTypeParameters().isEmpty()) {
            if (afterFirstToken) {
                this.builder.breakToFill(" ");
            }
            this.token("<");
            this.typeParametersRest(node.getTypeParameters(), this.plusFour);
            afterFirstToken = true;
        }
        boolean openedNameAndTypeScope = false;
        if (baseReturnType != null) {
            if (afterFirstToken) {
                this.builder.breakOp(Doc.FillMode.INDEPENDENT, " ", ZERO, Optional.of(breakBeforeType));
            } else {
                afterFirstToken = true;
            }
            this.builder.open(Indent.If.make(breakBeforeType, this.plusFour, ZERO));
            openedNameAndTypeScope = true;
            this.builder.open(ZERO);
            if (!returnTypeAnnotations.isEmpty()) {
                BreakOrNot breakOrNot = BreakOrNot.NO;
                this.visitAnnotations(returnTypeAnnotations, breakOrNot, breakOrNot);
                this.builder.breakOp(" ");
            }
            this.scan(baseReturnType, null);
            this.maybeAddDims(dims);
            this.builder.close();
        }
        if (afterFirstToken) {
            this.builder.breakOp(Doc.FillMode.INDEPENDENT, " ", ZERO, Optional.of(breakBeforeName));
        }
        if (!openedNameAndTypeScope) {
            this.builder.open(ZERO);
        }
        if ((name = node.getName().toString()).equals("<init>")) {
            name = this.builder.peekToken().get();
        }
        this.token((String)var3_3);
        if (!isRecordConstructor) {
            this.token("(");
        }
        this.builder.close();
        this.builder.close();
        this.builder.open(Indent.If.make(breakBeforeName, this.plusFour, ZERO));
        this.builder.open(Indent.If.make(breakBeforeType, this.plusFour, ZERO));
        this.builder.open(ZERO);
        if (!isRecordConstructor) {
            if (!node.getParameters().isEmpty() || node.getReceiverParameter() != null) {
                this.builder.breakToFill("");
                this.visitFormals(Optional.ofNullable(node.getReceiverParameter()), node.getParameters());
            }
            this.token(")");
        }
        if (dims != null) {
            void var2_2;
            this.maybeAddDims((Deque<List<? extends AnnotationTree>>)var2_2);
        }
        if (!node.getThrows().isEmpty()) {
            this.builder.breakToFill(" ");
            this.builder.open(this.plusFour);
            this.visitThrowsClause(node.getThrows());
            this.builder.close();
        }
        if (node.getDefaultValue() != null) {
            this.builder.space();
            this.token("default");
            if (node.getDefaultValue().getKind() == Tree.Kind.NEW_ARRAY) {
                this.builder.open(this.minusFour);
                this.builder.space();
                this.scan(node.getDefaultValue(), null);
                this.builder.close();
            } else {
                this.builder.open(ZERO);
                this.builder.breakToFill(" ");
                this.scan(node.getDefaultValue(), null);
                this.builder.close();
            }
        }
        this.builder.close();
        this.builder.close();
        this.builder.close();
        if (node.getBody() == null) {
            this.token(";");
        } else {
            this.builder.space();
            this.builder.token("{", Doc.Token.RealOrImaginary.REAL, this.plusTwo, Optional.of(this.plusTwo));
        }
        this.builder.close();
        if (node.getBody() != null) {
            void var1_1;
            this.methodBody((MethodTree)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void methodBody(MethodTree node) {
        if (node.getBody().getStatements().isEmpty()) {
            this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
        } else {
            void var1_1;
            this.builder.open(this.plusTwo);
            this.builder.forcedBreak();
            this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.PRESERVE);
            this.visitStatements(var1_1.getBody().getStatements());
            this.builder.close();
            this.builder.forcedBreak();
            this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
            this.markForPartialFormat();
        }
        this.token("}", this.plusTwo);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitMethodInvocation(MethodInvocationTree node, Void unused) {
        void var1_1;
        this.sync(node);
        if (this.handleLogStatement(node)) {
            return null;
        }
        this.visitDot((ExpressionTree)var1_1);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private boolean handleLogStatement(MethodInvocationTree node) {
        void var2_2;
        ExpressionTree expressionTree;
        void curr;
        if (!Trees.getMethodName(node).contentEquals("log")) {
            return false;
        }
        ArrayDeque<Object> parts = new ArrayDeque<Object>();
        while (curr instanceof MethodInvocationTree) {
            MethodInvocationTree method = (MethodInvocationTree)curr;
            parts.addFirst(method);
            if (!LOG_METHODS.contains(Trees.getMethodName(method).toString())) {
                return false;
            }
            expressionTree = Trees.getMethodReceiver((MethodInvocationTree)expressionTree);
        }
        if (!(expressionTree instanceof IdentifierTree)) {
            return false;
        }
        parts.addFirst(expressionTree);
        this.visitDotWithPrefix(ImmutableList.copyOf(parts), false, ImmutableList.of$714caac3((Object)(var2_2.size() - 1)), Doc.FillMode.INDEPENDENT);
        return true;
    }

    private static List<Long> handleStream(List<ExpressionTree> parts) {
        return JavaInputAstVisitor.indexes(parts.stream(), p -> {
            Name name;
            if (!(p instanceof MethodInvocationTree)) {
                return false;
            }
            Name name2 = Trees.getMethodName((MethodInvocationTree)p);
            return Stream.of("stream", "parallelStream", "toBuilder").anyMatch(name::contentEquals);
        }).collect(Collectors.toList());
    }

    /*
     * WARNING - void declaration
     */
    private static <T> Stream<Long> indexes(Stream<T> stream, Predicate<T> predicate) {
        void var1_1;
        return Streams.mapWithIndex(stream, (arg_0, arg_1) -> JavaInputAstVisitor.lambda$indexes$1((Predicate)var1_1, arg_0, arg_1)).filter(x -> x != -1L);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitMemberSelect(MemberSelectTree node, Void unused) {
        void var1_1;
        this.sync(node);
        this.visitDot((ExpressionTree)var1_1);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitLiteral(LiteralTree node, Void unused) {
        void var1_1;
        this.sync(node);
        String sourceForNode = Trees.getSourceForNode(node, this.getCurrentPath());
        if (JavaInputAstVisitor.isUnaryMinusLiteral(sourceForNode)) {
            this.token("-");
            sourceForNode = sourceForNode.substring(1).trim();
        }
        this.token((String)var1_1);
        return null;
    }

    private static boolean isUnaryMinusLiteral(String literalTreeSource) {
        return literalTreeSource.startsWith("-");
    }

    /*
     * WARNING - void declaration
     */
    private void visitPackage(ExpressionTree packageName, List<? extends AnnotationTree> packageAnnotations) {
        void var1_1;
        if (!packageAnnotations.isEmpty()) {
            Iterator iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var3_3;
                AnnotationTree annotation = (AnnotationTree)iterator.next();
                this.builder.forcedBreak();
                this.scan((Tree)var3_3, null);
            }
            this.builder.forcedBreak();
        }
        this.builder.open(this.plusFour);
        this.token("package");
        this.builder.space();
        this.visitName((Tree)var1_1);
        this.builder.close();
        this.token(";");
    }

    @Override
    public Void visitParameterizedType(ParameterizedTypeTree node, Void unused) {
        this.sync(node);
        if (node.getTypeArguments().isEmpty()) {
            this.scan(node.getType(), null);
            this.token("<");
            this.token(">");
        } else {
            Iterator<? extends Tree> iterator;
            this.builder.open(this.plusFour);
            this.scan(node.getType(), null);
            this.token("<");
            this.builder.breakOp();
            this.builder.open(ZERO);
            boolean afterFirstToken = false;
            for (Tree tree : iterator.getTypeArguments()) {
                if (afterFirstToken) {
                    this.token(",");
                    this.builder.breakOp(" ");
                }
                this.scan(tree, null);
                afterFirstToken = true;
            }
            this.builder.close();
            this.builder.close();
            this.token(">");
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitParenthesized(ParenthesizedTree node, Void unused) {
        void var1_1;
        this.token("(");
        this.scan((Tree)var1_1.getExpression(), null);
        this.token(")");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitUnary(UnaryTree node, Void unused) {
        this.sync(node);
        String operatorName = Trees.operatorName(node);
        if (((JCTree)((Object)node)).getTag().isPostUnaryOp()) {
            this.scan((Tree)node.getExpression(), null);
            this.splitToken(operatorName);
        } else {
            void var1_1;
            void var2_2;
            this.splitToken(operatorName);
            if (this.ambiguousUnaryOperator(node, (String)var2_2)) {
                this.builder.space();
            }
            this.scan((Tree)var1_1.getExpression(), null);
        }
        return null;
    }

    private void splitToken(String operatorName) {
        for (int i = 0; i < operatorName.length(); ++i) {
            this.token(String.valueOf(operatorName.charAt(i)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean ambiguousUnaryOperator(UnaryTree node, String operatorName) {
        void var2_2;
        void var1_1;
        void var3_3;
        switch (node.getKind()) {
            case UNARY_MINUS: 
            case UNARY_PLUS: {
                break;
            }
            default: {
                return false;
            }
        }
        JCTree.Tag tag = this.unaryTag(node.getExpression());
        if (tag == null) {
            return false;
        }
        if (var3_3.isPostUnaryOp()) {
            return false;
        }
        return Trees.operatorName((ExpressionTree)var1_1).startsWith((String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private JCTree.Tag unaryTag(ExpressionTree expression) {
        void var1_1;
        if (expression instanceof UnaryTree) {
            return ((JCTree)((Object)expression)).getTag();
        }
        if (expression instanceof LiteralTree && JavaInputAstVisitor.isUnaryMinusLiteral(Trees.getSourceForNode((Tree)var1_1, this.getCurrentPath()))) {
            return JCTree.Tag.MINUS;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitPrimitiveType(PrimitiveTypeTree node, Void unused) {
        this.sync(node);
        switch (node.getPrimitiveTypeKind()) {
            case BOOLEAN: {
                this.token("boolean");
                break;
            }
            case BYTE: {
                this.token("byte");
                break;
            }
            case SHORT: {
                this.token("short");
                break;
            }
            case INT: {
                this.token("int");
                break;
            }
            case LONG: {
                this.token("long");
                break;
            }
            case CHAR: {
                this.token("char");
                break;
            }
            case FLOAT: {
                this.token("float");
                break;
            }
            case DOUBLE: {
                this.token("double");
                break;
            }
            case VOID: {
                this.token("void");
                break;
            }
            default: {
                void var1_1;
                throw new AssertionError((Object)var1_1.getPrimitiveTypeKind());
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public boolean visit(Name name) {
        void var1_1;
        this.token(var1_1.toString());
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitReturn(ReturnTree node, Void unused) {
        this.sync(node);
        this.token("return");
        if (node.getExpression() != null) {
            void var1_1;
            this.builder.space();
            this.scan((Tree)var1_1.getExpression(), null);
        }
        this.token(";");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    boolean visitSingleMemberAnnotation(AnnotationTree node) {
        void var2_2;
        void var3_3;
        void var1_1;
        if (node.getArguments().size() != 1) {
            return false;
        }
        ExpressionTree value = Iterables.getOnlyElement(node.getArguments());
        if (value.getKind() == Tree.Kind.ASSIGNMENT) {
            return false;
        }
        boolean isArrayInitializer = value.getKind() == Tree.Kind.NEW_ARRAY;
        this.builder.open(isArrayInitializer ? ZERO : this.plusFour);
        this.token("@");
        this.scan(var1_1.getAnnotationType(), null);
        this.token("(");
        if (var3_3 == false) {
            this.builder.breakOp();
        }
        this.scan((Tree)var2_2, null);
        this.builder.close();
        this.token(")");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitCase(CaseTree node, Void unused) {
        void var1_1;
        this.sync(node);
        this.markForPartialFormat();
        this.builder.forcedBreak();
        if (node.getExpression() == null) {
            this.token("default", this.plusTwo);
            this.token(":");
        } else {
            this.token("case", this.plusTwo);
            this.builder.space();
            this.scan((Tree)node.getExpression(), null);
            this.token(":");
        }
        this.builder.open(this.plusTwo);
        this.visitStatements(var1_1.getStatements());
        this.builder.close();
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitSwitch(SwitchTree node, Void unused) {
        void var1_1;
        this.sync(node);
        this.visitSwitch(node.getExpression(), var1_1.getCases());
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected void visitSwitch(ExpressionTree expression, List<? extends CaseTree> cases) {
        Iterator iterator;
        this.token("switch");
        this.builder.space();
        this.token("(");
        this.scan((Tree)Trees.skipParen(expression), null);
        this.token(")");
        this.builder.space();
        this.tokenBreakTrailingComment("{", this.plusTwo);
        this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
        this.builder.open(this.plusTwo);
        boolean afterFirstToken = false;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_4;
            CaseTree caseTree = (CaseTree)iterator.next();
            if (afterFirstToken) {
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.PRESERVE);
            }
            this.scan((Tree)var3_4, null);
            afterFirstToken = true;
        }
        this.builder.close();
        this.builder.forcedBreak();
        this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
        this.token("}", this.plusFour);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitSynchronized(SynchronizedTree node, Void unused) {
        void var1_1;
        this.sync(node);
        this.token("synchronized");
        this.builder.space();
        this.token("(");
        this.builder.open(this.plusFour);
        this.builder.breakOp();
        this.scan((Tree)Trees.skipParen(node.getExpression()), null);
        this.builder.close();
        this.token(")");
        this.builder.space();
        this.scan((Tree)var1_1.getBlock(), null);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitThrow(ThrowTree node, Void unused) {
        void var1_1;
        this.sync(node);
        this.token("throw");
        this.builder.space();
        this.scan((Tree)var1_1.getExpression(), null);
        this.token(";");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitTry(TryTree node, Void unused) {
        this.sync(node);
        this.builder.open(ZERO);
        this.token("try");
        this.builder.space();
        if (!node.getResources().isEmpty()) {
            this.token("(");
            this.builder.open(node.getResources().size() > 1 ? this.plusFour : ZERO);
            boolean afterFirstToken = false;
            for (Tree tree : node.getResources()) {
                if (afterFirstToken) {
                    this.builder.forcedBreak();
                }
                if (tree instanceof VariableTree) {
                    VariableTree variableTree = (VariableTree)tree;
                    this.declareOne(DeclarationKind.PARAMETER, JavaInputAstVisitor.fieldAnnotationDirection(variableTree.getModifiers()), Optional.of(variableTree.getModifiers()), variableTree.getType(), variableTree.getName(), "", "=", Optional.ofNullable(variableTree.getInitializer()), Optional.empty(), Optional.empty(), Optional.empty());
                } else {
                    this.scan(tree, null);
                }
                if (this.builder.peekToken().equals(Optional.of(";"))) {
                    this.token(";");
                    this.builder.space();
                }
                boolean variableTree = true;
            }
            if (this.builder.peekToken().equals(Optional.of(";"))) {
                this.token(";");
                this.builder.space();
            }
            this.token(")");
            this.builder.close();
            this.builder.space();
        }
        boolean trailingClauses = !node.getCatches().isEmpty() || node.getFinallyBlock() != null;
        this.visitBlock(node.getBlock(), CollapseEmptyOrNot.valueOf(!trailingClauses), AllowLeadingBlankLine.YES, AllowTrailingBlankLine.valueOf(trailingClauses));
        for (int i = 0; i < node.getCatches().size(); ++i) {
            void var2_5;
            CatchTree catchTree = node.getCatches().get(i);
            trailingClauses = i < node.getCatches().size() - 1 || node.getFinallyBlock() != null;
            this.visitCatchClause(catchTree, AllowTrailingBlankLine.valueOf((boolean)var2_5));
        }
        if (node.getFinallyBlock() != null) {
            void var1_1;
            this.builder.space();
            this.token("finally");
            this.builder.space();
            this.visitBlock(var1_1.getFinallyBlock(), CollapseEmptyOrNot.NO, AllowLeadingBlankLine.YES, AllowTrailingBlankLine.NO);
        }
        this.builder.close();
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void visitClassDeclaration(ClassTree node) {
        void var2_2;
        void var3_3;
        this.sync(node);
        this.typeDeclarationModifiers(node.getModifiers());
        List<? extends Tree> permitsTypes = this.getPermitsClause(node);
        boolean hasSuperclassType = node.getExtendsClause() != null;
        boolean hasSuperInterfaceTypes = !node.getImplementsClause().isEmpty();
        boolean hasPermitsTypes = !permitsTypes.isEmpty();
        this.token(node.getKind() == Tree.Kind.INTERFACE ? "interface" : "class");
        this.builder.space();
        this.visit(node.getSimpleName());
        if (!node.getTypeParameters().isEmpty()) {
            this.token("<");
        }
        this.builder.open(this.plusFour);
        if (!node.getTypeParameters().isEmpty()) {
            this.typeParametersRest(node.getTypeParameters(), hasSuperclassType || hasSuperInterfaceTypes || hasPermitsTypes ? this.plusFour : ZERO);
        }
        if (var3_3 != false) {
            this.builder.breakToFill(" ");
            this.token("extends");
            this.builder.space();
            this.scan(node.getExtendsClause(), null);
        }
        this.classDeclarationTypeList(node.getKind() == Tree.Kind.INTERFACE ? "extends" : "implements", node.getImplementsClause());
        this.classDeclarationTypeList("permits", (List<? extends Tree>)var2_2);
        this.builder.close();
        if (node.getMembers() == null) {
            this.token(";");
        } else {
            void var1_1;
            this.addBodyDeclarations(var1_1.getMembers(), BracesOrNot.YES, FirstDeclarationsOrNot.YES);
        }
        this.dropEmptyDeclarations();
    }

    @Override
    public Void visitTypeParameter(TypeParameterTree node, Void unused) {
        this.sync(node);
        this.builder.open(ZERO);
        this.visitAnnotations(node.getAnnotations(), BreakOrNot.NO, BreakOrNot.YES);
        this.visit(node.getName());
        if (!node.getBounds().isEmpty()) {
            Iterator<? extends Tree> iterator;
            this.builder.space();
            this.token("extends");
            this.builder.open(this.plusFour);
            this.builder.breakOp(" ");
            this.builder.open(this.plusFour);
            boolean afterFirstToken = false;
            for (Tree tree : iterator.getBounds()) {
                if (afterFirstToken) {
                    this.builder.breakToFill(" ");
                    this.token("&");
                    this.builder.space();
                }
                this.scan(tree, null);
                afterFirstToken = true;
            }
            this.builder.close();
            this.builder.close();
        }
        this.builder.close();
        return null;
    }

    @Override
    public Void visitUnionType(UnionTypeTree node, Void unused) {
        throw new IllegalStateException("expected manual descent into union types");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitWhileLoop(WhileLoopTree node, Void unused) {
        void var1_1;
        this.sync(node);
        this.token("while");
        this.builder.space();
        this.token("(");
        this.scan((Tree)Trees.skipParen(node.getCondition()), null);
        this.token(")");
        this.visitStatement(var1_1.getStatement(), CollapseEmptyOrNot.YES, AllowLeadingBlankLine.YES, AllowTrailingBlankLine.NO);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitWildcard(WildcardTree node, Void unused) {
        this.sync(node);
        this.builder.open(ZERO);
        this.token("?");
        if (node.getBound() != null) {
            void var1_1;
            this.builder.open(this.plusFour);
            this.builder.space();
            this.token(node.getKind() == Tree.Kind.EXTENDS_WILDCARD ? "extends" : "super");
            this.builder.breakOp(" ");
            this.scan(var1_1.getBound(), null);
            this.builder.close();
        }
        this.builder.close();
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected void visitAnnotations(List<? extends AnnotationTree> annotations, BreakOrNot breakBefore, BreakOrNot breakAfter) {
        if (!annotations.isEmpty()) {
            void var3_4;
            Iterator iterator;
            if (breakBefore.isYes()) {
                this.builder.breakToFill(" ");
            }
            boolean afterFirstToken = false;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                AnnotationTree annotation = (AnnotationTree)iterator.next();
                if (afterFirstToken) {
                    this.builder.breakToFill(" ");
                }
                this.scan((Tree)annotation, null);
                afterFirstToken = true;
            }
            if (var3_4.isYes()) {
                this.builder.breakToFill(" ");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    void verticalAnnotations(List<AnnotationTree> annotations) {
        for (AnnotationTree annotation : annotations) {
            void var2_2;
            this.builder.forcedBreak();
            this.scan((Tree)var2_2, null);
            this.builder.forcedBreak();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void visitBlock(BlockTree node, CollapseEmptyOrNot collapseEmptyOrNot, AllowLeadingBlankLine allowLeadingBlankLine, AllowTrailingBlankLine allowTrailingBlankLine) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.sync(node);
        if (node.isStatic()) {
            this.token("static");
            this.builder.space();
        }
        if (var2_2.isYes() && node.getStatements().isEmpty()) {
            if (this.builder.peekToken().equals(Optional.of(";"))) {
                this.token(";");
                return;
            }
            this.tokenBreakTrailingComment("{", this.plusTwo);
            this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
            this.token("}", this.plusTwo);
            return;
        }
        this.builder.open(ZERO);
        this.builder.open(this.plusTwo);
        this.tokenBreakTrailingComment("{", this.plusTwo);
        if (var3_3 == AllowLeadingBlankLine.NO) {
            this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
        } else {
            this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.PRESERVE);
        }
        this.visitStatements(var1_1.getStatements());
        this.builder.close();
        this.builder.forcedBreak();
        this.builder.close();
        if (allowTrailingBlankLine == AllowTrailingBlankLine.NO) {
            this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
        } else {
            this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.PRESERVE);
        }
        this.markForPartialFormat();
        this.token("}", this.plusTwo);
    }

    /*
     * WARNING - void declaration
     */
    private void visitStatement(StatementTree node, CollapseEmptyOrNot collapseEmptyOrNot, AllowLeadingBlankLine allowLeadingBlank, AllowTrailingBlankLine allowTrailingBlank) {
        void var1_1;
        this.sync(node);
        switch (node.getKind()) {
            case BLOCK: {
                void var3_3;
                void var2_2;
                this.builder.space();
                this.visitBlock((BlockTree)node, (CollapseEmptyOrNot)var2_2, (AllowLeadingBlankLine)var3_3, allowTrailingBlank);
                return;
            }
        }
        this.builder.open(this.plusTwo);
        this.builder.breakOp(" ");
        this.scan((Tree)var1_1, null);
        this.builder.close();
    }

    /*
     * WARNING - void declaration
     */
    protected void visitStatements(List<? extends StatementTree> statements) {
        boolean afterFirstToken = false;
        Iterators.PeekingImpl it = Iterators.peekingIterator$488b6d4d(statements.iterator());
        this.dropEmptyDeclarations();
        while (it.hasNext()) {
            void var3_3;
            StatementTree tree = (StatementTree)it.next();
            this.builder.forcedBreak();
            if (afterFirstToken) {
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.PRESERVE);
            }
            this.markForPartialFormat();
            afterFirstToken = true;
            List<VariableTree> fragments = JavaInputAstVisitor.variableFragments(it, tree);
            if (!fragments.isEmpty()) {
                this.visitVariables(fragments, DeclarationKind.NONE, JavaInputAstVisitor.canLocalHaveHorizontalAnnotations(fragments.get(0).getModifiers()));
                continue;
            }
            this.scan((Tree)var3_3, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void typeDeclarationModifiers(ModifiersTree modifiers) {
        void var1_1;
        ImmutableList<AnnotationTree> typeAnnotations = this.visitModifiers(modifiers, Direction.VERTICAL, Optional.empty());
        this.verticalAnnotations((List<AnnotationTree>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    void visitAndBreakModifiers(ModifiersTree modifiers, Direction annotationDirection, Optional<Output.BreakTag> declarationAnnotationBreak) {
        void var1_1;
        void var3_3;
        void var2_2;
        ImmutableList<AnnotationTree> typeAnnotations = this.visitModifiers(modifiers, (Direction)var2_2, (Optional<Output.BreakTag>)var3_3);
        this.visitAnnotations((List<? extends AnnotationTree>)var1_1, BreakOrNot.NO, BreakOrNot.YES);
    }

    @Override
    public Void visitModifiers(ModifiersTree node, Void unused) {
        throw new IllegalStateException("expected manual descent into modifiers");
    }

    /*
     * WARNING - void declaration
     */
    protected ImmutableList<AnnotationTree> visitModifiers(ModifiersTree modifiersTree, Direction annotationsDirection, Optional<Output.BreakTag> declarationAnnotationBreak) {
        void var3_3;
        void var2_2;
        void var1_1;
        void v0 = var1_1;
        return this.visitModifiers((ModifiersTree)v0, v0.getAnnotations(), (Direction)var2_2, (Optional<Output.BreakTag>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected ImmutableList<AnnotationTree> visitModifiers(ModifiersTree modifiersTree, List<? extends AnnotationTree> annotationTrees, Direction annotationsDirection, Optional<Output.BreakTag> declarationAnnotationBreak) {
        void var3_3;
        void var1_1;
        void var2_2;
        DeclarationModifiersAndTypeAnnotations splitModifiers = this.splitModifiers(modifiersTree, (List<? extends AnnotationTree>)var2_2);
        return this.visitModifiers((DeclarationModifiersAndTypeAnnotations)var1_1, (Direction)var3_3, declarationAnnotationBreak);
    }

    /*
     * WARNING - void declaration
     */
    private ImmutableList<AnnotationTree> visitModifiers(DeclarationModifiersAndTypeAnnotations splitModifiers, Direction annotationsDirection, Optional<Output.BreakTag> declarationAnnotationBreak) {
        void var1_1;
        void var3_3;
        ImmutableList<Op> trailingBreak;
        if (splitModifiers.declarationModifiers().isEmpty()) {
            return splitModifiers.typeAnnotations();
        }
        ArrayDeque<AnnotationOrModifier> declarationModifiers = new ArrayDeque<AnnotationOrModifier>(splitModifiers.declarationModifiers());
        this.builder.open(ZERO);
        boolean afterFirstToken = false;
        boolean lastWasAnnotation = false;
        while (!declarationModifiers.isEmpty() && !((AnnotationOrModifier)declarationModifiers.peekFirst()).isModifier()) {
            if (afterFirstToken) {
                this.builder.addAll(annotationsDirection.isVertical() ? JavaInputAstVisitor.forceBreakList(declarationAnnotationBreak) : JavaInputAstVisitor.breakList(declarationAnnotationBreak));
            }
            this.formatAnnotationOrModifier(declarationModifiers);
            afterFirstToken = true;
            lastWasAnnotation = true;
        }
        this.builder.close();
        ImmutableList<Op> immutableList = trailingBreak = annotationsDirection.isVertical() ? JavaInputAstVisitor.forceBreakList(declarationAnnotationBreak) : JavaInputAstVisitor.breakList((Optional<Output.BreakTag>)var3_3);
        if (declarationModifiers.isEmpty()) {
            this.builder.addAll(trailingBreak);
            return splitModifiers.typeAnnotations();
        }
        if (lastWasAnnotation) {
            void var2_2;
            this.builder.addAll((List<Op>)var2_2);
        }
        this.builder.open(ZERO);
        afterFirstToken = false;
        while (!declarationModifiers.isEmpty()) {
            if (afterFirstToken) {
                this.builder.addAll(JavaInputAstVisitor.breakFillList(Optional.empty()));
            }
            this.formatAnnotationOrModifier(declarationModifiers);
            afterFirstToken = true;
        }
        this.builder.close();
        this.builder.addAll(JavaInputAstVisitor.breakFillList(Optional.empty()));
        return var1_1.typeAnnotations();
    }

    /*
     * WARNING - void declaration
     */
    DeclarationModifiersAndTypeAnnotations splitModifiers(ModifiersTree modifiersTree, List<? extends AnnotationTree> annotations) {
        void var1_1;
        void var2_3;
        AnnotationOrModifier modifier;
        if (annotations.isEmpty() && !JavaInputAstVisitor.isModifier(this.builder.peekToken().get())) {
            return DeclarationModifiersAndTypeAnnotations.empty();
        }
        TreeRangeSet<Integer> annotationRanges = TreeRangeSet.create();
        for (AnnotationTree annotationTree : annotations) {
            annotationRanges.add(Range.closedOpen(Trees.getStartPosition(annotationTree), Trees.getEndPosition(annotationTree, this.getCurrentPath())));
        }
        ImmutableList<Input.Tok> toks = this.builder.peekTokens(Trees.getStartPosition(modifiersTree), tok -> {
            void var1_1;
            return annotationRanges.contains(tok.getPosition()) || JavaInputAstVisitor.isModifier(var1_1.getText());
        });
        ImmutableList immutableList = ImmutableList.copyOf(Streams.concat(toks.stream().filter(t -> {
            void var1_1;
            return !annotationRanges.contains(var1_1.getPosition());
        }).map(AnnotationOrModifier::ofModifier), annotations.stream().map(AnnotationOrModifier::ofAnnotation)).sorted().collect(Collectors.toList()));
        ImmutableList.Builder typeAnnotations = ImmutableList.builder();
        for (int idx = immutableList.size() - 1; idx >= 0 && (modifier = (AnnotationOrModifier)immutableList.get(idx)).isAnnotation() && this.isTypeAnnotation(modifier.annotation()); --idx) {
            void var3_4;
            typeAnnotations.add(var3_4.annotation());
        }
        return DeclarationModifiersAndTypeAnnotations.create((ImmutableList<AnnotationOrModifier>)immutableList.subList(0, (int)(var2_3 + true)), var1_1.build().reverse());
    }

    /*
     * WARNING - void declaration
     */
    private void formatAnnotationOrModifier(Deque<AnnotationOrModifier> modifiers) {
        AnnotationOrModifier modifier = modifiers.removeFirst();
        switch (modifier.getKind().ordinal()) {
            case 0: {
                void var1_1;
                this.token(modifier.modifier().getText());
                if (!modifier.modifier().getText().equals("non")) break;
                this.token(modifiers.removeFirst().modifier().getText());
                this.token(((AnnotationOrModifier)var1_1.removeFirst()).modifier().getText());
                return;
            }
            case 1: {
                void var2_2;
                this.scan((Tree)var2_2.annotation(), null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    boolean isTypeAnnotation(AnnotationTree annotationTree) {
        void var1_1;
        Tree annotationType = annotationTree.getAnnotationType();
        if (!(annotationType instanceof IdentifierTree)) {
            return false;
        }
        return this.typeAnnotationSimpleNames.contains(((IdentifierTree)var1_1).getName());
    }

    private static boolean isModifier(String token) {
        switch (token) {
            case "public": 
            case "protected": 
            case "private": 
            case "abstract": 
            case "static": 
            case "final": 
            case "transient": 
            case "volatile": 
            case "synchronized": 
            case "native": 
            case "strictfp": 
            case "default": 
            case "sealed": 
            case "non": 
            case "-": {
                return true;
            }
        }
        return false;
    }

    @Override
    public Void visitCatch(CatchTree node, Void unused) {
        throw new IllegalStateException("expected manual descent into catch trees");
    }

    /*
     * WARNING - void declaration
     */
    private void visitCatchClause(CatchTree node, AllowTrailingBlankLine allowTrailingBlankLine) {
        void var2_2;
        void var1_1;
        this.sync(node);
        this.builder.space();
        this.token("catch");
        this.builder.space();
        this.token("(");
        this.builder.open(this.plusFour);
        VariableTree ex = node.getParameter();
        if (ex.getType().getKind() == Tree.Kind.UNION_TYPE) {
            this.builder.open(ZERO);
            this.visitUnionType(ex);
            this.builder.close();
        } else {
            void var3_3;
            this.builder.breakToFill();
            this.builder.open(ZERO);
            this.scan((Tree)var3_3, null);
            this.builder.close();
        }
        this.builder.close();
        this.token(")");
        this.builder.space();
        this.visitBlock(var1_1.getBlock(), CollapseEmptyOrNot.NO, AllowLeadingBlankLine.YES, (AllowTrailingBlankLine)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void visitUnionType(VariableTree declaration) {
        void var1_1;
        void var2_2;
        UnionTypeTree type = (UnionTypeTree)declaration.getType();
        this.builder.open(ZERO);
        this.sync(declaration);
        this.visitAndBreakModifiers(declaration.getModifiers(), Direction.HORIZONTAL, Optional.empty());
        List<? extends Tree> union = type.getTypeAlternatives();
        boolean afterFirstToken = false;
        for (int i = 0; i < union.size() - 1; ++i) {
            if (afterFirstToken) {
                this.builder.breakOp(" ");
                this.token("|");
                this.builder.space();
            } else {
                afterFirstToken = true;
            }
            this.scan(union.get(i), null);
        }
        this.builder.breakOp(" ");
        this.token("|");
        this.builder.space();
        void v0 = var2_2;
        Tree last = (Tree)v0.get(v0.size() - 1);
        this.declareOne(DeclarationKind.NONE, Direction.HORIZONTAL, Optional.empty(), last, declaration.getName(), "", "=", Optional.ofNullable(var1_1.getInitializer()), Optional.empty(), Optional.empty(), Optional.empty());
        this.builder.close();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static void walkInfix(int precedence, ExpressionTree expression, List<ExpressionTree> operands, List<String> operators) {
        if (!(expression instanceof BinaryTree)) {
            void var1_1;
            void var2_2;
            var2_2.add(var1_1);
            return;
        }
        BinaryTree binaryTree = (BinaryTree)expression;
        if (Trees.precedence(binaryTree) == precedence) {
            void var3_3;
            int n;
            JavaInputAstVisitor.walkInfix(precedence, binaryTree.getLeftOperand(), operands, operators);
            operators.add(Trees.operatorName(expression));
            JavaInputAstVisitor.walkInfix(n, binaryTree.getRightOperand(), operands, (List<String>)var3_3);
            return;
        }
        operands.add(expression);
    }

    protected void visitFormals(Optional<VariableTree> receiver, List<? extends VariableTree> parameters) {
        if (!receiver.isPresent() && parameters.isEmpty()) {
            return;
        }
        this.builder.open(ZERO);
        boolean afterFirstToken = false;
        if (receiver.isPresent()) {
            this.declareOne(DeclarationKind.PARAMETER, Direction.HORIZONTAL, Optional.of(receiver.get().getModifiers()), receiver.get().getType(), receiver.get().getName(), "", "", Optional.empty(), !parameters.isEmpty() ? Optional.of(",") : Optional.empty(), Optional.of(receiver.get().getNameExpression()), Optional.empty());
            afterFirstToken = true;
        }
        for (int i = 0; i < parameters.size(); ++i) {
            VariableTree parameter = parameters.get(i);
            if (afterFirstToken) {
                this.builder.breakOp(" ");
            }
            this.visitToDeclare(DeclarationKind.PARAMETER, Direction.HORIZONTAL, parameter, Optional.empty(), "=", i < parameters.size() - 1 ? Optional.of(",") : Optional.empty());
            afterFirstToken = true;
        }
        this.builder.close();
    }

    /*
     * WARNING - void declaration
     */
    private void visitThrowsClause(List<? extends ExpressionTree> thrownExceptionTypes) {
        Iterator iterator;
        this.token("throws");
        this.builder.breakToFill(" ");
        boolean afterFirstToken = false;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            ExpressionTree thrownExceptionType = (ExpressionTree)iterator.next();
            if (afterFirstToken) {
                this.token(",");
                this.builder.breakOp(" ");
            }
            this.scan((Tree)var3_3, null);
            afterFirstToken = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitIdentifier(IdentifierTree node, Void unused) {
        void var1_1;
        this.sync(node);
        this.token(var1_1.getName().toString());
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitModule(ModuleTree node, Void unused) {
        for (AnnotationTree annotationTree : node.getAnnotations()) {
            this.scan((Tree)annotationTree, null);
            this.builder.forcedBreak();
        }
        if (node.getModuleType() == ModuleTree.ModuleKind.OPEN) {
            this.token("open");
            this.builder.space();
        }
        this.token("module");
        this.builder.space();
        this.scan((Tree)node.getName(), null);
        this.builder.space();
        if (node.getDirectives().isEmpty()) {
            this.tokenBreakTrailingComment("{", this.plusTwo);
            this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
            this.token("}", this.plusTwo);
        } else {
            this.builder.open(this.plusTwo);
            this.token("{");
            this.builder.forcedBreak();
            Optional<Tree.Kind> previousDirective = Optional.empty();
            for (DirectiveTree directiveTree : node.getDirectives()) {
                void var1_3;
                this.markForPartialFormat();
                this.builder.blankLineWanted(previousDirective.map(k -> {
                    DirectiveTree directiveTree2;
                    return !k.equals((Object)directiveTree2.getKind());
                }).orElse(Boolean.FALSE) != false ? OpsBuilder.BlankLineWanted.YES : OpsBuilder.BlankLineWanted.NO);
                this.builder.forcedBreak();
                this.scan((Tree)directiveTree, null);
                previousDirective = Optional.of(var1_3.getKind());
            }
            this.builder.close();
            this.builder.forcedBreak();
            this.token("}");
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void visitDirective(String name, String separator, ExpressionTree nameExpression, @Nullable List<? extends ExpressionTree> items) {
        this.token(name);
        this.builder.space();
        this.scan((Tree)nameExpression, null);
        if (items != null) {
            Iterator iterator;
            this.builder.open(this.plusFour);
            this.builder.space();
            this.token((String)((Object)iterator));
            this.builder.forcedBreak();
            boolean afterFirstToken = false;
            for (ExpressionTree item : items) {
                void var3_6;
                if (afterFirstToken) {
                    this.token(",");
                    this.builder.forcedBreak();
                }
                this.scan((Tree)var3_6, null);
                afterFirstToken = true;
            }
            this.token(";");
            this.builder.close();
            return;
        }
        this.token(";");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitExports(ExportsTree node, Void unused) {
        void var1_1;
        this.visitDirective("exports", "to", node.getPackageName(), var1_1.getModuleNames());
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitOpens(OpensTree node, Void unused) {
        void var1_1;
        this.visitDirective("opens", "to", node.getPackageName(), var1_1.getModuleNames());
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitProvides(ProvidesTree node, Void unused) {
        void var1_1;
        this.visitDirective("provides", "with", node.getServiceName(), var1_1.getImplementationNames());
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitRequires(RequiresTree node, Void unused) {
        void var1_1;
        this.token("requires");
        this.builder.space();
        while (true) {
            if (this.builder.peekToken().equals(Optional.of("static"))) {
                this.token("static");
                this.builder.space();
                continue;
            }
            if (!this.builder.peekToken().equals(Optional.of("transitive"))) break;
            this.token("transitive");
            this.builder.space();
        }
        this.scan((Tree)var1_1.getModuleName(), null);
        this.token(";");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitUses(UsesTree node, Void unused) {
        void var1_1;
        this.token("uses");
        this.builder.space();
        this.scan((Tree)var1_1.getServiceName(), null);
        this.token(";");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void visitName(Tree node) {
        Iterator iterator;
        ArrayDeque<Name> stack = new ArrayDeque<Name>();
        while (node instanceof MemberSelectTree) {
            stack.addFirst(((MemberSelectTree)node).getIdentifier());
            node = ((MemberSelectTree)node).getExpression();
        }
        stack.addFirst(((IdentifierTree)node).getName());
        boolean afterFirstToken = false;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_4;
            Name name = (Name)iterator.next();
            if (afterFirstToken) {
                this.token(".");
            }
            this.token(var3_4.toString());
            afterFirstToken = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void visitToDeclare(DeclarationKind kind, Direction annotationsDirection, VariableTree node, Optional<ExpressionTree> initializer, String equals, Optional<String> trailing) {
        void var3_3;
        void var2_2;
        void var1_1;
        Tree type;
        Optional<DimensionHelpers.TypeWithDims> typeWithDims;
        this.sync(node);
        if (node.getType() != null) {
            DimensionHelpers.TypeWithDims extractedDims = DimensionHelpers.extractDims(node.getType(), DimensionHelpers.SortedDims.YES);
            typeWithDims = Optional.of(extractedDims);
            type = extractedDims.node;
        } else {
            typeWithDims = Optional.empty();
            type = null;
        }
        this.declareOne((DeclarationKind)var1_1, (Direction)var2_2, Optional.of(node.getModifiers()), type, var3_3.getName(), "", equals, initializer, trailing, Optional.empty(), typeWithDims);
    }

    /*
     * WARNING - void declaration
     */
    protected void typeParametersRest(List<? extends TypeParameterTree> typeParameters, Indent plusIndent) {
        Iterator iterator;
        this.builder.open(plusIndent);
        this.builder.breakOp();
        this.builder.open(ZERO);
        boolean afterFirstToken = false;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_4;
            TypeParameterTree typeParameter = (TypeParameterTree)iterator.next();
            if (afterFirstToken) {
                this.token(",");
                this.builder.breakOp(" ");
            }
            this.scan((Tree)var3_4, null);
            afterFirstToken = true;
        }
        this.token(">");
        this.builder.close();
        this.builder.close();
    }

    /*
     * WARNING - void declaration
     */
    void visitDot(ExpressionTree node0) {
        void var1_1;
        void var2_3;
        ExpressionTree node = node0;
        ArrayDeque<ExpressionTree> stack = new ArrayDeque<ExpressionTree>();
        block12: do {
            stack.addFirst(node);
            if (node.getKind() == Tree.Kind.ARRAY_ACCESS) {
                node = JavaInputAstVisitor.getArrayBase(node);
            }
            switch (node.getKind()) {
                case MEMBER_SELECT: {
                    node = ((MemberSelectTree)node).getExpression();
                    break;
                }
                case METHOD_INVOCATION: {
                    node = JavaInputAstVisitor.getMethodReceiver((MethodInvocationTree)node);
                    break;
                }
                case IDENTIFIER: {
                    node = null;
                    break block12;
                }
                default: {
                    node = (ExpressionTree)stack.removeFirst();
                    break block12;
                }
            }
        } while (node != null);
        ArrayList<ExpressionTree> items = new ArrayList<ExpressionTree>(stack);
        boolean needDot = false;
        if (node != null) {
            if (node.getKind() == Tree.Kind.NEW_CLASS && ((NewClassTree)node).getClassBody() != null) {
                this.builder.open(ZERO);
                this.scan((Tree)JavaInputAstVisitor.getArrayBase(node), null);
                this.token(".");
            } else {
                this.builder.open(this.plusFour);
                this.scan((Tree)JavaInputAstVisitor.getArrayBase(node), null);
                this.builder.breakOp();
                needDot = true;
            }
            this.formatArrayIndices(JavaInputAstVisitor.getArrayIndices(node));
            if (stack.isEmpty()) {
                this.builder.close();
                return;
            }
        }
        LinkedHashSet<Integer> prefixes = new LinkedHashSet<Integer>();
        TypeNameClassifier.typePrefixLength(JavaInputAstVisitor.simpleNames(stack)).ifPresent(prefixes::add);
        int invocationCount = 0;
        int firstInvocationIndex = -1;
        for (int i = 0; i < items.size(); ++i) {
            ExpressionTree expressionTree = (ExpressionTree)items.get(i);
            if (expressionTree.getKind() != Tree.Kind.METHOD_INVOCATION) continue;
            if (i > 0 || node != null) {
                ++invocationCount;
            }
            if (firstInvocationIndex >= 0) continue;
            firstInvocationIndex = i;
        }
        if (var2_3 == true && firstInvocationIndex > 0) {
            prefixes.add(firstInvocationIndex);
        }
        if (prefixes.isEmpty() && items.get(0) instanceof IdentifierTree) {
            switch (((IdentifierTree)items.get(0)).getName().toString()) {
                case "this": 
                case "super": {
                    prefixes.add(1);
                }
            }
        }
        List<Long> streamPrefixes = JavaInputAstVisitor.handleStream(items);
        streamPrefixes.forEach(x -> {
            void var1_1;
            prefixes.add(var1_1.intValue());
        });
        if (!prefixes.isEmpty()) {
            this.visitDotWithPrefix(items, needDot, prefixes, streamPrefixes.isEmpty() ? Doc.FillMode.INDEPENDENT : Doc.FillMode.UNIFIED);
        } else {
            void var3_4;
            this.visitRegularDot((List<ExpressionTree>)var3_4, needDot);
        }
        if (var1_1 != null) {
            this.builder.close();
        }
    }

    private void visitRegularDot(List<ExpressionTree> items, boolean needDot) {
        boolean trailingDereferences = items.size() > 1;
        boolean needDot0 = needDot;
        if (!needDot0) {
            this.builder.open(this.plusFour);
        }
        int minLength = this.indentMultiplier << 2;
        int length = needDot0 ? minLength : 0;
        for (ExpressionTree e : items) {
            if (needDot) {
                if (length > minLength) {
                    this.builder.breakOp(Doc.FillMode.UNIFIED, "", ZERO);
                }
                this.token(".");
                ++length;
            }
            if (!this.fillFirstArgument(e, items, trailingDereferences ? ZERO : this.minusFour)) {
                Output.BreakTag tyargTag = this.genSym();
                this.dotExpressionUpToArgs(e, Optional.of(tyargTag));
                Indent.If tyargIndent = Indent.If.make(tyargTag, this.plusFour, ZERO);
                this.dotExpressionArgsAndParen(e, tyargIndent, trailingDereferences || needDot ? this.plusFour : ZERO);
            }
            length += Trees.getLength(e, this.getCurrentPath());
            needDot = true;
        }
        if (!needDot0) {
            this.builder.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean fillFirstArgument(ExpressionTree e, List<ExpressionTree> items, Indent indent) {
        void var1_1;
        void var2_2;
        void var3_3;
        if (items.size() < 2) {
            return false;
        }
        if (e.getKind() != Tree.Kind.METHOD_INVOCATION) {
            return false;
        }
        MethodInvocationTree methodInvocation = (MethodInvocationTree)e;
        Name name = Trees.getMethodName(methodInvocation);
        if (!(methodInvocation.getMethodSelect() instanceof IdentifierTree) || name.length() > 4 || !methodInvocation.getTypeArguments().isEmpty() || methodInvocation.getArguments().size() != 1) {
            return false;
        }
        this.builder.open(ZERO);
        this.builder.open((Indent)var3_3);
        this.visit((Name)var2_2);
        this.token("(");
        ExpressionTree arg2 = Iterables.getOnlyElement(methodInvocation.getArguments());
        this.scan((Tree)var1_1, null);
        this.builder.close();
        this.token(")");
        this.builder.close();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void visitDotWithPrefix(List<ExpressionTree> items, boolean needDot, Collection<Integer> prefixes, Doc.FillMode prefixFillMode) {
        boolean trailingDereferences = !prefixes.isEmpty() && Iterables.getLast(prefixes) < items.size() - 1;
        this.builder.open(this.plusFour);
        for (int times = 0; times < prefixes.size(); ++times) {
            this.builder.open(ZERO);
        }
        ArrayDeque<Integer> unconsumedPrefixes = new ArrayDeque<Integer>(ImmutableSortedSet.copyOf(prefixes));
        Output.BreakTag nameTag = this.genSym();
        for (int i = 0; i < items.size(); ++i) {
            void var2_4;
            ExpressionTree e = items.get(i);
            if (needDot) {
                Doc.FillMode fillMode = !unconsumedPrefixes.isEmpty() && i <= (Integer)unconsumedPrefixes.peekFirst() ? prefixFillMode : Doc.FillMode.UNIFIED;
                this.builder.breakOp(fillMode, "", ZERO, Optional.of(nameTag));
                this.token(".");
            }
            Output.BreakTag tyargTag = this.genSym();
            this.dotExpressionUpToArgs(e, Optional.of(tyargTag));
            if (!unconsumedPrefixes.isEmpty() && i == (Integer)unconsumedPrefixes.peekFirst()) {
                this.builder.close();
                unconsumedPrefixes.removeFirst();
            }
            Indent.If tyargIndent = Indent.If.make(tyargTag, this.plusFour, ZERO);
            Indent.If argsIndent = Indent.If.make(nameTag, this.plusFour, trailingDereferences ? this.plusFour : ZERO);
            this.dotExpressionArgsAndParen(e, (Indent)var2_4, argsIndent);
            boolean bl = true;
        }
        this.builder.close();
    }

    /*
     * WARNING - void declaration
     */
    private static ImmutableList<String> simpleNames(Deque<ExpressionTree> stack) {
        void var1_1;
        Iterator<ExpressionTree> iterator;
        ImmutableList.Builder simpleNames = ImmutableList.builder();
        iterator = iterator.iterator();
        block5: while (iterator.hasNext()) {
            void var3_3;
            ExpressionTree expression = (ExpressionTree)iterator.next();
            boolean isArray = expression.getKind() == Tree.Kind.ARRAY_ACCESS;
            expression = JavaInputAstVisitor.getArrayBase(expression);
            switch (expression.getKind()) {
                case MEMBER_SELECT: {
                    simpleNames.add(((MemberSelectTree)expression).getIdentifier().toString());
                    break;
                }
                case IDENTIFIER: {
                    simpleNames.add(((IdentifierTree)expression).getName().toString());
                    break;
                }
                case METHOD_INVOCATION: {
                    void var2_2;
                    simpleNames.add(Trees.getMethodName((MethodInvocationTree)var2_2).toString());
                    break block5;
                }
                default: {
                    break block5;
                }
            }
            if (var3_3 == false) continue;
        }
        return var1_1.build();
    }

    /*
     * WARNING - void declaration
     */
    private void dotExpressionUpToArgs(ExpressionTree expression, Optional<Output.BreakTag> tyargTag) {
        void var1_1;
        expression = JavaInputAstVisitor.getArrayBase(expression);
        switch (expression.getKind()) {
            case MEMBER_SELECT: {
                MemberSelectTree fieldAccess = (MemberSelectTree)expression;
                this.visit(fieldAccess.getIdentifier());
                return;
            }
            case METHOD_INVOCATION: {
                MemberSelectTree fieldAccess;
                MethodInvocationTree methodInvocation = (MethodInvocationTree)((Object)fieldAccess);
                if (!methodInvocation.getTypeArguments().isEmpty()) {
                    void var2_2;
                    this.builder.open(this.plusFour);
                    this.addTypeArguments(methodInvocation.getTypeArguments(), ZERO);
                    this.builder.breakOp(Doc.FillMode.UNIFIED, "", ZERO, (Optional<Output.BreakTag>)var2_2);
                    this.builder.close();
                }
                this.visit(Trees.getMethodName((MethodInvocationTree)var1_1));
                return;
            }
            case IDENTIFIER: {
                this.visit(((IdentifierTree)var1_1).getName());
                return;
            }
        }
        this.scan((Tree)var1_1, null);
    }

    private static ExpressionTree getArrayBase(ExpressionTree node) {
        ExpressionTree expressionTree;
        while (node instanceof ArrayAccessTree) {
            node = ((ArrayAccessTree)node).getExpression();
        }
        return expressionTree;
    }

    private static ExpressionTree getMethodReceiver(MethodInvocationTree methodInvocation) {
        ExpressionTree select = methodInvocation.getMethodSelect();
        if (select instanceof MemberSelectTree) {
            ExpressionTree expressionTree;
            return ((MemberSelectTree)expressionTree).getExpression();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void dotExpressionArgsAndParen(ExpressionTree expression, Indent tyargIndent, Indent indent) {
        Deque<ExpressionTree> indices = JavaInputAstVisitor.getArrayIndices(expression);
        expression = JavaInputAstVisitor.getArrayBase(expression);
        switch (expression.getKind()) {
            case METHOD_INVOCATION: {
                void var3_3;
                void var1_1;
                void var2_2;
                this.builder.open((Indent)var2_2);
                MethodInvocationTree methodInvocation = (MethodInvocationTree)expression;
                this.addArguments(var1_1.getArguments(), (Indent)var3_3);
                this.builder.close();
            }
        }
        this.formatArrayIndices(indices);
    }

    private void formatArrayIndices(Deque<ExpressionTree> indices) {
        if (indices.isEmpty()) {
            return;
        }
        this.builder.open(ZERO);
        do {
            this.token("[");
            this.builder.breakToFill();
            this.scan((Tree)indices.removeLast(), null);
            this.token("]");
        } while (!indices.isEmpty());
        this.builder.close();
    }

    /*
     * WARNING - void declaration
     */
    private static Deque<ExpressionTree> getArrayIndices(ExpressionTree expression) {
        void var1_1;
        ArrayDeque<ExpressionTree> indices = new ArrayDeque<ExpressionTree>();
        while (expression instanceof ArrayAccessTree) {
            ExpressionTree expressionTree;
            ExpressionTree array = (ArrayAccessTree)expression;
            indices.addLast(array.getIndex());
            expressionTree = expressionTree.getExpression();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    void addTypeArguments(List<? extends Tree> typeArguments, Indent plusIndent) {
        Iterator iterator;
        if (typeArguments == null || typeArguments.isEmpty()) {
            return;
        }
        this.token("<");
        this.builder.open(plusIndent);
        boolean afterFirstToken = false;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_4;
            Tree typeArgument = (Tree)iterator.next();
            if (afterFirstToken) {
                this.token(",");
                this.builder.breakToFill(" ");
            }
            this.scan((Tree)var3_4, null);
            afterFirstToken = true;
        }
        this.builder.close();
        this.token(">");
    }

    /*
     * WARNING - void declaration
     */
    void addArguments(List<? extends ExpressionTree> arguments, Indent plusIndent) {
        this.builder.open(plusIndent);
        this.token("(");
        if (!arguments.isEmpty()) {
            if (arguments.size() % 2 == 0 && this.argumentsAreTabular(arguments) == 2) {
                this.builder.forcedBreak();
                this.builder.open(ZERO);
                boolean afterFirstToken = false;
                for (int i = 0; i < arguments.size() - 1; i += 2) {
                    ExpressionTree argument0 = arguments.get(i);
                    ExpressionTree argument1 = arguments.get(i + 1);
                    if (afterFirstToken) {
                        this.token(",");
                        this.builder.forcedBreak();
                    }
                    this.builder.open(this.plusFour);
                    this.scan((Tree)argument0, null);
                    this.token(",");
                    this.builder.breakOp(" ");
                    this.scan((Tree)argument1, null);
                    this.builder.close();
                    afterFirstToken = true;
                }
                this.builder.close();
            } else if (this.isFormatMethod(arguments)) {
                this.builder.breakOp();
                this.builder.open(ZERO);
                this.scan((Tree)arguments.get(0), null);
                this.token(",");
                this.builder.breakOp(" ");
                this.builder.open(ZERO);
                this.argList(arguments.subList(1, arguments.size()));
                this.builder.close();
                this.builder.close();
            } else {
                void var1_1;
                this.builder.breakOp();
                this.argList((List<? extends ExpressionTree>)var1_1);
            }
        }
        this.token(")");
        this.builder.close();
    }

    private void argList(List<? extends ExpressionTree> arguments) {
        Iterator iterator;
        this.builder.open(ZERO);
        boolean afterFirstToken = false;
        Doc.FillMode fillMode = this.hasOnlyShortItems(arguments) ? Doc.FillMode.INDEPENDENT : Doc.FillMode.UNIFIED;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            ExpressionTree argument = (ExpressionTree)iterator.next();
            if (afterFirstToken) {
                this.token(",");
                this.builder.breakOp(fillMode, " ", ZERO);
            }
            this.scan((Tree)argument, null);
            afterFirstToken = true;
        }
        this.builder.close();
    }

    /*
     * WARNING - void declaration
     */
    private boolean isFormatMethod(List<? extends ExpressionTree> arguments) {
        void var1_1;
        if (arguments.size() < 2) {
            return false;
        }
        return this.isStringConcat((ExpressionTree)var1_1.get(0));
    }

    /*
     * WARNING - void declaration
     */
    private boolean isStringConcat(ExpressionTree first) {
        void var3_3;
        void var2_2;
        void var1_1;
        boolean[] stringLiteral = new boolean[]{true};
        boolean[] formatString = new boolean[]{false};
        new TreeScanner(this, stringLiteral, formatString){
            final /* synthetic */ boolean[] val$stringLiteral;
            final /* synthetic */ boolean[] val$formatString;
            final /* synthetic */ JavaInputAstVisitor this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$stringLiteral = blArray;
                this.val$formatString = blArray2;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void scan(JCTree tree) {
                void var1_1;
                Object value;
                if (tree == null) {
                    return;
                }
                switch (tree.getKind()) {
                    case STRING_LITERAL: {
                        break;
                    }
                    case PLUS: {
                        super.scan(tree);
                        break;
                    }
                    default: {
                        this.val$stringLiteral[0] = false;
                    }
                }
                if (tree.getKind() == Tree.Kind.STRING_LITERAL && (value = ((LiteralTree)((Object)tree)).getValue()) instanceof String && FORMAT_SPECIFIER.matcher(var1_1.toString()).find()) {
                    this.val$formatString[0] = true;
                }
            }
        }.scan((JCTree)var1_1);
        return var2_2[0] != false && var3_3[0] != false;
    }

    /*
     * WARNING - void declaration
     */
    private int argumentsAreTabular(List<? extends ExpressionTree> arguments) {
        void var2_2;
        int i;
        if (arguments.isEmpty()) {
            return -1;
        }
        ArrayList<List<ExpressionTree>> rows = new ArrayList<List<ExpressionTree>>();
        Iterators.PeekingImpl it = Iterators.peekingIterator$488b6d4d(arguments.iterator());
        int start0 = this.actualColumn((ExpressionTree)it.peek());
        ArrayList<ExpressionTree> row = new ArrayList<ExpressionTree>();
        row.add((ExpressionTree)it.next());
        while (it.hasNext() && this.actualColumn((ExpressionTree)it.peek()) > start0) {
            row.add((ExpressionTree)it.next());
        }
        if (!it.hasNext()) {
            return -1;
        }
        if (JavaInputAstVisitor.rowLength(row) <= 1) {
            return -1;
        }
        rows.add(row);
        while (it.hasNext()) {
            row = new ArrayList();
            int n = this.actualColumn((ExpressionTree)it.peek());
            if (n != start0) {
                return -1;
            }
            row.add((ExpressionTree)it.next());
            while (it.hasNext() && this.actualColumn((ExpressionTree)it.peek()) > start0) {
                row.add((ExpressionTree)it.next());
            }
            rows.add(row);
        }
        int size0 = ((List)rows.get(0)).size();
        if (!JavaInputAstVisitor.expressionsAreParallel(rows, 0, rows.size())) {
            return -1;
        }
        for (i = 1; i < size0; ++i) {
            if (JavaInputAstVisitor.expressionsAreParallel(rows, i, rows.size() / 2 + 1)) continue;
            return -1;
        }
        if (rows.size() == 2) {
            if (size0 == ((List)rows.get(1)).size()) {
                return size0;
            }
            return -1;
        }
        for (i = 1; i < rows.size() - 1; ++i) {
            if (size0 == ((List)rows.get(i)).size()) continue;
            return -1;
        }
        if (size0 < ((List)Iterables.getLast(var2_2)).size()) {
            return -1;
        }
        return size0;
    }

    /*
     * WARNING - void declaration
     */
    static int rowLength(List<? extends ExpressionTree> row) {
        void var1_1;
        Iterator<? extends ExpressionTree> iterator;
        int size = 0;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            ExpressionTree tree = (ExpressionTree)iterator.next();
            if (tree.getKind() != Tree.Kind.NEW_ARRAY) {
                ++size;
                continue;
            }
            NewArrayTree array = (NewArrayTree)tree;
            if (array.getInitializers() == null) {
                ++size;
                continue;
            }
            size += JavaInputAstVisitor.rowLength(var2_2.getInitializers());
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Integer actualColumn(ExpressionTree expression) {
        void var1_1;
        ImmutableMap<Integer, Integer> immutableMap = this.builder.getInput().getPositionToColumnMap();
        return (Integer)immutableMap.get(this.builder.actualStartColumn(Trees.getStartPosition((Tree)var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    private static boolean expressionsAreParallel(List<List<ExpressionTree>> rows, int column, int atLeastM) {
        void var3_3;
        Iterator iterator;
        HashMultiset<Tree.Kind> nodeTypes = HashMultiset.create();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            List row = (List)iterator.next();
            if (column >= row.size()) continue;
            if (row.get(column) instanceof UnaryTree) {
                nodeTypes.add(((UnaryTree)row.get(column)).getExpression().getKind());
                continue;
            }
            nodeTypes.add(((ExpressionTree)row.get(column)).getKind());
        }
        for (Multiset.Entry entry : var3_3.entrySet()) {
            if (entry.getCount() < atLeastM) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected int declareOne(DeclarationKind kind, Direction annotationsDirection, Optional<ModifiersTree> modifiers, Tree type, Name name, String op, String equals, Optional<ExpressionTree> initializer, Optional<String> trailing, Optional<ExpressionTree> receiverExpression, Optional<DimensionHelpers.TypeWithDims> typeWithDims) {
        void var3_6;
        void var2_4;
        Output.BreakTag typeBreak = this.genSym();
        Output.BreakTag verticalAnnotationBreak = this.genSym();
        boolean isField = kind == DeclarationKind.FIELD;
        if (isField) {
            this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.conditional(verticalAnnotationBreak));
        }
        ArrayDeque<List<? extends AnnotationTree>> dims = new ArrayDeque<List<? extends AnnotationTree>>(typeWithDims.isPresent() ? typeWithDims.get().dims : ImmutableList.of());
        int baseDims = 0;
        DeclarationModifiersAndTypeAnnotations declarationAndTypeModifiers = modifiers.map(m -> {
            void var1_1;
            void v0 = var1_1;
            return this.splitModifiers((ModifiersTree)v0, v0.getAnnotations());
        }).orElse(DeclarationModifiersAndTypeAnnotations.empty());
        this.builder.open(kind == DeclarationKind.PARAMETER && declarationAndTypeModifiers.hasDeclarationAnnotation() ? this.plusFour : ZERO);
        ImmutableList<AnnotationTree> annotations = this.visitModifiers(declarationAndTypeModifiers, annotationsDirection, Optional.of(verticalAnnotationBreak));
        boolean isVar = this.builder.peekToken().get().equals("var") && (!name.contentEquals("var") || this.builder.peekToken(1).get().equals("var"));
        boolean hasType = type != null || isVar;
        this.builder.open(hasType ? this.plusFour : ZERO);
        this.builder.open(ZERO);
        this.builder.open(ZERO);
        this.visitAnnotations(annotations, BreakOrNot.NO, BreakOrNot.YES);
        if (typeWithDims.isPresent() && typeWithDims.get().node != null) {
            void var1_2;
            this.scan(typeWithDims.get().node, null);
            int totalDims = dims.size();
            this.builder.open(this.plusFour);
            this.maybeAddDims(dims);
            this.builder.close();
            baseDims = var1_2 - dims.size();
        } else if (var2_4 != false) {
            this.token("var");
        } else {
            this.scan(type, null);
        }
        this.builder.close();
        if (var3_6 != false) {
            this.builder.breakOp(Doc.FillMode.INDEPENDENT, " ", ZERO, Optional.of(typeBreak));
        }
        this.builder.open(Indent.If.make(typeBreak, this.plusFour, ZERO));
        if (receiverExpression.isPresent()) {
            this.scan((Tree)receiverExpression.get(), null);
        } else {
            this.variableName(name);
        }
        this.builder.op(op);
        this.maybeAddDims(dims);
        this.builder.close();
        this.builder.close();
        if (initializer.isPresent()) {
            this.builder.space();
            this.token(equals);
            if (initializer.get().getKind() == Tree.Kind.NEW_ARRAY && ((NewArrayTree)initializer.get()).getType() == null) {
                this.builder.open(this.minusFour);
                this.builder.space();
                initializer.get().accept(this, null);
                this.builder.close();
            } else {
                this.builder.open(Indent.If.make(typeBreak, this.plusFour, ZERO));
                this.builder.breakToFill(" ");
                this.scan((Tree)initializer.get(), null);
                this.builder.close();
            }
        }
        if (trailing.isPresent() && this.builder.peekToken().equals(trailing)) {
            this.builder.guessToken(trailing.get());
        }
        this.builder.close();
        this.builder.close();
        if (isField) {
            this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.conditional(verticalAnnotationBreak));
        }
        return baseDims;
    }

    /*
     * WARNING - void declaration
     */
    protected void variableName(Name name) {
        void var1_1;
        this.visit((Name)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void maybeAddDims(Deque<List<? extends AnnotationTree>> annotations) {
        void var1_1;
        this.maybeAddDims(new ArrayDeque<ExpressionTree>(), (Deque<List<? extends AnnotationTree>>)var1_1);
    }

    private void maybeAddDims(Deque<ExpressionTree> dimExpressions, Deque<List<? extends AnnotationTree>> annotations) {
        boolean lastWasAnnotation = false;
        block10: while (this.builder.peekToken().isPresent()) {
            switch (this.builder.peekToken().get()) {
                case "@": {
                    if (annotations.isEmpty()) {
                        return;
                    }
                    List<? extends AnnotationTree> dimAnnotations = annotations.removeFirst();
                    if (dimAnnotations.isEmpty()) continue block10;
                    this.builder.breakToFill(" ");
                    BreakOrNot breakOrNot = BreakOrNot.NO;
                    this.visitAnnotations(dimAnnotations, breakOrNot, breakOrNot);
                    lastWasAnnotation = true;
                    continue block10;
                }
                case "[": {
                    if (lastWasAnnotation) {
                        this.builder.breakToFill(" ");
                    } else {
                        this.builder.breakToFill();
                    }
                    this.token("[");
                    if (!this.builder.peekToken().get().equals("]")) {
                        this.scan((Tree)dimExpressions.removeFirst(), null);
                    }
                    this.token("]");
                    lastWasAnnotation = false;
                    continue block10;
                }
                case ".": {
                    if (!this.builder.peekToken().get().equals(".") || !this.builder.peekToken(1).get().equals(".")) {
                        return;
                    }
                    if (lastWasAnnotation) {
                        this.builder.breakToFill(" ");
                    } else {
                        this.builder.breakToFill();
                    }
                    this.builder.op("...");
                    lastWasAnnotation = false;
                    continue block10;
                }
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void declareMany(List<VariableTree> fragments, Direction annotationDirection) {
        Iterator iterator;
        this.builder.open(ZERO);
        ModifiersTree modifiers = fragments.get(0).getModifiers();
        Tree type = fragments.get(0).getType();
        this.visitAndBreakModifiers(modifiers, annotationDirection, Optional.empty());
        this.builder.open(this.plusFour);
        this.builder.open(ZERO);
        DimensionHelpers.TypeWithDims extractedDims = DimensionHelpers.extractDims(type, DimensionHelpers.SortedDims.YES);
        ArrayDeque<List<? extends AnnotationTree>> dims = new ArrayDeque<List<? extends AnnotationTree>>(extractedDims.dims);
        this.scan(extractedDims.node, null);
        int baseDims = dims.size();
        this.maybeAddDims(dims);
        baseDims -= dims.size();
        boolean afterFirstToken = false;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            VariableTree fragment = (VariableTree)iterator.next();
            if (afterFirstToken) {
                this.token(",");
            }
            Object fragmentDims = JavaInputAstVisitor.variableFragmentDims(afterFirstToken, baseDims, fragment.getType());
            fragmentDims = new ArrayDeque<List<AnnotationTree>>(((DimensionHelpers.TypeWithDims)fragmentDims).dims);
            this.builder.breakOp(" ");
            this.builder.open(ZERO);
            this.maybeAddDims((Deque<List<? extends AnnotationTree>>)fragmentDims);
            this.variableName(fragment.getName());
            this.maybeAddDims((Deque<List<? extends AnnotationTree>>)fragmentDims);
            ExpressionTree initializer = fragment.getInitializer();
            if (initializer != null) {
                void var3_4;
                this.builder.space();
                this.token("=");
                this.builder.open(this.plusFour);
                this.builder.breakOp(" ");
                this.scan((Tree)var3_4, null);
                this.builder.close();
            }
            this.builder.close();
            if (!afterFirstToken) {
                this.builder.close();
            }
            afterFirstToken = true;
        }
        this.builder.close();
        this.token(";");
        this.builder.close();
    }

    /*
     * WARNING - void declaration
     */
    protected void addBodyDeclarations(List<? extends Tree> bodyDeclarations, BracesOrNot braces, FirstDeclarationsOrNot first0) {
        if (bodyDeclarations.isEmpty()) {
            if (braces.isYes()) {
                this.builder.space();
                this.tokenBreakTrailingComment("{", this.plusTwo);
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
                this.builder.open(ZERO);
                if (this.builder.peekToken().equals(Optional.of(";"))) {
                    this.builder.open(this.plusTwo);
                    this.dropEmptyDeclarations();
                    this.builder.close();
                    this.builder.forcedBreak();
                }
                this.token("}", this.plusTwo);
                this.builder.close();
                return;
            }
        } else {
            void var2_2;
            if (braces.isYes()) {
                this.builder.space();
                this.tokenBreakTrailingComment("{", this.plusTwo);
                this.builder.open(ZERO);
            }
            this.builder.open(this.plusTwo);
            boolean first = first0.isYes();
            boolean lastOneGotBlankLineBefore = false;
            Iterators.PeekingImpl it = Iterators.peekingIterator$488b6d4d(bodyDeclarations.iterator());
            while (it.hasNext()) {
                boolean thisOneGetsBlankLineBefore;
                Tree bodyDeclaration = (Tree)it.next();
                this.dropEmptyDeclarations();
                this.builder.forcedBreak();
                boolean bl = thisOneGetsBlankLineBefore = bodyDeclaration.getKind() != Tree.Kind.VARIABLE || this.hasJavaDoc(bodyDeclaration);
                if (first) {
                    this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.PRESERVE);
                } else if (!first && (thisOneGetsBlankLineBefore || lastOneGotBlankLineBefore)) {
                    this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.YES);
                }
                this.markForPartialFormat();
                if (bodyDeclaration.getKind() == Tree.Kind.VARIABLE) {
                    this.visitVariables(JavaInputAstVisitor.variableFragments(it, bodyDeclaration), DeclarationKind.FIELD, JavaInputAstVisitor.fieldAnnotationDirection(((VariableTree)bodyDeclaration).getModifiers()));
                } else {
                    this.scan(bodyDeclaration, null);
                }
                first = false;
                lastOneGotBlankLineBefore = thisOneGetsBlankLineBefore;
            }
            this.dropEmptyDeclarations();
            this.builder.forcedBreak();
            this.builder.close();
            this.builder.forcedBreak();
            this.markForPartialFormat();
            if (var2_2.isYes()) {
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
                this.token("}", this.plusTwo);
                this.builder.close();
            }
        }
    }

    protected List<? extends Tree> getPermitsClause(ClassTree node) {
        return ImmutableList.of();
    }

    /*
     * WARNING - void declaration
     */
    private void classDeclarationTypeList(String token, List<? extends Tree> types) {
        Iterator iterator;
        if (types.isEmpty()) {
            return;
        }
        this.builder.breakToFill(" ");
        this.builder.open(types.size() > 1 ? this.plusFour : ZERO);
        this.token(token);
        this.builder.space();
        boolean afterFirstToken = false;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_4;
            Tree type = (Tree)iterator.next();
            if (afterFirstToken) {
                this.token(",");
                this.builder.breakOp(" ");
            }
            this.scan((Tree)var3_4, null);
            afterFirstToken = true;
        }
        this.builder.close();
    }

    /*
     * WARNING - void declaration
     */
    private static List<VariableTree> variableFragments(PeekingIterator<? extends Tree> it, Tree first) {
        void var2_2;
        ArrayList<VariableTree> fragments = new ArrayList<VariableTree>();
        if (first.getKind() == Tree.Kind.VARIABLE) {
            void var1_1;
            int start = Trees.getStartPosition(first);
            fragments.add((VariableTree)var1_1);
            while (it.hasNext() && it.peek().getKind() == Tree.Kind.VARIABLE && Trees.getStartPosition(it.peek()) == start) {
                fragments.add((VariableTree)it.next());
            }
        }
        return var2_2;
    }

    private boolean hasJavaDoc(Tree bodyDeclaration) {
        int position = ((JCTree)bodyDeclaration).getStartPosition();
        Input.Token token = this.builder.getInput().getPositionTokenMap().get(position);
        if (token != null) {
            Iterator iterator;
            for (Input.Tok tok : iterator.getToksBefore()) {
                if (!tok.getText().startsWith("/**")) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static Optional<? extends Input.Token> getNextToken(Input input, int position) {
        void var1_1;
        return Optional.ofNullable(input.getPositionTokenMap().get((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private boolean hasTrailingToken(Input input, List<? extends Tree> nodes, String token) {
        void var3_3;
        void var1_1;
        void var2_2;
        if (nodes.isEmpty()) {
            return false;
        }
        Tree lastNode = Iterables.getLast(nodes);
        Optional<? extends Input.Token> nextToken = JavaInputAstVisitor.getNextToken(input, Trees.getEndPosition((Tree)var2_2, this.getCurrentPath()));
        return nextToken.isPresent() && ((Input.Token)var1_1.get()).getTok().getText().equals(var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static Direction canLocalHaveHorizontalAnnotations(ModifiersTree modifiers) {
        ModifiersTree modifiersTree;
        void var1_1;
        int parameterlessAnnotations = 0;
        for (AnnotationTree annotationTree : modifiers.getAnnotations()) {
            if (!annotationTree.getArguments().isEmpty()) continue;
            ++parameterlessAnnotations;
        }
        if (parameterlessAnnotations <= 1 && var1_1 == modifiersTree.getAnnotations().size()) {
            return Direction.HORIZONTAL;
        }
        return Direction.VERTICAL;
    }

    private static Direction fieldAnnotationDirection(ModifiersTree modifiers) {
        for (AnnotationTree annotationTree : modifiers.getAnnotations()) {
            if (annotationTree.getArguments().isEmpty()) continue;
            return Direction.VERTICAL;
        }
        return Direction.HORIZONTAL;
    }

    /*
     * WARNING - void declaration
     */
    protected final void token(String token) {
        void var1_1;
        this.builder.token((String)var1_1, Doc.Token.RealOrImaginary.REAL, ZERO, Optional.empty());
    }

    /*
     * WARNING - void declaration
     */
    protected final void token(String token, Indent plusIndentCommentsBefore) {
        void var2_2;
        void var1_1;
        this.builder.token((String)var1_1, Doc.Token.RealOrImaginary.REAL, (Indent)var2_2, Optional.empty());
    }

    /*
     * WARNING - void declaration
     */
    final void tokenBreakTrailingComment(String token, Indent breakAndIndentTrailingComment) {
        void var2_2;
        void var1_1;
        this.builder.token((String)var1_1, Doc.Token.RealOrImaginary.REAL, ZERO, Optional.of(var2_2));
    }

    protected void markForPartialFormat() {
        if (!this.inExpression()) {
            this.builder.markForPartialFormat();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final void sync(Tree node) {
        void var1_1;
        this.builder.sync(((JCTree)var1_1).getStartPosition());
    }

    final Output.BreakTag genSym() {
        return new Output.BreakTag();
    }

    public final String toString() {
        return MoreObjects.toStringHelper(this).add("builder", this.builder).toString();
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ Long lambda$indexes$1(Predicate predicate, Object x, long i) {
        long l;
        void var1_1;
        return predicate.apply(var1_1) ? l : -1L;
    }

    protected static enum BracesOrNot {
        YES,
        NO;


        final boolean isYes() {
            return this == YES;
        }
    }

    protected static enum FirstDeclarationsOrNot {
        YES,
        NO;


        final boolean isYes() {
            return this == YES;
        }
    }

    protected static enum CollapseEmptyOrNot {
        YES,
        NO;


        static CollapseEmptyOrNot valueOf(boolean b) {
            if (b) {
                return YES;
            }
            return NO;
        }

        final boolean isYes() {
            return this == YES;
        }
    }

    protected static enum AllowLeadingBlankLine {
        YES,
        NO;


        static AllowLeadingBlankLine valueOf(boolean b) {
            if (b) {
                return YES;
            }
            return NO;
        }
    }

    protected static enum AllowTrailingBlankLine {
        YES,
        NO;


        static AllowTrailingBlankLine valueOf(boolean b) {
            if (b) {
                return YES;
            }
            return NO;
        }
    }

    protected static enum Direction {
        VERTICAL,
        HORIZONTAL;


        final boolean isVertical() {
            return this == VERTICAL;
        }
    }

    protected static enum BreakOrNot {
        YES,
        NO;


        final boolean isYes() {
            return this == YES;
        }
    }

    protected static enum DeclarationKind {
        NONE,
        FIELD,
        PARAMETER;

    }

    @AutoValue
    static abstract class DeclarationModifiersAndTypeAnnotations {
        DeclarationModifiersAndTypeAnnotations() {
        }

        abstract ImmutableList<AnnotationOrModifier> declarationModifiers();

        abstract ImmutableList<AnnotationTree> typeAnnotations();

        /*
         * WARNING - void declaration
         */
        static DeclarationModifiersAndTypeAnnotations create(ImmutableList<AnnotationOrModifier> declarationModifiers, ImmutableList<AnnotationTree> typeAnnotations) {
            void var1_1;
            ImmutableList<AnnotationOrModifier> immutableList;
            return new AutoValue_JavaInputAstVisitor_DeclarationModifiersAndTypeAnnotations(immutableList, (ImmutableList<AnnotationTree>)var1_1);
        }

        static DeclarationModifiersAndTypeAnnotations empty() {
            return DeclarationModifiersAndTypeAnnotations.create(ImmutableList.of(), ImmutableList.of());
        }

        boolean hasDeclarationAnnotation() {
            return this.declarationModifiers().stream().anyMatch(AnnotationOrModifier::isAnnotation);
        }
    }

    @AutoOneOf(value=Kind.class)
    static abstract class AnnotationOrModifier
    implements Comparable<AnnotationOrModifier> {
        private static final Comparator<AnnotationOrModifier> COMPARATOR = Comparator.comparingInt(AnnotationOrModifier::position);

        AnnotationOrModifier() {
        }

        abstract Kind getKind();

        abstract AnnotationTree annotation();

        abstract Input.Tok modifier();

        static AnnotationOrModifier ofModifier(Input.Tok m) {
            return AutoOneOf_JavaInputAstVisitor_AnnotationOrModifier.modifier(m);
        }

        static AnnotationOrModifier ofAnnotation(AnnotationTree a) {
            return AutoOneOf_JavaInputAstVisitor_AnnotationOrModifier.annotation(a);
        }

        boolean isModifier() {
            return this.getKind().equals((Object)Kind.MODIFIER);
        }

        boolean isAnnotation() {
            return this.getKind().equals((Object)Kind.ANNOTATION);
        }

        int position() {
            switch (this.getKind().ordinal()) {
                case 0: {
                    return this.modifier().getPosition();
                }
                case 1: {
                    return Trees.getStartPosition(this.annotation());
                }
            }
            throw new AssertionError();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int compareTo(AnnotationOrModifier o) {
            void var1_1;
            return COMPARATOR.compare(this, (AnnotationOrModifier)var1_1);
        }

        static enum Kind {
            MODIFIER,
            ANNOTATION;

        }
    }

    static enum ReceiverParameter {
        YES,
        NO;


        final boolean isYes() {
            return this == YES;
        }
    }

    static enum VarArgsOrNot {
        YES,
        NO;


        static VarArgsOrNot valueOf(boolean b) {
            if (b) {
                return YES;
            }
            return NO;
        }

        final boolean isYes() {
            return this == YES;
        }

        static VarArgsOrNot fromVariable(VariableTree node) {
            return VarArgsOrNot.valueOf((((JCTree.JCVariableDecl)node).mods.flags & 0x400000000L) == 0x400000000L);
        }
    }

    static enum DimensionsOrNot {
        YES,
        NO;


        final boolean isYes() {
            return this == YES;
        }
    }
}

