/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sun.tools.javac.parser.JavaTokenizer;
import com.sun.tools.javac.parser.Scanner;
import com.sun.tools.javac.parser.ScannerFactory;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.util.Context;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

final class JavacTokens {
    private static final CharSequence EOF_COMMENT = "\n//EOF";

    /*
     * WARNING - void declaration
     */
    public static ImmutableList<RawTok> getTokens(String source, Context context, Set<Tokens.TokenKind> stopTokens) {
        if (source == null) {
            return ImmutableList.of();
        }
        ScannerFactory fac = ScannerFactory.instance(context);
        char[] buffer = (source + String.valueOf(EOF_COMMENT)).toCharArray();
        CommentSavingTokenizer tokenizer = new CommentSavingTokenizer(fac, buffer, buffer.length);
        AccessibleScanner scanner = new AccessibleScanner(fac, tokenizer);
        ImmutableList.Builder tokens = ImmutableList.builder();
        int end = source.length();
        int last = 0;
        do {
            scanner.nextToken();
            Tokens.Token t = scanner.token();
            if (t.comments != null) {
                for (CommentWithTextAndPosition c : JavacTokens.getComments(t, tokenizer.comments())) {
                    if (last < c.getSourcePos(0)) {
                        tokens.add(new RawTok(null, null, last, c.getSourcePos(0)));
                    }
                    tokens.add(new RawTok(null, null, c.getSourcePos(0), c.getSourcePos(0) + c.getText().length()));
                    last = c.getSourcePos(0) + c.getText().length();
                }
            }
            if (stopTokens.contains(t.kind)) {
                if (t.kind == Tokens.TokenKind.EOF) break;
                end = t.pos;
                break;
            }
            if (last < t.pos) {
                tokens.add(new RawTok(null, null, last, t.pos));
            }
            tokens.add(new RawTok(t.kind == Tokens.TokenKind.STRINGLITERAL ? "\"" + t.stringVal() + "\"" : null, t.kind, t.pos, t.endPos));
            last = t.endPos;
        } while (scanner.token().kind != Tokens.TokenKind.EOF);
        if (last < end) {
            void var0_1;
            tokens.add(new RawTok(null, null, last, (int)var0_1));
        }
        return tokens.build();
    }

    /*
     * WARNING - void declaration
     */
    private static ImmutableList<CommentWithTextAndPosition> getComments(Tokens.Token token, Map<Tokens.Comment, CommentWithTextAndPosition> comments) {
        void var1_1;
        Tokens.Token token2;
        if (token.comments == null) {
            return ImmutableList.of();
        }
        return token2.comments.stream().map(((Map)var1_1)::get).collect(ImmutableList.toImmutableList()).reverse();
    }

    private JavacTokens() {
    }

    static class CommentSavingTokenizer
    extends JavaTokenizer {
        private final Map<Tokens.Comment, CommentWithTextAndPosition> comments = new HashMap<Tokens.Comment, CommentWithTextAndPosition>();

        /*
         * WARNING - void declaration
         */
        CommentSavingTokenizer(ScannerFactory fac, char[] buffer, int length) {
            super((ScannerFactory)var1_1, (char[])var2_2, (int)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        Map<Tokens.Comment, CommentWithTextAndPosition> comments() {
            return this.comments;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected Tokens.Comment processComment(int pos, int endPos, Tokens.Comment.CommentStyle style) {
            void var3_4;
            void var1_2;
            void var2_3;
            char[] buf = this.getRawCharactersReflectively(pos, endPos);
            Tokens.Comment comment = super.processComment(pos, endPos, style);
            CommentWithTextAndPosition commentWithTextAndPosition = new CommentWithTextAndPosition(pos, (int)var2_3, new String(buf));
            this.comments.put(comment, (CommentWithTextAndPosition)var1_2);
            return var3_4;
        }

        /*
         * WARNING - void declaration
         */
        private char[] getRawCharactersReflectively(int beginIndex, int endIndex) {
            Object instance;
            try {
                instance = JavaTokenizer.class.getDeclaredField("reader").get(this);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                instance = this;
            }
            try {
                void var2_3;
                void var3_4;
                return (char[])instance.getClass().getMethod("getRawCharacters", Integer.TYPE, Integer.TYPE).invoke((Object)var3_4, beginIndex, (int)var2_3);
            }
            catch (ReflectiveOperationException e) {
                void var1_2;
                throw new LinkageError(e.getMessage(), (Throwable)var1_2);
            }
        }
    }

    static class AccessibleScanner
    extends Scanner {
        /*
         * WARNING - void declaration
         */
        protected AccessibleScanner(ScannerFactory fac, JavaTokenizer tokenizer) {
            super((ScannerFactory)var1_1, (JavaTokenizer)var2_2);
            void var2_2;
            void var1_1;
        }
    }

    static class CommentWithTextAndPosition {
        private final int pos;
        private final int endPos;
        private final String text;

        /*
         * WARNING - void declaration
         */
        public CommentWithTextAndPosition(int pos, int endPos, String text) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.pos = var1_1;
            this.endPos = var2_2;
            this.text = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        public int getSourcePos(int index) {
            void var1_1;
            Preconditions.checkArgument(index >= 0 && index < this.endPos - this.pos, "Expected %s in the range [0, %s)", index, this.endPos - this.pos);
            return this.pos + var1_1;
        }

        public String getText() {
            return this.text;
        }

        public String toString() {
            return String.format("Comment: '%s'", this.getText());
        }
    }

    static class RawTok {
        private final String stringVal;
        private final Tokens.TokenKind kind;
        private final int pos;
        private final int endPos;

        /*
         * WARNING - void declaration
         */
        RawTok(String stringVal, Tokens.TokenKind kind, int pos, int endPos) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.stringVal = var1_1;
            this.kind = var2_2;
            this.pos = var3_3;
            this.endPos = endPos;
        }

        public Tokens.TokenKind kind() {
            return this.kind;
        }

        public int pos() {
            return this.pos;
        }

        public int endPos() {
            return this.endPos;
        }

        public String stringVal() {
            return this.stringVal;
        }
    }
}

